/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.LightIdeaTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.NotNull;

public class LightIdeaTestFixtureImpl
extends BaseFixture
implements LightIdeaTestFixture {
    private final LightProjectDescriptor d;
    private CodeStyleSettings f;
    private SdkLeakTracker e;

    public LightIdeaTestFixtureImpl(@NotNull LightProjectDescriptor lightProjectDescriptor) {
        if (lightProjectDescriptor == null) {
            LightIdeaTestFixtureImpl.a(0);
        }
        this.d = lightProjectDescriptor;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        IdeaTestApplication ideaTestApplication = LightPlatformTestCase.initApplication();
        LightPlatformTestCase.doSetup(this.d, LocalInspectionTool.EMPTY_ARRAY, this.getTestRootDisposable());
        InjectedLanguageManagerImpl.pushInjectors((Project)this.getProject());
        this.f = this.getCurrentCodeStyleSettings().clone();
        this.f.getIndentOptions((FileType)StdFileTypes.JAVA);
        ideaTestApplication.setDataProvider(new TestDataProvider(this.getProject()));
        this.e = new SdkLeakTracker();
    }

    @Override
    public void tearDown() {
        Project project2 = this.getProject();
        CodeStyleSettingsManager.getInstance((Project)project2).dropTemporarySettings();
        CodeStyleSettings codeStyleSettings = this.f;
        this.f = null;
        new RunAll(new ThrowableRunnable[0]).append(() -> UsefulTestCase.doCheckForSettingsDamage(codeStyleSettings, this.getCurrentCodeStyleSettings())).append(() -> super.tearDown()).append(() -> LightPlatformTestCase.doTearDown(project2, LightPlatformTestCase.getApplication())).append(() -> LightPlatformTestCase.checkEditorsReleased()).append(() -> this.e.checkForJdkTableLeaks()).append(() -> InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2)).append(() -> PersistentFS.getInstance().clearIdCache()).append(() -> PlatformTestCase.cleanupApplicationCaches(project2)).run();
    }

    @Override
    public Project getProject() {
        return LightPlatformTestCase.getProject();
    }

    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        try {
            if (CodeStyleSchemes.getInstance().getCurrentScheme() == null) {
                return new CodeStyleSettings();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LightIdeaTestFixtureImpl.a(illegalArgumentException);
        }
        return CodeStyleSettingsManager.getSettings((Project)this.getProject());
    }

    @Override
    public Module getModule() {
        return LightPlatformTestCase.getModule();
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDescriptor", "com/intellij/testFramework/fixtures/impl/LightIdeaTestFixtureImpl", "<init>"));
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

