/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.descriptors.impl.ConfigFileContainerImpl;
import com.intellij.util.descriptors.impl.ConfigFileImpl;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFileInfoSetImpl
implements ConfigFileInfoSet {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.util.descriptors.impl.ConfigFileInfoSetImpl");
    @NonNls
    private static final String a = "deploymentDescriptor";
    @NonNls
    private static final String g = "name";
    @NonNls
    private static final String e = "url";
    private final MultiValuesMap<ConfigFileMetaData, ConfigFileInfo> c = new MultiValuesMap();
    @Nullable
    private ConfigFileContainerImpl d;
    private final ConfigFileMetaDataProvider f;

    public ConfigFileInfoSetImpl(ConfigFileMetaDataProvider configFileMetaDataProvider) {
        this.f = configFileMetaDataProvider;
    }

    public void addConfigFile(ConfigFileInfo configFileInfo) {
        this.c.put((Object)configFileInfo.getMetaData(), (Object)configFileInfo);
        this.a();
    }

    public void addConfigFile(ConfigFileMetaData configFileMetaData, String string) {
        this.addConfigFile(new ConfigFileInfo(configFileMetaData, string));
    }

    public void removeConfigFile(ConfigFileInfo configFileInfo) {
        this.c.remove((Object)configFileInfo.getMetaData(), (Object)configFileInfo);
        this.a();
    }

    public void replaceConfigFile(ConfigFileMetaData configFileMetaData, String string) {
        this.c.removeAll((Object)configFileMetaData);
        this.addConfigFile(new ConfigFileInfo(configFileMetaData, string));
    }

    public ConfigFileInfo updateConfigFile(ConfigFile configFile) {
        this.c.remove((Object)configFile.getMetaData(), (Object)configFile.getInfo());
        ConfigFileInfo configFileInfo = new ConfigFileInfo(configFile.getMetaData(), configFile.getUrl());
        this.c.put((Object)configFileInfo.getMetaData(), (Object)configFileInfo);
        ((ConfigFileImpl)configFile).setInfo(configFileInfo);
        return configFileInfo;
    }

    public void removeConfigFiles(ConfigFileMetaData ... configFileMetaDataArray) {
        for (ConfigFileMetaData configFileMetaData : configFileMetaDataArray) {
            this.c.removeAll((Object)configFileMetaData);
        }
        this.a();
    }

    @Nullable
    public ConfigFileInfo getConfigFileInfo(ConfigFileMetaData configFileMetaData) {
        Collection collection;
        block4: {
            collection = this.c.get((Object)configFileMetaData);
            try {
                try {
                    if (collection != null && !collection.isEmpty()) break block4;
                }
                catch (InvalidDataException invalidDataException) {
                    throw ConfigFileInfoSetImpl.b(invalidDataException);
                }
                return null;
            }
            catch (InvalidDataException invalidDataException) {
                throw ConfigFileInfoSetImpl.b(invalidDataException);
            }
        }
        return (ConfigFileInfo)collection.iterator().next();
    }

    public ConfigFileInfo[] getConfigFileInfos() {
        Collection collection = this.c.values();
        return collection.toArray(new ConfigFileInfo[collection.size()]);
    }

    public void setConfigFileInfos(Collection<ConfigFileInfo> collection) {
        this.c.clear();
        for (ConfigFileInfo configFileInfo : collection) {
            this.c.put((Object)configFileInfo.getMetaData(), (Object)configFileInfo);
        }
        this.a();
    }

    private void a() {
        try {
            if (this.d != null) {
                this.d.updateDescriptors(this.c);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ConfigFileInfoSetImpl.b(invalidDataException);
        }
    }

    public ConfigFileMetaDataProvider getMetaDataProvider() {
        return this.f;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.c.clear();
        List list = element.getChildren(a);
        for (Element element2 : list) {
            ConfigFileMetaData configFileMetaData;
            String string = element2.getAttributeValue(g);
            if (string == null || (configFileMetaData = this.f.findMetaData(string)) == null) continue;
            String string2 = element2.getAttributeValue(e);
            try {
                if (string2 == null) {
                    throw new InvalidDataException("url attribute not specified for " + string + " descriptor");
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw ConfigFileInfoSetImpl.b(invalidDataException);
            }
            this.c.put((Object)configFileMetaData, (Object)new ConfigFileInfo(configFileMetaData, string2));
        }
        this.a();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        TreeSet treeSet = new TreeSet((configFileInfo, configFileInfo2) -> {
            int n2;
            int n3 = Comparing.compare((Comparable)((Object)configFileInfo.getMetaData().getId()), (Comparable)((Object)configFileInfo2.getMetaData().getId()));
            try {
                n2 = n3 != 0 ? n3 : Comparing.compare((Comparable)((Object)configFileInfo.getUrl()), (Comparable)((Object)configFileInfo2.getUrl()));
            }
            catch (InvalidDataException invalidDataException) {
                throw ConfigFileInfoSetImpl.b(invalidDataException);
            }
            return n2;
        });
        treeSet.addAll(this.c.values());
        for (ConfigFileInfo configFileInfo3 : treeSet) {
            Element element2 = new Element(a);
            ConfigFileMetaData configFileMetaData = configFileInfo3.getMetaData();
            element2.setAttribute(g, configFileMetaData.getId());
            element2.setAttribute(e, configFileInfo3.getUrl());
            element.addContent(element2);
        }
    }

    public void setContainer(@NotNull ConfigFileContainerImpl configFileContainerImpl) {
        boolean bl2;
        Logger logger;
        try {
            if (configFileContainerImpl == null) {
                ConfigFileInfoSetImpl.a(0);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ConfigFileInfoSetImpl.b(invalidDataException);
        }
        try {
            logger = b;
            bl2 = this.d == null;
        }
        catch (InvalidDataException invalidDataException) {
            throw ConfigFileInfoSetImpl.b(invalidDataException);
        }
        logger.assertTrue(bl2);
        this.d = configFileContainerImpl;
        this.d.updateDescriptors(this.c);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/util/descriptors/impl/ConfigFileInfoSetImpl", "setContainer"));
    }

    private static InvalidDataException b(InvalidDataException invalidDataException) {
        return invalidDataException;
    }
}

