/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.util.ReflectionAssignabilityCache;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.TypeChooserManager;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import com.intellij.util.xml.impl.DomImplementationClassEP;
import com.intellij.util.xml.impl.ImplementationClassCache;
import com.intellij.util.xml.impl.InvocationCache;
import com.intellij.util.xml.impl.StaticGenericInfo;
import com.intellij.util.xml.impl.VisitorDescription;
import gnu.trove.THashSet;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class DomApplicationComponent {
    private final Map<String, Set<DomFileDescription>> h = FactoryMap.create(string -> new THashSet());
    private final Set<DomFileDescription> e = new THashSet();
    private final ImplementationClassCache b = new ImplementationClassCache(DomImplementationClassEP.EP_NAME);
    private final TypeChooserManager d = new TypeChooserManager();
    final ReflectionAssignabilityCache assignabilityCache = new ReflectionAssignabilityCache();
    private final Map<Class, DomElementsAnnotator> f = ConcurrentFactoryMap.createMap(clazz -> {
        DomFileDescription domFileDescription = this.b((Class)clazz);
        return domFileDescription == null ? null : domFileDescription.createAnnotator();
    });
    private final Map<Class, StaticGenericInfo> a = ConcurrentFactoryMap.createMap(StaticGenericInfo::new, ContainerUtil::createConcurrentSoftValueMap);
    private final Map<Class, InvocationCache> g = ConcurrentFactoryMap.createMap(InvocationCache::new, ContainerUtil::createConcurrentSoftValueMap);
    private final Map<Class<? extends DomElementVisitor>, VisitorDescription> c = ConcurrentFactoryMap.createMap(VisitorDescription::new);

    public DomApplicationComponent() {
        for (DomFileDescription domFileDescription : (DomFileDescription[])Extensions.getExtensions((ExtensionPointName)DomFileDescription.EP_NAME)) {
            this.registerFileDescription(domFileDescription);
        }
    }

    public static DomApplicationComponent getInstance() {
        return (DomApplicationComponent)ServiceManager.getService(DomApplicationComponent.class);
    }

    public int getCumulativeVersion(boolean bl2) {
        int n2 = 0;
        for (DomFileDescription domFileDescription : this.getAllFileDescriptions()) {
            if (bl2) {
                if (!domFileDescription.hasStubs()) continue;
                n2 += domFileDescription.getStubVersion();
                n2 += domFileDescription.getRootTagName().hashCode();
                continue;
            }
            n2 += domFileDescription.getVersion();
            n2 += domFileDescription.getRootTagName().hashCode();
        }
        return n2;
    }

    public final synchronized Set<DomFileDescription> getFileDescriptions(String string) {
        return this.h.get(string);
    }

    public final synchronized Set<DomFileDescription> getAcceptingOtherRootTagNameDescriptions() {
        return this.e;
    }

    public final synchronized void registerFileDescription(DomFileDescription domFileDescription) {
        this.h.get(domFileDescription.getRootTagName()).add(domFileDescription);
        if (domFileDescription.acceptsOtherRootTagNames()) {
            this.e.add(domFileDescription);
        }
        Map map = domFileDescription.getImplementations();
        for (Map.Entry entry : map.entrySet()) {
            this.registerImplementation((Class)entry.getKey(), (Class)entry.getValue(), null);
        }
        this.d.copyFrom(domFileDescription.getTypeChooserManager());
    }

    public synchronized List<DomFileDescription> getAllFileDescriptions() {
        ArrayList arrayList = ContainerUtil.newArrayList();
        for (Set<DomFileDescription> set : this.h.values()) {
            arrayList.addAll(set);
        }
        arrayList.addAll(this.e);
        return arrayList;
    }

    @Nullable
    private synchronized DomFileDescription b(Class clazz) {
        for (Set<DomFileDescription> domFileDescription : this.h.values()) {
            for (DomFileDescription domFileDescription2 : domFileDescription) {
                if (domFileDescription2.getRootElementClass() != clazz) continue;
                return domFileDescription2;
            }
        }
        for (DomFileDescription domFileDescription : this.e) {
            if (domFileDescription.getRootElementClass() != clazz) continue;
            return domFileDescription;
        }
        return null;
    }

    public DomElementsAnnotator getAnnotator(Class clazz) {
        return this.f.get(clazz);
    }

    @Nullable
    final Class<? extends DomElement> getImplementation(Class clazz) {
        return this.b.get(clazz);
    }

    public final void registerImplementation(Class<? extends DomElement> clazz, Class<? extends DomElement> clazz2, @Nullable Disposable disposable) {
        this.b.registerImplementation(clazz, clazz2, disposable);
    }

    public TypeChooserManager getTypeChooserManager() {
        return this.d;
    }

    public final StaticGenericInfo getStaticGenericInfo(Type type) {
        return this.a.get(ReflectionUtil.getRawType((Type)type));
    }

    final InvocationCache getInvocationCache(Class clazz) {
        return this.g.get(clazz);
    }

    public final VisitorDescription getVisitorDescription(Class<? extends DomElementVisitor> clazz) {
        return this.c.get(clazz);
    }
}

