/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.DomElementsNavigationManager;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DomElementsNavigationManagerImpl
extends DomElementsNavigationManager {
    private final Map<String, DomElementNavigationProvider> c = new HashMap<String, DomElementNavigationProvider>();
    private final Project b;
    private final DomElementNavigationProvider a = new MyDomElementNavigateProvider();

    public DomElementsNavigationManagerImpl(Project project2) {
        this.b = project2;
        this.c.put(this.a.getProviderName(), this.a);
    }

    public Set<DomElementNavigationProvider> getDomElementsNavigateProviders(DomElement domElement) {
        HashSet<DomElementNavigationProvider> hashSet = new HashSet<DomElementNavigationProvider>();
        for (DomElementNavigationProvider domElementNavigationProvider : this.c.values()) {
            if (!domElementNavigationProvider.canNavigate(domElement)) continue;
            hashSet.add(domElementNavigationProvider);
        }
        return hashSet;
    }

    public DomElementNavigationProvider getDomElementsNavigateProvider(String string) {
        return this.c.get(string);
    }

    public void registerDomElementsNavigateProvider(DomElementNavigationProvider domElementNavigationProvider) {
        this.c.put(domElementNavigationProvider.getProviderName(), domElementNavigationProvider);
    }

    private class MyDomElementNavigateProvider
    extends DomElementNavigationProvider {
        private MyDomElementNavigateProvider() {
        }

        public String getProviderName() {
            return DomElementsNavigationManager.DEFAULT_PROVIDER_NAME;
        }

        public void navigate(DomElement domElement, boolean bl2) {
            if (!domElement.isValid()) {
                return;
            }
            DomFileElement domFileElement = DomUtil.getFileElement((DomElement)domElement);
            if (domFileElement == null) {
                return;
            }
            VirtualFile virtualFile = domFileElement.getFile().getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            XmlElement xmlElement = domElement.getXmlElement();
            if (xmlElement instanceof XmlAttribute) {
                xmlElement = ((XmlAttribute)xmlElement).getValueElement();
            }
            OpenFileDescriptor openFileDescriptor = xmlElement != null ? new OpenFileDescriptor(DomElementsNavigationManagerImpl.this.b, virtualFile, xmlElement.getTextOffset()) : new OpenFileDescriptor(DomElementsNavigationManagerImpl.this.b, virtualFile);
            FileEditorManagerEx.getInstanceEx((Project)DomElementsNavigationManagerImpl.this.b).openTextEditor(openFileDescriptor, bl2);
        }

        public boolean canNavigate(DomElement domElement) {
            return domElement != null && domElement.isValid();
        }
    }
}

