/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.rpp.equalstoset;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.List;

public class ConversionUtils {
    private ConversionUtils() {
    }

    public static PsiExpression getConstantFromComparison(PsiExpression psiExpression) {
        if (psiExpression instanceof PsiBinaryExpression) {
            PsiBinaryExpression psiBinaryExpression = (PsiBinaryExpression)psiExpression;
            PsiExpression psiExpression2 = psiBinaryExpression.getLOperand();
            PsiExpression psiExpression3 = psiBinaryExpression.getROperand();
            if (PsiUtil.isConstantExpression((PsiExpression)psiExpression2)) {
                return psiExpression2;
            }
            return psiExpression3;
        }
        if (psiExpression instanceof PsiPrefixExpression) {
            PsiPrefixExpression psiPrefixExpression = (PsiPrefixExpression)psiExpression;
            PsiExpression psiExpression4 = psiPrefixExpression.getOperand();
            return ConversionUtils.getConstantFromComparison(psiExpression4);
        }
        PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)psiExpression;
        PsiExpression psiExpression5 = psiMethodCallExpression.getMethodExpression().getQualifierExpression();
        PsiExpression psiExpression6 = psiMethodCallExpression.getArgumentList().getExpressions()[0];
        if (PsiUtil.isConstantExpression((PsiExpression)psiExpression5)) {
            return psiExpression5;
        }
        return psiExpression6;
    }

    static PsiExpression getReferenceFromComparison(PsiExpression psiExpression) {
        if (psiExpression instanceof PsiBinaryExpression) {
            PsiBinaryExpression psiBinaryExpression = (PsiBinaryExpression)psiExpression;
            PsiExpression psiExpression2 = psiBinaryExpression.getLOperand();
            PsiExpression psiExpression3 = psiBinaryExpression.getROperand();
            if (PsiUtil.isConstantExpression((PsiExpression)psiExpression2)) {
                return psiExpression3;
            }
            return psiExpression2;
        }
        if (psiExpression instanceof PsiPrefixExpression) {
            PsiPrefixExpression psiPrefixExpression = (PsiPrefixExpression)psiExpression;
            PsiExpression psiExpression4 = psiPrefixExpression.getOperand();
            return ConversionUtils.getReferenceFromComparison(psiExpression4);
        }
        PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)psiExpression;
        PsiExpression psiExpression5 = psiMethodCallExpression.getMethodExpression().getQualifierExpression();
        PsiExpression psiExpression6 = psiMethodCallExpression.getArgumentList().getExpressions()[0];
        if (PsiUtil.isConstantExpression((PsiExpression)psiExpression5)) {
            return psiExpression6;
        }
        return psiExpression5;
    }

    public static List<PsiExpression> split(PsiBinaryExpression psiBinaryExpression) {
        ArrayList<PsiExpression> arrayList = new ArrayList<PsiExpression>();
        ConversionUtils.split((PsiExpression)psiBinaryExpression, psiBinaryExpression.getOperationTokenType(), arrayList);
        return arrayList;
    }

    public static void split(PsiExpression psiExpression, IElementType iElementType, List<PsiExpression> list) {
        PsiExpression psiExpression2;
        if (psiExpression instanceof PsiParenthesizedExpression) {
            psiExpression2 = ((PsiParenthesizedExpression)psiExpression).getExpression();
            ConversionUtils.split(psiExpression2, iElementType, list);
        }
        if (!(psiExpression instanceof PsiBinaryExpression)) {
            list.add(psiExpression);
            return;
        }
        psiExpression2 = (PsiBinaryExpression)psiExpression;
        if (psiExpression2.getOperationTokenType().equals(iElementType)) {
            ConversionUtils.split(psiExpression2.getLOperand(), iElementType, list);
            ConversionUtils.split(psiExpression2.getROperand(), iElementType, list);
        } else {
            list.add(psiExpression2);
        }
    }
}

