/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.rpp.generatearraymethods;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.rpp.generatearraymethods.GenerateArrayMethodsHandler;
import com.sixrr.rpp.utils.ArrayUtils;
import java.util.List;

public class GenerateArrayMethodsAction
extends EditorAction {
    public GenerateArrayMethodsAction() {
        super((EditorActionHandler)new GenerateArrayMethodsHandler());
    }

    public void update(Editor editor, Presentation presentation, DataContext dataContext) {
        CaretModel caretModel = editor.getCaretModel();
        int n2 = caretModel.getOffset();
        PsiFile psiFile = (PsiFile)dataContext.getData("psi.File");
        if (psiFile == null) {
            presentation.setEnabled(false);
            return;
        }
        PsiElement psiElement = psiFile.findElementAt(n2);
        if (psiElement == null) {
            presentation.setEnabled(false);
            return;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
        if (psiClass == null) {
            presentation.setEnabled(false);
            return;
        }
        List<PsiField> list = ArrayUtils.getUnimplementedArrayFields(psiClass);
        if (list != null && !list.isEmpty()) {
            presentation.setEnabled(true);
        } else {
            presentation.setEnabled(false);
        }
    }
}

