/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterEditor;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsLocalInterpreterEditor
implements NodeJsInterpreterEditor<NodeJsLocalInterpreter> {
    private static final NodePackageDescriptor NPM_PACKAGE_DESCRIPTOR = new NodePackageDescriptor(new String[]{"npm", "yarn"}){

        @Override
        @NotNull
        protected NodePackageRef createPackageRef(@NotNull String text) {
            if (text == null) {
                1.$$$reportNull$$$0(0);
            }
            if (this.getPackageNames().contains(text)) {
                NodePackageRef nodePackageRef = NodePackageRef.create(text);
                if (nodePackageRef == null) {
                    1.$$$reportNull$$$0(1);
                }
                return nodePackageRef;
            }
            NodePackageRef nodePackageRef = super.createPackageRef(text);
            if (nodePackageRef == null) {
                1.$$$reportNull$$$0(2);
            }
            return nodePackageRef;
        }

        @Override
        @NotNull
        public List<NodePackageRef> listPackageRefs(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
            VirtualFile globalNodeModulesDir;
            if (project == null) {
                1.$$$reportNull$$$0(3);
            }
            ArrayList result2 = ContainerUtil.newArrayList();
            if (interpreter instanceof NodeJsLocalInterpreter && (globalNodeModulesDir = ((NodeJsLocalInterpreter)interpreter).getGlobalNodeModulesVirtualDir()) != null) {
                for (String name : this.getPackageNames()) {
                    ArrayList modules = ContainerUtil.newArrayList();
                    NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, globalNodeModulesDir, ModuleType.GLOBALLY_INSTALLED, name);
                    if (modules.isEmpty()) continue;
                    result2.add(NodePackageRef.create(name));
                }
            }
            List<NodePackageRef> refs = super.listPackageRefs(project, null, contextFileOrDirectory);
            result2.addAll(refs);
            ArrayList arrayList = result2;
            if (arrayList == null) {
                1.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterEditor$1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterEditor$1";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPackageRef";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "listPackageRefs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createPackageRef";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "listPackageRefs";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private final JBTextField myNodeField;
    private final NodePackageField myNpmPackageField;
    private final JPanel myPanel;
    private NodeJsLocalInterpreter myInterpreter;

    public NodeJsLocalInterpreterEditor(@NotNull Project project) {
        if (project == null) {
            NodeJsLocalInterpreterEditor.$$$reportNull$$$0(0);
        }
        this.myNodeField = new JBTextField();
        this.myNodeField.setEditable(false);
        this.myNpmPackageField = new NodePackageField(project, NPM_PACKAGE_DESCRIPTOR, () -> this.myInterpreter, null);
        this.myPanel = FormBuilder.createFormBuilder().addLabeledComponent("&Node interpreter:", (JComponent)this.myNodeField).addLabeledComponent("Np&m package:", (JComponent)((Object)this.myNpmPackageField)).addComponentFillVertically((JComponent)new JPanel(), 0).getPanel();
    }

    public void setPreferredWidthToFitText() {
        SwingHelper.setPreferredWidthToFitText((JTextField)this.myNodeField);
        this.myNpmPackageField.setPreferredWidthToFitText();
    }

    @Override
    public void resetEditor(@NotNull NodeJsLocalInterpreter interpreter) {
        if (interpreter == null) {
            NodeJsLocalInterpreterEditor.$$$reportNull$$$0(1);
        }
        this.myInterpreter = interpreter;
        this.myNodeField.setText(interpreter.getPresentableName());
        this.myNpmPackageField.setSelected(new NodePackage(interpreter.getNpmPackageDir()));
    }

    @Override
    @NotNull
    public NodeJsLocalInterpreter applyEditor() {
        NodePackage pkg = this.myNpmPackageField.getSelected();
        NodeJsLocalInterpreter nodeJsLocalInterpreter = new NodeJsLocalInterpreter(this.myInterpreter.getInterpreterSystemDependentPath(), pkg.getSystemDependentPath());
        if (nodeJsLocalInterpreter == null) {
            NodeJsLocalInterpreterEditor.$$$reportNull$$$0(2);
        }
        return nodeJsLocalInterpreter;
    }

    @Override
    @NotNull
    public JComponent getEditorComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            NodeJsLocalInterpreterEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "applyEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

