/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.javascript.nodejs.library.NodeJsCoreModulesCatalog;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsCoreLibraryManager {
    public static final String LIBRARY_NAME = "Node.js Core";
    private final Project myProject;
    private JSLibraryMappings myMappings;
    @Nullable
    private volatile LibraryWrapper myWrapper;

    public NodeJsCoreLibraryManager(@NotNull Project project) {
        if (project == null) {
            NodeJsCoreLibraryManager.$$$reportNull$$$0(0);
        }
        this.myMappings = null;
        this.myWrapper = null;
        this.myProject = project;
    }

    @NotNull
    public static NodeJsCoreLibraryManager getInstance(@NotNull Project project) {
        if (project == null) {
            NodeJsCoreLibraryManager.$$$reportNull$$$0(1);
        }
        NodeJsCoreLibraryManager nodeJsCoreLibraryManager = (NodeJsCoreLibraryManager)ServiceManager.getService((Project)project, NodeJsCoreLibraryManager.class);
        if (nodeJsCoreLibraryManager == null) {
            NodeJsCoreLibraryManager.$$$reportNull$$$0(2);
        }
        return nodeJsCoreLibraryManager;
    }

    public void setScriptingLibraryModel(@Nullable ScriptingLibraryModel libraryModel) {
        this.myWrapper = libraryModel == null ? null : new LibraryWrapper(libraryModel);
    }

    public static boolean isCoreModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            NodeJsCoreLibraryManager.$$$reportNull$$$0(3);
        }
        return NodeJsCoreModulesCatalog.INSTANCE.isPublicCoreModule(moduleName);
    }

    public boolean isCoreLibraryConfigured() {
        LibraryWrapper wrapper = this.myWrapper;
        return wrapper != null;
    }

    public boolean isCoreModuleLibraryFile(@NotNull VirtualFile virtualFile) {
        LibraryWrapper wrapper;
        if (virtualFile == null) {
            NodeJsCoreLibraryManager.$$$reportNull$$$0(4);
        }
        return (wrapper = this.myWrapper) != null && wrapper.containsFile(virtualFile);
    }

    @NotNull
    public Collection<String> listCoreModuleNames() {
        LibraryWrapper wrapper = this.myWrapper;
        if (wrapper == null) {
            ImmutableList<String> immutableList = NodeJsCoreModulesCatalog.INSTANCE.getPublicCoreModules();
            if (immutableList == null) {
                NodeJsCoreLibraryManager.$$$reportNull$$$0(5);
            }
            return immutableList;
        }
        ImmutableList<String> immutableList = wrapper.getPublicCoreModuleNames();
        if (immutableList == null) {
            NodeJsCoreLibraryManager.$$$reportNull$$$0(6);
        }
        return immutableList;
    }

    @Nullable
    public VirtualFile findCoreModuleFileByName(@NotNull String moduleName) {
        LibraryWrapper wrapper;
        if (moduleName == null) {
            NodeJsCoreLibraryManager.$$$reportNull$$$0(7);
        }
        if ((wrapper = this.myWrapper) == null) {
            return null;
        }
        return wrapper.getFileByModuleName(moduleName);
    }

    @NotNull
    public Set<VirtualFile> getCoreModules() {
        LibraryWrapper wrapper = this.myWrapper;
        if (wrapper == null) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                NodeJsCoreLibraryManager.$$$reportNull$$$0(8);
            }
            return set;
        }
        ImmutableSet<VirtualFile> immutableSet = wrapper.getPublicCoreModuleFiles();
        if (immutableSet == null) {
            NodeJsCoreLibraryManager.$$$reportNull$$$0(9);
        }
        return immutableSet;
    }

    public static boolean isAssociatedWithNodeCoreLibrary(@NotNull PsiFile psiFile) {
        VirtualFile virtualFile;
        if (psiFile == null) {
            NodeJsCoreLibraryManager.$$$reportNull$$$0(10);
        }
        if ((virtualFile = psiFile.getVirtualFile()) == null) {
            return false;
        }
        return NodeJsCoreLibraryManager.isAssociatedWithNodeCoreLibrary(psiFile.getProject(), virtualFile);
    }

    public static boolean isAssociatedWithNodeCoreLibrary(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            NodeJsCoreLibraryManager.$$$reportNull$$$0(11);
        }
        if (file == null) {
            NodeJsCoreLibraryManager.$$$reportNull$$$0(12);
        }
        NodeJsCoreLibraryManager manager = NodeJsCoreLibraryManager.getInstance(project);
        return manager.isAssociatedWithNodeCoreLibrary(file);
    }

    public boolean isAssociatedWithNodeCoreLibrary(@NotNull VirtualFile file) {
        JSLibraryMappings mappings;
        if (file == null) {
            NodeJsCoreLibraryManager.$$$reportNull$$$0(13);
        }
        if ((mappings = this.myMappings) == null) {
            this.myMappings = mappings = JSLibraryMappings.getInstance(this.myProject);
        }
        return mappings.isLibraryInScopeFor(file, LIBRARY_NAME);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "listCoreModuleNames";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoreModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCoreModuleName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCoreModuleLibraryFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findCoreModuleFileByName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAssociatedWithNodeCoreLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LibraryWrapper {
        private final ImmutableMap<String, VirtualFile> myPublicCoreModuleFileByNameMap;
        private final ImmutableList<String> myPublicCoreModuleNames;
        private final ImmutableSet<VirtualFile> myPublicCoreModuleFiles;
        private final ImmutableMap<String, VirtualFile> myAuxFiles;

        private LibraryWrapper(@NotNull ScriptingLibraryModel libraryModel) {
            if (libraryModel == null) {
                LibraryWrapper.$$$reportNull$$$0(0);
            }
            Set allFiles = ContainerUtil.union((Set)libraryModel.getSourceFiles(), (Set)libraryModel.getCompactFiles());
            Map publicCoreModuleFileByNameMap = ContainerUtilRt.newHashMap((int)allFiles.size());
            VirtualFile dir = null;
            for (VirtualFile file : allFiles) {
                String moduleName = file.getNameWithoutExtension();
                if (NodeJsCoreModulesCatalog.INSTANCE.isPublicCoreModule(moduleName)) {
                    publicCoreModuleFileByNameMap.put(moduleName, file);
                }
                if (!file.getName().equals("path.js")) continue;
                dir = file.getParent();
            }
            this.myPublicCoreModuleFileByNameMap = ImmutableMap.copyOf((Map)publicCoreModuleFileByNameMap);
            this.myPublicCoreModuleNames = ImmutableList.copyOf(publicCoreModuleFileByNameMap.keySet());
            this.myPublicCoreModuleFiles = ImmutableSet.copyOf(publicCoreModuleFileByNameMap.values());
            this.myAuxFiles = ImmutableMap.copyOf(LibraryWrapper.createAuxFileMap(dir, allFiles));
        }

        @NotNull
        private static Map<String, VirtualFile> createAuxFileMap(@Nullable VirtualFile dir, @NotNull Set<VirtualFile> libraryFiles) {
            if (libraryFiles == null) {
                LibraryWrapper.$$$reportNull$$$0(1);
            }
            HashMap auxFileMap = ContainerUtil.newHashMap();
            if (dir != null) {
                for (VirtualFile file : dir.getChildren()) {
                    if (libraryFiles.contains(file)) continue;
                    auxFileMap.put(file.getNameWithoutExtension(), file);
                }
            }
            HashMap hashMap = auxFileMap;
            if (hashMap == null) {
                LibraryWrapper.$$$reportNull$$$0(2);
            }
            return hashMap;
        }

        @Nullable
        public VirtualFile getFileByModuleName(@NotNull String moduleName) {
            VirtualFile file;
            if (moduleName == null) {
                LibraryWrapper.$$$reportNull$$$0(3);
            }
            if ((file = (VirtualFile)this.myPublicCoreModuleFileByNameMap.get((Object)moduleName)) != null) {
                return file;
            }
            return (VirtualFile)this.myAuxFiles.get((Object)moduleName);
        }

        public boolean containsFile(@NotNull VirtualFile file) {
            if (file == null) {
                LibraryWrapper.$$$reportNull$$$0(4);
            }
            return this.myPublicCoreModuleFiles.contains((Object)file);
        }

        @NotNull
        public ImmutableList<String> getPublicCoreModuleNames() {
            ImmutableList<String> immutableList = this.myPublicCoreModuleNames;
            if (immutableList == null) {
                LibraryWrapper.$$$reportNull$$$0(5);
            }
            return immutableList;
        }

        public ImmutableSet<VirtualFile> getPublicCoreModuleFiles() {
            return this.myPublicCoreModuleFiles;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryFiles";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager$LibraryWrapper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager$LibraryWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAuxFileMap";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPublicCoreModuleNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createAuxFileMap";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileByModuleName";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "containsFile";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

