/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.packageJson.PackageVersionRangeMatchRequest;
import com.intellij.javascript.nodejs.packageJson.PackageVersionRangeMatchResponse;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class PackageVersionRangeMatcher {
    private static final Logger LOG = Logger.getInstance(PackageVersionRangeMatcher.class);
    private static final long TOTAL_WAIT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private static volatile File WORKING_DIRECTORY;

    private PackageVersionRangeMatcher() {
    }

    @NotNull
    private static File getWorkingDirectory() throws IOException {
        File workingDirectory = WORKING_DIRECTORY;
        if (workingDirectory == null || !workingDirectory.isDirectory()) {
            WORKING_DIRECTORY = workingDirectory = FileUtil.createTempDirectory((String)"intellij-package-json-version-range-check", null, (boolean)true);
        }
        File file = workingDirectory;
        if (file == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(0);
        }
        return file;
    }

    public static boolean match(@NotNull NodeJsLocalInterpreter interpreter, @NotNull List<PackageVersionRangeMatchRequest> requests) {
        if (interpreter == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(1);
        }
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(2);
        }
        try {
            return PackageVersionRangeMatcher.doMatch(interpreter, requests);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    private static boolean doMatch(@NotNull NodeJsLocalInterpreter interpreter, @NotNull List<PackageVersionRangeMatchRequest> requests) throws IOException, ExecutionException {
        if (interpreter == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(3);
        }
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(4);
        }
        GeneralCommandLine commandLine = PackageVersionRangeMatcher.createCommandLine(interpreter, requests);
        long startNano = System.nanoTime();
        CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
        ProcessOutput output = processHandler.runProcess((int)TOTAL_WAIT_TIMEOUT_MILLIS, true);
        if (output.isTimeout()) {
            throw new ExecutionException("'" + commandLine.getCommandLineString() + "' command run is timed out (>" + TOTAL_WAIT_TIMEOUT_MILLIS + " ms)");
        }
        if (output.getExitCode() != 0) {
            LOG.warn("Failed to run " + NodeCommandLineUtil.formatErrorMessage(commandLine, output));
            return false;
        }
        List<PackageVersionRangeMatchResponse> result2 = PackageVersionRangeMatcher.parse(output.getStdout());
        PackageVersionRangeMatcher.validateResponses(requests, result2);
        List notMatched = ContainerUtil.filter(result2, response -> !response.isMatched() && !response.hasErrors());
        LOG.info("Matching " + requests.size() + " done in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms, not matched: " + ContainerUtil.map((Collection)notMatched, PackageVersionRangeMatchResponse::getRequest));
        return notMatched.isEmpty();
    }

    private static void validateResponses(@NotNull List<PackageVersionRangeMatchRequest> requests, @NotNull List<PackageVersionRangeMatchResponse> responses) throws ExecutionException {
        List processed;
        HashSet processedSet;
        HashSet<PackageVersionRangeMatchRequest> original;
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(5);
        }
        if (responses == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(6);
        }
        if (!(original = new HashSet<PackageVersionRangeMatchRequest>(requests)).equals(processedSet = new HashSet(processed = ContainerUtil.map(responses, response -> response.getRequest())))) {
            throw new ExecutionException("Responses do not match requests: requests: " + requests + ", responses: " + processed);
        }
    }

    @NotNull
    private static GeneralCommandLine createCommandLine(@NotNull NodeJsLocalInterpreter interpreter, @NotNull List<PackageVersionRangeMatchRequest> requests) throws IOException, ExecutionException {
        if (interpreter == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(7);
        }
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(8);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        commandLine.setWorkDirectory(PackageVersionRangeMatcher.getWorkingDirectory());
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        commandLine.addParameter(HelperFilesLocator.resolvePathForExecution("package-version-range-matcher/bin/batch-matcher"));
        for (PackageVersionRangeMatchRequest request : requests) {
            commandLine.addParameter("--package");
            commandLine.addParameter(request.getPackageName());
            commandLine.addParameter(request.getVersionRange());
            commandLine.addParameter(request.getVersion());
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(9);
        }
        return generalCommandLine;
    }

    @NotNull
    private static List<PackageVersionRangeMatchResponse> parse(@NotNull String content) throws ExecutionException {
        if (content == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(10);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        JsonArray array = JsonUtil.parseJsonArray((String)content);
        for (JsonElement element : array) {
            JsonObject obj = element.getAsJsonObject();
            String packageName = JsonUtil.getChildAsString((JsonObject)obj, (String)"packageName");
            String versionRange = JsonUtil.getChildAsString((JsonObject)obj, (String)"versionRange");
            String version = JsonUtil.getChildAsString((JsonObject)obj, (String)"version");
            Boolean matched = JsonUtil.getChildAsBooleanObj((JsonObject)obj, (String)"matched");
            boolean invalidVersion = JsonUtil.getChildAsBoolean((JsonObject)obj, (String)"invalidVersion", (boolean)false);
            boolean invalidVersionRange = JsonUtil.getChildAsBoolean((JsonObject)obj, (String)"invalidVersionRange", (boolean)false);
            if (invalidVersion || invalidVersionRange) {
                matched = false;
            }
            if (packageName == null || versionRange == null || version == null || matched == null) {
                throw new ExecutionException("packageName: " + packageName + ", versionRange: " + versionRange + ", version: " + version + ", matched: " + matched);
            }
            result2.add(new PackageVersionRangeMatchResponse(new PackageVersionRangeMatchRequest(packageName, versionRange, version), matched, invalidVersion, invalidVersionRange));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responses";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageVersionRangeMatcher";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doMatch";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateResponses";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

