/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageRefResolver {
    private final Supplier<NodeJsInterpreter> myInterpreterSupplier;
    private final Map<String, NodePackage> myCache = ContainerUtil.newHashMap();
    private NodeJsLocalInterpreter myCacheInterpreter;

    public NodePackageRefResolver(@Nullable Supplier<NodeJsInterpreter> interpreterSupplier) {
        this.myInterpreterSupplier = interpreterSupplier;
    }

    @Nullable
    public NodePackage resolve(@NotNull NodePackageRef ref) {
        NodePackage pkg;
        if (ref == null) {
            NodePackageRefResolver.$$$reportNull$$$0(0);
        }
        if ((pkg = ref.getConstantPackage()) != null) {
            return pkg;
        }
        NodeJsInterpreter interpreter = this.myInterpreterSupplier != null ? this.myInterpreterSupplier.get() : null;
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        if (localInterpreter == null) {
            return null;
        }
        if (!localInterpreter.equals(this.myCacheInterpreter)) {
            this.myCache.clear();
        }
        this.myCacheInterpreter = localInterpreter;
        String name = ref.getReferenceName();
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return null;
        }
        pkg = this.myCache.get(name);
        if (pkg == null) {
            pkg = NodePackageRefResolver.findGlobalPackage(localInterpreter, name);
            this.myCache.put(name, pkg);
        }
        return pkg;
    }

    @Nullable
    private static NodePackage findGlobalPackage(@NotNull NodeJsLocalInterpreter interpreter, @NotNull String pkgName) {
        VirtualFile globalNodeModulesDir;
        if (interpreter == null) {
            NodePackageRefResolver.$$$reportNull$$$0(1);
        }
        if (pkgName == null) {
            NodePackageRefResolver.$$$reportNull$$$0(2);
        }
        if ((globalNodeModulesDir = interpreter.getGlobalNodeModulesVirtualDir()) != null) {
            ArrayList modules = ContainerUtil.newArrayList();
            NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, globalNodeModulesDir, ModuleType.GLOBALLY_INSTALLED, pkgName);
            CompletionModuleInfo item = (CompletionModuleInfo)ContainerUtil.getFirstItem((List)modules);
            if (item != null && item.getVirtualFile() != null) {
                return new NodePackage(item.getVirtualFile().getPath());
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkgName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageRefResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolve";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findGlobalPackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

