/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.actions;

import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6GenerateIndexAction
extends AnAction {
    public ES6GenerateIndexAction() {
        super(JSBundle.message((String)"es6.generate.index.action", (Object[])new Object[0]), JSBundle.message((String)"es6.generate.index.action.description", (Object[])new Object[0]), null);
    }

    @Nullable
    private static VirtualFile getCurrentFileFromEditor(@NotNull DataContext dataContext) {
        Editor editor;
        if (dataContext == null) {
            ES6GenerateIndexAction.$$$reportNull$$$0(0);
        }
        if ((editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) != null) {
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            return psiFile != null ? psiFile.getVirtualFile() : null;
        }
        return null;
    }

    @NotNull
    protected VirtualFile[] getDirectories(@Nullable DataContext dataContext) {
        if (dataContext == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                ES6GenerateIndexAction.$$$reportNull$$$0(1);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile file = ES6GenerateIndexAction.getCurrentFileFromEditor(dataContext);
        if (file != null) {
            VirtualFile[] virtualFileArray = new VirtualFile[]{file.getParent()};
            if (virtualFileArray == null) {
                ES6GenerateIndexAction.$$$reportNull$$$0(2);
            }
            return virtualFileArray;
        }
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (files == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                ES6GenerateIndexAction.$$$reportNull$$$0(3);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        for (VirtualFile virtualFile : files) {
            if (virtualFile.isDirectory()) continue;
            if (VirtualFile.EMPTY_ARRAY == null) {
                ES6GenerateIndexAction.$$$reportNull$$$0(4);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        if (files == null) {
            ES6GenerateIndexAction.$$$reportNull$$$0(5);
        }
        return files;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ES6GenerateIndexAction.$$$reportNull$$$0(6);
        }
        if ((project = e.getProject()) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VirtualFile[] directories = this.getDirectories(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(directories.length > 0);
    }

    public void actionPerformed(AnActionEvent e) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile[] directories = this.getDirectories(e.getDataContext());
        if (directories.length == 0) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile directory : directories) {
            this.processDirectory(directory, manager);
        }
    }

    protected void processDirectory(@NotNull VirtualFile directory, PsiManager manager) {
        if (directory == null) {
            ES6GenerateIndexAction.$$$reportNull$$$0(7);
        }
        ArrayList jsFiles = ContainerUtil.newArrayList();
        ArrayList tsFiles = ContainerUtil.newArrayList();
        boolean allDefinitions = true;
        for (VirtualFile file : directory.getChildren()) {
            DialectOptionHolder holder;
            JSFile jsFile;
            PsiFile psiFile = manager.findFile(file);
            if (!(psiFile instanceof JSFile) || !(jsFile = (JSFile)psiFile).isCommonJSModule() || (holder = DialectDetector.dialectOfFile(psiFile)) == null) continue;
            if (holder.isTypeScript) {
                tsFiles.add(jsFile);
                if (TypeScriptUtil.isDefinitionFile(file)) continue;
                allDefinitions = false;
                continue;
            }
            if (!holder.isECMA6) continue;
            jsFiles.add(jsFile);
        }
        PsiDirectory psiDirectory = manager.findDirectory(directory);
        if (psiDirectory == null) {
            return;
        }
        if (!tsFiles.isEmpty()) {
            this.generateIndex(psiDirectory, "index" + (allDefinitions ? ".d.ts" : ".ts"), tsFiles);
            return;
        }
        this.generateIndex(psiDirectory, "index.js", jsFiles);
    }

    protected void generateIndex(@NotNull PsiDirectory directory, @NotNull String fileName, @NotNull Collection<JSFile> files) {
        PsiFile oldFile;
        if (directory == null) {
            ES6GenerateIndexAction.$$$reportNull$$$0(8);
        }
        if (fileName == null) {
            ES6GenerateIndexAction.$$$reportNull$$$0(9);
        }
        if (files == null) {
            ES6GenerateIndexAction.$$$reportNull$$$0(10);
        }
        if ((oldFile = directory.findFile(fileName)) != null) {
            return;
        }
        final PsiFile file = (PsiFile)WriteAction.compute(() -> {
            if (directory == null) {
                ES6GenerateIndexAction.$$$reportNull$$$0(13);
            }
            if (fileName == null) {
                ES6GenerateIndexAction.$$$reportNull$$$0(14);
            }
            return directory.createFile(fileName);
        });
        if (!(file instanceof JSFile)) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        Project project = directory.getProject();
        for (JSFile jsFile : files) {
            String pathText = ES6GenerateIndexAction.getModuleName(file, jsFile);
            if (pathText == null) continue;
            builder.append("export * from ").append(pathText).append(JSCodeStyleSettings.getSemicolon((PsiElement)file)).append("\n");
        }
        if (builder.length() > 0) {
            JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)file);
            final PsiFile newFile = JSChangeUtil.createJSFileFromText(project, builder.toString(), dialect);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            codeStyleManager.reformat((PsiElement)newFile);
            new WriteCommandAction.Simple<Void>(project, JSBundle.message((String)"es6.generate.index.action", (Object[])new Object[0]), new PsiFile[]{file}){

                protected void run() throws Throwable {
                    file.addRange(newFile.getFirstChild(), newFile.getLastChild());
                }
            }.execute();
        }
        FileEditorManager.getInstance((Project)project).openFile(file.getVirtualFile(), true);
    }

    @Nullable
    private static String getModuleName(@NotNull PsiFile placePsiFile, @NotNull JSFile jsFile) {
        if (placePsiFile == null) {
            ES6GenerateIndexAction.$$$reportNull$$$0(11);
        }
        if (jsFile == null) {
            ES6GenerateIndexAction.$$$reportNull$$$0(12);
        }
        VirtualFile dstFile = jsFile.getVirtualFile();
        TypeScriptConfig configFile = DialectDetector.isTypeScript((PsiElement)placePsiFile) ? TypeScriptConfigUtil.getConfigForPsiFile(placePsiFile) : null;
        JSModuleNameInfo info = ES6CreateImportUtil.getExactExternalFileModuleName((PsiElement)placePsiFile, dstFile, configFile);
        return info == null ? null : info.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/actions/ES6GenerateIndexAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placePsiFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/actions/ES6GenerateIndexAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentFileFromEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processDirectory";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generateIndex";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateIndex$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

