/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import gnu.trove.THashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportHandler {
    public static final String DEFAULT_EXPORT_NAMESPACE = "\"default\"";
    private static final Key<ParameterizedCachedValue<ES6ExportCache, PsiElement>> CACHED_VALUE_KEY = Key.create((String)"es6.exported.names.cache");
    private static final ParameterizedCachedValueProvider<ES6ExportCache, PsiElement> CACHED_VALUE_PROVIDER = new ParameterizedCachedValueProvider<ES6ExportCache, PsiElement>(){

        public CachedValueProvider.Result<ES6ExportCache> compute(PsiElement fileOrModule) {
            ES6ExportCache result2 = this.calcExportSpecifiersAndDefaults(JSStubBasedPsiTreeUtil.getFileOrModuleChildrenStream(fileOrModule));
            return new CachedValueProvider.Result((Object)result2, new Object[]{fileOrModule});
        }

        private ES6ExportCache calcExportSpecifiersAndDefaults(Stream<? extends PsiElement> fileElements) {
            THashSet exportSpecifiers = new THashSet();
            Ref exportDefaultOrAssignment = Ref.create();
            fileElements.forEach(psi -> {
                String initializerReference;
                if (psi instanceof ES6ExportDeclaration) {
                    for (ES6ExportSpecifier exportSpecifier : ((ES6ExportDeclaration)psi).getExportSpecifiers()) {
                        String referenceName = exportSpecifier.getReferenceName();
                        if (referenceName == null || exportSpecifier.getAlias() != null) continue;
                        exportSpecifiers.add((Object)referenceName);
                    }
                } else if (psi instanceof JSExportAssignment && (initializerReference = ((JSExportAssignment)psi).getInitializerReference()) != null) {
                    exportDefaultOrAssignment.set((Object)Pair.create((Object)initializerReference, (Object)(psi instanceof ES6ExportDefaultAssignment)));
                }
            });
            return new ES6ExportCache((Pair)exportDefaultOrAssignment.get(), (Set)exportSpecifiers);
        }
    };

    public static boolean isExported(@NotNull PsiElement element) {
        if (element == null) {
            ES6ImportHandler.$$$reportNull$$$0(0);
        }
        return element instanceof JSElementBase ? ((JSElementBase)element).isExported() : ES6ImportHandler.calculateIsExported(element);
    }

    public static boolean isExportedWithNameOrDefault(@NotNull PsiElement element) {
        if (element == null) {
            ES6ImportHandler.$$$reportNull$$$0(1);
        }
        return ES6ImportHandler.isExported(element) || ES6ImportHandler.isExportedWithDefault(element);
    }

    public static boolean isExportedWithNameOrDefaultOrAssignment(@NotNull PsiElement element) {
        if (element == null) {
            ES6ImportHandler.$$$reportNull$$$0(2);
        }
        return ES6ImportHandler.isExported(element) || ES6ImportHandler.isExportWithDefaultOrAssignment(element);
    }

    public static boolean isExportedWithDefault(@NotNull PsiElement element) {
        if (element == null) {
            ES6ImportHandler.$$$reportNull$$$0(3);
        }
        if (element.getParent() instanceof ES6ExportDefaultAssignment) {
            return true;
        }
        return ES6ImportHandler.isExportedViaStatement(element, true, true);
    }

    public static boolean isExportWithDefaultOrAssignment(@NotNull PsiElement element) {
        if (element == null) {
            ES6ImportHandler.$$$reportNull$$$0(4);
        }
        if (element.getParent() instanceof ES6ExportDefaultAssignment) {
            return true;
        }
        return ES6ImportHandler.isExportedViaStatement(element, true, false);
    }

    public static boolean calculateIsExported(@NotNull PsiElement element) {
        if (element == null) {
            ES6ImportHandler.$$$reportNull$$$0(5);
        }
        if (element instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
            if (attributeList != null && attributeList.getExplicitAccessType() == JSAttributeList.AccessType.PUBLIC) {
                return true;
            }
            if (DialectDetector.isTypeScript(element) && !(element instanceof TypeScriptImportStatement)) {
                JSFile file;
                if (element instanceof TypeScriptModule && !((TypeScriptModule)element).isInternal()) {
                    return true;
                }
                if (element.getParent() instanceof TypeScriptImplicitModule) {
                    return true;
                }
                if (element.getParent() instanceof JSFile && !(file = (JSFile)element.getParent()).isCommonJSModule()) {
                    return true;
                }
                if (TypeScriptPsiUtil.isAmbientDeclaration(element)) {
                    return true;
                }
            }
            if (DialectDetector.isJSX(element) && element instanceof JSVariable && JSXHarmonyLanguageDialect.isReactComponent(((JSVariable)element).getInitializerOrStub())) {
                return true;
            }
        }
        if (element instanceof ES6ExportSpecifierAlias || element instanceof ES6ExportedDefaultBinding) {
            return true;
        }
        return ES6ImportHandler.isExportedViaStatement(element, false, false);
    }

    public static boolean isExternalModuleExport(@NotNull JSElement element) {
        if (element == null) {
            ES6ImportHandler.$$$reportNull$$$0(6);
        }
        if (!(element instanceof JSElementBase)) {
            return false;
        }
        if (!((JSElementBase)element).isExported()) {
            return false;
        }
        if (!DialectDetector.isTypeScript((PsiElement)element)) {
            return ES6ImportHandler.isExported((PsiElement)element);
        }
        if (element instanceof ES6ExportSpecifierAlias) {
            return true;
        }
        if (element instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
            if (attributeList != null && attributeList.getNode().findChildByType(JSTokenTypes.EXPORT_KEYWORD) != null) {
                return true;
            }
            JSExecutionScope module = ES6ImportHandler.getOwnerExternalModule((PsiElement)element);
            if (module instanceof TypeScriptModule) {
                return true;
            }
        }
        return ES6ImportHandler.isExportedViaStatement((PsiElement)element, false, false);
    }

    public static JSExecutionScope getOwnerExternalModule(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            ES6ImportHandler.$$$reportNull$$$0(7);
        }
        if ((parent = element.getContext()) instanceof JSVarStatement) {
            parent = parent.getContext();
        }
        return parent instanceof JSFile && ((JSFile)parent).isCommonJSModule() || parent instanceof TypeScriptModule && !((TypeScriptModule)parent).isInternal() ? (JSExecutionScope)parent : null;
    }

    private static boolean isExportedViaStatement(@NotNull PsiElement element, boolean checkDefaultAndAssignment, boolean defaultOnly) {
        String name;
        ES6ExportCache exportedNames;
        if (element == null) {
            ES6ImportHandler.$$$reportNull$$$0(8);
        }
        if ((exportedNames = ES6ImportHandler.getExportedViaStatementCache(element, name = ES6ImportHandler.getName(element))) == null) {
            return false;
        }
        if (checkDefaultAndAssignment) {
            Pair reference = exportedNames.myExportDefaultOrAssignmentReference;
            return reference != null && name.equals(reference.first) && (!defaultOnly || (Boolean)reference.second != false);
        }
        return exportedNames.myNamedExports.contains(name);
    }

    @Nullable
    private static String getName(@NotNull PsiElement element) {
        if (element == null) {
            ES6ImportHandler.$$$reportNull$$$0(9);
        }
        return element instanceof ES6ImportSpecifier ? ((ES6ImportSpecifier)element).getReferenceName() : (element instanceof JSElement ? ((JSElement)element).getName() : null);
    }

    @Nullable
    public static ES6ExportCache getExportedViaStatementCache(@NotNull PsiElement element, @Nullable String name) {
        PsiElement fileOrModule;
        if (element == null) {
            ES6ImportHandler.$$$reportNull$$$0(10);
        }
        if (name == null) {
            return null;
        }
        Object object = fileOrModule = element instanceof JSFile ? element : ES6PsiUtil.getExportScope(element);
        if (fileOrModule == null || !ES6PsiUtil.isExternalModule(fileOrModule)) {
            return null;
        }
        return (ES6ExportCache)CachedValuesManager.getManager((Project)fileOrModule.getProject()).getParameterizedCachedValue((UserDataHolder)fileOrModule, CACHED_VALUE_KEY, CACHED_VALUE_PROVIDER, false, (Object)fileOrModule);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isExported";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isExportedWithNameOrDefault";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isExportedWithNameOrDefaultOrAssignment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isExportedWithDefault";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isExportWithDefaultOrAssignment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateIsExported";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isExternalModuleExport";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getOwnerExternalModule";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isExportedViaStatement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getExportedViaStatementCache";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ES6ExportCache {
        @Nullable
        private final Pair<String, Boolean> myExportDefaultOrAssignmentReference;
        @NotNull
        private final Set<String> myNamedExports;

        private ES6ExportCache(@Nullable Pair<String, Boolean> exportDefaultOrAssignmentReference, @NotNull Set<String> exports) {
            if (exports == null) {
                ES6ExportCache.$$$reportNull$$$0(0);
            }
            this.myExportDefaultOrAssignmentReference = exportDefaultOrAssignmentReference;
            this.myNamedExports = exports;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exports", "com/intellij/lang/ecmascript6/resolve/ES6ImportHandler$ES6ExportCache", "<init>"));
        }
    }
}

