/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSUnwrapPromiseTypeElement;
import com.intellij.lang.javascript.psi.types.ES6DoExpression;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ES6TypeEvaluator
extends JSTypeEvaluator {
    public ES6TypeEvaluator(JSEvaluateContext context, JSTypeProcessor processor) {
        super(context, processor);
    }

    @Override
    protected boolean addTypeFromDialectSpecificElements(PsiElement resolveResult) {
        if (resolveResult instanceof ES6ExportSpecifierAlias) {
            if ((resolveResult = resolveResult.getParent()) instanceof ES6ExportSpecifier) {
                this.processItem((ES6ExportSpecifier)resolveResult, JSEvaluateContext.JSEvaluationPlace.DEFAULT, specifier -> {
                    ResolveResult[] exportSpecifierResults;
                    for (ResolveResult result2 : exportSpecifierResults = specifier.multiResolve(false)) {
                        PsiElement element;
                        if (!result2.isValidResult() || (element = result2.getElement()) == null) continue;
                        this.addTypeFromResolvedImport(element);
                    }
                });
            }
            return true;
        }
        if (resolveResult instanceof ES6ImportedExportedDefaultBinding) {
            String type;
            PsiComment docComment;
            Collection referencedElements = ((ES6ImportedExportedDefaultBinding)resolveResult).findReferencedElements();
            for (PsiElement referencedElement : referencedElements) {
                this.addTypeFromResolvedImport(referencedElement);
            }
            PsiElement parent = resolveResult.getParent();
            if (parent instanceof ES6ImportDeclaration && ((ES6ImportDeclaration)parent).getImportSpecifiers().length == 0 && (!DialectDetector.isTypeScript(parent) || referencedElements.size() == 0) && (docComment = JSDocumentationUtils.findDocComment(parent)) instanceof JSDocComment && (type = ((JSDocComment)docComment).getType()) != null) {
                this.addType(JSTypeUtils.createType(type, JSTypeSourceFactory.createTypeSource((PsiElement)docComment, true)), resolveResult);
            }
            if (referencedElements.isEmpty()) {
                this.myTypeProcessor.processResolvedElement(resolveResult, this.myContext);
            }
            this.addTypeFromLocalName((PsiNamedElement)resolveResult);
            return true;
        }
        if (resolveResult instanceof ES6ImportSpecifierAlias) {
            this.addTypeFromES6ImportSpecifier((ES6ImportSpecifierAlias)resolveResult);
            return true;
        }
        if (resolveResult instanceof JSExportAssignment) {
            this.evaluateExportAssignment((JSExportAssignment)resolveResult);
        }
        return super.addTypeFromDialectSpecificElements(resolveResult);
    }

    @Override
    protected void addTypeFromVariableResolveResult(@NotNull JSFieldVariable jsVariable) {
        ES6ImportCall possibleImportCall;
        if (jsVariable == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(0);
        }
        if (jsVariable instanceof JSParameter && (possibleImportCall = ES6PsiUtil.getImportCallIfContinuationParameter((JSParameterListElement)((JSParameter)jsVariable))) != null) {
            this.addTypeFromImportCall(possibleImportCall);
        }
        super.addTypeFromVariableResolveResult(jsVariable);
    }

    private void addTypeFromES6ImportSpecifier(ES6ImportSpecifierAlias resolveResult) {
        PsiElement aliasedElement = resolveResult.findAliasedElement();
        if (aliasedElement != null) {
            this.processItem(aliasedElement, JSEvaluateContext.JSEvaluationPlace.DEFAULT, element -> this.addTypeFromResolveResult((PsiElement)element, false));
        }
        this.addTypeFromLocalName((PsiNamedElement)resolveResult);
    }

    private void addTypeFromLocalName(PsiNamedElement resolveResult) {
        String name = resolveResult.getName();
        if (name != null && DialectDetector.isJavaScript((PsiElement)resolveResult)) {
            PsiFile file = resolveResult.getContainingFile();
            this.myContext.withLocalScope((PsiElement)file, () -> this.addNamespace(new JSNamespaceImpl(JSQualifiedNameImpl.create(name, null), JSContext.STATIC, false, true), (PsiElement)resolveResult));
        }
    }

    protected void addTypeFromResolvedImport(PsiElement referencedElement) {
        if (referencedElement instanceof JSExportAssignment) {
            this.evaluateExportAssignment((JSExportAssignment)referencedElement);
        } else if (referencedElement instanceof JSFile) {
            this.addTypeFromExternalModuleReferenceResolveResult(referencedElement);
        } else if (referencedElement instanceof StylesheetFile) {
            this.myTypeProcessor.processResolvedElement(referencedElement, this.myContext);
        } else if (referencedElement != null) {
            this.addTypeFromResolveResult(referencedElement, false);
        }
    }

    protected void evaluateExportAssignment(JSExportAssignment assignment) {
        JSElement element = assignment.getStubSafeElement();
        if (element instanceof JSClass || element != null && !(element instanceof JSExpression)) {
            this.addTypeFromResolveResult((PsiElement)element, false);
        } else {
            JSExpression exportDefaultAssignmentExpression;
            JSExpression jSExpression = exportDefaultAssignmentExpression = element == null ? assignment.getExpression() : (JSExpression)element;
            if (exportDefaultAssignmentExpression != null) {
                this.evaluateTypes(exportDefaultAssignmentExpression);
            }
        }
    }

    @Override
    protected boolean evaluateDialectSpecificTypes(JSExpression rawqualifier) {
        if (rawqualifier instanceof JSClassExpression) {
            this.addTypeFromClassExpression((JSClassExpression)rawqualifier);
            return true;
        }
        if (rawqualifier instanceof ES6DoExpression) {
            JSExpression expression;
            JSExpressionStatement expressionStatement;
            ES6DoExpression doExpression = (ES6DoExpression)rawqualifier;
            JSStatement lastStatement = (JSStatement)ArrayUtil.getLastElement((Object[])doExpression.getStatements());
            JSExpressionStatement jSExpressionStatement = expressionStatement = lastStatement instanceof JSExpressionStatement ? (JSExpressionStatement)lastStatement : null;
            if (expressionStatement != null && (expression = expressionStatement.getExpression()) != null) {
                this.evaluateTypes(expression);
            }
        } else if (rawqualifier instanceof ES6ImportCall) {
            ES6ImportCall importCall = (ES6ImportCall)rawqualifier;
            if (this.myContext.peekJSElementToApply() instanceof JSUnwrapPromiseTypeElement) {
                this.myContext.processWithoutTopJSElementToApply(() -> this.addTypeFromImportCall(importCall));
            } else {
                this.addType(JSTypeUtils.wrapInPromiseType(JSAnyType.get((PsiElement)importCall, true)), (PsiElement)importCall);
            }
        } else if (rawqualifier instanceof ES6TaggedTemplateExpression) {
            ES6TaggedTemplateExpression taggedTemplate = (ES6TaggedTemplateExpression)rawqualifier;
            JSApplyCallElement elementToApply = JSApplyCallElement.fromTaggedTemplateExpression(taggedTemplate);
            this.myContext.processWithJSElementToApply(elementToApply, () -> this.evaluateTypes(elementToApply.getMethodExpression()));
            return true;
        }
        return super.evaluateDialectSpecificTypes(rawqualifier);
    }

    protected void addTypeFromClassExpression(@NotNull JSClassExpression classExpression) {
        String qualifiedName;
        if (classExpression == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(1);
        }
        if ((qualifiedName = classExpression.getQualifiedName()) == null || ES6TypeEvaluator.isLocalClass(classExpression)) {
            this.myTypeProcessor.processResolvedElement((PsiElement)classExpression, this.myContext);
            return;
        }
        this.addTypeFromClassWithQName((JSClass)classExpression);
    }

    private static boolean isLocalClass(@NotNull JSClassExpression classExpression) {
        if (classExpression == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(2);
        }
        return !classExpression.isExportedWithDefault() && !classExpression.isNamespaceExplicitlyDeclared();
    }

    protected boolean isPrototypeOrNewExpression() {
        return this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement;
    }

    @Override
    protected void addTypeFromClassCandidate(@NotNull JSClass resolveResult) {
        if (resolveResult == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(3);
        }
        if (resolveResult instanceof JSClassExpression) {
            this.addTypeFromClassExpression((JSClassExpression)resolveResult);
        } else {
            this.addTypeFromClassWithQName(resolveResult);
        }
    }

    protected void addTypeFromClassWithQName(@NotNull JSClass resolveResult) {
        String qualifiedName;
        if (resolveResult == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(4);
        }
        if ((qualifiedName = resolveResult.getQualifiedName()) == null) {
            return;
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)resolveResult, true);
        boolean prototypeOrNewExpression = this.isPrototypeOrNewExpression();
        JSType jsType = JSNamedType.createType(qualifiedName, typeSource, prototypeOrNewExpression ? JSContext.INSTANCE : JSContext.STATIC);
        this.addType(jsType, (PsiElement)resolveResult);
    }

    @Override
    protected void processSuperQualifierExpression(JSSuperExpression rawqualifier, JSClass jsClass) {
        if (jsClass != null) {
            for (JSClass aClass : jsClass.getSuperClasses()) {
                this.addTypeFromClassCandidate(aClass);
            }
        }
    }

    @Override
    protected void addModuleFromRequire(PsiElement module, JSCallExpression callExpression) {
        if (module instanceof JSExportAssignment) {
            this.evaluateExportAssignment((JSExportAssignment)module);
        } else {
            super.addModuleFromRequire(module, callExpression);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsVariable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classExpression";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6TypeEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addTypeFromVariableResolveResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addTypeFromClassExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isLocalClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addTypeFromClassCandidate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addTypeFromClassWithQName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

