/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.actions;

import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.Function;
import com.intellij.xml.util.XmlStringUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSShowTypeInfoAction
extends ExpressionTypeProvider<PsiElement> {
    public static final String UNKNOWN_TYPE_TEXT = "<unknown type>";

    @NotNull
    public String getInformationHint(@NotNull PsiElement element) {
        if (element == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(0);
        }
        JSType type = JSShowTypeInfoAction.expandTypesForPresentation(JSShowTypeInfoAction.getTypeForDocumentation(element));
        String presentableType = JSShowTypeInfoAction.getNonEmptyPresentableType(type, (JSElement)element);
        String string = XmlStringUtil.escapeString((String)presentableType) + JSShowTypeInfoAction.getEscapedMembersPresentation(type);
        if (string == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static JSType getTypeForDocumentation(@NotNull PsiElement element) {
        JSType candidate;
        JSCallExpression callExpression;
        List functionTypes;
        if (element == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(2);
        }
        JSType type = null;
        if (element instanceof JSExpression) {
            type = JSResolveUtil.getExpressionJSType((JSExpression)element);
        } else if (element instanceof JSParameter) {
            type = ((JSParameter)element).getType();
            if (type == null && ((JSParameter)element).getTypeElement() == null) {
                type = JSContextTypeEvaluator.getParameterType((JSParameterListElement)((JSParameter)element), new JSEvaluateContext(element.getContainingFile()), JSExpectedTypeKind.CONTEXTUAL);
            }
        } else if (element instanceof JSTypeDeclarationOwner && (type = ((JSTypeDeclarationOwner)element).getType()) == null) {
            JSTypeEvaluationResult result2 = JSTypeEvaluator.getElementType(element);
            JSType jSType = type = result2 != null ? result2.getType() : null;
        }
        if (type != null && element instanceof JSExpression && element.getParent() instanceof JSCallExpression && (functionTypes = JSTypeUtils.getFunctionType(type, (callExpression = (JSCallExpression)element.getParent()) instanceof JSNewExpression).collect(Collectors.toList())).size() == 1 && (candidate = (JSType)functionTypes.get(0)) instanceof JSFunctionTypeImpl) {
            return TypeScriptGenericTypesEvaluator.applyTypeScriptGenericArguments((JSFunctionTypeImpl)candidate, callExpression);
        }
        return type;
    }

    @NotNull
    public String getErrorHint() {
        String string = JSBundle.message((String)"js.show.type.info.action.error", (Object[])new Object[0]);
        if (string == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public List<PsiElement> getExpressionsAt(@NotNull PsiElement elementAt) {
        if (elementAt == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(4);
        }
        List list = SyntaxTraverser.psiApi().parents((Object)elementAt).filter(o -> o instanceof JSExpression && (!(o instanceof JSFunctionExpression) || JSPsiImplUtils.isArrowFunction((JSFunction)((JSFunctionExpression)o))) || o instanceof JSVariable).toList();
        if (list == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static String getNonEmptyPresentableType(@Nullable JSType type, @NotNull JSElement element) {
        if (element == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(6);
        }
        if (type == null) {
            if (!DialectDetector.isTypeScript((PsiElement)element)) {
                if (UNKNOWN_TYPE_TEXT == null) {
                    JSShowTypeInfoAction.$$$reportNull$$$0(7);
                }
                return UNKNOWN_TYPE_TEXT;
            }
            type = JSAnyType.get((PsiElement)element, false);
        }
        String string = type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        if (string == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String getEscapedMembersPresentation(@Nullable JSType type) {
        if (!(type instanceof JSUnionOrIntersectionType)) {
            if ("" == null) {
                JSShowTypeInfoAction.$$$reportNull$$$0(9);
            }
            return "";
        }
        JSRecordType recordType = type.asRecordType();
        List members = recordType.getTypeMembers();
        if (members.isEmpty()) {
            if ("" == null) {
                JSShowTypeInfoAction.$$$reportNull$$$0(10);
            }
            return "";
        }
        JSRecordTypeImpl wrappedRecordType = new JSRecordTypeImpl(recordType.getSource(), members){

            @Override
            @NotNull
            public String getTypeText(JSType.TypeTextFormat format) {
                StringBuilder builder = new StringBuilder();
                String separator = this.getTypeSeparator(format, ": ");
                char quote = this.getQuote(format);
                for (JSRecordType.TypeMember member : this.getTypeMembers()) {
                    builder.append("<br>&nbsp;&nbsp;");
                    StringBuilder subBuilder = new StringBuilder();
                    member.appendMemberPresentation(format, subBuilder, separator, quote);
                    builder.append(XmlStringUtil.escapeString((String)subBuilder.toString()));
                }
                String string = builder.toString();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/JSShowTypeInfoAction$1", "getTypeText"));
            }
        };
        String string = wrappedRecordType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        if (string == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public static JSType expandTypesForPresentation(@Nullable JSType type) {
        if (type == null) {
            return null;
        }
        type = JSCompositeTypeImpl.optimizeTypeIfComposite(JSTypeUtils.getValuableType(type));
        Function<JSType, JSType> function = new Function<JSType, JSType>(){

            public JSType fun(@NotNull JSType el) {
                JSType alias;
                if (el == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (el instanceof JSTypeImpl && (alias = ((JSTypeImpl)el).getTypedef()) != null) {
                    return alias.transformTypeHierarchy((Function)this);
                }
                if (el instanceof JSGenericTypeImpl) {
                    JSType ownerType = ((JSGenericTypeImpl)el).getType();
                    JSType ownerTransformed = ownerType.transformTypeHierarchy((Function)this);
                    if (ownerTransformed instanceof JSNamedType) {
                        return el;
                    }
                    JSType substitute = el.substitute();
                    return substitute == el ? el : substitute.transformTypeHierarchy((Function)this);
                }
                JSType processedType = JSTypeUtils.getValuableType(el, false);
                return processedType == el ? el : processedType.transformTypeHierarchy((Function)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "el", "com/intellij/lang/javascript/actions/JSShowTypeInfoAction$2", "fun"));
            }
        };
        return type.transformTypeHierarchy((Function)function);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/actions/JSShowTypeInfoAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/actions/JSShowTypeInfoAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationHint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorHint";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionsAt";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonEmptyPresentableType";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapedMembersPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInformationHint";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForDocumentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionsAt";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptyPresentableType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

