/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.EmptyNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSKeywordInsertHandlerBase;
import com.intellij.lang.javascript.macro.JSSuggestVariableNameMacro;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;

public final class JSKeywordInsertHandlers {
    public static final InsertHandler<LookupElement> STATEMENT_WITH_PARENS_INSERT_HANDLER = new JSWithFollowingElementInsertHandler(){

        @Override
        protected Template getTemplate() {
            return STATEMENT_WITH_PARENS_TEMPLATE;
        }

        @Override
        protected IElementType getElementType() {
            return JSTokenTypes.LPAR;
        }
    };
    public static final InsertHandler<LookupElement> TS_REQUIRE_INSERT_HANDLER = new JSWithFollowingElementInsertHandler(){

        @Override
        protected Template getTemplate() {
            return REQUIRE_ARG_TEMPLATE;
        }

        @Override
        protected IElementType getElementType() {
            return JSTokenTypes.LPAR;
        }
    };
    public static final InsertHandler<LookupElement> STATEMENT_WITH_BLOCK_INSERT_HANDLER = new JSWithFollowingElementInsertHandler(){

        @Override
        protected Template getTemplate() {
            return ENTITY_WITH_BLOCK_TEMPLATE;
        }

        @Override
        protected IElementType getElementType() {
            return JSTokenTypes.LBRACE;
        }
    };
    public static final InsertHandler<LookupElement> CATCH_BLOCK_INSERT_HANDLER = new JSWithFollowingElementInsertHandler(){

        @Override
        protected Template getTemplate() {
            return CATCH_BLOCK_TEMPLATE;
        }

        @Override
        protected IElementType getElementType() {
            return JSTokenTypes.LBRACE;
        }
    };
    public static final InsertHandler<LookupElement> NAMED_TYPE_INSERT_HANDLER = new JSWithFollowingElementInsertHandler(){

        @Override
        protected Template getTemplate() {
            return NAMED_TYPE_TEMPLATE;
        }

        @Override
        protected IElementType getElementType() {
            return JSTokenTypes.IDENTIFIER;
        }
    };
    public static final InsertHandler<LookupElement> FUNCTION_KEYWORD_INSERT_HANDLER = new JSKeywordInsertHandlerBase(){

        @Override
        @Nullable
        protected Template applyAndCreateTemplate(InsertionContext context, PsiFile file, PsiElement at) {
            PsiElement parent;
            Template template = null;
            if (at != null && at.getNode().getElementType() == JSTokenTypes.FUNCTION_KEYWORD && (parent = at.getParent()) instanceof JSFunction && !(at.getNextSibling() instanceof JSParameterList)) {
                if (parent instanceof JSFunctionExpression) {
                    template = FUNCTION_EXPRESSION_TEMPLATE;
                } else if (DialectDetector.isJavaScriptFamily((PsiElement)file)) {
                    template = FUNCTION_TEMPLATE;
                } else {
                    EditorModificationUtil.insertStringAtCaret((Editor)context.getEditor(), (String)" ");
                    PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
                }
            }
            return template;
        }
    };
    public static final InsertHandler<LookupElement> CLASS_KEYWORD_INSERT_HANDLER = new JSKeywordInsertHandlerBase(){

        private boolean isLBrace(PsiElement element) {
            if (!(element instanceof LeafPsiElement)) {
                return false;
            }
            return ((LeafPsiElement)element).getElementType() == JSTokenTypes.LBRACE;
        }

        @Override
        @Nullable
        protected Template applyAndCreateTemplate(InsertionContext context, PsiFile file, PsiElement at) {
            PsiElement parent;
            Template template = null;
            if (at != null && at.getNode().getElementType() == JSTokenTypes.CLASS_KEYWORD && ((parent = at.getParent()) instanceof JSClass || parent instanceof JSFile || parent instanceof TypeScriptModule) && !this.isLBrace(PsiTreeUtil.skipWhitespacesForward((PsiElement)at))) {
                if (parent instanceof JSClassExpression) {
                    template = ENTITY_WITH_BLOCK_TEMPLATE;
                } else if (DialectDetector.isJavaScriptFamily((PsiElement)file)) {
                    template = NAMED_TYPE_TEMPLATE;
                } else {
                    EditorModificationUtil.insertStringAtCaret((Editor)context.getEditor(), (String)" ");
                    PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
                }
            }
            return template;
        }
    };
    private static final Template STATEMENT_WITH_PARENS_TEMPLATE = new TemplateImpl("", " ($ARG$) $END$", "");
    private static final Template REQUIRE_ARG_TEMPLATE = new TemplateImpl("", "(\"$ARG$\");\n$END$", "");
    private static final Template ENTITY_WITH_BLOCK_TEMPLATE = new TemplateImpl("", " {\n  $END$\n}", "");
    private static final Template CATCH_BLOCK_TEMPLATE = new TemplateImpl("", " $BINDING$ {\n  $END$\n}", "");
    private static final Template FUNCTION_TEMPLATE = new TemplateImpl("", " $NAME$($PARAMS$) {\n  $END$\n}", "");
    private static final Template FUNCTION_EXPRESSION_TEMPLATE = new TemplateImpl("", "($PARAMS$) {\n  $END$\n}", "");
    private static final Template NAMED_TYPE_TEMPLATE = new TemplateImpl("", " $NAME$ {\n  $END$\n}", "");

    static {
        FUNCTION_TEMPLATE.addVariable("NAME", (Expression)new MacroCallNode((Macro)new JSSuggestVariableNameMacro()), true);
        FUNCTION_TEMPLATE.addVariable("PARAMS", (Expression)new EmptyNode(), true);
        FUNCTION_TEMPLATE.setToReformat(true);
        FUNCTION_EXPRESSION_TEMPLATE.addVariable("PARAMS", (Expression)new EmptyNode(), true);
        FUNCTION_EXPRESSION_TEMPLATE.setToReformat(true);
        STATEMENT_WITH_PARENS_TEMPLATE.addVariable("ARG", (Expression)new EmptyNode(), true);
        STATEMENT_WITH_PARENS_TEMPLATE.setToReformat(true);
        STATEMENT_WITH_PARENS_TEMPLATE.addVariable("ARG", (Expression)new EmptyNode(), true);
        STATEMENT_WITH_PARENS_TEMPLATE.setToReformat(true);
        REQUIRE_ARG_TEMPLATE.addVariable("ARG", (Expression)new MacroCallNode((Macro)new CompleteMacro()), true);
        REQUIRE_ARG_TEMPLATE.setToReformat(true);
        ENTITY_WITH_BLOCK_TEMPLATE.setToReformat(true);
        NAMED_TYPE_TEMPLATE.addVariable("NAME", (Expression)new MacroCallNode((Macro)new JSSuggestVariableNameMacro()), true);
        NAMED_TYPE_TEMPLATE.setToReformat(true);
        CATCH_BLOCK_TEMPLATE.addVariable("BINDING", (Expression)new ConstantNode("(e)"), true);
        CATCH_BLOCK_TEMPLATE.setToReformat(true);
    }

    private static abstract class JSWithFollowingElementInsertHandler
    extends JSKeywordInsertHandlerBase {
        private JSWithFollowingElementInsertHandler() {
        }

        @Override
        @Nullable
        protected Template applyAndCreateTemplate(InsertionContext context, PsiFile file, PsiElement at) {
            Template template = null;
            if (at != null && at.getNode() instanceof LeafPsiElement) {
                PsiElement element = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)at);
                if (element instanceof LeafPsiElement && ((LeafPsiElement)element).getElementType() == this.getElementType()) {
                    context.getEditor().getCaretModel().moveToOffset(((LeafPsiElement)element).getStartOffset() + 1);
                    return null;
                }
                template = this.getTemplate();
            }
            return template;
        }

        protected abstract Template getTemplate();

        protected abstract IElementType getElementType();
    }
}

