/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSReferenceCompletionContributor;
import com.intellij.lang.javascript.completion.JSReferenceCompletionUtil;
import com.intellij.lang.javascript.completion.JSSmartCompletionContributor;
import com.intellij.lang.javascript.completion.TextReferencePropertiesCollector;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.impl.PublicInheritorFilter;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReference;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSTextReferenceCompletion {
    static void addVariants(JSTextReference reference, @NotNull CompletionResultSet resultSet) {
        if (resultSet == null) {
            JSTextReferenceCompletion.$$$reportNull$$$0(0);
        }
        PsiElement element = reference.getElement();
        PsiFile containingFile = element.getContainingFile();
        List<LookupElement> localResults = null;
        boolean newResolveAndCompletion = reference.useActionScriptIndex(containingFile);
        if (newResolveAndCompletion) {
            CompletionResultSink resultSink = new CompletionResultSink((PsiElement)containingFile);
            Collection<String> baseClassFqns = reference.getBaseClassFqns();
            if (baseClassFqns != null && !baseClassFqns.isEmpty()) {
                JSTextReferenceCompletion.setCompletionFilter(resultSink, baseClassFqns, containingFile);
            }
            reference.processToSink(containingFile, resultSink);
            List<PsiElement> results = resultSink.getResults();
            if (results != null) {
                localResults = resultSink.resultsToLookupElements(results);
                resultSet.addAllElements(localResults);
                JSTextReferenceCompletion.forceQualifyIfNeeded(reference, localResults);
            } else {
                localResults = Collections.emptyList();
            }
        }
        if (!newResolveAndCompletion || element instanceof JSLiteralExpression) {
            PsiElement parent;
            JSSmartCompletionContributor contributor;
            List<LookupElement> stringLiteralVariants;
            ArrayList smartResults = ContainerUtil.newArrayList();
            if (element instanceof JSLiteralExpression && (stringLiteralVariants = (contributor = (JSSmartCompletionContributor)JSSmartCompletionContributor.EP_NAME.forLanguage(DialectDetector.languageOfElement(element))).getStringLiteralVariants((JSExpression)element, true)) != null) {
                smartResults.addAll(stringLiteralVariants);
            }
            if ((parent = element.getParent()) instanceof JSIndexedPropertyAccessExpression) {
                TextReferencePropertiesCollector innerSet = new TextReferencePropertiesCollector(resultSet.getPrefixMatcher(), (Consumer<CompletionResult>)((Consumer)result2 -> {}));
                JSReferenceCompletionUtil.calcDefaultVariants((JSExpression)parent, containingFile, containingFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4, (Set<String>)new HashSet(), innerSet);
                smartResults.addAll(innerSet.getCollectedItems());
            }
            JSTextReferenceCompletion.calcDefaultVariants(reference, containingFile, localResults, smartResults, resultSet);
            if (reference instanceof JSDocReference) {
                JSTextReferenceCompletion.addJSDocPredefinedTypes(reference, resultSet);
            }
        }
    }

    private static void addJSDocPredefinedTypes(JSTextReference reference, CompletionResultSet set) {
        if (reference.getElement() instanceof JSDocTagValue && reference.isPrimary()) {
            set.addElement(JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((String)"boolean"), JSLookupPriority.SMART_PRIORITY));
            set.addElement(JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((String)"function"), JSLookupPriority.SMART_PRIORITY));
            set.addElement(JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((String)"number"), JSLookupPriority.SMART_PRIORITY));
            set.addElement(JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((String)"string"), JSLookupPriority.SMART_PRIORITY));
        }
    }

    public static List<LookupElement> calcDefaultVariants(JSTextReference reference, PsiFile containingFile, List<LookupElement> localResults, @NotNull CompletionResultSet resultSet) {
        if (resultSet == null) {
            JSTextReferenceCompletion.$$$reportNull$$$0(1);
        }
        return JSTextReferenceCompletion.calcDefaultVariants(reference, containingFile, localResults, ContainerUtil.emptyList(), resultSet);
    }

    public static List<LookupElement> calcDefaultVariants(@NotNull JSTextReference reference, PsiFile containingFile, List<LookupElement> localResults, List<LookupElement> smartResults, @NotNull CompletionResultSet resultSet) {
        boolean tooMuch;
        PsiElement context;
        PsiReference ref;
        if (reference == null) {
            JSTextReferenceCompletion.$$$reportNull$$$0(2);
        }
        if (resultSet == null) {
            JSTextReferenceCompletion.$$$reportNull$$$0(3);
        }
        PsiElement referenceElement = reference.getElement();
        boolean hasSmartItems = smartResults.size() > 0;
        PsiElement originalElement = CompletionUtil.getOriginalElement((PsiElement)referenceElement);
        String originalQualifiedName = null;
        if (originalElement != null && (ref = originalElement.findReferenceAt(reference.getRangeInElement().getStartOffset())) != null) {
            originalQualifiedName = ref.getCanonicalText();
        }
        final String finalOriginalQualifiedName = originalQualifiedName;
        VariantsProcessor processor = new VariantsProcessor(containingFile, referenceElement, false, resultSet){

            @Override
            protected boolean isOriginalElement(@NotNull JSPsiElementBase element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return super.isOriginalElement(element) || finalOriginalQualifiedName != null && finalOriginalQualifiedName.equals(element.getQualifiedName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/completion/JSTextReferenceCompletion$1", "isOriginalElement"));
            }
        };
        JSQualifiedName qualifier = reference.getQualifiedName().getParent();
        if (qualifier != null) {
            JSNamespaceImpl ns = new JSNamespaceImpl(qualifier, JSContext.UNKNOWN, true);
            processor.addTypeHierarchy(ns, null);
        } else if (!DialectDetector.isActionScript((PsiElement)containingFile)) {
            processor.getTypeInfo().addGlobalType();
        }
        if (hasSmartItems) {
            processor.populateCompletionList(smartResults, false, resultSet);
        }
        processor.setAddOnlyCompleteMatches(qualifier != null || !(referenceElement instanceof JSLiteralExpression));
        if (localResults != null) {
            if (hasSmartItems) {
                JSTextReferenceCompletion.patchResultPrioritiesAndDecorations(containingFile, localResults);
            }
            processor.populateCompletionList(localResults, false, resultSet);
        }
        if ((context = containingFile.getContext()) != null || reference.isPrimary()) {
            CompletionResultSink sink = new CompletionResultSink(referenceElement);
            SinkResolveProcessor<CompletionResultSink> localProcessor = new SinkResolveProcessor<CompletionResultSink>(sink);
            reference.processLocalVariants(containingFile, localProcessor, context);
            List<PsiElement> processorResults = sink.getResults();
            if (processorResults != null) {
                List<LookupElement> resultsAsObjects = sink.resultsToLookupElements(processorResults);
                if (hasSmartItems) {
                    JSTextReferenceCompletion.patchResultPrioritiesAndDecorations(containingFile, resultsAsObjects);
                }
                processor.populateCompletionList(resultsAsObjects, false, resultSet);
            }
        }
        boolean bl = tooMuch = !JSReferenceCompletionContributor.processIndexedSymbols(referenceElement, processor, resultSet, null);
        if (tooMuch) {
            JSReferenceCompletionUtil.handleOverflow(resultSet);
        }
        ArrayList results = ContainerUtil.newArrayList(processor.getFinalResults());
        if (hasSmartItems) {
            JSTextReferenceCompletion.patchResultPrioritiesAndDecorations(containingFile, results);
        }
        processor.populateCompletionList(results, false, resultSet);
        return results;
    }

    private static void patchResultPrioritiesAndDecorations(PsiFile containingFile, List<LookupElement> results) {
        if (!DialectDetector.isActionScript((PsiElement)containingFile)) {
            for (int i = 0; i < results.size(); ++i) {
                LookupElement element = results.get(i);
                element = JSLookupUtilImpl.setBold(element, false);
                results.set(i, JSCompletionUtil.withJSLookupPriority(element, JSLookupPriority.LOWEST_PRIORITY));
            }
        }
    }

    private static void forceQualifyIfNeeded(JSTextReference reference, List<LookupElement> results) {
        if (reference.isOnlyFqns() && reference.isPrimary()) {
            for (LookupElement result2 : results) {
                if (!(result2 instanceof LookupElement)) continue;
                JSLookupUtilImpl.setForceQualify(result2);
            }
        }
    }

    private static void setCompletionFilter(CompletionResultSink resultSink, Collection<String> baseClassFqns, PsiFile containingFile) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
        if (module != null) {
            Condition filter;
            GlobalSearchScope scope = GlobalSearchScope.moduleWithLibrariesScope((Module)module);
            if (baseClassFqns.size() == 1) {
                filter = new PublicInheritorFilter(module.getProject(), baseClassFqns.iterator().next(), scope, false);
            } else {
                List conditions = ContainerUtil.map(baseClassFqns, fqn -> new PublicInheritorFilter(module.getProject(), (String)fqn, scope, false));
                filter = aClass -> {
                    for (Condition condition : conditions) {
                        if (!condition.value(aClass)) continue;
                        return true;
                    }
                    return false;
                };
            }
            resultSink.acceptOnlyClasses((Condition<JSClass>)filter);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSTextReferenceCompletion";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addVariants";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calcDefaultVariants";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

