/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.flowconfig;

import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSConfigImpl
implements FlowJSConfig {
    @NotNull
    private final VirtualFile myConfigDir;
    @NotNull
    private final VirtualFile myConfigFile;
    @NotNull
    private final Collection<String> myIncludedPatterns;
    @NotNull
    private final Collection<String> myIgnoredPatterns;
    @NotNull
    private final Collection<String> tags;
    private final NullableLazyValue<Pattern> myIncludedRegPattern;
    private final NullableLazyValue<Pattern> myIgnoredRegPattern;

    @Nullable
    public static FlowJSConfig getConfig(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile configFile = psiFile.getVirtualFile();
        if (configFile == null) {
            return null;
        }
        VirtualFile configDir = configFile.getParent();
        if (configDir == null) {
            return null;
        }
        return new FlowJSConfigImpl(configFile, configDir);
    }

    @NotNull
    private Collection<String> getIgnoredPatterns() {
        Collection<String> collection = this.getPatterns("ignore");
        if (collection == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    private Collection<String> getIncludedPatterns() {
        Collection<String> collection = this.getPatterns("include");
        if (collection == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(2);
        }
        return collection;
    }

    private static boolean isCommentLine(@NotNull String line) {
        if (line == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(3);
        }
        boolean isComment = false;
        String lineWithoutWhiteSpaces = line.trim();
        if (lineWithoutWhiteSpaces.charAt(0) == '#') {
            isComment = true;
        }
        return isComment;
    }

    @NotNull
    private static ArrayList<String> removeEmptyLines(@NotNull String[] stringArray) {
        if (stringArray == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(4);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (String line : stringArray) {
            String newLine = line.trim();
            if (newLine.isEmpty()) continue;
            result2.add(newLine);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private Collection<String> getPatterns(@NotNull String requiredTag) {
        if (requiredTag == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(6);
        }
        Document configDocument = FileDocumentManager.getInstance().getDocument(this.myConfigFile);
        HashSet myTags = ContainerUtil.newHashSet();
        myTags.addAll(this.tags);
        myTags.remove(requiredTag);
        ArrayList collection = ContainerUtil.newArrayList();
        if (configDocument != null && configDocument.getLineCount() > 0) {
            String text = configDocument.getText();
            boolean isStart = false;
            String[] textLines = text.split("\n");
            ArrayList<String> textWithoutEmptyLines = FlowJSConfigImpl.removeEmptyLines(textLines);
            for (String line : textWithoutEmptyLines) {
                if (!isStart) {
                    if (!line.contains("[" + requiredTag + "]")) continue;
                    isStart = true;
                    continue;
                }
                boolean isAnotherTag = false;
                for (String tag : myTags) {
                    if (!line.contains("[" + tag + "]")) continue;
                    isAnotherTag = true;
                }
                if (isAnotherTag) break;
                if (FlowJSConfigImpl.isCommentLine(line)) continue;
                collection.add(line);
            }
        }
        return collection;
    }

    @Nullable
    private static Pattern createPattern(@Nullable String pattern) {
        if (pattern == null) {
            return null;
        }
        try {
            return Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            Logger.getInstance(FlowJSConfigImpl.class).warn("Bad pattern in .flowconfig: " + pattern);
            return null;
        }
    }

    private FlowJSConfigImpl(@NotNull VirtualFile configFile, @NotNull VirtualFile configDir) {
        if (configFile == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(7);
        }
        if (configDir == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(8);
        }
        this.myIncludedRegPattern = new NullableLazyValue<Pattern>(){

            @Nullable
            protected Pattern compute() {
                if (FlowJSConfigImpl.this.myIncludedPatterns.isEmpty()) {
                    return null;
                }
                String pattern = FlowJSConfigUtil.getRegularExpressionForGlobPattern(FlowJSConfigImpl.this.myIncludedPatterns, FlowJSConfigImpl.this.myConfigDir);
                return FlowJSConfigImpl.createPattern(pattern);
            }
        };
        this.myIgnoredRegPattern = new NullableLazyValue<Pattern>(){

            @Nullable
            protected Pattern compute() {
                if (FlowJSConfigImpl.this.myIgnoredPatterns.isEmpty()) {
                    return null;
                }
                String pattern = FlowJSConfigUtil.getRegularExpression(FlowJSConfigImpl.this.myIgnoredPatterns, FlowJSConfigImpl.this.myConfigDir);
                return FlowJSConfigImpl.createPattern(pattern);
            }
        };
        this.myConfigDir = configDir;
        this.myConfigFile = configFile;
        this.tags = ContainerUtil.newHashSet();
        FlowJSConfigImpl.createTags(this.tags);
        this.myIncludedPatterns = this.getIncludedPatterns();
        this.myIgnoredPatterns = this.getIgnoredPatterns();
    }

    private static void createTags(@NotNull Collection<String> set) {
        if (set == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(9);
        }
        set.add("ignore");
        set.add("include");
        set.add("version");
        set.add("options");
        set.add("libs");
    }

    @Override
    public boolean isFileIncluded(@NotNull VirtualFile file) {
        if (file == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(10);
        }
        String path = file.getCanonicalPath();
        Pattern pattern = (Pattern)this.myIncludedRegPattern.getValue();
        return VfsUtilCore.isAncestor((VirtualFile)this.getConfigDirectory(), (VirtualFile)file, (boolean)false) || pattern != null && FlowJSConfigImpl.checkPattern(path, pattern);
    }

    @Override
    public boolean isFileIgnored(@NotNull VirtualFile file) {
        if (file == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(11);
        }
        String path = file.getCanonicalPath();
        if (this.myIgnoredPatterns.isEmpty()) {
            return false;
        }
        Pattern pattern = (Pattern)this.myIgnoredRegPattern.getValue();
        if (pattern == null) {
            return false;
        }
        return FlowJSConfigImpl.checkPattern(path, pattern);
    }

    private static boolean checkPattern(@NotNull String path, @NotNull Pattern pattern) {
        if (path == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(12);
        }
        if (pattern == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(13);
        }
        Matcher m = pattern.matcher(path);
        return m.find();
    }

    @Override
    @NotNull
    public VirtualFile getConfigFile() {
        VirtualFile virtualFile = this.myConfigFile;
        if (virtualFile == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(14);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile getConfigDirectory() {
        VirtualFile virtualFile = this.myConfigDir;
        if (virtualFile == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(15);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringArray";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredTag";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredPatterns";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedPatterns";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "removeEmptyLines";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfig";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 14: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCommentLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeEmptyLines";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPatterns";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTags";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isFileIncluded";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFileIgnored";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

