/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.formatter.PostFormatProcessorUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import org.jetbrains.annotations.NotNull;

public class JSBracePostFormatProcessor
implements PostFormatProcessor {
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            JSBracePostFormatProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            JSBracePostFormatProcessor.$$$reportNull$$$0(1);
        }
        return PostFormatProcessorUtil.processElement(source, (childElement, childRange) -> {
            if (settings == null) {
                JSBracePostFormatProcessor.$$$reportNull$$$0(9);
            }
            return JSBracePostFormatProcessor.processJS(settings, childElement, childRange);
        });
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            JSBracePostFormatProcessor.$$$reportNull$$$0(2);
        }
        if (rangeToReformat == null) {
            JSBracePostFormatProcessor.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            JSBracePostFormatProcessor.$$$reportNull$$$0(4);
        }
        TextRange textRange = PostFormatProcessorUtil.processText(source, rangeToReformat, (childElement, childRange) -> {
            if (settings == null) {
                JSBracePostFormatProcessor.$$$reportNull$$$0(8);
            }
            return JSBracePostFormatProcessor.processJS(settings, childElement, childRange);
        });
        if (textRange == null) {
            JSBracePostFormatProcessor.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    @NotNull
    private static TextRange processJS(@NotNull CodeStyleSettings settings, PsiElement childElement, TextRange childRange) {
        if (settings == null) {
            JSBracePostFormatProcessor.$$$reportNull$$$0(6);
        }
        JSBraceEnforcer jsBraceEnforcer = new JSBraceEnforcer(settings, childElement, childRange);
        TextRange textRange = jsBraceEnforcer.processElementRange();
        if (textRange == null) {
            JSBracePostFormatProcessor.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    private static void removeIfWhitespace(PsiElement sibling) {
        if (sibling instanceof PsiWhiteSpace) {
            CodeEditUtil.removeChild((ASTNode)sibling.getParent().getNode(), (ASTNode)sibling.getNode());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToReformat";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "processJS";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processJS";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processText$1";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processElement$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSBraceEnforcer
    extends JSRecursiveElementVisitor {
        private CommonCodeStyleSettings mySettings;
        private final PostFormatProcessorHelper myPostFormatProcessor;
        private final PsiElement jsRootElement;
        private final Project myProject;
        private boolean changed;

        public JSBraceEnforcer(@NotNull CodeStyleSettings settings, @NotNull PsiElement element, @NotNull TextRange rangeToReformat) {
            if (settings == null) {
                JSBraceEnforcer.$$$reportNull$$$0(0);
            }
            if (element == null) {
                JSBraceEnforcer.$$$reportNull$$$0(1);
            }
            if (rangeToReformat == null) {
                JSBraceEnforcer.$$$reportNull$$$0(2);
            }
            this.myProject = element.getProject();
            this.myPostFormatProcessor = new PostFormatProcessorHelper(settings);
            this.jsRootElement = element;
            this.mySettings = settings.getCommonSettings(JSLanguageUtil.getLanguageDialect(element));
            this.myPostFormatProcessor.setResultTextRange(rangeToReformat);
        }

        public void visitJSIfStatement(JSIfStatement node) {
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSIfStatement(node);
                this.processStatement((JSStatement)node, node.getThen(), this.mySettings.IF_BRACE_FORCE);
                if (!(node.getElse() instanceof JSIfStatement) || !this.mySettings.SPECIAL_ELSE_IF_TREATMENT) {
                    this.processStatement((JSStatement)node, node.getElse(), this.mySettings.IF_BRACE_FORCE);
                }
            }
        }

        public void visitJSDoWhileStatement(JSDoWhileStatement node) {
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSDoWhileStatement(node);
                this.processStatement((JSStatement)node, node.getBody(), this.mySettings.DOWHILE_BRACE_FORCE);
            }
        }

        public void visitJSWhileStatement(JSWhileStatement node) {
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSWhileStatement(node);
                this.processStatement((JSStatement)node, node.getBody(), this.mySettings.WHILE_BRACE_FORCE);
            }
        }

        public void visitJSForStatement(JSForStatement node) {
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSForStatement(node);
                this.processStatement((JSStatement)node, node.getBody(), this.mySettings.FOR_BRACE_FORCE);
            }
        }

        public void visitJSForInStatement(JSForInStatement node) {
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSForInStatement(node);
                this.processStatement((JSStatement)node, node.getBody(), this.mySettings.FOR_BRACE_FORCE);
            }
        }

        private void processStatement(JSStatement statement, JSStatement blockCandidate, int options) {
            if (blockCandidate instanceof JSBlockStatement || blockCandidate == null) {
                return;
            }
            if (options == 3 || options == 1 && PostFormatProcessorHelper.isMultiline((PsiElement)statement)) {
                this.replaceWithBlock(statement, blockCandidate);
            }
        }

        private void replaceWithBlock(@NotNull JSStatement parent, JSStatement blockCandidate) {
            if (parent == null) {
                JSBraceEnforcer.$$$reportNull$$$0(3);
            }
            assert (parent.isValid());
            if (!this.myPostFormatProcessor.isElementFullyInRange((PsiElement)blockCandidate)) {
                return;
            }
            String oldText = blockCandidate.getText();
            StringBuilder buf = new StringBuilder(oldText.length() + 3);
            buf.append('{');
            buf.append(oldText);
            buf.append("\n}");
            int oldTextLength = parent.getTextLength();
            ASTNode replacement = JSChangeUtil.createJSTreeFromTextWithContext(buf.toString(), (PsiElement)parent);
            if (replacement == null) {
                return;
            }
            ASTNode parentNode = parent.getNode();
            JSBracePostFormatProcessor.removeIfWhitespace(blockCandidate.getNextSibling());
            JSBracePostFormatProcessor.removeIfWhitespace(blockCandidate.getPrevSibling());
            CodeEditUtil.replaceChild((ASTNode)parentNode, (ASTNode)blockCandidate.getNode(), (ASTNode)replacement);
            this.myPostFormatProcessor.updateResultRange(oldTextLength, parent.getTextLength());
            this.changed = true;
        }

        public TextRange processElementRange() {
            if (this.mySettings.IF_BRACE_FORCE == 0 && this.mySettings.FOR_BRACE_FORCE == 0 && this.mySettings.WHILE_BRACE_FORCE == 0 && this.mySettings.DOWHILE_BRACE_FORCE == 0) {
                return this.myPostFormatProcessor.getResultTextRange();
            }
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
            codeStyleManager.performActionWithFormatterDisabled(() -> {
                this.jsRootElement.accept((PsiElementVisitor)this);
                if (!this.changed) {
                    return;
                }
                TextRange resultRange = this.myPostFormatProcessor.getResultTextRange();
                PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)this.myProject);
                Document doc = this.jsRootElement.getContainingFile().getViewProvider().getDocument();
                if (doc != null) {
                    docManager.doPostponedOperationsAndUnblockDocument(doc);
                    codeStyleManager.reformatRange(this.jsRootElement, resultRange.getStartOffset(), resultRange.getEndOffset(), true);
                }
            });
            return this.myPostFormatProcessor.getResultTextRange();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeToReformat";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor$JSBraceEnforcer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replaceWithBlock";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

