/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionDeclaration;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSymbolUtil {
    @NonNls
    public static final String J_QUERY_VAR_NAME = "jQuery";
    @NonNls
    static final String FN_FUN_NAME = "fn";
    @NonNls
    public static final String YAHOO_NAME = "YAHOO";
    public static final String WINDOW_OBJECT_NAME = "window";
    public static final String GLOBAL_OBJECT_NAME2 = "global";
    public static final String GLOBAL_OBJECT_NAME3 = "GLOBAL";
    public static final String EXPORTS = "exports";
    public static final String MODULE = "module";
    public static final String MODULE_EXPORTS = "module.exports";
    public static final String EXTEND_METHOD_PART = "extend";
    private static final String INHERIT_METHOD_PART = "inherit";
    private static final String MERGE_METHOD_NAME = "merge";
    private static final String CREATE_METHOD_PART = "create";
    public static final String DEFINE_METHOD_NAME = "define";
    public static final String REQUIRE_METHOD_NAME = "require";
    public static final String DECLARE_METHOD_NAME = "declare";
    public static final String IMPLEMENT_METHOD_NAME = "implement";
    private static final Key<CachedValue<Map<JSReferenceExpression, JSNamespaceEvaluationResult>>> cachedClassExtendingKey = Key.create((String)"cached.class.extending");

    public static boolean symbolSeemsToBeExtensionFunction(String name) {
        return name != null && (StringUtil.containsIgnoreCase((String)name, (String)EXTEND_METHOD_PART) || StringUtil.containsIgnoreCase((String)name, (String)INHERIT_METHOD_PART) || StringUtil.containsIgnoreCase((String)name, (String)CREATE_METHOD_PART)) || StringUtil.equals((CharSequence)name, (CharSequence)MERGE_METHOD_NAME);
    }

    public static JSExpression[] findClassesNames(JSExpression value) {
        JSExpression firstArg;
        JSExpression[] arguments;
        JSArgumentList list;
        if (value instanceof JSReferenceExpression || value instanceof JSLiteralExpression) {
            return new JSExpression[]{value};
        }
        if (value instanceof JSArrayLiteralExpression) {
            return ((JSArrayLiteralExpression)value).getExpressions();
        }
        if (value instanceof JSCallExpression && (list = ((JSCallExpression)value).getArgumentList()) != null && (arguments = list.getArguments()).length > 0 && (firstArg = arguments[0]) instanceof JSObjectLiteralExpression) {
            JSProperty[] properties = ((JSObjectLiteralExpression)firstArg).getProperties();
            JSExpression[] extendList = new JSExpression[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                extendList[i] = properties[i].getValue();
            }
            return extendList;
        }
        return JSExpression.EMPTY_ARRAY;
    }

    public static boolean isDefinitelyConstructor(@Nullable PsiElement resolve) {
        if (resolve == null) {
            return false;
        }
        JSFunctionItem functionItem = JSPsiImplUtils.calculatePossibleFunction(resolve);
        if (functionItem instanceof JSFunction) {
            return ((JSFunction)functionItem).isConstructor();
        }
        return false;
    }

    public static boolean isConstructorName(String name) {
        if ("constructor".equals(name)) {
            return true;
        }
        return name != null && !name.isEmpty() && Character.isUpperCase(name.charAt(0));
    }

    public static boolean isConstructorSymbol(@NotNull JSPsiElementBase function) {
        if (function == null) {
            JSSymbolUtil.$$$reportNull$$$0(0);
        }
        if (JSResolveUtil.isConstructorFunction((PsiElement)function)) {
            return true;
        }
        return JSSymbolUtil.isConstructorName(function.getName());
    }

    public static void forEachIdentifierProperty(JSObjectLiteralExpression value, PropertyProcessor propertyProcessor) {
        for (JSProperty property : value.getProperties()) {
            String s = property.getName();
            if (s == null || s.length() <= 0 || !StringUtil.isJavaIdentifier((String)s)) continue;
            propertyProcessor.process(StringUtil.toTitleCase((String)s), property);
        }
    }

    public static boolean isExtendCallOutsideFunction(JSExpression qualifier, String calledMethodName, @Nullable Ref<JSContext> outContext) {
        if ("inherits".equals(calledMethodName)) {
            if (outContext != null && qualifier instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)qualifier, "goog")) {
                outContext.set((Object)JSContext.INSTANCE);
            }
            return qualifier != null;
        }
        return qualifier != null && CREATE_METHOD_PART.equals(calledMethodName);
    }

    @NonNls
    public static String suggestSetterName(String propertyName) {
        return "set" + StringUtil.capitalize((String)propertyName);
    }

    @NonNls
    public static String suggestGetterName(String propertyName) {
        return "get" + StringUtil.capitalize((String)propertyName);
    }

    static JSElement findNameComponent(JSElement expr) {
        if (expr instanceof JSReferenceExpression) {
            return expr;
        }
        JSElement current = expr;
        while (expr != null) {
            if (expr instanceof JSReferenceExpression) {
                return expr;
            }
            if (expr instanceof JSAssignmentExpression) {
                JSExpression lOperand;
                JSExpression _lOperand = ((JSAssignmentExpression)expr).getLOperand();
                if (!(_lOperand instanceof JSDefinitionExpression) || !((lOperand = ((JSDefinitionExpression)_lOperand).getExpression()) instanceof JSReferenceExpression)) break;
                expr = lOperand;
                continue;
            }
            if (expr instanceof JSVariable) {
                return expr;
            }
            if (expr instanceof JSCallExpression) {
                JSExpression method = ((JSCallExpression)expr).getMethodExpression();
                if (method instanceof JSReferenceExpression) {
                    return method;
                }
            } else {
                current = expr;
            }
            if (current == null) continue;
            PsiElement parent = current.getParent();
            if (!(parent instanceof JSElement) || parent instanceof JSStatement) break;
            expr = (JSElement)parent;
        }
        return null;
    }

    @NotNull
    public static List<String> buildNameIndexArray(JSElement _expr) {
        final ArrayList<String> nameComponents = new ArrayList<String>();
        JSElement nameComponent = JSSymbolUtil.findNameComponent(_expr);
        JSReferenceExpression expr = null;
        if (nameComponent instanceof JSVariable) {
            String varName = nameComponent.getName();
            if (varName != null) {
                nameComponents.add(varName);
            }
        } else if (nameComponent instanceof JSReferenceExpression) {
            expr = (JSReferenceExpression)nameComponent;
        }
        if (expr != null) {
            final JSReferenceExpression expr1 = expr;
            JSSymbolUtil.visitReferenceExpressionComponentsInRootFirstOrder(expr, new ReferenceExpressionProcessor(){

                @Override
                public void processExpression(JSReferenceExpression expr) {
                    JSType predefinedType = JSSymbolUtil.getPredefinedType(expr);
                    String name = predefinedType != null ? predefinedType.getTypeText(JSType.TypeTextFormat.SIMPLE) : expr.getReferencedName();
                    nameComponents.add(JavaScriptIndex.intern(name));
                }

                @Override
                public void processUnresolvedThis() {
                    nameComponents.add("");
                }

                @Override
                public boolean isTopLevel(JSReferenceExpression expression) {
                    return expr1 == expression;
                }
            });
        }
        ArrayList<String> arrayList = nameComponents;
        if (arrayList == null) {
            JSSymbolUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static String handleSpecialPropertyNames(@NotNull String name, char quote) {
        if (name == null) {
            JSSymbolUtil.$$$reportNull$$$0(2);
        }
        if (name.startsWith("[Symbol.")) {
            String string = name;
            if (string == null) {
                JSSymbolUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (!JSSymbolUtil.isValidPropertyName(name)) {
            StringBuilder builder = new StringBuilder();
            builder.append(quote);
            JSStringUtil.escapeSimpleStringChars(name, quote, true, false, false, builder);
            builder.append(quote);
            String string = builder.toString();
            if (string == null) {
                JSSymbolUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            JSSymbolUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static boolean isUndefinedExpression(@Nullable JSExpression operand) {
        if (!(operand instanceof JSReferenceExpression)) {
            return false;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)operand;
        if (referenceExpression.getQualifier() != null) {
            return false;
        }
        return "undefined".equals(referenceExpression.getText());
    }

    public static boolean isNullLiteral(@Nullable JSExpression initializer) {
        return initializer instanceof JSLiteralExpression && initializer.getNode().findChildByType(JSTokenTypes.NULL_KEYWORD) != null;
    }

    public static boolean areElementsFromSameNamespace(@NotNull JSPsiElementBase element1, @NotNull JSPsiElementBase element2) {
        if (element1 == null) {
            JSSymbolUtil.$$$reportNull$$$0(6);
        }
        if (element2 == null) {
            JSSymbolUtil.$$$reportNull$$$0(7);
        }
        JSNamespace ns1 = element1.getJSNamespace();
        JSNamespace ns2 = element2.getJSNamespace();
        if (!ComparatorUtil.equalsNullable((Object)ns1.getQualifiedName(), (Object)ns2.getQualifiedName())) {
            return false;
        }
        if (!ns1.getJSContext().isCompatibleWith(ns2.getJSContext())) {
            return false;
        }
        if (ns1.isLocal()) {
            if (!ns2.isLocal()) {
                return false;
            }
            PsiFile file1 = element1.getContainingFile();
            if (file1 == null || !file1.isEquivalentTo((PsiElement)element2.getContainingFile())) {
                return false;
            }
        }
        return true;
    }

    static void visitReferenceExpressionComponentsInRootFirstOrder(JSReferenceExpression expr, ReferenceExpressionProcessor processor) {
        String refName;
        JSExpression qualifier = expr.getQualifier();
        if (qualifier instanceof JSCallExpression) {
            qualifier = ((JSCallExpression)qualifier).getMethodExpression();
        }
        if (qualifier instanceof JSIndexedPropertyAccessExpression) {
            qualifier = ((JSIndexedPropertyAccessExpression)qualifier).getQualifier();
        }
        if (qualifier instanceof JSReferenceExpression) {
            JSSymbolUtil.visitReferenceExpressionComponentsInRootFirstOrder((JSReferenceExpression)qualifier, processor);
        }
        if (qualifier instanceof JSThisExpression) {
            processor.processUnresolvedThis();
        }
        if ((refName = expr.getReferencedName()) != null && (!refName.equals("prototype") || processor.isTopLevel(expr))) {
            processor.processExpression(expr);
        }
    }

    public static boolean binaryOpTypeToAvoidRecursions(IElementType sign) {
        return sign == JSTokenTypes.PLUS || sign == JSTokenTypes.OROR || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.COMMA;
    }

    public static boolean isMeaningfulLocalVariableInitializer(JSExpression initializer) {
        return initializer instanceof JSFunction || initializer instanceof JSObjectLiteralExpression;
    }

    public static boolean referencesInterface(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            JSSymbolUtil.$$$reportNull$$$0(8);
        }
        return ContainerUtil.or(JSResolveResult.toElements(ref.multiResolve(false)), e -> e instanceof JSPsiElementBase && ((JSPsiElementBase)e).isClassOrInterface() == JSElementBase.ClassOrInterface.INTERFACE);
    }

    public static boolean isInterface(@NotNull String name, PsiElement context) {
        if (name == null) {
            JSSymbolUtil.$$$reportNull$$$0(9);
        }
        return JSClassIndex.isInterface(name, context, !DialectDetector.isTypeScript(context));
    }

    @Nullable
    private static JSNamespaceEvaluationResult evaluateInitializedPrototype(JSExpression initializer, @NotNull Ref<JSReferenceExpression> outSourceReference) {
        JSExpression operand;
        JSBinaryExpression binaryExpression;
        if (outSourceReference == null) {
            JSSymbolUtil.$$$reportNull$$$0(10);
        }
        if (initializer instanceof JSParenthesizedExpression) {
            initializer = JSUtils.unparenthesize(initializer);
        }
        if (initializer instanceof JSBinaryExpression && (binaryExpression = (JSBinaryExpression)initializer).getOperationSign() == JSTokenTypes.OROR && (operand = binaryExpression.getLOperand()) instanceof JSReferenceExpression) {
            outSourceReference.set((Object)((JSReferenceExpression)operand));
            return JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)operand, JSContext.STATIC, true);
        }
        JSReferenceExpression initializedPrototype = null;
        JSTypeContext typeContext = JSTypeContext.UNKNOWN;
        if (initializer instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)initializer).getReferenceName())) {
            JSExpression qualifier = ((JSReferenceExpression)initializer).getQualifier();
            if (qualifier instanceof JSReferenceExpression) {
                initializedPrototype = (JSReferenceExpression)qualifier;
                typeContext = JSTypeContext.PROTOTYPE;
            }
        } else {
            JSNamespaceEvaluationResult ns;
            if (initializer instanceof JSReferenceExpression && WINDOW_OBJECT_NAME.equals(((JSReferenceExpression)initializer).getReferenceName())) {
                outSourceReference.set((Object)((JSReferenceExpression)initializer));
                return JSSymbolUtil.createWindowNamespace((JSReferenceExpression)initializer, true);
            }
            if (initializer instanceof JSAssignmentExpression) {
                JSExpression initializerlOperand = ((JSAssignmentExpression)initializer).getLOperand();
                if (initializerlOperand instanceof JSDefinitionExpression) {
                    JSExpression lOperand = ((JSDefinitionExpression)initializerlOperand).getExpression();
                    typeContext = JSTypeContext.STATIC;
                    JSSymbolUtil.evaluateInitializedPrototype(lOperand, outSourceReference);
                    initializedPrototype = (JSReferenceExpression)outSourceReference.get();
                    if (initializedPrototype == null && lOperand instanceof JSReferenceExpression && ((JSReferenceExpression)lOperand).getQualifier() instanceof JSReferenceExpression) {
                        initializedPrototype = (JSReferenceExpression)lOperand;
                    }
                }
            } else if (initializer instanceof JSThisExpression && (ns = JSContextResolver.resolveContext((PsiElement)initializer)) != null) {
                return ns;
            }
        }
        if (initializedPrototype == null) {
            return null;
        }
        outSourceReference.set(initializedPrototype);
        return JSSymbolUtil.createNamespaceFromReferenceExpression(initializedPrototype, typeContext.toJSContext(), true);
    }

    @Nullable
    public static JSNamespaceEvaluationResult evaluateNamespaceLocally(@NotNull JSReferenceExpression lOperand) {
        Map cachedMap;
        PsiFile containingFile;
        CachedValue value;
        if (lOperand == null) {
            JSSymbolUtil.$$$reportNull$$$0(11);
        }
        if ((value = (CachedValue)(containingFile = lOperand.getContainingFile()).getUserData(cachedClassExtendingKey)) == null) {
            value = CachedValuesManager.getManager((Project)containingFile.getManager().getProject()).createCachedValue(() -> new CachedValueProvider.Result(Collections.synchronizedMap(new THashMap(100)), new Object[]{containingFile}), false);
            containingFile.putUserData(cachedClassExtendingKey, (Object)value);
        }
        if ((cachedMap = (Map)value.getValue()).containsKey(lOperand)) {
            return (JSNamespaceEvaluationResult)((Object)cachedMap.get(lOperand));
        }
        JSNamespaceEvaluationResult type = JSSymbolUtil.evaluateNamespaceLocally(lOperand, null);
        cachedMap.put(lOperand, type);
        return type;
    }

    @Nullable
    public static JSType getPredefinedType(JSReferenceExpression expression) {
        if (JSSymbolUtil.isAccurateReferenceExpressionName(expression, WINDOW_OBJECT_NAME)) {
            return JSSymbolUtil.createWindowType((PsiElement)expression);
        }
        return null;
    }

    @Nullable
    public static JSNamespaceEvaluationResult getPredefinedNamespace(JSReferenceExpression expression) {
        if (expression.getQualifier() == null && WINDOW_OBJECT_NAME.equals(expression.getReferencedName())) {
            return JSSymbolUtil.createWindowNamespace(expression, true);
        }
        return null;
    }

    private static JSType createWindowType(PsiElement source) {
        return JSNamedType.createType("Window", JSTypeSourceFactory.createTypeSource(source, true), JSTypeContext.PROTOTYPE);
    }

    private static JSNamespaceEvaluationResult createWindowNamespace(JSReferenceExpression expression, boolean isExplicitlyDeclared) {
        JSQualifiedNameImpl name = JSQualifiedNameImpl.create("Window", null);
        return new JSNamespaceEvaluationResult((JSQualifiedName)name, JSContext.INSTANCE, isExplicitlyDeclared, true, (JSElement)expression);
    }

    public static JSNamespaceEvaluationResult evaluateNamespaceLocallyAsIs(@NotNull JSExpression expression) {
        JSNamespaceEvaluationResult result2;
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(12);
        }
        if ((result2 = JSSymbolUtil.evaluateNamespaceLocally(expression)) == null && expression instanceof JSReferenceExpression) {
            result2 = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)expression, JSContext.STATIC, false);
        }
        return result2;
    }

    @Nullable
    public static JSNamespaceEvaluationResult evaluateNamespaceLocally(@Nullable JSExpression expression) {
        return JSSymbolUtil.evaluateNamespaceLocally(expression, null);
    }

    @Nullable
    public static JSNamespaceEvaluationResult evaluateNamespaceLocally(@Nullable JSExpression expression, Set<PsiElement> visited) {
        JSExpression[] arguments;
        JSExpression methodExpression;
        if (expression instanceof JSReferenceExpression) {
            JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally((JSReferenceExpression)expression, visited);
            if (ns != null) {
                return ns;
            }
            JSNamespaceEvaluationResult rawType = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)expression, JSContext.STATIC, true, false, true);
            if (rawType != null) {
                return JSSymbolUtil.replaceLocalVars(rawType, (JSReferenceExpression)expression, visited);
            }
        } else if (expression instanceof JSThisExpression) {
            Ref ref = Ref.create(null);
            JSNamespaceEvaluationResult namespace = JSSymbolUtil.evalThis((JSThisExpression)expression, (Ref<JSReferenceExpression>)ref);
            if (namespace != null) {
                return JSSymbolUtil.replaceLocalVars(namespace, (JSReferenceExpression)ref.get(), visited);
            }
        } else if (expression instanceof JSNewExpression) {
            JSNamespaceEvaluationResult innerResult = JSSymbolUtil.evaluateNamespaceLocally(((JSNewExpression)expression).getMethodExpression());
            if (innerResult != null && innerResult.getJSContext() == JSContext.STATIC) {
                return new JSNamespaceEvaluationResult(innerResult.getQualifiedName(), JSContext.INSTANCE, innerResult.isExplicitlyDeclared(), false, innerResult.getSource());
            }
        } else if (expression instanceof JSCallExpression && (methodExpression = ((JSCallExpression)expression).getMethodExpression()) instanceof JSReferenceExpression && (JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", CREATE_METHOD_PART) || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", EXTEND_METHOD_PART)) && (arguments = ((JSCallExpression)expression).getArguments()).length > 0) {
            return JSSymbolUtil.evaluateNamespaceLocally(arguments[0], visited);
        }
        return null;
    }

    @Nullable
    public static JSType evaluateTypeLocally(JSExpression expression, boolean skipExpressionsHavingStubs) {
        JSNamespaceEvaluationResult result2;
        if (expression instanceof JSLiteralExpression) {
            return JSTypeEvaluator.getTypeFromConstant(expression);
        }
        if (expression instanceof JSArrayLiteralExpression) {
            JSExpression[] expressions = ((JSArrayLiteralExpression)expression).getExpressions();
            ArrayList types = ContainerUtil.newArrayListWithCapacity((int)expressions.length);
            for (JSExpression element : expressions) {
                JSType locallyEvaluatedType = JSSymbolUtil.evaluateTypeLocally(element, skipExpressionsHavingStubs);
                if (locallyEvaluatedType == null) {
                    return null;
                }
                types.add(locallyEvaluatedType);
            }
            boolean isDestructuring = JSDestructuringUtil.arrayLiteralCorrespondsToDestructuringArray(expression);
            if (isDestructuring || types.size() > 0) {
                JSTupleTypeImpl tuple = new JSTupleTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)expression, true), types, false);
                return isDestructuring ? tuple : tuple.toArrayType(false);
            }
            return new JSPrimitiveArrayType(JSTypeSourceFactory.createTypeSource((PsiElement)expression, true), JSTypeContext.INSTANCE);
        }
        if (expression instanceof JSObjectLiteralExpression) {
            JSProperty[] properties = ((JSObjectLiteralExpression)expression).getProperties();
            ArrayList members = ContainerUtil.newArrayListWithCapacity((int)properties.length);
            for (JSProperty property : properties) {
                if (!property.canBeLocallyEvaluated()) {
                    return null;
                }
                String name = property.getName();
                if (name == null) continue;
                JSType type = JSSymbolUtil.evaluateTypeLocally(property.getValue(), skipExpressionsHavingStubs);
                if (type == null) {
                    return null;
                }
                members.add(new JSRecordTypeImpl.PropertySignatureImpl(name, type, false, (PsiElement)property));
            }
            return new JSFreshObjectLiteralTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)expression, true), members);
        }
        if ((!skipExpressionsHavingStubs || expression instanceof JSNewExpression) && (result2 = JSSymbolUtil.evaluateNamespaceLocally(expression)) != null) {
            return result2.toType((PsiElement)expression);
        }
        return null;
    }

    @Nullable
    private static JSNamespaceEvaluationResult evaluateNamespaceLocally(JSReferenceExpression lOperand, @Nullable Set<PsiElement> visited) {
        JSNamespaceEvaluationResult outerType;
        String name;
        JSNamespaceEvaluationResult predefinedType = JSSymbolUtil.getPredefinedNamespace(lOperand);
        if (predefinedType != null) {
            return predefinedType;
        }
        boolean applyInstance = false;
        JSExpression qualifier = lOperand.getQualifier();
        if (qualifier != null && JSSymbolUtil.isPrototype(name = lOperand.getReferenceName()) && qualifier instanceof JSReferenceExpression) {
            lOperand = (JSReferenceExpression)qualifier;
            applyInstance = true;
        }
        JSReferenceExpression originalExpr = lOperand;
        JSElement expressionToFollow = JSSymbolUtil.calcRefExprValue(lOperand);
        if (expressionToFollow == null) {
            return null;
        }
        JSNamespaceEvaluationResult ns = null;
        JSContext jsContext = JSContext.STATIC;
        Ref ref = Ref.create(null);
        if (expressionToFollow instanceof JSExpression) {
            ns = JSSymbolUtil.evaluateInitializedPrototype((JSExpression)expressionToFollow, (Ref<JSReferenceExpression>)ref);
        }
        if (ns == null && (outerType = JSSymbolUtil.checkAnonymousCallForClassExtension(originalExpr.getReferenceName(), expressionToFollow)) != null) {
            ns = outerType;
            JSElement source = outerType.getSource();
            if (source instanceof JSReferenceExpression) {
                ref.set((Object)((JSReferenceExpression)source));
            }
        }
        if (ns != null) {
            lOperand = (JSReferenceExpression)ref.get();
            jsContext = ns.getJSContext();
        } else if (expressionToFollow instanceof JSReferenceExpression) {
            lOperand = (JSReferenceExpression)expressionToFollow;
        } else if (expressionToFollow instanceof JSCallExpression) {
            JSExpression methodExpr = ((JSCallExpression)expressionToFollow).getMethodExpression();
            if ((methodExpr = JSUtils.unparenthesize(methodExpr)) instanceof JSFunctionExpression) {
                JSNamespaceEvaluationResult resultIf = JSSymbolUtil.calcRefExprUsedForClassExtension((JSFunctionExpression)methodExpr, (PsiElement)expressionToFollow, null);
                if (resultIf != null) {
                    ns = resultIf;
                }
            } else if (expressionToFollow instanceof JSNewExpression) {
                if (methodExpr instanceof JSReferenceExpression && !JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpr, "Object")) {
                    JSElement element = JSSymbolUtil.calcRefExprValue((JSReferenceExpression)methodExpr);
                    JSReferenceExpression refExpr = (JSReferenceExpression)(element instanceof JSReferenceExpression ? element : methodExpr);
                    ns = JSSymbolUtil.createNamespaceFromReferenceExpression(refExpr, JSContext.INSTANCE, false);
                }
            } else {
                JSArgumentList list = ((JSCallExpression)expressionToFollow).getArgumentList();
                if (list != null && methodExpr instanceof JSReferenceExpression) {
                    JSExpression[] jsExpressions = list.getArguments();
                    String methodName = ((JSReferenceExpression)methodExpr).getReferencedName();
                    if (jsExpressions.length >= 2 && jsExpressions[0] instanceof JSReferenceExpression && jsExpressions[1] instanceof JSReferenceExpression && methodName != null && JSSymbolUtil.symbolSeemsToBeExtensionFunction(methodName)) {
                        lOperand = (JSReferenceExpression)jsExpressions[0];
                        jsContext = JSContext.UNKNOWN;
                    }
                }
            }
        } else if (expressionToFollow instanceof JSThisExpression) {
            ns = JSSymbolUtil.evalThis((JSThisExpression)expressionToFollow, (Ref<JSReferenceExpression>)ref);
            if (ns != null) {
                lOperand = (JSReferenceExpression)ref.get();
            }
        } else if (expressionToFollow instanceof JSDefinitionExpression) {
            JSExpression refExpr = ((JSDefinitionExpression)expressionToFollow).getExpression();
            if (refExpr instanceof JSReferenceExpression && JSSymbolUtil.isExplicitExportReference((JSReferenceExpression)refExpr)) {
                ns = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)refExpr, JSContext.STATIC, true);
            }
        } else if (expressionToFollow instanceof JSFunctionDeclaration || expressionToFollow instanceof JSVariable) {
            ns = JSNamespaceEvaluationResult.buildProvidedNamespace((JSElementBase)expressionToFollow, true, visited);
        }
        if (ns == null && originalExpr == lOperand && expressionToFollow instanceof JSExpression) {
            if (visited == null) {
                visited = new THashSet();
            }
            if (visited.add((PsiElement)expressionToFollow)) {
                ns = JSSymbolUtil.findNamespace((JSExpression)expressionToFollow, (Set<PsiElement>)visited);
            }
        }
        if (ns == null && lOperand != originalExpr && lOperand != null) {
            ns = JSSymbolUtil.createNamespaceFromReferenceExpression(lOperand, jsContext, true);
        }
        if (ns != null) {
            if (applyInstance) {
                ns = ns.withJSContext(JSContext.INSTANCE);
            }
            return JSSymbolUtil.replaceLocalVars(ns, lOperand, visited);
        }
        return null;
    }

    @Nullable
    public static JSNamespaceEvaluationResult checkAnonymousCallForClassExtension(String name, JSElement scopeElement) {
        JSFunctionExpression funExpr = (JSFunctionExpression)PsiTreeUtil.getParentOfType((PsiElement)scopeElement, JSFunctionExpression.class);
        if (funExpr != null) {
            JSNamespaceEvaluationResult resultIf;
            PsiElement parentOfFunExpr = JSPsiImplUtils.getNonParenthesizeParent((PsiElement)funExpr);
            JSFunctionExpression grandParentForExtensionCalculation = null;
            if (parentOfFunExpr instanceof JSVariable) {
                grandParentForExtensionCalculation = funExpr;
            } else if (parentOfFunExpr instanceof JSCallExpression) {
                grandParentForExtensionCalculation = parentOfFunExpr;
            }
            if (grandParentForExtensionCalculation != null && (resultIf = JSSymbolUtil.calcRefExprUsedForClassExtension(funExpr, (PsiElement)grandParentForExtensionCalculation, name)) != null) {
                return resultIf;
            }
        }
        return null;
    }

    @Nullable
    public static JSElement calcRefExprValue(@NotNull JSReferenceExpression lOperand) {
        if (lOperand == null) {
            JSSymbolUtil.$$$reportNull$$$0(13);
        }
        SmartHashSet visited = new SmartHashSet();
        JSReferenceExpression previous = null;
        while (visited.add(lOperand)) {
            ASTNode node = lOperand.getNode();
            if (JSReferenceExpressionImpl.getQualifierNode(node) != null) {
                return previous;
            }
            String referenceName = JSReferenceExpressionImpl.getReferenceName(node);
            if (referenceName == null) {
                return previous;
            }
            JSElement value = JSSymbolUtil.calcRefExprValue(referenceName, (JSElement)lOperand);
            if (value == null) {
                return previous;
            }
            if (!(value instanceof JSReferenceExpression)) {
                return value;
            }
            previous = lOperand = (JSReferenceExpression)value;
        }
        return null;
    }

    @Nullable
    private static JSElement calcRefExprValue(@NotNull String name, @NotNull JSElement context) {
        if (name == null) {
            JSSymbolUtil.$$$reportNull$$$0(14);
        }
        if (context == null) {
            JSSymbolUtil.$$$reportNull$$$0(15);
        }
        JSElement jsElement = JSSymbolUtil.resolveLocallyIncludingDefinitions(name, context);
        JSElement expressionToFollow = null;
        if (jsElement instanceof JSVariable) {
            JSType type = ((JSVariable)jsElement).getType();
            if (type != null && type.getSource().isStrict()) {
                expressionToFollow = null;
            } else if (jsElement instanceof JSParameter) {
                JSParameter parameter = (JSParameter)jsElement;
                JSNamespaceEvaluationResult initialization = JSSymbolUtil.getParameterInitialization(parameter);
                if (initialization != null && initialization.getSource() != null) {
                    expressionToFollow = initialization.getSource();
                }
            } else if (!(jsElement.getParent() instanceof JSDestructuringProperty) && !(jsElement.getParent() instanceof JSDestructuringContainer)) {
                expressionToFollow = ((JSVariable)jsElement).getInitializer();
            }
        } else if (jsElement instanceof JSFunction) {
            expressionToFollow = jsElement;
        } else if (jsElement instanceof JSDefinitionExpression) {
            expressionToFollow = JSPsiImplUtils.getRightmostOperand((JSDefinitionExpression)jsElement);
        }
        return expressionToFollow;
    }

    @Nullable
    public static JSElement resolveLocallyIncludingDefinitions(@NotNull String name, @NotNull JSElement context) {
        if (name == null) {
            JSSymbolUtil.$$$reportNull$$$0(16);
        }
        if (context == null) {
            JSSymbolUtil.$$$reportNull$$$0(17);
        }
        PsiElement parent = context.getParent();
        ASTNode node = context.getNode();
        JSTreeUtil.JSScopeDeclarationsAndAssignments up = JSTreeUtil.getDeclarationsAndAssignmentsInScopeAndUp(name, node);
        if (up == null) {
            return null;
        }
        CompositeElement definition = up.findNearestDefinition(node);
        if (definition == null) {
            return null;
        }
        PsiElement jsElement = definition.getPsi();
        if (jsElement == null && parent instanceof JSDefinitionExpression) {
            jsElement = parent;
        }
        return (JSElement)jsElement;
    }

    @Nullable
    private static JSNamespaceEvaluationResult evalThis(JSThisExpression expressionToFollow, @NotNull Ref<JSReferenceExpression> outSourceReference) {
        JSNamespaceEvaluationResult ns;
        if (outSourceReference == null) {
            JSSymbolUtil.$$$reportNull$$$0(18);
        }
        if ((ns = JSSymbolUtil.evaluateInitializedPrototype((JSExpression)expressionToFollow, outSourceReference)) != null) {
            return ns.withExplicitlyDeclared(true);
        }
        boolean thisIsGlobal = false;
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expressionToFollow, JSFunction.class);
        if (function == null || function.isAnonymousFunctionCall()) {
            thisIsGlobal = true;
        } else if (function instanceof JSFunctionExpression) {
            PsiElement functionParent = function.getParent();
            if (functionParent instanceof JSParenthesizedExpression) {
                functionParent = functionParent.getParent();
            }
            if (functionParent instanceof JSReferenceExpression && "call".equals(((JSReferenceExpression)functionParent).getReferencedName())) {
                PsiElement prevParent = functionParent;
                if ((functionParent = functionParent.getParent()) instanceof JSCallExpression && ((JSCallExpression)functionParent).getMethodExpression() == prevParent) {
                    JSExpression[] arguments = ((JSCallExpression)functionParent).getArguments();
                    if (arguments.length > 0) {
                        ns = JSSymbolUtil.evaluateInitializedPrototype(arguments[0], outSourceReference);
                        if (outSourceReference.isNull() && arguments[0] instanceof JSThisExpression && PsiTreeUtil.getParentOfType((PsiElement)arguments[0], (Class[])new Class[]{JSFunction.class, JSObjectLiteralExpression.class}) == null) {
                            thisIsGlobal = true;
                        }
                    } else {
                        thisIsGlobal = true;
                    }
                }
            }
        }
        if (thisIsGlobal) {
            return new JSNamespaceEvaluationResult(null, JSContext.STATIC, true, true, (JSElement)expressionToFollow);
        }
        return ns;
    }

    @Nullable
    private static JSNamespaceEvaluationResult calcRefExprUsedForClassExtension(JSFunctionExpression funExpr, PsiElement grandParent, String name) {
        JSExpression expr;
        JSSourceElement[] body = funExpr.getBody();
        if (body.length == 0) {
            return null;
        }
        JSStatement lastStatement = (JSStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)body[0].getLastChild(), JSStatement.class);
        if (lastStatement instanceof JSReturnStatement && (expr = ((JSReturnStatement)lastStatement).getExpression()) != null && (name == null || JSSymbolUtil.isReferencingName(name, expr))) {
            String varName;
            PsiElement grandGrandParent = JSPsiImplUtils.getNonParenthesizeParent(grandParent);
            if (grandGrandParent instanceof JSAssignmentExpression) {
                JSExpression definedExpr;
                JSExpression jsExpression = ((JSAssignmentExpression)grandGrandParent).getLOperand();
                if (jsExpression instanceof JSDefinitionExpression && (definedExpr = ((JSDefinitionExpression)jsExpression).getExpression()) instanceof JSReferenceExpression) {
                    return JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)definedExpr, JSContext.STATIC, true);
                }
            } else if (grandGrandParent instanceof JSVariable && (varName = ((JSVariable)grandGrandParent).getName()) != null) {
                return new JSNamespaceEvaluationResult((JSQualifiedName)JSQualifiedNameImpl.create(varName, null), JSContext.STATIC, true, true, (JSElement)((JSVariable)grandGrandParent));
            }
        }
        return null;
    }

    private static boolean isReferencingName(@Nullable String name, @Nullable JSExpression expr) {
        if (expr instanceof JSReferenceExpression) {
            JSReferenceExpression ref = (JSReferenceExpression)expr;
            return Comparing.equal((String)name, (String)ref.getReferenceName()) && ref.getQualifier() == null;
        }
        return false;
    }

    @Nullable
    public static JSType evaluateReturnedTypeLocally(@NotNull JSFunction function) {
        JSExpression returnExpression;
        JSSourceElement[] body;
        if (function == null) {
            JSSymbolUtil.$$$reportNull$$$0(19);
        }
        if ((body = function.getBody()).length == 0) {
            return null;
        }
        JSStatement lastStatement = (JSStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)body[0].getLastChild(), JSStatement.class);
        if (lastStatement instanceof JSReturnStatement && (returnExpression = ((JSReturnStatement)lastStatement).getExpression()) != null) {
            JSType type = JSSymbolUtil.evaluateTypeLocally(returnExpression, false);
            return type;
        }
        return null;
    }

    @Nullable
    public static JSNamespaceEvaluationResult replaceLocalVars(JSReferenceExpression expression) {
        JSNamespaceEvaluationResult ns = JSSymbolUtil.createNamespaceFromReferenceExpression(expression, JSContext.UNKNOWN, true);
        if (ns != null) {
            return JSSymbolUtil.replaceLocalVars(ns, expression, null);
        }
        return null;
    }

    @Nullable
    private static JSNamespaceEvaluationResult replaceLocalVars(@NotNull JSNamespaceEvaluationResult ns, @Nullable JSReferenceExpression expression, @Nullable Set<PsiElement> visited) {
        if (ns == null) {
            JSSymbolUtil.$$$reportNull$$$0(20);
        }
        if (expression == null) {
            return ns;
        }
        JSQualifiedName qualifiedName = ns.getQualifiedName();
        if (qualifiedName == null) {
            return ns;
        }
        JSReferenceExpression innerMostExpr = expression;
        while (innerMostExpr.getQualifier() != null) {
            JSExpression innerMostExprQualifier = innerMostExpr.getQualifier();
            if (!(innerMostExprQualifier instanceof JSReferenceExpression)) {
                return ns;
            }
            innerMostExpr = (JSReferenceExpression)innerMostExprQualifier;
        }
        PsiElement ref = JSStubBasedPsiTreeUtil.resolveLocally(JSQualifiedNameImpl.getTopmostParent(qualifiedName), (PsiElement)expression, false);
        if (ref instanceof JSParameter) {
            JSFunction declaringFunction = ((JSParameter)ref).getDeclaringFunction();
            if (declaringFunction instanceof JSFunctionExpression && (declaringFunction.getParent() instanceof JSArgumentList || declaringFunction.getParent() instanceof JSParenthesizedExpression)) {
                return null;
            }
            return new JSNamespaceEvaluationResult(JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)((JSVariable)ref)), ns.getJSContext(), true, ns.isDeclaration(), true, false, (JSElement)((JSVariable)ref));
        }
        if (ref instanceof JSVariable) {
            JSExpression initializer = ((JSVariable)ref).getInitializer();
            boolean isDeclaration = ns.isDeclaration();
            JSType type = ((JSVariable)ref).getType();
            if (type != null && type.getSource().isStrict()) {
                isDeclaration = false;
            }
            if (initializer instanceof JSReferenceExpression) {
                JSNamespaceEvaluationResult initializerType = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)initializer, ns.getJSContext(), isDeclaration);
                return JSSymbolUtil.replaceTopmostQualifier(ns, initializerType);
            }
            if (visited == null) {
                visited = new THashSet();
            }
            boolean added = visited.add((PsiElement)innerMostExpr);
            if (innerMostExpr != expression && added) {
                JSNamespaceEvaluationResult innerMostType = JSSymbolUtil.evaluateNamespaceLocally(innerMostExpr, (Set<PsiElement>)visited);
                if (innerMostType == null) {
                    String name = innerMostExpr.getReferenceName();
                    if (JSSymbolUtil.isImportantName(name)) {
                        return JSSymbolUtil.createNamespaceFromReferenceExpression(expression, ns.getJSContext(), isDeclaration);
                    }
                    return null;
                }
                return JSSymbolUtil.replaceTopmostQualifier(ns, innerMostType);
            }
            if (added) {
                JSNamespaceEvaluationResult innerResult = JSSymbolUtil.evaluateNamespaceLocally(innerMostExpr, (Set<PsiElement>)visited);
                if (innerResult == null) {
                    return new JSNamespaceEvaluationResult(JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)((JSVariable)ref)), ns.getJSContext(), true, isDeclaration, ns.isLocal(), false, (JSElement)((JSVariable)ref));
                }
                JSContext jsContext = JSTypeUtils.combineJSContexts(innerResult.getJSContext(), ns.getJSContext());
                return new JSNamespaceEvaluationResult(innerResult.getQualifiedName(), jsContext, innerResult.isExplicitlyDeclared(), innerResult.isDeclaration(), innerResult.isLocal(), false, innerResult.getSource());
            }
        }
        return ns;
    }

    @Contract(value="null -> false")
    public static boolean isAccurateReferenceExpression(@Nullable JSExpression initializer) {
        return initializer instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpression((JSReferenceExpression)initializer);
    }

    public static boolean isAccurateReferenceExpression(@NotNull JSReferenceExpression initializer) {
        if (initializer == null) {
            JSSymbolUtil.$$$reportNull$$$0(21);
        }
        JSExpression initializerQualifier = initializer.getQualifier();
        while (initializerQualifier instanceof JSReferenceExpression) {
            initializerQualifier = ((JSReferenceExpression)initializerQualifier).getQualifier();
        }
        return initializerQualifier == null;
    }

    public static boolean isAccurateReferenceExpressionName(@Nullable JSExpression expression, String ... components) {
        return expression instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)expression, components);
    }

    public static boolean isAccurateReferenceExpressionName(@Nullable JSReferenceExpression referenceExpression, String ... components) {
        JSReferenceExpression ref = referenceExpression;
        int i = components.length - 1;
        while (ref != null) {
            if (i < 0) {
                return false;
            }
            if (!StringUtil.equals((CharSequence)ref.getReferenceName(), (CharSequence)components[i])) {
                return false;
            }
            JSExpression qualifier = ref.getQualifier();
            if (qualifier != null && !(qualifier instanceof JSReferenceExpression)) {
                return false;
            }
            ref = (JSReferenceExpression)qualifier;
            --i;
        }
        return i == -1;
    }

    public static List<String> getReferenceParts(@NotNull JSExpression referenceOrIndexedAccessExpression) {
        if (referenceOrIndexedAccessExpression == null) {
            JSSymbolUtil.$$$reportNull$$$0(22);
        }
        SmartList nameParts = new SmartList();
        JSExpression ref = referenceOrIndexedAccessExpression;
        while (ref != null) {
            if (ref instanceof JSReferenceExpression) {
                JSReferenceExpression reference = (JSReferenceExpression)ref;
                String name = reference.getReferenceName();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    return null;
                }
                nameParts.add(name);
                ref = reference.getQualifier();
                continue;
            }
            if (ref instanceof JSIndexedPropertyAccessExpression) {
                JSIndexedPropertyAccessExpression indexedAccessExpression = (JSIndexedPropertyAccessExpression)ref;
                JSExpression indexExpression = indexedAccessExpression.getIndexExpression();
                if (indexExpression == null) {
                    return null;
                }
                String indexText = indexExpression.getText();
                if (StringUtil.isEmptyOrSpaces((String)indexText)) {
                    return null;
                }
                nameParts.add("[" + indexText + "]");
                ref = indexedAccessExpression.getQualifier();
                continue;
            }
            return null;
        }
        assert (!nameParts.isEmpty());
        Collections.reverse(nameParts);
        return nameParts;
    }

    public static boolean isArgumentOfCallWithName(@NotNull JSExpression argument, String ... components) {
        PsiElement argumentList;
        if (argument == null) {
            JSSymbolUtil.$$$reportNull$$$0(23);
        }
        if (!((argumentList = argument.getParent()) instanceof JSArgumentList)) {
            return false;
        }
        PsiElement callExpression = argumentList.getParent();
        if (!(callExpression instanceof JSCallExpression)) {
            return false;
        }
        JSExpression methodExpression = ((JSCallExpression)callExpression).getMethodExpression();
        return methodExpression instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, components);
    }

    @Nullable
    public static JSQualifiedName getAccurateReferenceName(@NotNull PsiQualifiedReference reference) {
        String referenceName;
        if (reference == null) {
            JSSymbolUtil.$$$reportNull$$$0(24);
        }
        if ((referenceName = reference.getReferenceName()) == null) {
            return null;
        }
        PsiElement qualifier = reference.getQualifier();
        if (qualifier == null) {
            return JSQualifiedNameImpl.create(referenceName, null);
        }
        if (qualifier instanceof PsiQualifiedReference) {
            JSQualifiedName qualifierName = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)qualifier);
            return qualifierName != null ? JSQualifiedNameImpl.create(referenceName, qualifierName) : null;
        }
        return null;
    }

    @Nullable
    public static JSType createTypeFromReferenceExpression(@NotNull JSReferenceExpression expression, JSTypeContext staticOrInstance) {
        JSType predefinedType;
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(25);
        }
        if ((predefinedType = JSSymbolUtil.getPredefinedType(expression)) != null) {
            return predefinedType;
        }
        return JSSymbolUtil.isAccurateReferenceExpression(expression) ? (JSSymbolUtil.isExplicitExportReference(expression) ? JSNamedType.createType(EXPORTS, JSTypeSourceFactory.createTypeSource((PsiElement)expression), staticOrInstance) : JSNamedType.createType(expression.getText(), JSTypeSourceFactory.createTypeSource((PsiElement)expression), staticOrInstance)) : null;
    }

    @Nullable
    public static JSNamespaceEvaluationResult createNamespaceFromReferenceExpression(@NotNull JSReferenceExpression expression, JSContext jsContext, boolean isDeclaration) {
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(26);
        }
        return JSSymbolUtil.createNamespaceFromReferenceExpression(expression, jsContext, isDeclaration, false);
    }

    @Nullable
    public static JSNamespaceEvaluationResult createNamespaceFromReferenceExpression(@NotNull JSReferenceExpression expression, @NotNull JSContext jsContext, boolean isDeclaration, boolean inheritsFunction) {
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(27);
        }
        if (jsContext == null) {
            JSSymbolUtil.$$$reportNull$$$0(28);
        }
        return JSSymbolUtil.createNamespaceFromReferenceExpression(expression, jsContext, isDeclaration, inheritsFunction, false);
    }

    @Nullable
    public static JSNamespaceEvaluationResult createNamespaceFromReferenceExpression(@NotNull JSReferenceExpression expression, @NotNull JSContext jsContext, boolean isDeclaration, boolean inheritsFunction, boolean explicitlyDeclared) {
        JSNamespaceEvaluationResult predefinedNs;
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(29);
        }
        if (jsContext == null) {
            JSSymbolUtil.$$$reportNull$$$0(30);
        }
        if ((predefinedNs = JSSymbolUtil.getPredefinedNamespace(expression)) != null) {
            return predefinedNs;
        }
        String name = expression.getReferenceName();
        if (JSSymbolUtil.isPrototype(name)) {
            JSExpression qualifier = expression.getQualifier();
            if (!(qualifier instanceof JSReferenceExpression)) {
                return null;
            }
            expression = (JSReferenceExpression)qualifier;
            jsContext = JSContext.INSTANCE;
            isDeclaration = true;
        }
        if (JSSymbolUtil.isExplicitExportReference(expression)) {
            return new JSNamespaceEvaluationResult(JSQualifiedNameImpl.create(EXPORTS, null), jsContext, explicitlyDeclared, isDeclaration, true, inheritsFunction, (JSElement)expression);
        }
        JSQualifiedName qualifiedName = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)expression);
        if (qualifiedName == null) {
            return null;
        }
        if (qualifiedName.getParent() != null && WINDOW_OBJECT_NAME.equals(JSQualifiedNameImpl.getTopmostParent(qualifiedName))) {
            List components = qualifiedName.toComponents();
            components.set(0, "Window");
            qualifiedName = JSQualifiedNameImpl.fromComponents(components);
        }
        return new JSNamespaceEvaluationResult(qualifiedName, jsContext, explicitlyDeclared, isDeclaration, inheritsFunction, (JSElement)expression);
    }

    private static boolean isPrototype(String name) {
        return "prototype".equals(name) || FN_FUN_NAME.equals(name);
    }

    @Nullable
    public static JSQualifiedName evaluateReferencedNamespace(JSExpression expression) {
        JSNamespace namespace = JSSymbolUtil.evaluateReferencedNamespace(expression, false);
        return namespace == null ? null : namespace.getQualifiedName();
    }

    @Nullable
    public static JSNamespace evaluateReferencedNamespace(JSExpression expression, boolean evaluateThis) {
        SmartList components = new SmartList();
        boolean canBeEvaluated = true;
        JSContext context = JSContext.STATIC;
        while (canBeEvaluated) {
            JSNamespaceEvaluationResult result2;
            if (expression instanceof JSReferenceExpression) {
                JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally((JSReferenceExpression)expression);
                if (ns != null && ns.getQualifiedName() != null) {
                    JSSymbolUtil.addNamespaceComponents((List<String>)components, ns);
                    break;
                }
                String name = ((JSReferenceExpression)expression).getReferencedName();
                if (!"prototype".equals(name) && name != null) {
                    components.add(0, name);
                } else {
                    context = JSContext.INSTANCE;
                }
                expression = ((JSReferenceExpression)expression).getQualifier();
                continue;
            }
            if (expression instanceof JSIndexedPropertyAccessExpression) {
                String propertyName;
                JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)expression).getIndexExpression();
                if (indexExpression instanceof JSLiteralExpression && (propertyName = ((JSLiteralExpression)indexExpression).getValueAsPropertyName()) != null) {
                    components.add(0, propertyName);
                }
                expression = ((JSIndexedPropertyAccessExpression)expression).getQualifier();
                continue;
            }
            if (evaluateThis && expression instanceof JSThisExpression && (result2 = JSSymbolUtil.evaluateNamespaceLocally(expression)) != null) {
                JSSymbolUtil.addNamespaceComponents((List<String>)components, result2);
                context = JSContext.INSTANCE;
            }
            if (expression == null || expression instanceof JSThisExpression) break;
            canBeEvaluated = false;
        }
        return canBeEvaluated ? new JSNamespaceImpl(JSQualifiedNameImpl.fromComponents((List<String>)components), context, true) : null;
    }

    private static void addNamespaceComponents(@NotNull List<String> components, @NotNull JSSymbolNamespace ns) {
        JSQualifiedName name;
        if (components == null) {
            JSSymbolUtil.$$$reportNull$$$0(31);
        }
        if (ns == null) {
            JSSymbolUtil.$$$reportNull$$$0(32);
        }
        if ((name = ns.getQualifiedName()) == null) {
            return;
        }
        components.addAll(0, QualifiedName.fromDottedString((String)name.getQualifiedName()).getComponents());
    }

    @Nullable
    public static JSQualifiedName getReferencedNamespace(@NotNull JSExpression expression) {
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(33);
        }
        JSExpression qualifier = null;
        String name = null;
        if (expression instanceof JSReferenceExpression) {
            name = ((JSReferenceExpression)expression).getReferencedName();
            qualifier = ((JSReferenceExpression)expression).getQualifier();
        } else if (expression instanceof JSIndexedPropertyAccessExpression) {
            JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)expression).getIndexExpression();
            if (indexExpression instanceof JSLiteralExpression) {
                name = ((JSLiteralExpression)indexExpression).getValueAsPropertyName();
            }
            qualifier = ((JSIndexedPropertyAccessExpression)expression).getQualifier();
        }
        if (name == null) {
            return null;
        }
        if (qualifier == null) {
            return JSQualifiedNameImpl.create(name, null);
        }
        JSQualifiedName namespace = JSSymbolUtil.getReferencedNamespace(qualifier);
        return namespace != null && !"prototype".equals(name) ? JSQualifiedNameImpl.create(name, namespace) : namespace;
    }

    @Nullable
    public static JSQualifiedName getLiteralValueAsQualifiedName(@NotNull JSLiteralExpression literal) {
        if (literal == null) {
            JSSymbolUtil.$$$reportNull$$$0(34);
        }
        if (literal.isQuotedLiteral()) {
            if (literal.getTextLength() > 200) {
                return null;
            }
            String text = literal.getText();
            if (StringUtil.containsWhitespaces((CharSequence)text)) {
                return null;
            }
            return JSQualifiedNameImpl.fromQualifiedName(JSStringUtil.unquoteAndUnescapeString(text));
        }
        return null;
    }

    public static boolean isImportantName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        char ch = name.charAt(0);
        return Character.isUpperCase(ch) || ch == '$';
    }

    @Nullable
    private static JSNamespaceEvaluationResult replaceTopmostQualifier(@NotNull JSNamespaceEvaluationResult ns, @Nullable JSNamespaceEvaluationResult by) {
        JSQualifiedNameImpl initialQName;
        if (ns == null) {
            JSSymbolUtil.$$$reportNull$$$0(35);
        }
        if ((initialQName = (JSQualifiedNameImpl)ns.getQualifiedName()) == null) {
            throw new IllegalArgumentException("Nothing to replace");
        }
        if (by == null) {
            return null;
        }
        JSQualifiedName tail = initialQName.withoutInnermostComponent(null);
        JSQualifiedName replaced = JSQualifiedNameImpl.concat(by.getQualifiedName(), tail);
        return new JSNamespaceEvaluationResult(replaced, ns.getJSContext(), false, ns.isDeclaration(), by.isLocal(), ns.inheritsFunction(), ns.getSource());
    }

    @Nullable
    public static Pair<JSExpression, JSContext> findNamespaceFromArgument(@NotNull JSExpression argument, @NotNull JSArgumentList argumentList) {
        JSQualifiedNamedElement initializedElement;
        boolean seemsToBeExtensionCall;
        JSExpression[] arguments;
        PsiElement firstParent;
        if (argument == null) {
            JSSymbolUtil.$$$reportNull$$$0(36);
        }
        if (argumentList == null) {
            JSSymbolUtil.$$$reportNull$$$0(37);
        }
        if (!((firstParent = argumentList.getParent()) instanceof JSCallExpression)) {
            return null;
        }
        JSCallExpression call = (JSCallExpression)firstParent;
        JSExpression methodExpression = call.getMethodExpression();
        JSExpression qualifyingExpression = null;
        JSContext jsContext = JSContext.UNKNOWN;
        if (methodExpression instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", "defineProperties") && (arguments = argumentList.getArguments()).length > 0 && arguments[0] != argument) {
            qualifyingExpression = arguments[0];
            jsContext = JSContext.STATIC;
        }
        String methodName = methodExpression instanceof JSReferenceExpression ? ((JSReferenceExpression)methodExpression).getReferenceName() : null;
        PsiElement grandParent = call.getParent();
        if (qualifyingExpression == null && grandParent instanceof JSExpressionStatement) {
            JSExpression methodQualifier;
            JSExpression jSExpression = methodQualifier = methodName != null ? ((JSReferenceExpression)methodExpression).getQualifier() : null;
            if ("each".equals(methodName) || EXTEND_METHOD_PART.equals(methodName)) {
                JSReferenceExpression qualifierExpr;
                if (methodQualifier instanceof JSReferenceExpression && FN_FUN_NAME.equals((qualifierExpr = (JSReferenceExpression)methodQualifier).getReferenceName())) {
                    methodQualifier = qualifierExpr.getQualifier();
                }
                if (methodQualifier instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodQualifier, J_QUERY_VAR_NAME)) {
                    qualifyingExpression = methodQualifier;
                }
            } else if (IMPLEMENT_METHOD_NAME.equals(methodName) && methodQualifier instanceof JSReferenceExpression && argumentList.getArguments().length == 1) {
                qualifyingExpression = methodQualifier;
                jsContext = JSContext.INSTANCE;
            }
        }
        boolean seemsToBeExtensionCallStricter = JSSymbolUtil.symbolSeemsToBeExtensionFunction(methodName) || IMPLEMENT_METHOD_NAME.equals(methodName) || JSSymbolUtil.isFrameworkInheritanceMethod(methodName, (PsiElement)argument);
        boolean bl = seemsToBeExtensionCall = seemsToBeExtensionCallStricter || methodName != null && (StringUtil.containsIgnoreCase((String)methodName, (String)CREATE_METHOD_PART) || StringUtil.containsIgnoreCase((String)methodName, (String)"Class"));
        if (!(qualifyingExpression != null || !seemsToBeExtensionCall || (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)call)) == null || initializedElement instanceof JSProperty && "propTypes".equals(initializedElement.getName()))) {
            qualifyingExpression = call;
        }
        if (qualifyingExpression == null && seemsToBeExtensionCallStricter) {
            qualifyingExpression = JSSymbolUtil.getFirstLiteralOrExprArg(argumentList);
        }
        return qualifyingExpression != null ? Pair.create((Object)qualifyingExpression, (Object)jsContext) : null;
    }

    private static boolean isFrameworkInheritanceMethod(String name, PsiElement element) {
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getExtensions(element)) {
            for (String method : handler.inheritanceMethodNames()) {
                if (!StringUtil.equals((CharSequence)name, (CharSequence)method)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static JSExpression getFirstLiteralOrExprArg(JSArgumentList parent) {
        JSExpression[] jsExpressions = parent.getArguments();
        for (int i = 0; i < jsExpressions.length; ++i) {
            JSExpression expr = jsExpressions[i];
            if (expr instanceof JSReferenceExpression || expr instanceof JSLiteralExpression && !expr.textContains(' ') && expr.getTextLength() < 100) {
                return expr;
            }
            if (expr instanceof JSCallExpression) {
                JSArgumentList argumentList = ((JSCallExpression)expr).getArgumentList();
                if (argumentList == null) continue;
                jsExpressions = argumentList.getArguments();
                i = -1;
                continue;
            }
            if (expr instanceof JSArrayLiteralExpression) {
                jsExpressions = ((JSArrayLiteralExpression)expr).getExpressions();
                i = -1;
                continue;
            }
            if (expr instanceof JSObjectLiteralExpression) break;
        }
        return null;
    }

    public static boolean isExtendCall(@Nullable JSExpression qualifier, @Nullable String calledMethodName, @Nullable Ref<JSContext> outContext) {
        if (!JSSymbolUtil.symbolSeemsToBeExtensionFunction(calledMethodName)) {
            return false;
        }
        if (qualifier == null) {
            return true;
        }
        if (!(qualifier instanceof JSReferenceExpression) || ((JSReferenceExpression)qualifier).getQualifier() != null) {
            return false;
        }
        String qualifierText = ((JSReferenceExpression)qualifier).getReferenceName();
        if ("Object".equals(qualifierText)) {
            if (outContext != null) {
                outContext.set((Object)JSContext.STATIC);
            }
            return true;
        }
        if ("Ext".equals(qualifierText)) {
            if (outContext != null) {
                outContext.set((Object)JSContext.INSTANCE);
            }
            return true;
        }
        return YAHOO_NAME.equals(qualifierText) || "_".equals(qualifierText) || "Class".equals(qualifierText);
    }

    public static JSCallExpression getAnonymousFunCall(JSFunction function) {
        PsiElement functionParent = function.getParent();
        if (functionParent instanceof JSParenthesizedExpression) {
            functionParent = functionParent.getParent();
        }
        if (!(functionParent instanceof JSCallExpression)) {
            return null;
        }
        return (JSCallExpression)functionParent;
    }

    @Nullable
    public static JSLiteralExpression getParameterInitializationIfRequireArgument(@NotNull JSParameter jsParameter) {
        JSFunction function;
        if (jsParameter == null) {
            JSSymbolUtil.$$$reportNull$$$0(38);
        }
        if ((function = jsParameter.getDeclaringFunction()) == null) {
            return null;
        }
        Pair<JSLiteralExpression, JSArrayLiteralExpression> requireArguments = JSAmdPsiUtil.getRequireArguments(function);
        if (requireArguments != null) {
            int parameterIndex = JSUtils.findParameterIndex(function, jsParameter);
            if (requireArguments.second != null) {
                JSExpression id = null;
                JSExpression[] expressions = ((JSArrayLiteralExpression)requireArguments.second).getExpressions();
                if (parameterIndex < expressions.length && parameterIndex >= 0) {
                    id = expressions[parameterIndex];
                }
                if (id instanceof JSLiteralExpression) {
                    return (JSLiteralExpression)id;
                }
            }
        }
        return null;
    }

    @Nullable
    public static JSNamespaceEvaluationResult getParameterInitialization(@NotNull JSParameter jsParameter) {
        JSExpression expression;
        JSExpression actualParameter;
        JSFunction function;
        if (jsParameter == null) {
            JSSymbolUtil.$$$reportNull$$$0(39);
        }
        if ((function = jsParameter.getDeclaringFunction()) == null) {
            return null;
        }
        JSNamespaceEvaluationResult nsFromFactoryArgument = JSSymbolUtil.getNamespaceFromMatchedFactoryArgument(jsParameter);
        if (nsFromFactoryArgument != null) {
            return nsFromFactoryArgument;
        }
        JSCallExpression anonymousCallExpr = JSSymbolUtil.getAnonymousFunCall(function);
        if (anonymousCallExpr == null) {
            return null;
        }
        int parameterIndex = JSUtils.findParameterIndex(function, jsParameter);
        JSExpression[] expressions = anonymousCallExpr.getArguments();
        if (0 <= parameterIndex && parameterIndex < expressions.length) {
            actualParameter = expressions[parameterIndex];
        } else {
            if (parameterIndex == -1 && !TypeScriptPsiUtil.isThisParameter((JSParameterItem)jsParameter)) {
                Logger.getInstance(JSSymbolUtil.class).error("name = " + jsParameter.getName(), new Attachment[]{new Attachment("function.txt", function.getText())});
            }
            actualParameter = null;
        }
        JSNamespaceEvaluationResult result2 = null;
        if (actualParameter instanceof JSThisExpression) {
            Ref ref = Ref.create();
            result2 = JSSymbolUtil.evalThis((JSThisExpression)actualParameter, (Ref<JSReferenceExpression>)ref);
            actualParameter = (JSExpression)ref.get();
        }
        if (actualParameter instanceof JSCallExpression && 0 == ((JSCallExpression)actualParameter).getArguments().length && (expression = ((JSCallExpression)actualParameter).getMethodExpression()) instanceof JSReferenceExpression && "call".equals(((JSReferenceExpression)expression).getReferencedName())) {
            JSSourceElement[] body;
            JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
            if (qualifier instanceof JSParenthesizedExpression) {
                qualifier = ((JSParenthesizedExpression)qualifier).getInnerExpression();
            }
            if (qualifier instanceof JSFunctionExpression && (body = ((JSFunctionExpression)qualifier).getBody()).length == 1 && body[0] instanceof JSBlockStatement) {
                JSExpression returned;
                JSStatement secondStatement;
                JSStatement firstStatement = (JSStatement)PsiTreeUtil.getChildOfType((PsiElement)body[0], JSStatement.class);
                JSStatement jSStatement = secondStatement = firstStatement != null ? (JSStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)firstStatement, JSStatement.class) : null;
                if (secondStatement == null && firstStatement instanceof JSReturnStatement && (returned = ((JSReturnStatement)firstStatement).getExpression()) instanceof JSThisExpression) {
                    JSQualifiedNameImpl windowName = JSQualifiedNameImpl.create("Window", null);
                    result2 = new JSNamespaceEvaluationResult((JSQualifiedName)windowName, JSContext.INSTANCE, true, false, (JSElement)returned);
                }
            }
        }
        if (actualParameter instanceof JSReferenceExpression) {
            return new JSNamespaceEvaluationResult(null, JSContext.INSTANCE, false, false, (JSElement)actualParameter);
        }
        return result2;
    }

    private static JSNamespaceEvaluationResult getNamespaceFromMatchedFactoryArgument(@NotNull JSParameter parameter) {
        JSFunction factoryFunction;
        if (parameter == null) {
            JSSymbolUtil.$$$reportNull$$$0(40);
        }
        if (!((factoryFunction = parameter.getDeclaringFunction()) instanceof JSExpression)) {
            return null;
        }
        PsiElement argumentList = factoryFunction.getParent();
        if (!(argumentList instanceof JSArgumentList)) {
            return null;
        }
        PsiElement anonymousFunctionCall = argumentList.getParent();
        if (!(anonymousFunctionCall instanceof JSCallExpression)) {
            return null;
        }
        JSExpression methodExpression = ((JSCallExpression)anonymousFunctionCall).getMethodExpression();
        if (!((methodExpression = JSUtils.unparenthesize(methodExpression)) instanceof JSFunctionExpression)) {
            return null;
        }
        JSParameterListElement[] callingFunctionParameters = ((JSFunctionExpression)methodExpression).getParameters();
        int factoryParameterIndex = ArrayUtil.indexOf((Object[])((JSArgumentList)argumentList).getArguments(), (Object)factoryFunction);
        if (factoryParameterIndex < 0 || factoryParameterIndex >= callingFunctionParameters.length) {
            return null;
        }
        JSParameterListElement factoryParameter = callingFunctionParameters[factoryParameterIndex];
        if (!(factoryParameter instanceof JSParameter)) {
            return null;
        }
        final String factoryParameterName = factoryParameter.getName();
        SmartList factoryCalls = new SmartList();
        methodExpression.acceptChildren((PsiElementVisitor)new JSRecursiveWalkingElementVisitor((List)factoryCalls){
            final /* synthetic */ List val$factoryCalls;
            {
                this.val$factoryCalls = list;
            }

            public void visitJSCallExpression(JSCallExpression node) {
                JSExpression methodExpression = node.getMethodExpression();
                if (methodExpression instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, factoryParameterName)) {
                    this.val$factoryCalls.add(node);
                }
            }

            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/lang/javascript/index/JSSymbolUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        int namespaceParameterIndex = JSUtils.findParameterIndex(factoryFunction, parameter);
        if (namespaceParameterIndex == -1 || factoryCalls.isEmpty()) {
            return null;
        }
        for (JSCallExpression factoryCall : factoryCalls) {
            JSNamespaceEvaluationResult result2;
            JSExpression argumentMatchingNs;
            JSExpression[] arguments = factoryCall.getArguments();
            if (arguments.length <= namespaceParameterIndex || !((argumentMatchingNs = arguments[namespaceParameterIndex]) instanceof JSReferenceExpression) || (result2 = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)argumentMatchingNs, JSContext.STATIC, true, false, true)) == null) continue;
            return result2;
        }
        return null;
    }

    public static boolean isExportReference(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            JSSymbolUtil.$$$reportNull$$$0(41);
        }
        if (JSSymbolUtil.isExplicitExportReference(referenceExpression)) {
            return true;
        }
        if (referenceExpression.getQualifier() != null) {
            return false;
        }
        JSElement element = JSSymbolUtil.calcRefExprValue(referenceExpression);
        return element instanceof JSReferenceExpression && JSSymbolUtil.isExplicitExportReference((JSReferenceExpression)element);
    }

    public static boolean isExplicitExportReference(@Nullable JSReferenceExpression referenceExpression) {
        if (referenceExpression != null) {
            String referencedName = referenceExpression.getReferenceName();
            JSExpression qualifier = referenceExpression.getQualifier();
            return EXPORTS.equals(referencedName) && (qualifier == null || qualifier instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)qualifier, MODULE));
        }
        return false;
    }

    @Nullable
    public static JSType evaluateModuleInnerAlias(JSFunction moduleInitializer, String functionNs) {
        ASTNode returnStatementNode;
        JSType returnType = moduleInitializer.getReturnType();
        if (returnType != null && returnType.getSource().isStrict()) {
            return returnType;
        }
        JSSourceElement[] body = moduleInitializer.getBody();
        if (body.length > 0 && (returnStatementNode = body[0].getNode().findChildByType(JSStubElementTypes.RETURN_STATEMENT)) != null) {
            JSExpression returnExpression = ((JSReturnStatement)returnStatementNode.getPsi()).getExpression();
            JSTypeContext staticOrInstance = JSTypeContext.STATIC;
            JSReferenceExpression referenceExpression = null;
            if (returnExpression instanceof JSNewExpression) {
                JSExpression methodExpression = ((JSNewExpression)returnExpression).getMethodExpression();
                if (methodExpression instanceof JSReferenceExpression) {
                    referenceExpression = (JSReferenceExpression)methodExpression;
                    staticOrInstance = JSTypeContext.INSTANCE;
                }
            } else if (returnExpression instanceof JSReferenceExpression) {
                referenceExpression = (JSReferenceExpression)returnExpression;
            }
            if (referenceExpression != null) {
                return JSSymbolUtil.createTypeFromReferenceExpression(referenceExpression, staticOrInstance);
            }
            if (returnExpression instanceof JSObjectLiteralExpression) {
                return JSNamedType.createType(functionNs, JSTypeSource.EMPTY, staticOrInstance);
            }
        }
        return null;
    }

    public static JSContext getContext(@NotNull JSElement element, boolean useJSDoc) {
        JSExpression qualifier;
        JSExpression expression;
        JSQualifiedNamedElement assignedTo;
        if (element == null) {
            JSSymbolUtil.$$$reportNull$$$0(42);
        }
        if (element instanceof JSAttributeListOwner) {
            if (element instanceof JSParameter) {
                return JSContext.UNKNOWN;
            }
            JSAttributeList attributes = ((JSAttributeListOwner)element).getAttributeList();
            if (attributes != null && attributes.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                return JSContext.STATIC;
            }
            PsiElement parent = JSResolveUtil.findParent((PsiElement)element);
            if (parent instanceof TypeScriptEnum || parent instanceof TypeScriptModule) {
                return JSContext.STATIC;
            }
            if (parent instanceof JSClass) {
                return JSContext.INSTANCE;
            }
        }
        if (element instanceof JSFunctionExpression && (assignedTo = ((JSFunctionExpression)element).getElementAssignedTo()) != null) {
            return assignedTo.getJSContext();
        }
        if (element instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)element).getExpression()) instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)expression).getQualifier()) instanceof JSReferenceExpression && ((JSReferenceExpression)qualifier).getQualifier() != null && "prototype".equals(((JSReferenceExpression)qualifier).getReferenceName())) {
            return JSContext.INSTANCE;
        }
        if (element instanceof TypeScriptTypeMember) {
            if (JSUtils.getMemberContainingClass((PsiElement)element) instanceof TypeScriptInterface) {
                return JSContext.INSTANCE;
            }
            return JSContext.UNKNOWN;
        }
        if (!useJSDoc) {
            return JSContext.UNKNOWN;
        }
        JSContext context = JSDocumentationUtils.findJSContext((PsiElement)element);
        if (element instanceof JSProperty && context == JSContext.UNKNOWN) {
            return JSDocumentationUtils.findJSContext(element.getParent());
        }
        return context;
    }

    @Nullable
    public static String getIndexedPropertyName(@NotNull JSIndexedPropertyAccessExpression expr) {
        JSFunction function;
        PsiElement ref;
        JSExpression indexExpression;
        if (expr == null) {
            JSSymbolUtil.$$$reportNull$$$0(43);
        }
        if ((indexExpression = expr.getIndexExpression()) instanceof JSReferenceExpression && (ref = JSResolveUtil.getLocalVariableRef(function = JSPsiImplUtils.getScopeFunction((JSElement)expr), (JSReferenceExpression)indexExpression)) instanceof JSVariable && !(JSResolveUtil.findParent(ref) instanceof JSLoopStatement)) {
            indexExpression = ((JSVariable)ref).getInitializer();
        }
        if (indexExpression instanceof JSLiteralExpression && ((JSLiteralExpression)indexExpression).isQuotedLiteral()) {
            return JSStringUtil.unquoteAndUnescapeString(indexExpression.getText());
        }
        return null;
    }

    @Nullable
    public static JSNamespaceEvaluationResult findNamespace(@NotNull JSExpression expression) {
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(44);
        }
        return JSSymbolUtil.findNamespace(expression, null);
    }

    @Nullable
    private static JSNamespaceEvaluationResult findNamespace(@NotNull JSExpression expression, @Nullable Set<PsiElement> visited) {
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(45);
        }
        PsiElement parent = expression.getParent();
        JSExpression returnedExpression = JSDialectSpecificHandlersFactory.forElement((PsiElement)expression).getPsiHelper().isReturnedFromFunction(expression) ? expression : null;
        PsiComment docComment = JSDocumentationUtils.findDocCommentWider((PsiElement)expression);
        if (docComment instanceof JSDocComment) {
            JSDocComment comment = (JSDocComment)docComment;
            JSQualifiedName namespace = comment.getNamespace();
            String name = comment.getExplicitName();
            if (name != null) {
                JSContext context = comment.getJSContext();
                return new JSNamespaceEvaluationResult((JSQualifiedName)JSQualifiedNameImpl.create(name, namespace), context, true, true, (JSElement)((JSDocComment)docComment));
            }
        }
        if (parent instanceof JSVariable) {
            return JSNamespaceEvaluationResult.buildProvidedNamespace((JSElementBase)((JSVariable)parent), true, visited);
        }
        if (parent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parent).getROperand() == expression) {
            JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
            if (lOperand instanceof JSDefinitionExpression) {
                return JSNamespaceEvaluationResult.buildProvidedNamespace((JSElementBase)((JSDefinitionExpression)lOperand), true, visited);
            }
        } else {
            PsiElement grandParent;
            if (parent instanceof JSProperty) {
                JSNamespaceEvaluationResult ns = JSNamespaceEvaluationResult.buildProvidedNamespace((JSElementBase)((JSProperty)parent), false, visited);
                if (ns != null && ns.getQualifiedName() != null && parent.getParent() instanceof JSObjectLiteralExpression && parent.getParent().getParent() instanceof JSArgumentList) {
                    String name = ((JSProperty)parent).getName();
                    if ("members".equals(name) || "proto".equals(name)) {
                        return new JSNamespaceEvaluationResult(ns.getQualifiedName().getParent(), JSContext.INSTANCE, ns.isExplicitlyDeclared(), ns.isDeclaration(), ns.isLocal(), ns.inheritsFunction(), (JSElement)parent);
                    }
                    if ("statics".equals(name) || "own".equals(name)) {
                        return new JSNamespaceEvaluationResult(ns.getQualifiedName().getParent(), JSContext.STATIC, ns.isExplicitlyDeclared(), ns.isDeclaration(), ns.isLocal(), ns.inheritsFunction(), (JSElement)parent);
                    }
                }
                return ns;
            }
            if (parent instanceof JSArgumentList && (grandParent = parent.getParent()) instanceof JSCallExpression) {
                JSExpression qualifyingExpression;
                JSExpression methodExpression = ((JSCallExpression)grandParent).getMethodExpression();
                if (methodExpression instanceof JSReferenceExpression && (JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", "freeze") || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", "seal"))) {
                    return JSSymbolUtil.findNamespace((JSExpression)grandParent, visited);
                }
                Pair<JSExpression, JSContext> nsFromArgument = JSSymbolUtil.findNamespaceFromArgument(expression, (JSArgumentList)parent);
                JSExpression jSExpression = qualifyingExpression = nsFromArgument != null ? (JSExpression)nsFromArgument.first : null;
                if (qualifyingExpression instanceof JSReferenceExpression) {
                    JSNamespaceEvaluationResult nsResult = JSSymbolUtil.evaluateNamespaceLocally((JSReferenceExpression)qualifyingExpression, visited);
                    if (nsResult != null) {
                        return nsResult.withJSContext(JSTypeUtils.combineJSContexts((JSContext)nsFromArgument.second, nsResult.getJSContext()));
                    }
                } else if (qualifyingExpression == null) {
                    if (grandParent.getParent() instanceof JSReturnStatement) {
                        returnedExpression = (JSExpression)grandParent;
                    } else {
                        String name;
                        PsiComment callExpressionDocComment = JSDocumentationUtils.findDocComment(grandParent);
                        if (callExpressionDocComment instanceof JSDocComment && (name = ((JSDocComment)callExpressionDocComment).getExplicitName()) != null && ((JSDocComment)callExpressionDocComment).isClassExplicitly()) {
                            JSQualifiedNameImpl qName = JSQualifiedNameImpl.create(name, ((JSDocComment)callExpressionDocComment).getNamespace());
                            return new JSNamespaceEvaluationResult((JSQualifiedName)qName, JSContext.UNKNOWN, false, true, (JSElement)((JSDocComment)callExpressionDocComment));
                        }
                    }
                }
                if (qualifyingExpression != null) {
                    JSNamespaceEvaluationResult innerNs;
                    String s = JSContextResolver.getQualifierOfExprAsString((JSElement)qualifyingExpression);
                    if (s != null) {
                        return new JSNamespaceEvaluationResult((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedName(s), (JSContext)nsFromArgument.second, false, true, (JSElement)qualifyingExpression);
                    }
                    if (visited == null) {
                        visited = ContainerUtil.newHashSet();
                    }
                    if (visited.add(qualifyingExpression) && (innerNs = JSSymbolUtil.findNamespace(qualifyingExpression, visited)) != null) {
                        return innerNs.withJSContext(JSTypeUtils.combineJSContexts((JSContext)nsFromArgument.second, innerNs.getJSContext()));
                    }
                }
            } else {
                if (parent instanceof JSParenthesizedExpression) {
                    return JSSymbolUtil.findNamespace((JSExpression)((JSParenthesizedExpression)parent), visited);
                }
                if (parent instanceof JSBinaryExpression) {
                    IElementType sign = ((JSBinaryExpression)parent).getOperationSign();
                    if (sign == JSTokenTypes.OROR || sign == JSTokenTypes.ANDAND) {
                        return JSSymbolUtil.findNamespace((JSExpression)((JSBinaryExpression)parent), visited);
                    }
                } else {
                    if (parent instanceof JSConditionalExpression) {
                        return JSSymbolUtil.findNamespace((JSExpression)((JSConditionalExpression)parent), visited);
                    }
                    if (parent instanceof ES6ExportDefaultAssignment) {
                        return new JSNamespaceEvaluationResult(JSQualifiedNameImpl.create("default", null), JSContext.STATIC, true, true, true, false, (JSElement)expression);
                    }
                }
            }
        }
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunction.class);
        if (returnedExpression != null && function != null) {
            JSQualifiedName amdNamespace = JSAmdPsiUtil.getNamespaceForAmdModuleElements(function);
            if (amdNamespace != null) {
                return new JSNamespaceEvaluationResult(amdNamespace, JSContext.UNKNOWN, false, true, (JSElement)function);
            }
            PsiElement call = JSPsiImplUtils.getNonParenthesizeParent((PsiElement)function);
            if (call instanceof JSCallExpression) {
                return JSSymbolUtil.findNamespace((JSExpression)call, visited);
            }
        }
        return null;
    }

    public static boolean isValidPropertyName(@NotNull String name) {
        if (name == null) {
            JSSymbolUtil.$$$reportNull$$$0(46);
        }
        if (name.length() == 0) {
            return false;
        }
        char firstChar = (name = StringUtil.replaceUnicodeEscapeSequences((String)name)).charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar)) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSSymbolUtil";
                break;
            }
            case 2: 
            case 9: 
            case 14: 
            case 16: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outSourceReference";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lOperand";
                break;
            }
            case 12: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 33: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceOrIndexedAccessExpression";
                break;
            }
            case 23: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsParameter";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSSymbolUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNameIndexArray";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "handleSpecialPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isConstructorSymbol";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleSpecialPropertyNames";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "areElementsFromSameNamespace";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "referencesInterface";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInterface";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "evaluateInitializedPrototype";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "evaluateNamespaceLocally";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "evaluateNamespaceLocallyAsIs";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "calcRefExprValue";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocallyIncludingDefinitions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "evalThis";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "evaluateReturnedTypeLocally";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "replaceLocalVars";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isAccurateReferenceExpression";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceParts";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isArgumentOfCallWithName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAccurateReferenceName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createTypeFromReferenceExpression";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createNamespaceFromReferenceExpression";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addNamespaceComponents";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedNamespace";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralValueAsQualifiedName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "replaceTopmostQualifier";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findNamespaceFromArgument";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getParameterInitializationIfRequireArgument";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getParameterInitialization";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceFromMatchedFactoryArgument";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isExportReference";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPropertyName";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findNamespace";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isValidPropertyName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PropertyProcessor {
        public void process(String var1, JSProperty var2);
    }

    static interface ReferenceExpressionProcessor {
        public void processExpression(JSReferenceExpression var1);

        public void processUnresolvedThis();

        public boolean isTopLevel(JSReferenceExpression var1);
    }
}

