/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSRecursiveWalkingElementSkippingNestedFunctionsVisitor;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ES6ClassMemberInitializationOrderInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSClass(JSClass aClass) {
                MultiMap referenced = MultiMap.createLinked();
                MultiMap nodes = MultiMap.createLinked();
                for (JSField element : aClass.getFields()) {
                    JSExpression initializer = element.getInitializer();
                    if (initializer == null) continue;
                    String fieldName = element.getName();
                    JSFieldUsagesCollector collector = new JSFieldUsagesCollector(fieldName, (MultiMap<Pair<String, String>, PsiElement>)nodes);
                    initializer.accept((PsiElementVisitor)collector);
                    referenced.put((Object)fieldName, (Collection)collector.referencedFields);
                }
                String[] keySet = referenced.keySet().toArray(ArrayUtil.EMPTY_STRING_ARRAY);
                for (int i = 0; i < keySet.length; ++i) {
                    Collection strings = referenced.get((Object)keySet[i]);
                    for (int j = i; j < keySet.length; ++j) {
                        if (!strings.contains(keySet[j])) continue;
                        Collection elements = nodes.get((Object)Pair.create((Object)keySet[i], (Object)keySet[j]));
                        for (PsiElement element : elements) {
                            holder.registerProblem(element, i == j ? JSBundle.message((String)"js.class.member.initialization.inspection.text.id", (Object[])new Object[]{keySet[i]}) : JSBundle.message((String)"js.class.member.initialization.inspection.text", (Object[])new Object[]{keySet[i], keySet[j]}), new LocalQuickFix[0]);
                        }
                    }
                }
            }
        };
        if (jSElementVisitor == null) {
            ES6ClassMemberInitializationOrderInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ClassMemberInitializationOrderInspection", "createVisitor"));
    }

    private static class JSFieldUsagesCollector
    extends JSRecursiveWalkingElementSkippingNestedFunctionsVisitor {
        private final String myName;
        private final MultiMap<Pair<String, String>, PsiElement> myNodes;
        private Set<String> referencedFields = ContainerUtil.newHashSet();

        public JSFieldUsagesCollector(String name, MultiMap<Pair<String, String>, PsiElement> nodes) {
            this.myName = name;
            this.myNodes = nodes;
        }

        public void visitJSThisExpression(JSThisExpression node) {
            PsiElement parent = node.getParent();
            if (parent instanceof JSReferenceExpression) {
                String referenceName = ((JSReferenceExpression)parent).getReferenceName();
                this.referencedFields.add(referenceName);
                this.myNodes.putValue((Object)Pair.create((Object)this.myName, (Object)referenceName), (Object)parent);
            }
        }
    }
}

