/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.macro.JSMacroUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSSuggestIndexNameMacro
extends Macro {
    public String getName() {
        return "jsSuggestIndexName";
    }

    public String getPresentableName() {
        return JSBundle.message((String)"macro.js.suggest.index.name", (Object[])new Object[0]);
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            JSSuggestIndexNameMacro.$$$reportNull$$$0(0);
        }
        if (params.length != 0) {
            return null;
        }
        PsiElement place = JSMacroUtil.getElementFromContext(context);
        JSNamedElement[] vars = JSMacroUtil.getNamedElementsVisibleAt(context);
        vars = JSSuggestIndexNameMacro.removeNonConflictingLocalVars(vars, place);
        block0: for (char letter = 'i'; letter <= 'z'; letter = (char)(letter + '\u0001')) {
            for (JSNamedElement var : vars) {
                String name = var.getName();
                if (name != null && name.length() == 1 && name.charAt(0) == letter) continue block0;
            }
            return new TextResult(String.valueOf(letter));
        }
        return null;
    }

    private static JSNamedElement[] removeNonConflictingLocalVars(JSNamedElement[] vars, PsiElement place) {
        ArrayList<JSNamedElement> result2 = new ArrayList<JSNamedElement>(vars.length);
        for (JSNamedElement var : vars) {
            PsiElement varParentParent;
            boolean noConflict = false;
            if (var instanceof JSVariable && ((varParentParent = var.getParent().getParent()) instanceof JSBlockStatement || varParentParent instanceof JSLoopStatement) && !PsiTreeUtil.isAncestor((PsiElement)varParentParent, (PsiElement)place, (boolean)false)) {
                noConflict = true;
            }
            if (noConflict) continue;
            result2.add(var);
        }
        return result2.toArray(new JSNamedElement[result2.size()]);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return JSMacroUtil.isJSLikeContext(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/lang/javascript/macro/JSSuggestIndexNameMacro", "calculateResult"));
    }
}

