/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.javascript.nodejs.ForRequireModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModuleUtil {
    @NonNls
    public static final String NODE_MODULES = "node_modules";
    public static final Comparator<VirtualFile> VIRTUAL_FILE_COMPARATOR = (o1, o2) -> {
        int cnt2;
        String path1 = o1.getPath();
        String path2 = o2.getPath();
        int cnt1 = StringUtil.countChars((CharSequence)path1, (char)'/');
        if (cnt1 != (cnt2 = StringUtil.countChars((CharSequence)path2, (char)'/'))) {
            return cnt1 - cnt2;
        }
        return path1.compareTo(path2);
    };
    private static final Key<Ref<VirtualFile>> ourModuleRoot = Key.create((String)"NodeJs.Current.Module.Root");

    public static boolean isModuleFile(@NotNull PsiFile file) {
        if (file == null) {
            NodeModuleUtil.$$$reportNull$$$0(0);
        }
        if (DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType())) {
            return NodeJsCoreLibraryManager.isAssociatedWithNodeCoreLibrary(file);
        }
        return false;
    }

    @Nullable
    public static VirtualFile getProjectChildModuleByName(@NotNull Project project, @NotNull VirtualFile moduleRoot, @NotNull String name) {
        Object nodeModules;
        if (project == null) {
            NodeModuleUtil.$$$reportNull$$$0(1);
        }
        if (moduleRoot == null) {
            NodeModuleUtil.$$$reportNull$$$0(2);
        }
        if (name == null) {
            NodeModuleUtil.$$$reportNull$$$0(3);
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        boolean projectScope = moduleRoot.equals(project.getBaseDir());
        if (projectScope && (nodeModules = moduleRoot.findChild(NODE_MODULES)) != null) {
            return nodeModules.findChild(name);
        }
        nodeModules = new ArrayList(FilenameIndex.getVirtualFilesByName((Project)project, (String)NODE_MODULES, (GlobalSearchScope)scope));
        if (nodeModules.isEmpty()) {
            return null;
        }
        Collections.sort(nodeModules, Comparator.comparing(VirtualFile::getUrl));
        Iterator iterator = nodeModules.iterator();
        while (iterator.hasNext()) {
            VirtualFile child;
            VirtualFile root = (VirtualFile)iterator.next();
            String path = VfsUtilCore.getRelativePath((VirtualFile)root.getParent(), (VirtualFile)moduleRoot);
            if (path == null || path.contains(NODE_MODULES) || (child = root.findChild(name)) == null) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static ForRequireModuleInfo getRequireModuleInfo(@NotNull Project project, @NotNull VirtualFile mainModuleRoot, @NotNull VirtualFile targetFile) {
        VirtualFile current;
        if (project == null) {
            NodeModuleUtil.$$$reportNull$$$0(4);
        }
        if (mainModuleRoot == null) {
            NodeModuleUtil.$$$reportNull$$$0(5);
        }
        if (targetFile == null) {
            NodeModuleUtil.$$$reportNull$$$0(6);
        }
        if (VfsUtilCore.isAncestor((VirtualFile)mainModuleRoot, (VirtualFile)targetFile, (boolean)true)) {
            VirtualFile moduleRoot = JSLibraryUtil.getLibraryFolder(targetFile, NODE_MODULES);
            if (moduleRoot == null) {
                Pair<Boolean, NodeModuleSearchUtil.ModuleMainFiles> info = NodeModuleSearchUtil.findMainModuleInPackage(mainModuleRoot);
                return new ForRequireModuleInfo(mainModuleRoot, targetFile, (NodeModuleSearchUtil.ModuleMainFiles)info.getSecond(), ModuleType.EXACT_PATH);
            }
            return NodeModuleUtil.addFromChildModule(targetFile, moduleRoot);
        }
        VirtualFile baseDir = project.getBaseDir();
        VirtualFile moduleRoot = NodeModuleUtil.findModuleRoot(baseDir, current = targetFile.getParent());
        if (moduleRoot == null) {
            return null;
        }
        return NodeModuleUtil.addFromChildModule(targetFile, moduleRoot);
    }

    public static boolean checkNodeModulesAssociation(@NotNull PsiFile targetPsiFile, boolean checkForNodeLibraryAssociation) {
        if (targetPsiFile == null) {
            NodeModuleUtil.$$$reportNull$$$0(7);
        }
        return !checkForNodeLibraryAssociation || NodeModuleSearchUtil.canLoadFile(targetPsiFile.getVirtualFile()) && NodeModuleUtil.isLocalModuleOrNodeModulesLibrary(targetPsiFile, targetPsiFile.getVirtualFile());
    }

    private static boolean isLocalModuleOrNodeModulesLibrary(PsiFile targetPsiFile, VirtualFile targetFile) {
        return NodeModuleUtil.isModuleFile(targetPsiFile) || JSLibraryUtil.hasDirectoryInPath(targetFile, NODE_MODULES, null);
    }

    @NotNull
    private static ForRequireModuleInfo addFromChildModule(VirtualFile targetFile, VirtualFile moduleRoot) {
        Pair<Boolean, NodeModuleSearchUtil.ModuleMainFiles> info = NodeModuleSearchUtil.findMainModuleInPackage(moduleRoot);
        ForRequireModuleInfo forRequireModuleInfo = new ForRequireModuleInfo(moduleRoot, targetFile, (NodeModuleSearchUtil.ModuleMainFiles)info.getSecond(), ModuleType.NODE_MODULES_DIR);
        if (forRequireModuleInfo == null) {
            NodeModuleUtil.$$$reportNull$$$0(8);
        }
        return forRequireModuleInfo;
    }

    @Nullable
    private static VirtualFile findModuleRoot(@NotNull VirtualFile baseDir, @Nullable VirtualFile current) {
        if (baseDir == null) {
            NodeModuleUtil.$$$reportNull$$$0(9);
        }
        VirtualFile moduleRoot = null;
        while (current != null && !baseDir.equals(current)) {
            if (current.getParent() != null && NODE_MODULES.equals(current.getParent().getName())) {
                moduleRoot = current;
                break;
            }
            current = current.getParent();
        }
        return moduleRoot;
    }

    public static VirtualFile getMainModuleRoot(LocalInspectionToolSession session) {
        VirtualFile moduleRoot;
        Ref ref = (Ref)session.getUserData(ourModuleRoot);
        if (ref == null) {
            PsiFile psiFile = session.getFile();
            moduleRoot = NodeModuleUtil.findMainModuleRoot(psiFile.getProject(), psiFile.getVirtualFile());
            session.putUserData(ourModuleRoot, (Object)new Ref((Object)moduleRoot));
        } else {
            moduleRoot = (VirtualFile)ref.get();
        }
        return moduleRoot;
    }

    @Nullable
    public static VirtualFile findMainModuleRoot(Project project, VirtualFile file) {
        VirtualFile current;
        if (file == null) {
            return null;
        }
        VirtualFile baseDir = project.getBaseDir();
        VirtualFile contentRoot = NodeModuleUtil.findParentContentRoot(project, file);
        if (contentRoot == null) {
            return null;
        }
        VirtualFile virtualFile = current = file.isDirectory() ? file : file.getParent();
        while (current != null) {
            VirtualFile packageJson = current.findChild("package.json");
            if (packageJson != null && packageJson.isValid() && !packageJson.isDirectory()) {
                return current;
            }
            if (baseDir.equals(current)) {
                return baseDir;
            }
            current = current.getParent();
        }
        return ApplicationManager.getApplication().isUnitTestMode() ? baseDir : null;
    }

    @Nullable
    public static VirtualFile findParentContentRoot(Project project, VirtualFile file) {
        VirtualFile[] contentRoots = ProjectRootManager.getInstance((Project)project).getContentRoots();
        VirtualFile contentRoot = null;
        for (VirtualFile root : contentRoots) {
            if (!root.equals(VfsUtilCore.getCommonAncestor((VirtualFile)root, (VirtualFile)file))) continue;
            contentRoot = root;
            break;
        }
        return contentRoot;
    }

    public static boolean isForNode(@NotNull Project project, @NotNull VirtualFile vf) {
        if (project == null) {
            NodeModuleUtil.$$$reportNull$$$0(10);
        }
        if (vf == null) {
            NodeModuleUtil.$$$reportNull$$$0(11);
        }
        return NodeJsCoreLibraryManager.isAssociatedWithNodeCoreLibrary(project, vf);
    }

    public static boolean isWrappedInAmdDefinition(@NotNull PsiElement element) {
        if (element == null) {
            NodeModuleUtil.$$$reportNull$$$0(12);
        }
        return JSAmdUtil.getCachedWrappingAmdDefinition(element) != null;
    }

    public static boolean isResolvedGloballyCommonJS(@NotNull ResolveResult result2, @NotNull Set<VirtualFile> predefinedFiles, @NotNull LocalInspectionToolSession session) {
        if (result2 == null) {
            NodeModuleUtil.$$$reportNull$$$0(13);
        }
        if (predefinedFiles == null) {
            NodeModuleUtil.$$$reportNull$$$0(14);
        }
        if (session == null) {
            NodeModuleUtil.$$$reportNull$$$0(15);
        }
        return result2.isValidResult() && result2.getElement() != null && result2.getElement().getContainingFile() != null && (predefinedFiles.contains(result2.getElement().getContainingFile().getVirtualFile()) || NodeModuleUtil.isResolvedGloballyForNode(result2) || NodeModuleUtil.isResolvedGloballyForFlowOrTypeScript(result2));
    }

    public static boolean isResolvedGloballyForNode(@NotNull ResolveResult result2) {
        JSQualifiedName qualifier;
        if (result2 == null) {
            NodeModuleUtil.$$$reportNull$$$0(16);
        }
        return result2.getElement() != null && result2.getElement() instanceof JSDefinitionExpression && (qualifier = ((JSDefinitionExpression)result2.getElement()).getNamespace()) != null && "global".equals(qualifier.getName());
    }

    private static boolean isResolvedGloballyForFlowOrTypeScript(@NotNull ResolveResult result2) {
        JSAttributeList attributeList;
        DialectOptionHolder holder;
        PsiElement element;
        if (result2 == null) {
            NodeModuleUtil.$$$reportNull$$$0(17);
        }
        return (element = result2.getElement()) instanceof JSAttributeListOwner && (holder = DialectDetector.dialectOfElement(element)) != null && (holder.isFlow || holder.isTypeScript) && JSPsiImplUtils.getScopeNode((JSElement)((JSAttributeListOwner)element)) instanceof JSFile && (attributeList = ((JSAttributeListOwner)element).getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.DECLARE);
    }

    public static boolean isFromNodeModules(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile nodeModulesDir;
        if (project == null) {
            NodeModuleUtil.$$$reportNull$$$0(18);
        }
        if (file == null) {
            NodeModuleUtil.$$$reportNull$$$0(19);
        }
        if ((nodeModulesDir = NodeModuleSearchUtil.findAncestorNodeModulesDir(file)) == null) {
            return false;
        }
        return NodeModuleUtil.findParentContentRoot(project, nodeModulesDir) == null && !VfsUtilCore.isAncestor((VirtualFile)project.getBaseDir(), (VirtualFile)nodeModulesDir, (boolean)true);
    }

    @Nullable
    public static VirtualFile findNodeModulesByPackageJson(@NotNull VirtualFile packageJson) {
        VirtualFile nodeModulesDir;
        VirtualFile parent;
        if (packageJson == null) {
            NodeModuleUtil.$$$reportNull$$$0(20);
        }
        VirtualFile virtualFile = parent = packageJson.isDirectory() ? null : packageJson.getParent();
        if (parent != null && parent.isValid() && (nodeModulesDir = parent.findChild(NODE_MODULES)) != null && nodeModulesDir.isDirectory()) {
            return nodeModulesDir;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile findPackageJsonByNodeModules(@Nullable VirtualFile nodeModulesDir) {
        VirtualFile parent;
        VirtualFile virtualFile = parent = nodeModulesDir != null && nodeModulesDir.isDirectory() ? nodeModulesDir.getParent() : null;
        if (parent != null) {
            return PackageJsonUtil.findChildPackageJsonFile(parent);
        }
        return null;
    }

    @Nullable
    public static VirtualFile findUpClosestNodeModulesResolveRoot(@NotNull VirtualFile file) {
        if (file == null) {
            NodeModuleUtil.$$$reportNull$$$0(21);
        }
        return JSLibraryUtil.findUpClosestNodeModulesResolveRoot(file);
    }

    public static boolean moduleNotInPackageJson(@NotNull String name, @NotNull VirtualFile packageJsonFile) {
        PackageJsonData data;
        if (name == null) {
            NodeModuleUtil.$$$reportNull$$$0(22);
        }
        if (packageJsonFile == null) {
            NodeModuleUtil.$$$reportNull$$$0(23);
        }
        return !(data = PackageJsonData.getOrCreate(packageJsonFile)).isDependencyOfAnyType(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
            case 3: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainModuleRoot";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPsiFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/NodeModuleUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedFiles";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/NodeModuleUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addFromChildModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isModuleFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProjectChildModuleByName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRequireModuleInfo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkNodeModulesAssociation";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findModuleRoot";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isForNode";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isWrappedInAmdDefinition";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isResolvedGloballyCommonJS";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isResolvedGloballyForNode";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isResolvedGloballyForFlowOrTypeScript";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isFromNodeModules";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findNodeModulesByPackageJson";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findUpClosestNodeModulesResolveRoot";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "moduleNotInPackageJson";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

