/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.JSParsingResult;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeNameValuePairImpl;
import com.intellij.lang.javascript.psi.stubs.JSAttributeListStub;
import com.intellij.lang.javascript.psi.stubs.JSParameterListStub;
import com.intellij.lang.javascript.psi.stubs.JSParameterStub;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class FunctionParser<T extends JavaScriptParser>
extends JavaScriptParserBase<T> {
    public static final Key<Boolean> ASYNC_METHOD_KEY = Key.create((String)"js.asyncMethod");
    public static final Key<String> methodsEmptinessKey = Key.create((String)"methodsEmptinessKey");
    public static final String METHODS_EMPTINESS_ALWAYS = "a";
    public static final String METHODS_EMPTINESS_POSSIBLY = "p";
    public static final Key<Boolean> IS_GENERATOR_FUNCTION_KEY = Key.create((String)"js.generator.Function");

    protected FunctionParser(T parser) {
        super(parser);
    }

    public boolean parseFunctionExpression() {
        PsiBuilder.Marker mark = this.builder.mark();
        this.parseFunctionExpressionAttributeList();
        return this.parseFunctionNoMarker(Context.EXPRESSION, mark);
    }

    public boolean isFunctionDeclarationStart() {
        return this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD;
    }

    public void parseFunctionDeclaration() {
        String prevMethodEmptiness = (String)this.builder.getUserData(methodsEmptinessKey);
        try {
            PsiBuilder.Marker mark = this.builder.mark();
            this.parseAttributesList();
            this.parseFunctionNoMarker(Context.SOURCE_ELEMENT, mark);
        }
        finally {
            this.builder.putUserData(methodsEmptinessKey, (Object)prevMethodEmptiness);
        }
    }

    public void parseFunctionExpressionAttributeList() {
        this.parseAttributesList();
    }

    public boolean parseFunctionNoMarker(Context context, @NotNull PsiBuilder.Marker functionMarker) {
        if (functionMarker == null) {
            FunctionParser.$$$reportNull$$$0(0);
        }
        boolean functionKeywordWasOmitted = true;
        boolean parsedWithoutErrors = true;
        boolean isGeneratorContext = false;
        if (this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD && context != Context.PROPERTY) {
            this.builder.advanceLexer();
            functionKeywordWasOmitted = false;
            if (this.builder.getTokenType() == JSTokenTypes.MULT && this.isJSorTS()) {
                this.builder.advanceLexer();
                isGeneratorContext = true;
            }
        }
        boolean wasGenerator = this.isGeneratorContext();
        this.setIsGenerator(isGeneratorContext);
        if (!this.parseFunctionName(functionKeywordWasOmitted, context)) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.function.name", (Object[])new Object[0]));
            parsedWithoutErrors = false;
        }
        JSParsingResult parameterListResult = this.parseParameterList(context == Context.EXPRESSION || context == Context.PROPERTY);
        parsedWithoutErrors &= !parameterListResult.hasErrors();
        ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseFunctionReturnType();
        String methodEmptiness = (String)this.builder.getUserData(methodsEmptinessKey);
        if (methodEmptiness == null) {
            if (functionKeywordWasOmitted && JSTokenTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
            }
            parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
        } else if (METHODS_EMPTINESS_ALWAYS.equals(methodEmptiness)) {
            if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                this.builder.advanceLexer();
            }
            if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                String key = this.builder.getUserData(StatementParser.withinInterfaceKey) == null ? "javascript.ambient.declaration.should.have.no.body" : "interface.function.declaration.should.have.no.body";
                parsedWithoutErrors = false;
                this.builder.error(JSBundle.message((String)key, (Object[])new Object[0]));
            }
        } else if (METHODS_EMPTINESS_POSSIBLY.equals(methodEmptiness)) {
            if (functionKeywordWasOmitted && JSTokenTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
                parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
            } else if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
            }
        }
        functionMarker.done(context == Context.SOURCE_ELEMENT ? this.getFunctionDeclarationElementType() : this.getFunctionExpressionElementType());
        functionMarker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        this.setIsGenerator(wasGenerator);
        return parsedWithoutErrors;
    }

    public boolean parseFunctionName(boolean functionKeywordWasOmitted, Context context) {
        IElementType tokenType;
        IElementType firstToken = this.builder.getTokenType();
        if (JSTokenTypes.GET_SET.contains(firstToken) && context != Context.EXPRESSION) {
            IElementType lookAhead = this.builder.lookAhead(1);
            if (JSKeywordSets.PROPERTY_NAMES.contains(lookAhead)) {
                this.builder.advanceLexer();
            } else if (context == Context.PROPERTY && ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).isPropertyNameStart(lookAhead)) {
                this.builder.advanceLexer();
                ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parsePropertyName();
                return true;
            }
        }
        if (!(this.isIdentifierToken(tokenType = this.builder.getTokenType()) || functionKeywordWasOmitted && JSKeywordSets.PROPERTY_NAMES.contains(tokenType))) {
            return context == Context.EXPRESSION;
        }
        this.parseFunctionIdentifier();
        return true;
    }

    public void parseFunctionIdentifier() {
        this.builder.advanceLexer();
    }

    public IElementType getFunctionDeclarationElementType() {
        return JSStubElementTypes.FUNCTION_DECLARATION;
    }

    public boolean parseAttributesList() {
        PsiBuilder.Marker mark = this.builder.mark();
        if (this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD) {
            this.builder.advanceLexer();
        }
        mark.done(this.getAttributeListElementType());
        return true;
    }

    public JSStubElementType<JSAttributeListStub, JSAttributeList> getAttributeListElementType() {
        return JSStubElementTypes.ATTRIBUTE_LIST;
    }

    public void parseES7Decorators() {
        if (this.hasSupportDecorators()) {
            PsiBuilder.Marker attribute = this.builder.mark();
            this.builder.advanceLexer();
            Object expressionParser = this.myJavaScriptParser.getExpressionParser();
            ((ExpressionParser)expressionParser).parseLeftHandSideExpression(false);
            attribute.done(JSStubElementTypes.ES6_DECORATOR);
        } else {
            this.builder.advanceLexer();
        }
    }

    public boolean tryParseES7Decorators() {
        boolean hadAnnotation = false;
        if (this.hasSupportDecorators()) {
            while (this.builder.getTokenType() == JSTokenTypes.AT) {
                this.parseES7Decorators();
                hadAnnotation = true;
            }
        }
        return hadAnnotation;
    }

    public boolean hasSupportDecorators() {
        return false;
    }

    public void parseAttributeBody() {
        boolean haveLParen = FunctionParser.checkMatches(this.builder, JSTokenTypes.LPAR, "javascript.parser.message.expected.lparen");
        while (haveLParen) {
            boolean hasName = JSAttributeNameValuePairImpl.IDENTIFIER_TOKENS_SET.contains(this.builder.getTokenType());
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifer.or.value", (Object[])new Object[0]));
                break;
            }
            IElementType tokenType = this.builder.getTokenType();
            if (tokenType == JSTokenTypes.RBRACKET || tokenType == JSTokenTypes.RPAR) break;
            PsiBuilder.Marker attributeNameValuePair = this.builder.mark();
            this.builder.advanceLexer();
            if (hasName && this.builder.getTokenType() != JSTokenTypes.COMMA && this.builder.getTokenType() != JSTokenTypes.RPAR) {
                FunctionParser.checkMatches(this.builder, JSTokenTypes.EQ, "javascript.parser.message.expected.equal");
                IElementType type = this.builder.getTokenType();
                if (type != JSTokenTypes.COMMA && type != JSTokenTypes.RBRACKET && type != JSTokenTypes.RPAR) {
                    if (type == JSTokenTypes.IDENTIFIER) {
                        PsiBuilder.Marker ident = this.builder.mark();
                        this.builder.advanceLexer();
                        IElementType nextTokenType = this.builder.getTokenType();
                        ident.rollbackTo();
                        if (!JSTokenTypes.STRING_LITERALS.contains(nextTokenType)) {
                            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseSimpleExpression();
                        } else {
                            this.builder.advanceLexer();
                        }
                    } else {
                        this.builder.advanceLexer();
                    }
                } else {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.value", (Object[])new Object[0]));
                }
            }
            if (attributeNameValuePair != null) {
                attributeNameValuePair.done(JSStubElementTypes.ATTRIBUTE_NAME_VALUE_PAIR);
            }
            if (this.builder.getTokenType() != JSTokenTypes.COMMA) break;
            this.builder.advanceLexer();
            if (!this.builder.eof()) continue;
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.rparen", (Object[])new Object[0]));
            return;
        }
        if (haveLParen) {
            FunctionParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        } else {
            this.builder.advanceLexer();
        }
    }

    @NotNull
    public JSParsingResult parseParameterList(boolean funExpr) {
        if (!((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseTypeParameterList()) {
            JSParsingResult jSParsingResult = JSParsingResult.HAS_ERRORS_NO_IMPRINT;
            if (jSParsingResult == null) {
                FunctionParser.$$$reportNull$$$0(1);
            }
            return jSParsingResult;
        }
        if (this.builder.getTokenType() != JSTokenTypes.LPAR) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.lparen", (Object[])new Object[0]));
            if (!funExpr) {
                PsiBuilder.Marker parameterList = this.builder.mark();
                parameterList.done(this.getParameterListElementType());
            }
            JSParsingResult jSParsingResult = JSParsingResult.HAS_ERRORS_NO_IMPRINT;
            if (jSParsingResult == null) {
                FunctionParser.$$$reportNull$$$0(2);
            }
            return jSParsingResult;
        }
        PsiBuilder.Marker parameterList = this.builder.mark();
        this.builder.advanceLexer();
        boolean hasErrors = false;
        boolean looksLikeParameterList = false;
        boolean first = true;
        while (this.builder.getTokenType() != JSTokenTypes.RPAR) {
            IElementType tokenType;
            boolean allowPropertyNameAsIdentifier;
            if (first) {
                first = false;
            } else if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.RPAR && this.allowLastCommaInParameterAndArgumentList()) {
                    break;
                }
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.comma.or.rparen", (Object[])new Object[0]));
                hasErrors = true;
                break;
            }
            PsiBuilder.Marker parameter = this.builder.mark();
            if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
                looksLikeParameterList = true;
            }
            if (this.isParameterName(allowPropertyNameAsIdentifier = this.parseParameterAttributeList(), tokenType = this.builder.getTokenType())) {
                this.builder.advanceLexer();
                this.parseParameterOptionalMark();
                looksLikeParameterList |= this.tryParseArrowFunctionParameterType();
                if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                    PsiBuilder.Marker m = null;
                    if (!this.hasParameterInitializers()) {
                        m = this.builder.mark();
                    }
                    this.builder.advanceLexer();
                    ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(true, false);
                    if (m != null) {
                        m.error(JSBundle.message((String)"javascript.parser.message.expected.comma.or.rparen", (Object[])new Object[0]));
                        hasErrors = true;
                    }
                }
                parameter.done(this.getParameterType());
                continue;
            }
            if (this.willParseDestructuringAssignment()) {
                this.parseDestructuringParameter(parameter);
                continue;
            }
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.formal.parameter.name", (Object[])new Object[0]));
            hasErrors = true;
            if (this.hasParameterInitializers() && this.builder.getTokenType() == JSTokenTypes.EQ) {
                looksLikeParameterList = true;
                this.builder.advanceLexer();
                ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(true, false);
            } else if (((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType()) {
                looksLikeParameterList = true;
            }
            parameter.drop();
        }
        if (this.builder.getTokenType() == JSTokenTypes.RPAR) {
            this.builder.advanceLexer();
        }
        parameterList.done(this.getParameterListElementType());
        if (first) {
            JSParsingResult jSParsingResult = JSParsingResult.EMPTY;
            if (jSParsingResult == null) {
                FunctionParser.$$$reportNull$$$0(3);
            }
            return jSParsingResult;
        }
        JSParsingResult jSParsingResult = JSParsingResult.of(hasErrors, looksLikeParameterList);
        if (jSParsingResult == null) {
            FunctionParser.$$$reportNull$$$0(4);
        }
        return jSParsingResult;
    }

    protected boolean isParameterName(boolean allowPropertyNameAsIdentifier, IElementType tokenType) {
        return this.isIdentifierToken(tokenType) || allowPropertyNameAsIdentifier && JSKeywordSets.IDENTIFIER_NAMES.contains(tokenType);
    }

    protected boolean allowLastCommaInParameterAndArgumentList() {
        return false;
    }

    protected boolean tryParseArrowFunctionParameterType() {
        boolean looksLikeParameterList = this.builder.getTokenType() == JSTokenTypes.COLON;
        ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
        return looksLikeParameterList;
    }

    protected void parseDestructuringParameter(PsiBuilder.Marker parameter) {
        IElementType elementType = ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseDestructuringElementNoMarker((IElementType)this.getParameterType(), true, true);
        parameter.done(elementType);
    }

    public JSStubElementType<JSParameterStub, JSParameter> getParameterType() {
        return JSStubElementTypes.FORMAL_PARAMETER;
    }

    public void parseParameterOptionalMark() {
    }

    protected boolean willParseDestructuringAssignment() {
        return (this.builder.getTokenType() == JSTokenTypes.LBRACKET || this.builder.getTokenType() == JSTokenTypes.LBRACE) && !this.isECMAL4();
    }

    protected boolean hasParameterInitializers() {
        return false;
    }

    protected boolean parseParameterAttributeList() {
        if (this.hasSupportDecorators() && this.builder.getTokenType() == JSTokenTypes.AT) {
            PsiBuilder.Marker mark = this.builder.mark();
            this.tryParseES7Decorators();
            mark.done(this.getAttributeListElementType());
        }
        return false;
    }

    public boolean parseArrowFunction() {
        return this.parseArrowFunctionNoMarker(this.builder.mark());
    }

    protected boolean parseArrowFunctionNoMarker(PsiBuilder.Marker arrowFunction) {
        IElementType firstToken = this.builder.getTokenType();
        boolean isDefinitelyArrowFunction = false;
        if (this.isIdentifierToken(firstToken)) {
            PsiBuilder.Marker parameterList = this.builder.mark();
            PsiBuilder.Marker parameter = this.builder.mark();
            this.builder.advanceLexer();
            parameter.done(this.getParameterType());
            parameterList.done(this.getParameterListElementType());
            parameterList.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        } else {
            JSParsingResult result2 = this.parseParameterList(true);
            if (result2.hasImprint()) {
                isDefinitelyArrowFunction = true;
            } else if (result2.hasErrors()) {
                arrowFunction.rollbackTo();
                return false;
            }
            boolean hasColon = ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseArrowFunctionReturnType();
            if (result2 == JSParsingResult.EMPTY && hasColon) {
                isDefinitelyArrowFunction = true;
            }
        }
        IElementType arrow = this.builder.getTokenType();
        if (JSTokenTypes.ARROWS.contains(arrow)) {
            this.builder.advanceLexer();
            ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseBlockOrFunctionBody(StatementParser.BlockType.ARROW_FUNCTION_BODY);
            isDefinitelyArrowFunction = true;
        } else if (isDefinitelyArrowFunction) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.eqgt", (Object[])new Object[0]));
        }
        if (isDefinitelyArrowFunction) {
            arrowFunction.done(this.getFunctionExpressionElementType());
            arrowFunction.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        } else {
            arrowFunction.rollbackTo();
        }
        return isDefinitelyArrowFunction;
    }

    public JSStubElementType<JSParameterListStub, JSParameterList> getParameterListElementType() {
        return JSStubElementTypes.PARAMETER_LIST;
    }

    protected IElementType getFunctionExpressionElementType() {
        return JSStubElementTypes.FUNCTION_EXPRESSION;
    }

    public boolean isAsyncContext() {
        return Boolean.TRUE.equals(this.builder.getUserData(ASYNC_METHOD_KEY));
    }

    public void setIsGenerator(boolean isGenerator) {
        if (!((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).hasGeneratorsSupport()) {
            return;
        }
        this.builder.putUserData(IS_GENERATOR_FUNCTION_KEY, (Object)isGenerator);
    }

    public boolean isGeneratorContext() {
        if (!((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).hasGeneratorsSupport()) {
            return false;
        }
        return Boolean.TRUE.equals(this.builder.getUserData(IS_GENERATOR_FUNCTION_KEY));
    }

    protected boolean parseParameterListAndBody(PsiBuilder.Marker marker, IElementType elementType) {
        JSParsingResult parameterListResult = ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseParameterList(false);
        boolean lexerAdvanced = !parameterListResult.hasErrors();
        lexerAdvanced |= ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseFunctionReturnType();
        marker.done(elementType);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return lexerAdvanced |= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionMarker";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/parsing/FunctionParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/parsing/FunctionParser";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseParameterList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFunctionNoMarker";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Context {
        EXPRESSION,
        SOURCE_ELEMENT,
        PROPERTY;

    }
}

