/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSReferenceListStub;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSReferenceListImpl<T extends JSReferenceListStub<?>>
extends JSStubElementImpl<T>
implements JSReferenceList,
StubBasedPsiElement<T> {
    private static final Function<JSReferenceListMember, String> MEMBER_TO_STRING_REFERENCE = JSReferenceListMember::getReferenceText;
    protected static final Function<JSReferenceListMember, JSExpression> MEMBER_TO_EXPRESSION = JSReferenceListMember::getExpression;

    public JSReferenceListImpl(ASTNode node) {
        super(node);
    }

    public JSReferenceListImpl(T stub) {
        super(stub, stub.getStubType());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSReferenceListImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSReferenceList((JSReferenceList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public JSExpression[] getExpressions() {
        JSExpression[] jSExpressionArray = (JSExpression[])ContainerUtil.map2Array((Object[])this.getMembers(), JSExpression.class, MEMBER_TO_EXPRESSION);
        if (jSExpressionArray == null) {
            JSReferenceListImpl.$$$reportNull$$$0(1);
        }
        return jSExpressionArray;
    }

    @NotNull
    public String[] getReferenceTexts() {
        Object[] members = this.getMembers();
        if (members.length == 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                JSReferenceListImpl.$$$reportNull$$$0(2);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = ContainerUtil.map2List((Object[])members, MEMBER_TO_STRING_REFERENCE).toArray(ArrayUtil.EMPTY_STRING_ARRAY);
        if (stringArray == null) {
            JSReferenceListImpl.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @NotNull
    public JSReferenceListMember[] getMembers() {
        JSReferenceListMember[] jSReferenceListMemberArray = (JSReferenceListMember[])this.getStubOrPsiChildren((IStubElementType)JSStubElementTypes.EXTENDS_LIST_MEMBER, JSReferenceListMember.ARRAY_FACTORY);
        if (jSReferenceListMemberArray == null) {
            JSReferenceListImpl.$$$reportNull$$$0(4);
        }
        return jSReferenceListMemberArray;
    }

    @NotNull
    public JSClass[] getReferencedClasses() {
        String[] texts = this.getReferenceTexts();
        if (texts.length == 0) {
            if (JSClass.EMPTY_ARRAY == null) {
                JSReferenceListImpl.$$$reportNull$$$0(5);
            }
            return JSClass.EMPTY_ARRAY;
        }
        ArrayList<JSClass> supers = new ArrayList<JSClass>(texts.length);
        JSImportHandler importHandler = this.getImportHandler();
        for (String text : texts) {
            supers.addAll(this.resolveTextReferenceClasses(importHandler, text));
        }
        JSClass[] jSClassArray = supers.toArray(new JSClass[supers.size()]);
        if (jSClassArray == null) {
            JSReferenceListImpl.$$$reportNull$$$0(6);
        }
        return jSClassArray;
    }

    @NotNull
    protected JSImportHandler getImportHandler() {
        JSImportHandler jSImportHandler = JSDialectSpecificHandlersFactory.forElement((PsiElement)this).getImportHandler();
        if (jSImportHandler == null) {
            JSReferenceListImpl.$$$reportNull$$$0(7);
        }
        return jSImportHandler;
    }

    @NotNull
    private Collection<JSClass> resolveTextReferenceClasses(JSImportHandler importHandler, String text) {
        Collection<JSClass> collection = this.resolveReferenceClasses(importHandler.resolveTypeName(text, (PsiElement)this));
        if (collection == null) {
            JSReferenceListImpl.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    protected Collection<JSClass> resolveReferenceClasses(JSTypeResolveResult resolveResult) {
        String text = resolveResult.getQualifiedName();
        if (DialectDetector.isActionScript((PsiElement)this)) {
            PsiElement clazz = JSClassResolver.findClassFromNamespace(text, (PsiElement)this, JSResolveUtil.getResolveScope((PsiElement)this));
            if (clazz instanceof JSClass) {
                List list = ContainerUtil.createMaybeSingletonList((Object)((JSClass)clazz));
                if (list == null) {
                    JSReferenceListImpl.$$$reportNull$$$0(9);
                }
                return list;
            }
        } else {
            if (resolveResult.hasElements()) {
                PsiElement parentClass = this.getParent();
                List result2 = ContainerUtil.newSmartList();
                for (PsiElement psiElement : resolveResult.getElements()) {
                    if (!(psiElement instanceof JSClass) || parentClass == psiElement) continue;
                    result2.add((JSClass)psiElement);
                }
                List list = result2;
                if (list == null) {
                    JSReferenceListImpl.$$$reportNull$$$0(10);
                }
                return list;
            }
            if (!DialectDetector.isTypeScript((PsiElement)this)) {
                Collection<JSClass> collection = this.resolveDirectlyToClasses(text);
                if (collection == null) {
                    JSReferenceListImpl.$$$reportNull$$$0(11);
                }
                return collection;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSReferenceListImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public Collection<Pair<JSReferenceListMember, Collection<JSClass>>> getResolvedExpressions() {
        JSReferenceListMember[] members = this.getMembers();
        if (members.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSReferenceListImpl.$$$reportNull$$$0(13);
            }
            return list;
        }
        JSImportHandler importHandler = this.getImportHandler();
        List resolvedList = ContainerUtil.newSmartList();
        for (JSReferenceListMember member : members) {
            String text = member.getReferenceText();
            if (text != null) {
                resolvedList.add(Pair.create((Object)member, this.resolveTextReferenceClasses(importHandler, text)));
                continue;
            }
            resolvedList.add(Pair.create((Object)member, Collections.emptyList()));
        }
        List list = resolvedList;
        if (list == null) {
            JSReferenceListImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    protected Collection<JSClass> resolveDirectlyToClasses(String text) {
        JSClassResolver resolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)this).getClassResolver();
        List<JSClass> list = resolver.findClassesByQName(text, JSResolveUtil.getResolveScope((PsiElement)this));
        if (list == null) {
            JSReferenceListImpl.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceTexts";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedClasses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTextReferenceClasses";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReferenceClasses";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedExpressions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDirectlyToClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

