/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JSBlockStatementImpl
extends LazyParseablePsiElement
implements JSBlockStatement {
    private Language myLanguage;

    public JSBlockStatementImpl(CharSequence buffer) {
        super((IElementType)JSElementTypes.BLOCK_STATEMENT, buffer);
    }

    @NotNull
    public JSStatement[] getStatements() {
        JSStatement[] jSStatementArray = JSBlockStatementImpl.getStatements(this);
        if (jSStatementArray == null) {
            JSBlockStatementImpl.$$$reportNull$$$0(0);
        }
        return jSStatementArray;
    }

    public static JSStatement[] getStatements(JSBlockStatement blockStatement) {
        ASTNode[] nodes = blockStatement.getNode().getChildren(JSExtendedLanguagesTokenSetProvider.STATEMENTS);
        JSStatement[] statements = new JSStatement[nodes.length];
        for (int i = 0; i < statements.length; ++i) {
            statements[i] = (JSStatement)nodes[i].getPsi();
        }
        return statements;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSBlockStatementImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSBlock((JSBlockStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        ASTNode node;
        if (element == null) {
            JSBlockStatementImpl.$$$reportNull$$$0(2);
        }
        if (element instanceof JSStatement && (node = this.getNode().findChildByType(JSTokenTypes.RBRACE)) != null) {
            PsiElement psiElement = super.addAfter(element, node.getTreePrev().getPsi());
            CodeStyleManager.getInstance((Project)this.getProject()).reformatNewlyAddedElement(this.getNode(), psiElement.getNode());
            return psiElement;
        }
        return super.add(element);
    }

    public JSStatement addStatementBefore(JSStatement toAdd) throws IncorrectOperationException {
        return JSChangeUtil.addSourceElement((JSSourceElement)this, toAdd, true);
    }

    public JSStatement addStatementAfter(JSStatement toAdd) throws IncorrectOperationException {
        return JSChangeUtil.addSourceElement((JSSourceElement)this, toAdd, false);
    }

    public JSStatement replace(JSStatement with) {
        return JSChangeUtil.replaceStatement((JSStatement)this, with);
    }

    @NotNull
    public Language getLanguage() {
        if (this.myLanguage == null) {
            Language language = DialectDetector.languageOfElement((PsiElement)this);
            this.myLanguage = language instanceof JSLanguageDialect ? language : JavascriptLanguage.INSTANCE;
        }
        Language language = this.myLanguage;
        if (language == null) {
            JSBlockStatementImpl.$$$reportNull$$$0(3);
        }
        return language;
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSBlockStatementImpl.$$$reportNull$$$0(4);
        }
        return JSChangeUtil.doAddBefore((PsiElement)this, element, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSBlockStatementImpl.$$$reportNull$$$0(5);
        }
        return JSChangeUtil.doAddAfter((PsiElement)this, element, anchor);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            JSBlockStatementImpl.$$$reportNull$$$0(6);
        }
        ASTNode myNode = this.getNode();
        ASTNode result2 = newElement.getNode().copyElement();
        myNode.getTreeParent().replaceChild(myNode, result2);
        return result2.getPsi();
    }

    public String toString() {
        return "JSBlockStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSBlockStatementImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSBlockStatementImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

