/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.literal;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementCustomProvider;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitParameterStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLiteralImplicitElementProvidersRegistry {
    private static final Map<String, Collection<JSLiteralImplicitElementProvider>> ourCallArgumentsProvidersRegistry = new THashMap();
    private static final Collection<JSLiteralImplicitElementCustomProvider> ourCustomProvidersRegistry = new SmartList();

    public static void addClassFromArgument(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @Nullable String userString, @NotNull JSElementIndexingData outIndexingData) {
        JSQualifiedName qualifiedName;
        JSExpression[] jsExpressions;
        if (argument == null) {
            JSLiteralImplicitElementProvidersRegistry.$$$reportNull$$$0(0);
        }
        if (callExpression == null) {
            JSLiteralImplicitElementProvidersRegistry.$$$reportNull$$$0(1);
        }
        if (outIndexingData == null) {
            JSLiteralImplicitElementProvidersRegistry.$$$reportNull$$$0(2);
        }
        if ((jsExpressions = callExpression.getArguments()).length == 1 && jsExpressions[0] == argument && (qualifiedName = JSSymbolUtil.getLiteralValueAsQualifiedName(argument)) != null) {
            JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(qualifiedName.getName(), (PsiElement)argument).setNamespace(qualifiedName.getParent()).setProperties(JSImplicitElement.Property.MinorImportance).setType(JSImplicitElement.Type.Class).setUserString(userString);
            JSImplicitElementImpl element = builder.toImplicitElement();
            outIndexingData.addImplicitElement((JSImplicitElement)element);
            JSStubIndexingUtils.addImplicitNamespaces(qualifiedName, outIndexingData.getImplicitElements(), (PsiElement)argument);
        }
    }

    @NotNull
    private static JSLiteralImplicitElementProvider createClassImplicitElementProvider(final boolean isNamespace) {
        JSLiteralImplicitElementProvider jSLiteralImplicitElementProvider = new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                JSQualifiedName qualifiedName;
                if (argument == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (callExpression == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (outIndexingData == null) {
                    6.$$$reportNull$$$0(2);
                }
                JSExpression methodExpression = callExpression.getMethodExpression();
                assert (methodExpression instanceof JSReferenceExpression);
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (qualifier != null && (qualifiedName = JSSymbolUtil.getLiteralValueAsQualifiedName(argument)) != null) {
                    if ((!"YAHOO".equals(qualifiedName.getName()) || qualifiedName.getParent() == null) && "YAHOO".equals(qualifier.getText())) {
                        qualifiedName = JSQualifiedNameImpl.concat(JSQualifiedNameImpl.create("YAHOO", null), qualifiedName);
                    }
                    JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(qualifiedName.getName(), (PsiElement)argument).setNamespace(qualifiedName.getParent()).setType(isNamespace ? JSImplicitElement.Type.Namespace : JSImplicitElement.Type.Class);
                    outIndexingData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl(builder));
                    JSStubIndexingUtils.addImplicitNamespaces(qualifiedName, outIndexingData.getImplicitElements(), (PsiElement)argument);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "argument";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outIndexingData";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$6";
                objectArray[2] = "fillIndexingData";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (jSLiteralImplicitElementProvider == null) {
            JSLiteralImplicitElementProvidersRegistry.$$$reportNull$$$0(3);
        }
        return jSLiteralImplicitElementProvider;
    }

    private static void addImplicitElementProvider(String methodName, JSLiteralImplicitElementProvider type) {
        SmartList list = ourCallArgumentsProvidersRegistry.get(methodName);
        if (list == null) {
            list = new SmartList();
            ourCallArgumentsProvidersRegistry.put(methodName, (Collection<JSLiteralImplicitElementProvider>)list);
        }
        list.add((JSLiteralImplicitElementProvider)type);
    }

    @Nullable
    public static JSElementIndexingData calculateIndexingData(@NotNull JSLiteralExpression literalExpression) {
        String name;
        JSExpression methodExpression;
        PsiElement grandParent;
        PsiElement parent;
        if (literalExpression == null) {
            JSLiteralImplicitElementProvidersRegistry.$$$reportNull$$$0(4);
        }
        if ((parent = literalExpression.getParent()) instanceof JSArgumentList && (grandParent = parent.getParent()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)grandParent).getMethodExpression()) instanceof JSReferenceExpression && (name = ((JSReferenceExpression)methodExpression).getReferencedName()) != null && ourCallArgumentsProvidersRegistry.containsKey(name)) {
            Collection<JSLiteralImplicitElementProvider> elementProviderTypes = ourCallArgumentsProvidersRegistry.get(name);
            JSElementIndexingDataImpl data = new JSElementIndexingDataImpl();
            for (JSLiteralImplicitElementProvider type : elementProviderTypes) {
                type.fillIndexingData(literalExpression, (JSCallExpression)grandParent, data);
            }
            return data;
        }
        JSElementIndexingDataImpl result2 = null;
        ASTNode node = literalExpression.getNode();
        for (JSLiteralImplicitElementCustomProvider provider2 : ourCustomProvidersRegistry) {
            if (!provider2.checkIfCandidate(node)) continue;
            if (result2 == null) {
                result2 = new JSElementIndexingDataImpl();
            }
            provider2.fillIndexingDataForCandidate(literalExpression, result2);
        }
        return result2;
    }

    public static boolean shouldCreateStub(ASTNode node) {
        String name;
        ASTNode methodExpression;
        ASTNode grandParent;
        ASTNode parent = node.getTreeParent();
        if (parent.getElementType() == JSElementTypes.ARGUMENT_LIST && (grandParent = parent.getTreeParent()).getElementType() == JSStubElementTypes.CALL_EXPRESSION && (methodExpression = grandParent.getFirstChildNode()).getElementType() == JSElementTypes.REFERENCE_EXPRESSION && ourCallArgumentsProvidersRegistry.containsKey(name = methodExpression.getLastChildNode().getText())) {
            return true;
        }
        for (JSLiteralImplicitElementCustomProvider customProvider : ourCustomProvidersRegistry) {
            if (!customProvider.checkIfCandidate(node)) continue;
            return true;
        }
        return false;
    }

    static {
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("defineProperty", new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                String name;
                JSExpression[] arguments;
                if (argument == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (callExpression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (outIndexingData == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((arguments = callExpression.getArguments()).length >= 3 && argument == arguments[1] && (name = argument.getValueAsPropertyName()) != null) {
                    JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally(arguments[0]);
                    JSQualifiedName qualifiedName = ns != null ? ns.getQualifiedName() : null;
                    JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(name, (PsiElement)argument).setNamespace(qualifiedName).setTypeString(JSDocumentationUtils.findType((PsiElement)callExpression));
                    outIndexingData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl(builder));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "argument";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outIndexingData";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$1";
                objectArray[2] = "fillIndexingData";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        JSLiteralImplicitElementProvider type = new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                String name;
                JSExpression[] arguments;
                if (argument == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (callExpression == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (outIndexingData == null) {
                    2.$$$reportNull$$$0(2);
                }
                JSExpression methodExpression = callExpression.getMethodExpression();
                assert (methodExpression instanceof JSReferenceExpression);
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (qualifier != null && (arguments = callExpression.getArguments()).length == 2 && arguments[0] == argument && (name = argument.getValueAsPropertyName()) != null) {
                    JSQualifiedName namespace = JSSymbolUtil.evaluateReferencedNamespace(qualifier);
                    outIndexingData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl(name, namespace, (PsiElement)argument));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "argument";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outIndexingData";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$2";
                objectArray[2] = "fillIndexingData";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("__defineGetter__", type);
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("__defineSetter__", type);
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("method", type);
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("provide", new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                if (argument == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (callExpression == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (outIndexingData == null) {
                    3.$$$reportNull$$$0(2);
                }
                JSLiteralImplicitElementProvidersRegistry.addClassFromArgument(argument, callExpression, null, outIndexingData);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "argument";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outIndexingData";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$3";
                objectArray[2] = "fillIndexingData";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("addProperty", new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                JSExpression[] jsExpressions;
                if (argument == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (callExpression == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (outIndexingData == null) {
                    4.$$$reportNull$$$0(2);
                }
                JSExpression methodExpression = callExpression.getMethodExpression();
                assert (methodExpression instanceof JSReferenceExpression);
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (qualifier != null && (jsExpressions = callExpression.getArguments()).length == 2 && jsExpressions[0] == argument) {
                    JSQualifiedName namespace = JSSymbolUtil.evaluateReferencedNamespace(qualifier);
                    String propertyName = argument.getValueAsPropertyName();
                    String type = jsExpressions[1].getText().toLowerCase();
                    if (propertyName != null) {
                        JSImplicitElementImpl.Builder builder;
                        PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)callExpression);
                        String typeString = null;
                        if (comment instanceof JSDocComment) {
                            typeString = ((JSDocComment)comment).getType();
                        }
                        if (type.contains("read")) {
                            builder = new JSImplicitElementImpl.Builder(JSSymbolUtil.suggestGetterName(propertyName), (PsiElement)argument).setType(JSImplicitElement.Type.Function).setTypeString(typeString).setNamespace(namespace);
                            outIndexingData.addImplicitElement((JSImplicitElement)builder.toImplicitElement());
                        }
                        if (type.contains("write")) {
                            builder = new JSImplicitElementImpl.Builder(JSSymbolUtil.suggestSetterName(propertyName), (PsiElement)argument).setType(JSImplicitElement.Type.Function).setParameters(Collections.singletonList(new JSImplicitParameterStructure(propertyName, typeString, false, false, true))).setNamespace(namespace);
                            outIndexingData.addImplicitElement((JSImplicitElement)builder.toImplicitElement());
                        }
                        builder = new JSImplicitElementImpl.Builder("_" + propertyName, (PsiElement)argument).setNamespace(namespace).setTypeString(typeString);
                        outIndexingData.addImplicitElement((JSImplicitElement)builder.toImplicitElement());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "argument";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outIndexingData";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$4";
                objectArray[2] = "fillIndexingData";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        type = JSLiteralImplicitElementProvidersRegistry.createClassImplicitElementProvider(true);
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("namespace", type);
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("ns", type);
        type = JSLiteralImplicitElementProvidersRegistry.createClassImplicitElementProvider(false);
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("defineClass", type);
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("define", type);
        type = new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                JSExpression[] jsExpressions;
                if (argument == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (callExpression == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (outIndexingData == null) {
                    5.$$$reportNull$$$0(2);
                }
                JSExpression methodExpression = callExpression.getMethodExpression();
                assert (methodExpression instanceof JSReferenceExpression);
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (qualifier instanceof JSReferenceExpression && (jsExpressions = callExpression.getArguments()).length == 2 && jsExpressions[0] == argument) {
                    JSReferenceExpression refExpr = (JSReferenceExpression)qualifier;
                    Object namespace = "Window".equals(refExpr.getReferencedName()) && refExpr.getQualifier() == null ? null : JSSymbolUtil.evaluateReferencedNamespace(qualifier);
                    String propertyName = argument.getValueAsPropertyName();
                    if (propertyName != null) {
                        outIndexingData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl(propertyName, (JSQualifiedName)namespace, (PsiElement)argument));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "argument";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outIndexingData";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$5";
                objectArray[2] = "fillIndexingData";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("extend", type);
        JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider("implement", type);
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])Extensions.getExtensions(FrameworkIndexingHandler.EP_NAME)) {
            for (String methodName : handler.implicitProviderMethodNames()) {
                JSLiteralImplicitElementProvidersRegistry.addImplicitElementProvider(methodName, handler.createLiteralImplicitElementProvider(methodName));
            }
            JSLiteralImplicitElementCustomProvider customProvider = handler.createLiteralImplicitElementCustomProvider();
            if (customProvider == null) continue;
            ourCustomProvidersRegistry.add(customProvider);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outIndexingData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassImplicitElementProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addClassFromArgument";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calculateIndexingData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

