/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSContextualUnionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCompositeTypeImpl
extends JSCompositeTypeBaseImpl
implements JSUnionType {
    public static final int TYPES_NUMBER_LIMIT = 5;
    public static final Comparator<JSType> GENERIC_PARAMETER_LAST = (o1, o2) -> {
        if (o1 instanceof JSUndefinedType) {
            return o2 instanceof JSUndefinedType ? 0 : 1;
        }
        if (o2 instanceof JSUndefinedType) {
            return -1;
        }
        if (o1 instanceof JSNullType) {
            return o2 instanceof JSNullType ? 0 : 1;
        }
        if (o2 instanceof JSNullType) {
            return -1;
        }
        if (o1 instanceof JSGenericParameterImpl) {
            return o2 instanceof JSGenericParameterImpl ? 0 : 1;
        }
        if (o2 instanceof JSGenericParameterImpl) {
            return -1;
        }
        return 0;
    };
    @NotNull
    private final OptimizedKind myOptimized;

    @Contract(value="!null -> !null")
    public static JSType optimizeTypeIfComposite(@Nullable JSType currentType) {
        return JSCompositeTypeImpl.optimizeTypeIfComposite(currentType, true, OptimizedKind.NOT_OPTIMIZED);
    }

    @Contract(value="!null,_ -> !null")
    public static JSType optimizeTypeIfComposite(@Nullable JSType currentType, boolean allowResolve) {
        return JSCompositeTypeImpl.optimizeTypeIfComposite(currentType, allowResolve, OptimizedKind.NOT_OPTIMIZED);
    }

    @NotNull
    private static JSType optimizeTypeForSubstitute(@NotNull JSCompositeTypeImpl currentType) {
        if (currentType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(0);
        }
        PsiFile scope = currentType.getScope();
        TypeScriptConfig config2 = !currentType.isTypeScript() || scope == null ? null : TypeScriptConfigUtil.getConfigForPsiFile(scope);
        JSType jSType = JSCompositeTypeImpl.optimizeTypeIfComposite(currentType, true, config2 == null || !config2.strictNullChecks() ? OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED : OptimizedKind.NOT_OPTIMIZED);
        if (jSType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(1);
        }
        return jSType;
    }

    @Contract(value="!null,_,_ -> !null")
    public static JSType optimizeTypeIfComposite(@Nullable JSType currentType, boolean allowResolve, @NotNull OptimizedKind removeNullAndUndefinedTypes) {
        List preFilteredTypes;
        JSType simplified;
        if (removeNullAndUndefinedTypes == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(2);
        }
        if (currentType instanceof JSIntersectionTypeImpl && !(currentType instanceof JSContextualUnionTypeImpl) && (simplified = JSIntersectionTypeImpl.getSimplifiedTypeIfPossible(((JSIntersectionTypeImpl)currentType).getTypes(), currentType.getSource(), allowResolve, true)) != null) {
            currentType = simplified;
        }
        if (!(currentType instanceof JSCompositeTypeImpl)) {
            return currentType;
        }
        JSCompositeTypeImpl compositeType = (JSCompositeTypeImpl)currentType;
        OptimizedKind optimized = compositeType.getOptimized();
        if (JSCompositeTypeImpl.isOptimizedAcceptable(optimized, removeNullAndUndefinedTypes)) {
            return compositeType;
        }
        List<JSType> originalNestedTypes = compositeType.getTypes();
        if (originalNestedTypes.isEmpty()) {
            return compositeType;
        }
        Stream<JSType> typeStream = originalNestedTypes.stream().filter(el -> !JSCompositeTypeImpl.isEmptyType(el));
        if (removeNullAndUndefinedTypes == OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED || removeNullAndUndefinedTypes == OptimizedKind.OPTIMIZED_REMOVED_FALSY || !currentType.getSource().isStrict() || !currentType.isTypeScript()) {
            typeStream = typeStream.filter(el -> {
                if (removeNullAndUndefinedTypes == null) {
                    JSCompositeTypeImpl.$$$reportNull$$$0(67);
                }
                return removeNullAndUndefinedTypes == OptimizedKind.OPTIMIZED_REMOVED_FALSY ? !JSTypeCastUtil.isFalsy(el) : !JSCompositeTypeImpl.isNullOrUndefinedType(el);
            });
        }
        if ((preFilteredTypes = typeStream.collect(Collectors.toList())).size() == 0) {
            return (JSType)ContainerUtil.getFirstItem(originalNestedTypes);
        }
        if (preFilteredTypes.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem(preFilteredTypes);
        }
        List<JSType> types = JSCompositeTypeImpl.flattenTypes(preFilteredTypes.stream().map(el -> JSCompositeTypeImpl.getTypeOfType(el, allowResolve)).filter(el -> !JSCompositeTypeImpl.isEmptyType(el)), JSCompositeTypeImpl.class);
        if (types.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem(types);
        }
        ArrayList filteredEqualsTypes = ContainerUtil.newArrayList(types);
        HashSet removedTypes = ContainerUtil.newHashSet();
        ProcessingContext context = new ProcessingContext();
        for (JSType fromCompare : types) {
            if (removedTypes.contains(fromCompare)) continue;
            Iterator iterator = filteredEqualsTypes.iterator();
            while (iterator.hasNext()) {
                JSType toCompare = (JSType)iterator.next();
                if (fromCompare == toCompare || !fromCompare.isEquivalentTo(toCompare, context, allowResolve)) continue;
                iterator.remove();
                removedTypes.add(toCompare);
            }
        }
        int filteredSize = filteredEqualsTypes.size();
        if (filteredSize == 1) {
            return (JSType)filteredEqualsTypes.get(0);
        }
        if (filteredSize == originalNestedTypes.size() && !allowResolve) {
            return currentType;
        }
        OptimizedKind kind = allowResolve ? (removeNullAndUndefinedTypes != OptimizedKind.NOT_OPTIMIZED ? removeNullAndUndefinedTypes : OptimizedKind.OPTIMIZED_SIMPLE) : OptimizedKind.NOT_OPTIMIZED;
        return new JSCompositeTypeImpl(compositeType.getSource(), filteredEqualsTypes, kind);
    }

    private static boolean isOptimizedAcceptable(@NotNull OptimizedKind optimized, @NotNull OptimizedKind removeNullAndUndefinedTypes) {
        if (optimized == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(3);
        }
        if (removeNullAndUndefinedTypes == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(4);
        }
        return removeNullAndUndefinedTypes == OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED && optimized == OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED || removeNullAndUndefinedTypes == OptimizedKind.OPTIMIZED_REMOVED_FALSY && optimized == OptimizedKind.OPTIMIZED_REMOVED_FALSY || removeNullAndUndefinedTypes != OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED && removeNullAndUndefinedTypes != OptimizedKind.OPTIMIZED_REMOVED_FALSY && optimized != OptimizedKind.NOT_OPTIMIZED;
    }

    @NotNull
    public static JSType getCommonType(@NotNull JSType type1, @NotNull JSType type2, @Nullable JSTypeSource source, boolean allowResolve) {
        if (type1 == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(5);
        }
        if (type2 == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(6);
        }
        if (type1 == type2) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(7);
            }
            return jSType;
        }
        if (type1 instanceof JSAnyType) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(8);
            }
            return jSType;
        }
        if (type2 instanceof JSAnyType) {
            JSType jSType = type2;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(9);
            }
            return jSType;
        }
        if (JSCompositeTypeImpl.isEmptyType(type1) || JSCompositeTypeImpl.isNullOrUndefinedType(type1)) {
            JSType jSType = type2;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(10);
            }
            return jSType;
        }
        if (JSCompositeTypeImpl.isEmptyType(type2) || JSCompositeTypeImpl.isNullOrUndefinedType(type2)) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(11);
            }
            return jSType;
        }
        if (!allowResolve && type1 instanceof JSNamedType && type2 instanceof JSNamedType && type1.getTypeText().equals(type2.getTypeText())) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(12);
            }
            return jSType;
        }
        List<JSType> allCommonTypes = JSCompositeTypeImpl.flattenTypes(Stream.of(type1, type2), JSCompositeTypeImpl.class);
        if (source == null) {
            source = type1 instanceof JSCompositeTypeImpl || !(type2 instanceof JSCompositeTypeImpl) ? type1.getSource() : type2.getSource();
        }
        JSType jSType = JSCompositeTypeImpl.getCommonType(allCommonTypes, source, allowResolve);
        if (jSType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(13);
        }
        return jSType;
    }

    @NotNull
    public static JSType getCommonType(@NotNull Collection<JSType> allCommonTypes, @NotNull JSTypeSource source, boolean allowResolve) {
        if (allCommonTypes == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(14);
        }
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(15);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        List<JSType> flattenTypes = JSCompositeTypeImpl.flattenTypes(allCommonTypes.stream(), JSCompositeTypeImpl.class);
        for (JSType currentType : flattenTypes) {
            if (currentType instanceof JSAnyType) {
                JSType jSType = currentType;
                if (jSType == null) {
                    JSCompositeTypeImpl.$$$reportNull$$$0(16);
                }
                return jSType;
            }
            if (JSCompositeTypeImpl.isEmptyType(currentType) || JSCompositeTypeImpl.isNullOrUndefinedType(currentType) && !source.isTypeScript()) continue;
            boolean add = true;
            for (JSType resultedType : result2) {
                if (!currentType.isEquivalentTo(resultedType, null, allowResolve)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            result2.add(currentType);
        }
        if (result2.size() == 1) {
            JSType jSType = (JSType)ContainerUtil.getFirstItem((Collection)result2, null);
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(17);
            }
            return jSType;
        }
        JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(source, result2);
        if (jSCompositeTypeImpl == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(18);
        }
        return jSCompositeTypeImpl;
    }

    @NotNull
    private static JSType getTypeOfType(JSType type, boolean allowResolve) {
        if (!allowResolve) {
            JSType jSType = type;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(19);
            }
            return jSType;
        }
        JSType jSType = type instanceof JSEvaluableType ? type.substitute() : type;
        if (jSType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(20);
        }
        return jSType;
    }

    private JSCompositeTypeImpl(@NotNull JSTypeSource source, @NotNull List<JSType> _types, @Nullable OptimizedKind optimized) {
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(21);
        }
        if (_types == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(22);
        }
        super(source, _types);
        this.myOptimized = optimized == null ? OptimizedKind.NOT_OPTIMIZED : optimized;
    }

    public JSCompositeTypeImpl(@NotNull JSTypeSource source, @NotNull List<JSType> _types) {
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(23);
        }
        if (_types == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(24);
        }
        this(source, _types, null);
    }

    public JSCompositeTypeImpl(@NotNull JSTypeSource source, JSType ... _types) {
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(25);
        }
        if (_types == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(26);
        }
        super(source, _types);
        this.myOptimized = OptimizedKind.NOT_OPTIMIZED;
    }

    @Override
    @NotNull
    protected String getTypeSeparator() {
        if ("|" == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(27);
        }
        return "|";
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(28);
        }
        if (this.isEquivalentTo(elementType, processingContext)) {
            return true;
        }
        if ((elementType = TypeScriptTypeRelations.getAsUnionTypeIfEnumWithLiterals(elementType)) instanceof JSCompositeTypeImpl && this.isTypeScript()) {
            return JSTypeCastUtil.checkAssignableComposite(this, (JSCompositeTypeImpl)elementType, processingContext, this.getSource().isStrict() && elementType.getSource().isStrict());
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult common;
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(29);
        }
        if ((common = this.checkDirectAssignableCommonInSuperClass(elementType, processingContext)).isStrict() && !(elementType instanceof JSUnionOrIntersectionType)) {
            JSTypeCastUtil.AssignableResult assignableResult = common;
            if (assignableResult == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(30);
            }
            return assignableResult;
        }
        if (this.checkAssignableForNestedTypes(elementType, processingContext)) {
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(true);
            if (assignableResult == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(31);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = common;
        if (assignableResult == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(32);
        }
        return assignableResult;
    }

    private boolean checkAssignableForNestedTypes(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(33);
        }
        if (this.anyNestedTypeEqualsTo(elementType, processingContext)) {
            return true;
        }
        for (JSType t : this.getTypes()) {
            if (JSCompositeTypeImpl.isEmptyType(t) || JSCompositeTypeImpl.isNullOrUndefinedType(t) || !t.isDirectlyAssignableType(elementType, processingContext)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private JSTypeCastUtil.AssignableResult checkDirectAssignableCommonInSuperClass(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(34);
        }
        ProcessingContext context = processingContext != null ? processingContext : new ProcessingContext();
        context.put(JSTypeCastUtil.SKIP_NULL_CHECKS, (Object)true);
        JSTypeCastUtil.AssignableResult assignableResult = super.isDirectlyAssignableTypeCommon(elementType, context);
        JSTypeCastUtil.AssignableResult assignableResult2 = assignableResult;
        if (assignableResult2 == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(35);
        }
        return assignableResult2;
        finally {
            if (processingContext != null) {
                processingContext.put(JSTypeCastUtil.SKIP_NULL_CHECKS, (Object)false);
            }
        }
    }

    private boolean anyNestedTypeEqualsTo(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(36);
        }
        if (JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext)) {
            return false;
        }
        return this.getTypes().stream().anyMatch(type -> {
            if (elementType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(66);
            }
            return type != null && type.isEquivalentTo(elementType, processingContext);
        });
    }

    @NotNull
    private OptimizedKind getOptimized() {
        OptimizedKind optimizedKind = this.myOptimized;
        if (optimizedKind == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(37);
        }
        return optimizedKind;
    }

    @Override
    @NotNull
    protected JSType createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource) {
        JSType type;
        if (transformedTypes == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(38);
        }
        if (newSource == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(39);
        }
        JSCompositeTypeImpl jSCompositeTypeImpl = (type = JSCompositeTypeImpl.getCommonType(transformedTypes, newSource, false)) instanceof JSCompositeTypeImpl ? (JSCompositeTypeImpl)type : new JSCompositeTypeImpl(newSource, type);
        if (jSCompositeTypeImpl == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(40);
        }
        return jSCompositeTypeImpl;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType result2 = this.getSimpleCompositeTypeResult();
        if (result2 != null) {
            JSType jSType = result2;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(41);
            }
            return jSType;
        }
        JSType rawTypeToProcess = JSCompositeTypeImpl.optimizeTypeForSubstitute(this);
        if (!(rawTypeToProcess instanceof JSCompositeTypeImpl)) {
            JSType jSType = rawTypeToProcess;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(42);
            }
            return jSType;
        }
        JSCompositeTypeImpl typeToProcess = (JSCompositeTypeImpl)rawTypeToProcess;
        Collection<JSRecordType> resolvedTypes = typeToProcess.getNestedTypesAsRecordType();
        if (resolvedTypes.isEmpty()) {
            JSAnyType jSAnyType = JSAnyType.get(this.getSource().getSourceElement(), this.getSource().isStrict());
            if (jSAnyType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(43);
            }
            return jSAnyType;
        }
        JSRecordType item = (JSRecordType)ContainerUtil.getFirstItem(resolvedTypes);
        resolvedTypes.remove(item);
        assert (item != null);
        ArrayList resultMembers = ContainerUtil.newArrayList();
        for (JSRecordType.TypeMember member : item.getTypeMembers()) {
            if (!(member instanceof JSRecordType.PropertySignature)) continue;
            this.addCommonPropertyMember(resolvedTypes, resultMembers, (JSRecordType.PropertySignature)member);
        }
        this.addCommonCallSignatureMembers(resolvedTypes, resultMembers, item.getCallSignatures());
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), resultMembers);
        if (jSRecordTypeImpl == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(44);
        }
        return jSRecordTypeImpl;
    }

    private void addCommonCallSignatureMembers(@NotNull Collection<JSRecordType> typesToMerge, @NotNull List<JSRecordType.TypeMember> resultMembers, @NotNull List<JSRecordType.CallSignature> callSignatures) {
        if (typesToMerge == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(45);
        }
        if (resultMembers == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(46);
        }
        if (callSignatures == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(47);
        }
        if (callSignatures.isEmpty()) {
            return;
        }
        PsiElement element = this.getSource().getSourceElement();
        if (element == null || !element.isValid()) {
            return;
        }
        List toProcessNewSignatures = ContainerUtil.newSmartList();
        List toProcessCallSignatures = ContainerUtil.newSmartList();
        for (JSRecordType.CallSignature signature : callSignatures) {
            (signature.hasNew() ? toProcessNewSignatures : toProcessCallSignatures).add(signature);
        }
        boolean collectNew = !toProcessNewSignatures.isEmpty();
        boolean collectCall = !toProcessCallSignatures.isEmpty();
        List<List<JSRecordType.CallSignature>> newTable = collectNew ? JSCompositeTypeImpl.createTable(toProcessNewSignatures) : ContainerUtil.emptyList();
        List<List<JSRecordType.CallSignature>> callTable = collectCall ? JSCompositeTypeImpl.createTable(toProcessCallSignatures) : ContainerUtil.emptyList();
        for (JSRecordType type : typesToMerge) {
            List signatures = type.getCallSignatures();
            if (collectCall) {
                collectCall = JSCompositeTypeImpl.addToTable(callTable, signatures, false);
            }
            if (!collectNew) continue;
            collectNew = JSCompositeTypeImpl.addToTable(newTable, signatures, true);
        }
        if (collectCall) {
            resultMembers.addAll(JSCompositeTypeImpl.getUnionSignatures(callTable, element));
        }
        if (collectNew) {
            resultMembers.addAll(JSCompositeTypeImpl.getUnionSignatures(newTable, element));
        }
    }

    private static boolean addToTable(@NotNull List<List<JSRecordType.CallSignature>> callTable, @NotNull List<JSRecordType.CallSignature> signatures, boolean b) {
        if (callTable == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(48);
        }
        if (signatures == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(49);
        }
        List<JSRecordType.CallSignature> collected = JSCompositeTypeImpl.getSignaturesWithKind(signatures, b);
        callTable.add(collected);
        return !collected.isEmpty();
    }

    @NotNull
    private static List<JSRecordType.CallSignature> getSignaturesWithKind(@NotNull List<JSRecordType.CallSignature> signatures, boolean hasNew) {
        if (signatures == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(50);
        }
        List<JSRecordType.CallSignature> list = signatures.stream().filter(el -> el.hasNew() == hasNew).collect(Collectors.toList());
        if (list == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(51);
        }
        return list;
    }

    private static List<List<JSRecordType.CallSignature>> createTable(@NotNull List<JSRecordType.CallSignature> value) {
        if (value == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(52);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        result2.add(value);
        return result2;
    }

    @NotNull
    public static List<JSRecordType.CallSignature> getUnionSignatures(@NotNull List<List<JSRecordType.CallSignature>> signatureTable, @NotNull PsiElement context) {
        DialectOptionHolder holder;
        if (signatureTable == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(53);
        }
        if (context == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(54);
        }
        if ((holder = DialectDetector.dialectOfElement(context)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(55);
            }
            return list;
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (int i = 0; i < signatureTable.size(); ++i) {
            List<JSRecordType.CallSignature> signatures = signatureTable.get(i);
            for (JSRecordType.CallSignature signature : signatures) {
                if (!result2.isEmpty() && TypeScriptSignatureChooser.findMatchedSignature(result2, signature, false, true) != null) continue;
                List<JSRecordType.CallSignature> matchingSignatures = TypeScriptSignatureChooser.findMatchingSignatures(signatureTable, signature, i);
                if (matchingSignatures.size() > 1) {
                    JSRecordType.CallSignature callSignature = matchingSignatures.get(0);
                    JSFunctionType type = callSignature.getFunctionType();
                    for (JSRecordType.CallSignature matchingSignature : matchingSignatures) {
                        JSFunctionType commonFunctionType;
                        JSFunctionType candidate = matchingSignature.getFunctionType();
                        if (type != candidate && (commonFunctionType = JSCompositeTypeImpl.getCommonFunctionType(type, candidate, holder)) != null) {
                            type = commonFunctionType;
                        }
                        result2.add(new JSRecordTypeImpl.CallSignatureImpl(callSignature.hasNew(), type));
                    }
                    continue;
                }
                result2.addAll(matchingSignatures);
            }
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(56);
        }
        return arrayList;
    }

    @Nullable
    private static JSFunctionType getCommonFunctionType(@NotNull JSFunctionType lType, @NotNull JSFunctionType rType, @NotNull DialectOptionHolder holder) {
        if (lType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(57);
        }
        if (rType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(58);
        }
        if (holder == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(59);
        }
        if (rType.isEquivalentTo((JSType)lType, null)) {
            return lType;
        }
        int count = JSCompositeTypeImpl.getIntersectionParameters(lType, rType);
        if (count == -1) {
            return null;
        }
        List lParameters = lType.getParameters();
        List rParameters = rType.getParameters();
        ArrayList resultParameters = ContainerUtil.newArrayList();
        int lLength = lParameters.size();
        int rLength = rParameters.size();
        for (int i = 0; i < count; ++i) {
            JSType rParameterType;
            JSParameterTypeDecorator lDecorator = lLength > i ? (JSParameterTypeDecorator)lParameters.get(i) : null;
            JSParameterTypeDecorator rDecorator = rLength > i ? (JSParameterTypeDecorator)rParameters.get(i) : null;
            JSType lParameterType = lDecorator == null || lDecorator.isRest() && rDecorator != null && !rDecorator.isRest() ? JSCompositeTypeImpl.getRestComponentType(lParameters) : lDecorator.getType();
            JSType jSType = rParameterType = rDecorator == null || rDecorator.isRest() && lDecorator != null && !lDecorator.isRest() ? JSCompositeTypeImpl.getRestComponentType(rParameters) : rDecorator.getType();
            if (lDecorator == null) {
                lDecorator = rDecorator;
            }
            if (rDecorator == null) {
                rDecorator = lDecorator;
            }
            if (rDecorator == null) {
                Logger.getInstance(JSCompositeTypeImpl.class).error("Incorrect state in signature merging \nltype: " + lType.getTypeText() + "\nrtype: " + rType.getTypeText());
                return null;
            }
            JSType parameterType = JSCompositeTypeImpl.getCommonTypeWithDialect(holder, lParameterType, rParameterType);
            boolean isOptional = lDecorator.isOptional() && rDecorator.isOptional();
            boolean explicit = rDecorator.isExplicitlyDeclared() && lDecorator.isExplicitlyDeclared();
            boolean isRest = lDecorator.isRest() && rDecorator.isRest();
            resultParameters.add(new JSParameterTypeDecoratorImpl(parameterType, isOptional, isRest, explicit));
        }
        JSType lReturnType = lType.getReturnType();
        JSType rReturnType = rType.getReturnType();
        JSType resultReturn = JSCompositeTypeImpl.getCommonTypeWithDialect(holder, lReturnType, rReturnType);
        return new JSFunctionTypeImpl(lType.getSource(), resultParameters, resultReturn);
    }

    private static int getIntersectionParameters(JSFunctionType commonCurrent, JSFunctionType type) {
        int min2;
        List commonCurrentParameters = commonCurrent.getParameters();
        List typeParameters = type.getParameters();
        int max1 = TypeScriptSignatureChooser.getMaxArgumentCount(commonCurrentParameters);
        int max2 = TypeScriptSignatureChooser.getMaxArgumentCount(typeParameters);
        int commonMaxLength = Math.min(max1, max2);
        int min1 = TypeScriptSignatureChooser.getMinArgumentCount(commonCurrentParameters);
        int commonMinLength = Math.max(min1, min2 = TypeScriptSignatureChooser.getMinArgumentCount(typeParameters));
        if (commonMinLength > commonMaxLength) {
            return -1;
        }
        if (commonMaxLength == commonMinLength) {
            return commonMaxLength;
        }
        return commonMaxLength == Integer.MAX_VALUE ? Math.min(commonCurrentParameters.size(), typeParameters.size()) : commonMaxLength;
    }

    @Nullable
    private static JSType getRestComponentType(@NotNull List<JSParameterTypeDecorator> parameters) {
        int size;
        if (parameters == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(60);
        }
        if ((size = parameters.size()) == 0) {
            return null;
        }
        JSParameterTypeDecorator last = parameters.get(size - 1);
        return last.isRest() && last.getType() != null ? JSTypeUtils.getIndexableComponentType(last.getType()) : null;
    }

    @Nullable
    private static JSType getCommonTypeWithDialect(@Nullable DialectOptionHolder holder, @Nullable JSType lType, @Nullable JSType rType) {
        JSType parameterType = null;
        if (lType != null && rType != null) {
            parameterType = JSTypeUtils.getCommonType(lType, rType, holder, true);
        }
        return parameterType != null ? parameterType : (lType == null ? rType : lType);
    }

    private void addCommonPropertyMember(@NotNull Collection<JSRecordType> typesToMerge, @NotNull List<JSRecordType.TypeMember> resultMembers, @NotNull JSRecordType.PropertySignature currentProperty) {
        if (typesToMerge == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(61);
        }
        if (resultMembers == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(62);
        }
        if (currentProperty == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(63);
        }
        JSType commonType = null;
        String memberName = currentProperty.getMemberName();
        JSRecordType.MemberSource source = currentProperty.getMemberSource();
        ArrayList allProps = ContainerUtil.newArrayList((Iterable)source.getAllSourceElements());
        for (JSRecordType resolvedType : typesToMerge) {
            JSRecordType.PropertySignature signature = resolvedType.findPropertySignature(memberName);
            if (signature == null) {
                return;
            }
            commonType = this.getCommonPropertyType(signature, currentProperty, commonType);
            allProps.addAll(signature.getMemberSource().getAllSourceElements());
        }
        String name = currentProperty.getMemberName();
        boolean optional = currentProperty.isOptional();
        resultMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(name, commonType, optional, JSRecordMemberSourceFactory.createSource(allProps, JSRecordType.MemberSourceKind.Union)));
    }

    @Nullable
    private JSType getCommonPropertyType(@NotNull JSRecordType.PropertySignature typeMember, @NotNull JSRecordType.PropertySignature currentProperty, @Nullable JSType commonType) {
        if (typeMember == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(64);
        }
        if (currentProperty == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(65);
        }
        if (currentProperty.isEquivalentTo((JSRecordType.TypeMember)typeMember, true)) {
            return commonType == null ? currentProperty.getType() : commonType;
        }
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (StringUtil.equals((CharSequence)currentProperty.getMemberName(), (CharSequence)typeMember.getMemberName())) {
            JSType type1 = currentProperty.getType();
            JSType type2 = typeMember.getType();
            DialectOptionHolder holder = sourceElement == null ? null : DialectDetector.dialectOfElement(sourceElement);
            JSType typeToUse = (JSType)ObjectUtils.coalesce((Object)commonType, (Object)type1);
            commonType = JSCompositeTypeImpl.getCommonTypeWithDialect(holder, typeToUse, type2);
        }
        return commonType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 51: 
            case 55: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 51: 
            case 55: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 51: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl";
                break;
            }
            case 2: 
            case 4: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeNullAndUndefinedTypes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optimized";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allCommonTypes";
                break;
            }
            case 15: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_types";
                break;
            }
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 36: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 45: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesToMerge";
                break;
            }
            case 46: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultMembers";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSignatures";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callTable";
                break;
            }
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatures";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureTable";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentProperty";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeTypeForSubstitute";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeOfType";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDirectAssignableCommonInSuperClass";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptimized";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignaturesWithKind";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnionSignatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "optimizeTypeForSubstitute";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 51: 
            case 55: 
            case 56: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "optimizeTypeIfComposite";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isOptimizedAcceptable";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCommonType";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignableForNestedTypes";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "checkDirectAssignableCommonInSuperClass";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "anyNestedTypeEqualsTo";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addCommonCallSignatureMembers";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addToTable";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getSignaturesWithKind";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createTable";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getUnionSignatures";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getCommonFunctionType";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getRestComponentType";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "addCommonPropertyMember";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getCommonPropertyType";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "lambda$anyNestedTypeEqualsTo$5";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "lambda$optimizeTypeIfComposite$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 51: 
            case 55: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum OptimizedKind {
        NOT_OPTIMIZED,
        OPTIMIZED_SIMPLE,
        OPTIMIZED_REMOVED_NULL_UNDEFINED,
        OPTIMIZED_REMOVED_FALSY;

    }
}

