/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenericTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    @NotNull
    private final JSType myType;
    @NotNull
    private final List<JSType> myArguments;
    @Nullable
    private final Map<String, JSType> myOuterArguments;

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @Nullable Map<String, JSType> outer) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(0);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(1);
        }
        super(source);
        this.myType = type;
        this.myArguments = ContainerUtil.newArrayList();
        this.myOuterArguments = outer;
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @NotNull JSType argument) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(2);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(3);
        }
        if (argument == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(4);
        }
        super(source);
        this.myType = type;
        this.myArguments = ContainerUtil.newArrayList((Object[])new JSType[]{argument});
        this.myOuterArguments = null;
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @NotNull List<JSType> arguments, @Nullable Map<String, JSType> outer) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(5);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(6);
        }
        if (arguments == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(7);
        }
        super(source);
        this.myType = type;
        this.myArguments = ContainerUtil.newArrayList(arguments);
        this.myOuterArguments = outer;
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, List<JSType> arguments) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(8);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(9);
        }
        this(source, type, arguments, null);
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSGenericType((JSType)this);
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        this.myType.accept(visitor);
        for (JSType argument : this.myArguments) {
            argument.accept(visitor);
        }
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        boolean isSerialization;
        StringBuilder builder = new StringBuilder();
        boolean bl = isSerialization = format == JSType.TypeTextFormat.SERIALIZED;
        if (!this.isTypeScript() || isSerialization) {
            boolean wrapInBraces = JSTypeUtils.isNeedWrapTypeForSerialization(this.myType);
            if (wrapInBraces) {
                builder.append("(");
            }
            builder.append(this.myType.getTypeText(format));
            if (wrapInBraces) {
                builder.append(")");
            }
            if (this.getSource().getLanguage() == JSTypeSource.SourceLanguage.AS) {
                builder.append('.');
            }
            this.appendArgumentTypeText(format, builder);
        } else {
            boolean isNestedFunctionType = this.myType instanceof JSFunctionTypeImpl;
            if (isNestedFunctionType) {
                this.appendArgumentTypeText(format, builder);
                builder.append(this.myType.getTypeText(format));
            } else {
                builder.append(this.myType.getTypeText(format));
                this.appendArgumentTypeText(format, builder);
            }
        }
        String string = builder.toString();
        if (string == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getTypeId() {
        String desc = "#generic#" + this.getType().getTypeId() + "#inner#" + StringUtil.join(this.getArguments(), JSType::getTypeId, (String)",");
        Map<String, JSType> outer = this.getOuterArguments();
        if (outer == null) {
            String string = desc;
            if (string == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = desc + "#outer#" + StringUtil.join(outer.entrySet(), e -> (String)e.getKey() + ":" + (e.getValue() == null ? "$null$" : ((JSType)e.getValue()).getTypeId()), (String)",");
        if (string == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    private void appendArgumentTypeText(@NotNull JSType.TypeTextFormat format, @NotNull StringBuilder builder) {
        if (format == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(13);
        }
        if (builder == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(14);
        }
        builder.append("<");
        String prefix = "";
        for (JSType argument : this.myArguments) {
            JSType constraint;
            builder.append(prefix);
            builder.append(argument.getTypeText(format));
            if (argument instanceof JSGenericParameterImpl && !((JSGenericParameterImpl)argument).isCallEnvironment() && format != JSType.TypeTextFormat.SERIALIZED && (constraint = ((JSGenericParameterImpl)argument).getConstraintType()) != null) {
                builder.append(" extends ");
                builder.append(constraint.getTypeText(format));
            }
            prefix = ", ";
        }
        builder.append(">");
    }

    @Override
    @Nullable
    public JSClass resolveClass() {
        return this.myType.resolveClass();
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(15);
        }
        if (this.isTypeScript()) {
            JSType elemType;
            String thisQName;
            Boolean ourResult;
            JSTypeCastUtil.AssignableResult type;
            JSType typedef;
            if (processingContext == null) {
                processingContext = new ProcessingContext();
            }
            if (elementType instanceof JSTypeImpl && (typedef = ((JSTypeImpl)elementType).getTypedef(null, processingContext)) != null) {
                elementType = typedef;
            }
            if (elementType instanceof JSTupleTypeImpl) {
                return this.isDirectlyAssignableType(((JSTupleTypeImpl)elementType).toArrayType(true), processingContext);
            }
            if (elementType instanceof JSArrayType) {
                elementType = ((JSArrayType)elementType).asGenericType();
            } else {
                JSType resolved;
                if (elementType instanceof JSCompositeTypeImpl) {
                    String thisText = this.getResolvedTypeText();
                    String elementQName = elementType.getResolvedTypeText();
                    JSCompositeTypeImpl composite = (JSCompositeTypeImpl)elementType;
                    return JSRecursiveTypeUtil.computeWithRecursiveTypes(thisText, elementQName, processingContext, ctx -> {
                        boolean isAssignable = true;
                        for (JSType type : composite.getTypes()) {
                            if (this.isDirectlyAssignableType(type, ctx)) continue;
                            isAssignable = false;
                            break;
                        }
                        return isAssignable;
                    }, Boolean.valueOf(true));
                }
                if (elementType instanceof JSRecordType && this != (resolved = this.substitute())) {
                    JSType finalElementType = elementType;
                    ProcessingContext finalProcessingContext = processingContext;
                    Boolean result2 = (Boolean)RecursionManager.doPreventingRecursion((Object)("JSGenericTypeImpl.isDirectlyAssignableTypeImpl." + this.getResolvedTypeText()), (boolean)false, () -> resolved.isDirectlyAssignableType(finalElementType, finalProcessingContext));
                    return result2 == null ? true : result2;
                }
            }
            if (elementType instanceof JSGenericTypeImpl && (type = this.isDirectlyAssignableGenericType((JSGenericTypeImpl)elementType, processingContext)).isStrict()) {
                return type.isAssignable();
            }
            String elementQName = JSTypeUtils.getQualifiedNameMatchingType(elementType, true);
            if (elementQName != null && (ourResult = JSRecursiveTypeUtil.computeRecursivelyOrNot(thisQName = JSTypeUtils.getQualifiedNameMatchingType(this, true), elementQName, processingContext, arg_0 -> this.lambda$isDirectlyAssignableTypeImpl$3(elemType = elementType, arg_0), true, thisQName == null)) != null) {
                return ourResult;
            }
            return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
        }
        if (elementType instanceof JSGenericTypeImpl) {
            if (!this.myType.isDirectlyAssignableType(((JSGenericTypeImpl)elementType).myType, processingContext)) {
                return false;
            }
            List<JSType> elementTypeArgs = ((JSGenericTypeImpl)elementType).myArguments;
            ListIterator<JSType> iterator = elementTypeArgs.listIterator();
            boolean allArgumentsEquivalent = true;
            for (JSType argument : this.myArguments) {
                allArgumentsEquivalent &= iterator.hasNext() && JSTypeUtils.areTypesCompatible(argument, iterator.next(), processingContext, null);
            }
            return this.getSource().getLanguage() == JSTypeSource.SourceLanguage.JS || allArgumentsEquivalent && !iterator.hasNext();
        }
        if (JSGenericTypeImpl.isGenericActionScriptVectorType(this) && !(elementType instanceof JSNullType) && !(elementType instanceof JSAnyType)) {
            return false;
        }
        if (elementType instanceof JSArrayTypeImpl) {
            return this.isDirectlyAssignableType(((JSArrayTypeImpl)elementType).asGenericType(), processingContext);
        }
        if (elementType instanceof JSTypeofTypeImpl) {
            return this.isDirectlyAssignableType(elementType.substitute(), processingContext);
        }
        return this.myType.isDirectlyAssignableType(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult result2;
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(16);
        }
        if ((result2 = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = result2;
            if (assignableResult == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(17);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(this.myType.isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(18);
        }
        return assignableResult;
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(19);
        }
        if (type instanceof JSGenericTypeImpl) {
            if (!this.myType.isEquivalentTo(((JSGenericTypeImpl)type).myType, processingContext, allowResolve)) {
                return false;
            }
            return JSGenericTypeImpl.areGenericArgumentsAssignable(this, (JSGenericTypeImpl)type, processingContext, true, allowResolve) == JSTypeCastUtil.AssignableResult.ASSIGNABLE;
        }
        return false;
    }

    public JSTypeCastUtil.AssignableResult isDirectlyAssignableGenericType(@NotNull JSGenericTypeImpl elementType, @NotNull ProcessingContext processingContext) {
        JSType rMainType;
        boolean isSameMainType;
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(20);
        }
        if (processingContext == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(21);
        }
        if (isSameMainType = this.myType.isEquivalentTo(rMainType = elementType.myType, processingContext)) {
            String elementText;
            String thisText = this.getResolvedTypeText();
            JSTypeCastUtil.AssignableResult assignableResult = JSRecursiveTypeUtil.computeWithRecursiveTypes(thisText, elementText = elementType.getResolvedTypeText(), processingContext, ctx -> {
                if (elementType == null) {
                    JSGenericTypeImpl.$$$reportNull$$$0(36);
                }
                return JSGenericTypeImpl.areGenericArgumentsAssignable(this, elementType, ctx, false, true);
            }, JSTypeCastUtil.AssignableResult.ASSIGNABLE);
            if (assignableResult.isAssignable() || !assignableResult.isStrict()) {
                return JSTypeCastUtil.AssignableResult.ASSIGNABLE;
            }
            if (this.myType instanceof JSPrimitiveArrayType && rMainType instanceof JSPrimitiveArrayType) {
                return JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
            }
        } else if (rMainType instanceof JSNamedType && this.myType instanceof JSNamedType) {
            Collection<? extends PsiElement> lOpElements = TypeScriptTypeParser.resolveElementsByType(this.myType);
            Collection<? extends PsiElement> rOpElements = TypeScriptTypeParser.resolveElementsByType(rMainType);
            for (PsiElement psiElement : lOpElements) {
                for (PsiElement psiElement2 : rOpElements) {
                    JSClass parentClass;
                    JSClass childClass;
                    if (!(psiElement instanceof JSClass) || !(psiElement2 instanceof JSClass) || !JSInheritanceUtil.isParentClass(childClass = (JSClass)psiElement, parentClass = (JSClass)psiElement2, false)) continue;
                    String thisText = this.getResolvedTypeText();
                    String elementText = elementType.getResolvedTypeText();
                    return JSRecursiveTypeUtil.computeWithRecursiveTypes(thisText, elementText, processingContext, ctx -> {
                        if (elementType == null) {
                            JSGenericTypeImpl.$$$reportNull$$$0(35);
                        }
                        TypeScriptTypeParameterList list = ((TypeScriptTypeParameterListOwner)parentClass).getTypeParameterList();
                        JSTypeCastUtil.AssignableResult result2 = JSTypeCastUtil.AssignableResult.NOT_SURE;
                        if (list != null) {
                            JSTypeSource source = rMainType.getSource();
                            ArrayList rawGenerics = ContainerUtil.newArrayList();
                            for (TypeScriptTypeParameter parameter : list.getTypeParameters()) {
                                String name = parameter.getName();
                                if (name == null) continue;
                                rawGenerics.add(JSNamedType.createType(name, source, JSContext.INSTANCE));
                            }
                            JSGenericTypeImpl guessedType = new JSGenericTypeImpl(rMainType.getSource(), rMainType, rawGenerics);
                            JSType type = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(childClass, elementType.getArguments(), parentClass, guessedType);
                            if (type instanceof JSGenericTypeImpl) {
                                result2 = JSGenericTypeImpl.areGenericArgumentsAssignable(this, (JSGenericTypeImpl)type, ctx, false, true);
                            }
                        }
                        return result2;
                    }, JSTypeCastUtil.AssignableResult.ASSIGNABLE);
                }
            }
        }
        return JSTypeCastUtil.AssignableResult.NOT_SURE;
    }

    public static JSTypeCastUtil.AssignableResult areGenericArgumentsAssignable(@NotNull JSGenericTypeImpl lType, @NotNull JSGenericTypeImpl rType, @Nullable ProcessingContext processingContext, boolean checkEquivalent, boolean allowResolve) {
        if (lType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(22);
        }
        if (rType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(23);
        }
        Iterator<JSType> iterator = rType.myArguments.iterator();
        for (JSType argument : lType.myArguments) {
            boolean result2;
            if (!iterator.hasNext()) {
                return JSTypeCastUtil.AssignableResult.NOT_SURE;
            }
            JSType next = iterator.next();
            if (!(checkEquivalent ? !argument.isEquivalentTo(next, processingContext, allowResolve) : !(result2 = argument.isDirectlyAssignableType(next, processingContext)))) continue;
            return JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
        }
        return iterator.hasNext() ? JSTypeCastUtil.AssignableResult.NOT_SURE : JSTypeCastUtil.AssignableResult.ASSIGNABLE;
    }

    public static boolean isGenericActionScriptVectorType(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof JSGenericTypeImpl && type.getSource().isEcma()) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)type;
            String typeText = genericType.myType.getResolvedTypeText();
            return "Vector".equals(typeText) && genericType.myArguments.size() == 1;
        }
        return false;
    }

    @NotNull
    public JSType getType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(24);
        }
        return jSType;
    }

    @Deprecated
    void addGenericArgument(JSType type) {
        this.myArguments.add(type);
    }

    @NotNull
    public List<JSType> getArguments() {
        List<JSType> list = Collections.unmodifiableList(this.myArguments);
        if (list == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(25);
        }
        return list;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(26);
        }
        JSType oldType = this.getType();
        JSType newType = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform);
        List<JSType> oldArgs = this.getArguments();
        List newArgs = ContainerUtil.map(oldArgs, type -> {
            if (childTransform == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(34);
            }
            return JSTypeUtils.transformTypeHierarchySafe(type, childTransform);
        });
        Map<String, JSType> oldOuterArgs = this.getOuterArguments();
        LinkedHashMap newOuterArgs = null;
        boolean hasNewOuters = false;
        if (oldOuterArgs != null) {
            newOuterArgs = ContainerUtil.newLinkedHashMap();
            for (Map.Entry<String, JSType> entry : oldOuterArgs.entrySet()) {
                JSType oldOuterArgType = entry.getValue();
                JSType newOuterArgType = JSTypeUtils.transformTypeHierarchySafe(oldOuterArgType, childTransform);
                if (newOuterArgType != oldOuterArgType) {
                    hasNewOuters = true;
                }
                newOuterArgs.put(entry.getKey(), newOuterArgType);
            }
        }
        if (!hasNewOuters && ContainerUtil.equalsIdentity(oldArgs, (List)newArgs) && oldType == newType) {
            JSGenericTypeImpl jSGenericTypeImpl = this;
            if (jSGenericTypeImpl == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(27);
            }
            return jSGenericTypeImpl;
        }
        if (newType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(this.getSource(), ((JSGenericTypeImpl)newType).getType(), ((JSGenericTypeImpl)newType).getArguments().stream().map(a -> {
                if (childTransform == null) {
                    JSGenericTypeImpl.$$$reportNull$$$0(33);
                }
                return a.transformTypeHierarchy(childTransform);
            }).collect(Collectors.toList()), newOuterArgs);
            if (jSGenericTypeImpl == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(28);
            }
            return jSGenericTypeImpl;
        }
        JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(this.getSource(), newType, newArgs, newOuterArgs);
        if (jSGenericTypeImpl == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(29);
        }
        return jSGenericTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(30);
        }
        JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(source, this.getType(), this.getArguments(), this.getOuterArguments());
        if (jSGenericTypeImpl == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(31);
        }
        return jSGenericTypeImpl;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = JSTypeImpl.resolveQualifiedType(this);
        if (jSType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(32);
        }
        return jSType;
    }

    @Nullable
    public Map<String, JSType> getOuterArguments() {
        return this.myOuterArguments;
    }

    private /* synthetic */ Boolean lambda$isDirectlyAssignableTypeImpl$3(JSType elemType, ProcessingContext ctx) {
        JSType resolved = this.substitute();
        if (resolved != this) {
            return resolved.isDirectlyAssignableType(elemType, ctx);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 15: 
            case 16: 
            case 20: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 26: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeId";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendArgumentTypeText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableGenericType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "areGenericArgumentsAssignable";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copyTypeHierarchy$7";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copyTypeHierarchy$6";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isDirectlyAssignableGenericType$5";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isDirectlyAssignableGenericType$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

