/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStringLiteralTypeImpl
extends JSStringType
implements JSPrimitiveLiteralType<String> {
    @NotNull
    protected final String myUnquotedValue;
    private final boolean myStrict;

    public JSStringLiteralTypeImpl(@NotNull String literal, boolean strict, @NotNull JSTypeSource source) {
        if (literal == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(1);
        }
        super(true, source, JSTypeContext.INSTANCE);
        this.myUnquotedValue = literal;
        this.myStrict = strict;
    }

    @Override
    @NotNull
    public String getLiteral() {
        String string = this.myUnquotedValue;
        if (string == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (this.isEcma() || format == JSType.TypeTextFormat.RESOLVED) {
            if ("String" == null) {
                JSStringLiteralTypeImpl.$$$reportNull$$$0(3);
            }
            return "String";
        }
        if (format == JSType.TypeTextFormat.PRESENTABLE || format == JSType.TypeTextFormat.CODE) {
            String string = this.isTypeScript() && (this.isStrict() || format != JSType.TypeTextFormat.CODE) ? StringUtil.wrapWithDoubleQuote((String)this.myUnquotedValue) : "string";
            if (string == null) {
                JSStringLiteralTypeImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (format == JSType.TypeTextFormat.SERIALIZED) {
            String string = "\"" + this.myUnquotedValue + "\"" + (this.myStrict ? "!" : "");
            if (string == null) {
                JSStringLiteralTypeImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = "String(\"" + this.myUnquotedValue + "\")";
        if (string == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(7);
        }
        if (elementType instanceof JSStringLiteralTypeImpl && this.getSource().isStrict() && (this.isJavaScript() || this.myStrict)) {
            return this.myUnquotedValue.equals(((JSStringLiteralTypeImpl)elementType).myUnquotedValue);
        }
        if (this.myStrict && elementType instanceof JSStringType) {
            return false;
        }
        if (this.myStrict && elementType instanceof JSResolvableType) {
            JSResolvedTypeInfo resolvedType = ((JSResolvableType)elementType).resolveType();
            if (resolvedType != null && resolvedType.isEnumLiteral()) {
                TypeScriptEnumField field = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
                if (field == null) {
                    return false;
                }
                EnumConstantValue value = field.getConstantValue();
                String stringValue = value.getStringValue();
                return stringValue != null && stringValue.equals(this.myUnquotedValue);
            }
            if (resolvedType != null && resolvedType.isEnum()) {
                return false;
            }
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(8);
        }
        return type instanceof JSStringLiteralTypeImpl && this.myUnquotedValue.equals(((JSStringLiteralTypeImpl)type).myUnquotedValue);
    }

    @Override
    @NotNull
    public JSType asPrimitiveType() {
        JSType jSType = JSNamedType.createType("string", this.getSource(), this.getTypeContext());
        if (jSType == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(9);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSStringLiteralTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(10);
        }
        JSStringLiteralTypeImpl jSStringLiteralTypeImpl = new JSStringLiteralTypeImpl(this.getLiteral(), this.myStrict, source);
        if (jSStringLiteralTypeImpl == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(11);
        }
        return jSStringLiteralTypeImpl;
    }

    @Override
    public boolean isStrict() {
        return this.myStrict;
    }

    @Override
    @NotNull
    public JSLiteralType copyWithStrictness(boolean strict) {
        JSStringLiteralTypeImpl jSStringLiteralTypeImpl = new JSStringLiteralTypeImpl(this.myUnquotedValue, strict, this.getSource());
        if (jSStringLiteralTypeImpl == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(12);
        }
        return jSStringLiteralTypeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSStringLiteralTypeImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSStringLiteralTypeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteral";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "asPrimitiveType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithStrictness";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

