/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfoImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeImpl
extends JSNamedType
implements JSResolvableType {
    @NotNull
    private final String myType;
    private boolean myIsResolved;
    private boolean myIsStrict;
    private final boolean myInheritsFunction;
    private JSResolvedTypeInfo myResolvedType;
    private boolean myIsWidened;
    private static final Key<String> ourQualifiedTypeNameKey = Key.create((String)"qualified.type.name");
    static Key<Map<String, JSType>> ourTypedefsExpandedKey = Key.create((String)"typedefs.expanded");

    JSTypeImpl(@NotNull String type, @NotNull JSTypeSource source, @NotNull JSTypeContext staticOrInstance, boolean inheritsFunction, boolean isWidened) {
        if (type == null) {
            JSTypeImpl.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSTypeImpl.$$$reportNull$$$0(1);
        }
        if (staticOrInstance == null) {
            JSTypeImpl.$$$reportNull$$$0(2);
        }
        super(source, staticOrInstance);
        this.myType = type;
        this.myInheritsFunction = inheritsFunction;
        this.myIsWidened = isWidened;
        this.myIsStrict = true;
    }

    @Override
    @Nullable
    public JSResolvedTypeInfo resolveType() {
        if (this.myIsResolved) {
            return this.myResolvedType;
        }
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (JSTypeImpl.isSourceElementNotValid(sourceElement)) {
            return null;
        }
        JSTypeResolveResult result2 = JSDialectSpecificHandlersFactory.forElement(sourceElement).getImportHandler().resolveMainElementName(this.myType, sourceElement);
        this.myResolvedType = new JSResolvedTypeInfoImpl(result2.getQualifiedName(), result2.getElements());
        this.myIsResolved = true;
        return this.myResolvedType;
    }

    @Override
    @Nullable
    public JSClass resolveClass() {
        PsiElement clazz;
        if (!this.isEcma()) {
            return null;
        }
        ProgressManager.checkCanceled();
        String qualifiedType = this.myType;
        JSTypeSource source = this.getSource();
        PsiElement element = source.getSourceElement();
        PsiElement resolvedElement = null;
        if (element != null) {
            JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement((PsiElement)this.getScope()).getImportHandler();
            JSTypeResolveResult result2 = importHandler.resolveTypeName(this.myType, element);
            qualifiedType = result2.getQualifiedName();
            Iterator<? extends PsiElement> iterator = result2.getElements().iterator();
            if (iterator.hasNext()) {
                resolvedElement = iterator.next();
            }
        }
        PsiElement psiElement = clazz = resolvedElement != null ? resolvedElement : JSResolveUtil.findType(qualifiedType, (PsiElement)this.getScope(), true);
        if (clazz instanceof JSClass) {
            return (JSClass)clazz;
        }
        return null;
    }

    @Override
    @NotNull
    public String getResolvedTypeText() {
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (JSTypeImpl.isSourceElementNotValid(sourceElement)) {
            String string = this.myType;
            if (string == null) {
                JSTypeImpl.$$$reportNull$$$0(3);
            }
            return string;
        }
        JSResolvedTypeInfo resolvedType = this.resolveType();
        if (resolvedType == null) {
            String string = this.myType;
            if (string == null) {
                JSTypeImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = resolvedType.getResolvedTypeText();
        if (string == null) {
            JSTypeImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static boolean isSourceElementNotValid(PsiElement sourceElement) {
        return sourceElement == null || !sourceElement.isValid();
    }

    @Nullable
    public static JSType fromElement(PsiElement element, PsiElement context) {
        JSType type = null;
        if (element instanceof JSVariable) {
            type = ((JSVariable)element).getType();
        } else if (element instanceof JSFunction) {
            type = JSFunctionImpl.getReturnTypeInContext((JSFunction)element, JSTypeUtils.getScopeInOriginalTree(context));
        }
        return type;
    }

    @Override
    @NotNull
    public String getTypeText() {
        String string = this.myType;
        if (string == null) {
            JSTypeImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.RESOLVED || format == JSType.TypeTextFormat.CODE) {
            String string = this.getResolvedTypeText();
            if (string == null) {
                JSTypeImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (format == JSType.TypeTextFormat.SERIALIZED) {
            String toProcess = this.myType;
            if (StringUtil.contains((CharSequence)toProcess, (CharSequence)"\"")) {
                toProcess = toProcess.replace("\"", JSNamedType.QUOTE_ESCAPE);
            }
            if (this.isStaticOrInstance() == JSContext.STATIC) {
                toProcess = toProcess + "^s";
            }
            if (this.inheritsFunction()) {
                toProcess = toProcess + "^f";
            }
            if (this.isWidened()) {
                toProcess = toProcess + "^w";
            }
            String string = toProcess;
            if (string == null) {
                JSTypeImpl.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = this.getTypeText();
        if (string == null) {
            JSTypeImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSResolvedTypeInfo resolvedType;
        if (elementType == null) {
            JSTypeImpl.$$$reportNull$$$0(10);
        }
        String qName = this.addToContextQualifierName(processingContext);
        if (this.getSource().isStrict() && !this.isEcma()) {
            JSType typedefValue;
            if (processingContext == null) {
                processingContext = new ProcessingContext();
            }
            if ((typedefValue = this.getTypedef(qName, processingContext)) != null) {
                String elementTypeText = elementType.getResolvedTypeText();
                return JSRecursiveTypeUtil.computeWithRecursiveTypes(qName, elementTypeText, processingContext, ctx -> {
                    if (elementType == null) {
                        JSTypeImpl.$$$reportNull$$$0(22);
                    }
                    return typedefValue.isDirectlyAssignableType(elementType, ctx);
                }, Boolean.valueOf(true));
            }
        }
        if ((resolvedType = this.resolveType()) != null) {
            String qualifiedName;
            TypeScriptEnum parentEnumElement;
            TypeScriptEnumField field;
            if (elementType instanceof JSNumberType && resolvedType.isEnum()) {
                return true;
            }
            boolean isEnumLiteral = resolvedType.isEnumLiteral();
            boolean otherIsEnumLiteral = false;
            boolean otherIsEnum = false;
            JSResolvedTypeInfo resolvedOtherType = null;
            if (elementType instanceof JSTypeImpl && (resolvedOtherType = ((JSTypeImpl)elementType).resolveType()) != null) {
                otherIsEnumLiteral = resolvedOtherType.isEnumLiteral();
                otherIsEnum = resolvedOtherType.isEnum();
            }
            if (isEnumLiteral && otherIsEnumLiteral) {
                TypeScriptEnum otherEnum;
                TypeScriptEnumField ownField = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
                TypeScriptEnumField otherField = resolvedOtherType.getDeclarationOfType(TypeScriptEnumField.class);
                if (ownField == null || otherField == null) {
                    return false;
                }
                TypeScriptEnum ownEnum = (TypeScriptEnum)JSUtils.getMemberContainingClass((PsiElement)ownField);
                if (!Objects.equals(ownEnum, otherEnum = (TypeScriptEnum)JSUtils.getMemberContainingClass((PsiElement)otherField))) {
                    return false;
                }
                EnumConstantValue ownConstantValue = ownField.getConstantValue();
                EnumConstantValue otherConstantValue = otherField.getConstantValue();
                Double ownDouble = ownConstantValue.getNumericValue();
                Double otherDouble = otherConstantValue.getNumericValue();
                if (ownDouble != null && otherDouble != null && Objects.equals(ownDouble, otherDouble)) {
                    return true;
                }
                String ownString = ownConstantValue.getStringValue();
                String otherString = otherConstantValue.getStringValue();
                return ownString != null && otherString != null && Objects.equals(ownString, otherString);
            }
            if (otherIsEnumLiteral && resolvedType.isEnum() && (field = resolvedOtherType.getDeclarationOfType(TypeScriptEnumField.class)) != null && (parentEnumElement = (TypeScriptEnum)PsiTreeUtil.getContextOfType((PsiElement)field, (Class[])new Class[]{TypeScriptEnum.class})) != null && (qualifiedName = parentEnumElement.getQualifiedName()) != null) {
                return this.isDirectlyAssignableType(JSNamedType.createExplicitlyDeclaredType(qualifiedName, (PsiElement)parentEnumElement), processingContext);
            }
            if (isEnumLiteral && otherIsEnum) {
                return false;
            }
            if ((elementType instanceof JSNumberLiteralTypeImpl || elementType instanceof JSNumberType) && isEnumLiteral) {
                field = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
                if (field == null) {
                    return false;
                }
                Double value = field.getConstantValue().getNumericValue();
                return value != null;
            }
            if (elementType instanceof JSStringLiteralTypeImpl && isEnumLiteral) {
                return false;
            }
            if (!otherIsEnum && isEnumLiteral) {
                return false;
            }
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult result2;
        if (elementType == null) {
            JSTypeImpl.$$$reportNull$$$0(11);
        }
        if ((result2 = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = result2;
            if (assignableResult == null) {
                JSTypeImpl.$$$reportNull$$$0(12);
            }
            return assignableResult;
        }
        if (elementType instanceof JSTypeImpl) {
            JSTypeImpl elementTypeImpl = (JSTypeImpl)elementType;
            JSTypeContext elementTypeContext = elementTypeImpl.getTypeContext();
            if (this.getTypeContext() == JSTypeContext.STATIC && elementTypeContext == JSTypeContext.STATIC) {
                JSResolvedTypeInfo resolvedType1 = this.resolveType();
                JSResolvedTypeInfo resolvedType2 = ((JSTypeImpl)elementType).resolveType();
                if (resolvedType1 != null && resolvedType2 != null && !resolvedType1.isAbstract() && resolvedType2.isAbstract()) {
                    JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
                    if (assignableResult == null) {
                        JSTypeImpl.$$$reportNull$$$0(13);
                    }
                    return assignableResult;
                }
            }
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(this.getTypeHelper().isAssignableToNamedType(this, elementType, processingContext));
        if (assignableResult == null) {
            JSTypeImpl.$$$reportNull$$$0(14);
        }
        return assignableResult;
    }

    @NotNull
    private String addToContextQualifierName(@Nullable ProcessingContext processingContext) {
        String qName;
        Map cachesMap;
        Map map = cachesMap = processingContext != null ? (Map)processingContext.get((Object)this) : null;
        if (cachesMap == null && processingContext != null) {
            cachesMap = new THashMap();
            processingContext.put((Object)this, (Object)cachesMap);
        }
        if ((qName = (String)ourQualifiedTypeNameKey.get(cachesMap)) == null) {
            qName = this.getResolvedTypeText();
            ourQualifiedTypeNameKey.set(cachesMap, (Object)qName);
        }
        String string = qName;
        if (string == null) {
            JSTypeImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSTypeImpl.$$$reportNull$$$0(16);
        }
        if (!(type instanceof JSTypeImpl)) {
            return false;
        }
        JSTypeImpl jsType = (JSTypeImpl)type;
        if (allowResolve) {
            boolean areEquals = this.getResolvedTypeText().equals(type.getResolvedTypeText());
            if (!areEquals) {
                return false;
            }
            JSResolvedTypeInfo resolvedType1 = this.resolveType();
            JSResolvedTypeInfo resolvedType2 = jsType.resolveType();
            if (resolvedType1 != null && resolvedType2 != null && !resolvedType1.isLocal() && !resolvedType2.isLocal()) {
                return true;
            }
        } else {
            boolean areEquals = this.getTypeText().equals(type.getTypeText());
            if (!areEquals) {
                return false;
            }
        }
        return this.getSource().getSourceElement() == jsType.getSource().getSourceElement();
    }

    @Nullable
    public JSType getTypedef() {
        return this.getTypedef(null, null);
    }

    @Nullable
    public JSType getTypedef(@Nullable String qName, @Nullable ProcessingContext processingContext) {
        JSType typedefValue;
        boolean contextContainedTypedefsMap;
        if (qName == null) {
            qName = this.getResolvedTypeText();
        }
        Map evaluatedTypedefs = processingContext == null ? null : (Map)processingContext.get(ourTypedefsExpandedKey);
        boolean bl = contextContainedTypedefsMap = evaluatedTypedefs != null;
        if (processingContext != null && evaluatedTypedefs == null) {
            evaluatedTypedefs = new THashMap();
        }
        if (processingContext != null && evaluatedTypedefs.containsKey(qName)) {
            typedefValue = (JSType)evaluatedTypedefs.get(qName);
        } else {
            JSResolvedTypeInfo resolvedType = this.resolveType();
            JSType typedef = resolvedType == null ? null : resolvedType.getTypedef();
            JSType jSType = typedefValue = typedef != null ? typedef : JSTypeEvaluateManager.expandTypedefs((PsiElement)this.getScope(), qName);
        }
        if (processingContext != null) {
            evaluatedTypedefs.put(qName, typedefValue);
        }
        if (processingContext != null && !contextContainedTypedefsMap) {
            processingContext.put(ourTypedefsExpandedKey, (Object)evaluatedTypedefs);
        }
        return typedefValue;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSTypeImpl((JSType)this);
    }

    public boolean inheritsFunction() {
        return this.myInheritsFunction;
    }

    @Override
    public boolean isWidened() {
        return this.myIsWidened;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeImpl.$$$reportNull$$$0(17);
        }
        JSTypeImpl jSTypeImpl = this.copyWithNewSource(source, false);
        if (jSTypeImpl == null) {
            JSTypeImpl.$$$reportNull$$$0(18);
        }
        return jSTypeImpl;
    }

    @Override
    @NotNull
    public JSTypeImpl copyWithStrictness(boolean strict) {
        JSTypeImpl type = new JSTypeImpl(this.getTypeText(), this.getSource(), this.getTypeContext(), this.myInheritsFunction, this.myIsWidened);
        type.myIsResolved = this.myIsResolved;
        type.myResolvedType = this.myResolvedType;
        type.myIsStrict = strict;
        JSTypeImpl jSTypeImpl = type;
        if (jSTypeImpl == null) {
            JSTypeImpl.$$$reportNull$$$0(19);
        }
        return jSTypeImpl;
    }

    @Override
    @NotNull
    public JSTypeImpl copyAsWidened() {
        JSTypeImpl type = new JSTypeImpl(this.getTypeText(), this.getSource(), this.getTypeContext(), this.myInheritsFunction, true);
        type.myIsResolved = this.myIsResolved;
        type.myResolvedType = this.myResolvedType;
        JSTypeImpl jSTypeImpl = type;
        if (jSTypeImpl == null) {
            JSTypeImpl.$$$reportNull$$$0(20);
        }
        return jSTypeImpl;
    }

    public JSTypeImpl copyWithNewSource(JSTypeSource newSource, boolean resolve) {
        if (this.myIsResolved || resolve) {
            JSTypeImpl type = new JSTypeImpl(this.getTypeText(), newSource, this.getTypeContext(), this.myInheritsFunction, this.myIsWidened);
            type.myResolvedType = this.resolveType();
            type.myIsResolved = true;
            return type;
        }
        return new JSTypeImpl(this.getTypeText(), newSource, this.getTypeContext(), this.myInheritsFunction, this.myIsWidened);
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = JSTypeImpl.resolveQualifiedType(this);
        if (jSType == null) {
            JSTypeImpl.$$$reportNull$$$0(21);
        }
        return jSType;
    }

    public static JSType resolveQualifiedType(JSTypeBaseImpl type) {
        JSType declaration;
        if (!type.getSource().isTypeScript()) {
            return type;
        }
        Collection<? extends PsiElement> elements = TypeScriptTypeParser.resolveElementsByType(type);
        PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
        if (item instanceof TypeScriptTypeAlias && elements.size() == 1 && (declaration = ((TypeScriptTypeAlias)item).getParsedTypeDeclaration()) != null) {
            if (type instanceof JSGenericTypeImpl) {
                JSTypeSubstitutor generics = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)((TypeScriptTypeAlias)item), type);
                declaration = JSTypeUtils.applyGenericArguments(declaration, (Map<String, JSType>)generics);
            }
            return declaration;
        }
        return TypeScriptTypeParser.buildResolvedType(elements, type);
    }

    @Override
    public boolean isStrict() {
        return this.myIsStrict;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeImpl";
                break;
            }
            case 10: 
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedTypeText";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addToContextQualifierName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithStrictness";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAsWidened";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isDirectlyAssignableTypeImpl$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

