/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSScopeNamesCache;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSReturnStatementStub;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStubBasedPsiTreeUtil {
    static final TokenSet DECLARATIONS_TOKEN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{TypeScriptElementTypes.TYPE_MEMBERS, JSElementTypes.FUNCTION_DECLARATIONS, JSExtendedLanguagesTokenSetProvider.CLASSES, JSExtendedLanguagesTokenSetProvider.VARIABLES, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.TYPESCRIPT_MODULE, TypeScriptElementTypes.IMPLICIT_MODULE, JSStubElementTypes.DEFINITION_EXPRESSION, ES6ElementTypes.IMPORT_SPECIFIER, ES6ElementTypes.IMPORT_SPECIFIER_ALIAS, ES6ElementTypes.IMPORTED_BINDING, ES6ElementTypes.EXPORT_SPECIFIER, ES6ElementTypes.EXPORT_SPECIFIER_ALIAS, ES6ElementTypes.EXPORTED_DEFAULT_BINDING, TypeScriptElementTypes.IMPORT_STATEMENT, JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS})});
    private static final TokenSet FUNCTIONS_TOKEN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSElementTypes.FUNCTION_DECLARATIONS, JSElementTypes.FUNCTION_EXPRESSIONS});
    private static final TokenSet RETURN_STATEMENT_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.RETURN_STATEMENT});
    private static final Predicate<PsiElement> IS_TARGET = element -> {
        boolean isImport = false;
        if (element instanceof JSVariable) {
            JSExpression initializer = ((JSVariable)element).getInitializerOrStub();
            isImport = initializer instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall();
        } else if (element instanceof JSDefinitionExpression) {
            JSQualifiedName name = ((JSDefinitionExpression)element).getJSNamespace().getQualifiedName();
            isImport = name != null && "exports".equals(name.getName()) && (name.getParent() == null || "module".equals(name.getParent().getName()) && name.getParent().getParent() == null);
        } else if (element instanceof TypeScriptImportStatement || element instanceof ES6ImportExportSpecifierAlias || element instanceof ES6ImportedExportedDefaultBinding || element instanceof JSExportAssignment) {
            isImport = true;
        }
        return !isImport;
    };
    private static final Predicate<PsiElement> SEMANTIC_HIGHLIGHTING_STOP_AT = element -> {
        if (!IS_TARGET.test((PsiElement)element)) {
            return false;
        }
        if (element instanceof JSVariable && element.getParent() instanceof JSDestructuringProperty) {
            return false;
        }
        return !(element instanceof JSProperty) || ((JSProperty)element).getInitializerReference() == null;
    };
    private static final Predicate<PsiElement> SEMANTIC_HIGHLIGHTING_STOP_BEFORE = element -> element instanceof JSParameter && !TypeScriptPsiUtil.isFieldParameter((JSParameter)element);

    @Nullable
    public static PsiElement resolveLocally(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(1);
        }
        return JSStubBasedPsiTreeUtil.resolveLocally(name, context, true);
    }

    @Nullable
    public static PsiElement resolveLocally(final @NotNull String name, @NotNull PsiElement context, final boolean includeDefinitions) {
        if (name == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(3);
        }
        if (name.contains(".")) {
            return null;
        }
        final Ref result2 = Ref.create(null);
        JSStubBasedPsiTreeUtil.processDeclarationsInScope(context, new JSResolveProcessorBase(name){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((includeDefinitions || !(element instanceof JSDefinitionExpression)) && element instanceof JSNamedElement && name.equals(((JSNamedElement)element).getName())) {
                    result2.set((Object)element);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, true);
        return (PsiElement)result2.get();
    }

    @NotNull
    public static List<PsiElement> resolveLocallyWithMergedResults(final @NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(5);
        }
        if (name.contains(".")) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        final List result2 = ContainerUtil.newSmartList();
        JSStubBasedPsiTreeUtil.processDeclarationsInScope(context, new JSResolveProcessorBase(name){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!result2.isEmpty() && JSStubBasedPsiTreeUtil.getContextOfType((PsiElement)result2.get(0), JSTreeUtil.ScopeTypesHolder.SCOPE_TYPES, true) != JSStubBasedPsiTreeUtil.getContextOfType(element, JSTreeUtil.ScopeTypesHolder.SCOPE_TYPES, true)) {
                    return true;
                }
                if (element instanceof JSNamedElement && Objects.equals(((JSNamedElement)element).getName(), name) || element instanceof ES6ImportSpecifier && Objects.equals(((ES6ImportSpecifier)element).getDeclaredName(), name)) {
                    result2.add(element);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, true);
        List list = result2;
        if (list == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static boolean processDeclarationsInScope(@NotNull PsiElement context, @NotNull PsiScopeProcessor processor, boolean includeParentScopes) {
        String name;
        PsiElement scope;
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(9);
        }
        if ((scope = JSStubBasedPsiTreeUtil.getScope(context = (PsiElement)ObjectUtils.coalesce((Object)CompletionUtilCoreImpl.getOriginalElement((PsiElement)context), (Object)context))) == null) {
            return true;
        }
        String string = name = processor instanceof JSResolveProcessor ? ((JSResolveProcessor)processor).getName() : null;
        if (!JSStubBasedPsiTreeUtil.hasStub(scope)) {
            return JSStubBasedPsiTreeUtil.processDeclarationsInScopeAstBased(context, scope, processor, name, includeParentScopes);
        }
        return JSStubBasedPsiTreeUtil.processDeclarationsInScopeStubBased(context, scope, processor, name, includeParentScopes);
    }

    @Nullable
    private static PsiElement getScope(@NotNull PsiElement context) {
        PsiElement scope;
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(10);
        }
        return (scope = JSStubBasedPsiTreeUtil.getContextOfType(context, JSTreeUtil.ScopeTypesHolder.SCOPE_TYPES, false)) instanceof TypeScriptInterface ? ((TypeScriptInterface)scope).getBody() : scope;
    }

    private static boolean hasStub(@NotNull PsiElement scope) {
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(11);
        }
        return scope instanceof StubBasedPsiElementBase && ((StubBasedPsiElementBase)scope).getStub() != null || scope instanceof PsiFileImpl && ((PsiFileImpl)scope).getStubTree() != null;
    }

    private static boolean processDeclarationsInScopeStubBased(@NotNull PsiElement context, @NotNull PsiElement scope, @NotNull PsiScopeProcessor processor, @Nullable String name, boolean includeParentScopes) {
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(14);
        }
        while (scope != null) {
            if (!JSStubBasedPsiTreeUtil.processDeclarationsInScopeStubBased(context, scope, processor, name)) {
                return false;
            }
            if (!includeParentScopes || scope instanceof PsiFile || scope instanceof JSEmbeddedContent) {
                return true;
            }
            context = scope;
            scope = JSStubBasedPsiTreeUtil.getContextOfType(scope, JSTreeUtil.ScopeTypesHolder.SCOPE_TYPES, true);
        }
        return true;
    }

    private static boolean processDeclarationsInScopeStubBased(@NotNull PsiElement context, @NotNull PsiElement scope, @NotNull PsiScopeProcessor processor, @Nullable String name) {
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(17);
        }
        List<JSElement> elements = scope == context && name != null ? JSScopeNamesCache.findNamedElementsInStubScope(name, scope) : JSStubBasedPsiTreeUtil.findElementsInStubScopeWithContext(context, scope, name);
        for (PsiElement psiElement : elements) {
            if (processor.execute(psiElement, ResolveState.initial())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static TIntObjectHashMap<Object> buildStubBasedNamesMap(@NotNull PsiElement scope) {
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(18);
        }
        TIntObjectHashMap defs = new TIntObjectHashMap();
        ArrayList declarations = new ArrayList();
        JSStubBasedPsiTreeUtil.addDescendantsRecursively(scope, DECLARATIONS_TOKEN_SET, JSExtendedLanguagesTokenSetProvider.SCOPE_ELEMENTS, scope, null, declarations);
        for (PsiElement declaration : declarations) {
            String name = JSStubBasedPsiTreeUtil.extractName(declaration);
            if (name == null || !JSStubBasedPsiTreeUtil.isAcceptableDeclaration(declaration)) continue;
            JSScopeNamesCache.addElementCompact((TIntObjectHashMap<Object>)defs, (JSElement)declaration, name.hashCode());
        }
        TIntObjectHashMap tIntObjectHashMap = defs;
        if (tIntObjectHashMap == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(19);
        }
        return tIntObjectHashMap;
    }

    @NotNull
    private static List<JSElement> findElementsInStubScopeWithContext(@NotNull PsiElement context, @NotNull PsiElement scope, @Nullable String name) {
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(20);
        }
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(21);
        }
        List result2 = ContainerUtil.newSmartList();
        ArrayList declarations = new ArrayList();
        Ref declarationsBeforeContextRef = Ref.create((Object)0);
        JSStubBasedPsiTreeUtil.addDescendantsRecursively(scope, DECLARATIONS_TOKEN_SET, JSExtendedLanguagesTokenSetProvider.SCOPE_ELEMENTS, context, (Ref<Integer>)declarationsBeforeContextRef, declarations);
        int declarationsBeforeContext = (Integer)declarationsBeforeContextRef.get();
        for (int i = 0; i < declarations.size(); ++i) {
            PsiElement declaration = (PsiElement)declarations.get(i < declarationsBeforeContext ? declarationsBeforeContext - i - 1 : i);
            String extractedName = JSStubBasedPsiTreeUtil.extractName(declaration);
            if (name != null && !name.equals(extractedName) || !JSStubBasedPsiTreeUtil.isAcceptableDeclaration(declaration)) continue;
            result2.add((JSElement)declaration);
        }
        List list = result2;
        if (list == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(22);
        }
        return list;
    }

    private static boolean isAcceptableDeclaration(@NotNull PsiElement declaration) {
        if (declaration == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(23);
        }
        if (declaration instanceof JSDefinitionExpression) {
            JSDefinitionExpression definitionExpression = (JSDefinitionExpression)declaration;
            return definitionExpression.getNamespace() == null;
        }
        if (declaration instanceof ES6ImportExportSpecifier) {
            return ((ES6ImportExportSpecifier)declaration).getAlias() == null;
        }
        return declaration instanceof JSNamedElement;
    }

    @Nullable
    private static String extractName(@NotNull PsiElement declaration) {
        if (declaration == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(24);
        }
        if (declaration instanceof JSDefinitionExpression) {
            JSDefinitionExpression definitionExpression = (JSDefinitionExpression)declaration;
            return definitionExpression.getName();
        }
        if (declaration instanceof JSNamedElement) {
            return ((JSNamedElement)declaration).getName();
        }
        if (declaration instanceof ES6ImportExportSpecifier) {
            return ((ES6ImportExportSpecifier)declaration).getDeclaredName();
        }
        return null;
    }

    private static boolean processDeclarationsInScopeAstBased(@NotNull PsiElement context, @NotNull PsiElement scope, @NotNull PsiScopeProcessor processor, @Nullable String name, boolean includeParentScopes) {
        JSTreeUtil.JSScopeDeclarationsAndAssignments definitions;
        if (context == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(25);
        }
        if (scope == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(26);
        }
        if (processor == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(27);
        }
        JSTreeUtil.JSScopeDeclarationsAndAssignments jSScopeDeclarationsAndAssignments = definitions = includeParentScopes ? JSTreeUtil.getDeclarationsAndAssignmentsInScopeAndUp(name, scope.getNode()) : JSTreeUtil.getDeclarationsAndAssignmentsInScope(name, (CompositeElement)scope.getNode());
        if (context.getNode() == null) {
            if (!(context instanceof JSImplicitElement)) {
                Logger.getInstance(JSStubBasedPsiTreeUtil.class).error("Element without node " + context + ", isValid " + context.isValid());
                return true;
            }
            context = context.getParent();
        }
        ASTNode node = context.getNode();
        return definitions == null || node == null || definitions.processFromNearest(node, processor, context != scope);
    }

    @Nullable
    public static PsiElement getContextOfType(@NotNull PsiElement element, @NotNull TokenSet types, boolean strict) {
        StubElement stub;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(28);
        }
        if (types == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(29);
        }
        if (strict && element instanceof PsiFile) {
            return null;
        }
        if (strict) {
            element = element.getContext();
        }
        if (element == null) {
            return null;
        }
        Object object = element instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)element).getStub() : (stub = element instanceof PsiFileImpl ? ((PsiFileImpl)element).getStub() : null);
        if (stub != null) {
            while (stub != null) {
                PsiElement psi = stub.getPsi();
                if (stub instanceof PsiFileStub) {
                    return types.contains((IElementType)((PsiFileStub)stub).getType()) ? psi : null;
                }
                if (types.contains((IElementType)stub.getStubType())) {
                    return psi;
                }
                stub = stub.getParentStub();
            }
        } else {
            ASTNode node = element.getNode();
            while (node != null) {
                if (types.contains(node.getElementType())) {
                    return node.getPsi();
                }
                if (node instanceof FileASTNode) {
                    return null;
                }
                node = TreeUtil.findParent((ASTNode)node, (TokenSet)types);
            }
        }
        return null;
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findDescendants(@NotNull PsiElement element, @NotNull IStubElementType<?, T> elementType) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(30);
        }
        if (elementType == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(31);
        }
        Collection<T> collection = JSStubBasedPsiTreeUtil.findDescendants(element, TokenSet.create((IElementType[])new IElementType[]{elementType}));
        if (collection == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(32);
        }
        return collection;
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findDescendants(@NotNull PsiElement element, @NotNull TokenSet elements) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(33);
        }
        if (elements == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(34);
        }
        Collection<T> collection = JSStubBasedPsiTreeUtil.findDescendants(element, elements, TokenSet.EMPTY);
        if (collection == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(35);
        }
        return collection;
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findDescendants(@NotNull PsiElement element, @NotNull TokenSet elements, @NotNull TokenSet stopAt) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(36);
        }
        if (elements == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(37);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(38);
        }
        ArrayList result2 = new ArrayList();
        JSStubBasedPsiTreeUtil.addDescendantsRecursively(element, elements, stopAt, null, null, result2);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    private static <T extends PsiElement> void addDescendantsRecursively(@NotNull PsiElement container, @NotNull TokenSet targetElements, @NotNull TokenSet stopAt, @Nullable PsiElement context, @Nullable Ref<Integer> outTargetElementsBeforeContext, Collection<T> out) {
        StubElement stub;
        if (container == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(40);
        }
        if (targetElements == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(41);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(42);
        }
        if (!(container instanceof PsiFileImpl || container instanceof StubBasedPsiElementBase || container instanceof LazyParseablePsiElement)) {
            return;
        }
        Object object = container instanceof PsiFileImpl ? ((PsiFileImpl)container).getStub() : (stub = container instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)container).getStub() : null);
        if (stub != null) {
            List stubs = stub.getChildrenStubs();
            for (StubElement child : stubs) {
                IStubElementType type;
                PsiElement psi = child.getPsi();
                if (psi == context && outTargetElementsBeforeContext != null) {
                    outTargetElementsBeforeContext.set((Object)out.size());
                }
                if (targetElements.contains((IElementType)(type = child.getStubType()))) {
                    out.add(psi);
                }
                if (stopAt.contains((IElementType)type)) continue;
                JSStubBasedPsiTreeUtil.addDescendantsRecursively(psi, targetElements, stopAt, context, outTargetElementsBeforeContext, out);
            }
        } else {
            JSStubBasedPsiTreeUtil.addDescendantsRecursively(container.getNode(), targetElements, stopAt, context != null ? context.getNode() : null, outTargetElementsBeforeContext, out);
        }
    }

    private static <T extends PsiElement> void addDescendantsRecursively(@NotNull ASTNode container, @NotNull TokenSet targetElements, @NotNull TokenSet stopAt, @Nullable ASTNode context, @Nullable Ref<Integer> outTargetElementsBeforeContext, Collection<T> out) {
        if (container == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(43);
        }
        if (targetElements == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(44);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(45);
        }
        for (ASTNode child = container.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type;
            if (child == context && outTargetElementsBeforeContext != null) {
                outTargetElementsBeforeContext.set((Object)out.size());
            }
            if (targetElements.contains(type = child.getElementType())) {
                out.add(child.getPsi());
            }
            if (stopAt.contains(type)) continue;
            JSStubBasedPsiTreeUtil.addDescendantsRecursively(child, targetElements, stopAt, context, outTargetElementsBeforeContext, out);
        }
    }

    @Nullable
    public static JSDocComment findDocComment(@NotNull PsiElement element) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(46);
        }
        JSDocComment candidate = null;
        if (!(element instanceof StubBasedPsiElementBase) || ((StubBasedPsiElementBase)element).getStub() == null) {
            PsiComment docComment = JSDocumentationUtils.findDocComment(element);
            if (docComment instanceof JSDocComment) {
                candidate = (JSDocComment)docComment;
            }
        } else if (element instanceof JSDefinitionExpression) {
            PsiElement prevSibling;
            if ((element = element.getContext()) != null && (prevSibling = JSStubBasedPsiTreeUtil.getPrevSibling(element)) instanceof JSDocComment) {
                candidate = (JSDocComment)prevSibling;
            }
        } else {
            candidate = (JSDocComment)((StubBasedPsiElementBase)element).getStubOrPsiChild(JSStubElementTypes.DOC_COMMENT);
        }
        if (candidate != null && JSDocumentationUtils.mayRelateTo(candidate, element)) {
            return candidate;
        }
        return null;
    }

    @Nullable
    public static PsiElement getNextSibling(@NotNull PsiElement element) {
        StubElement stub;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(47);
        }
        if (element instanceof StubBasedPsiElementBase && (stub = ((StubBasedPsiElementBase)element).getStub()) != null) {
            StubElement prevSibling = StubTreeUtil.getNextSibling(stub);
            return prevSibling != null ? prevSibling.getPsi() : null;
        }
        return element.getNextSibling();
    }

    @Nullable
    public static PsiElement getPrevSibling(@NotNull PsiElement element) {
        StubElement stub;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(48);
        }
        if (element instanceof StubBasedPsiElementBase && (stub = ((StubBasedPsiElementBase)element).getStub()) != null) {
            StubElement prevSibling = StubTreeUtil.getPrevSibling(stub);
            return prevSibling != null ? prevSibling.getPsi() : null;
        }
        return element.getPrevSibling();
    }

    @NotNull
    public static <T extends JSExpression> Collection<T> findReturnedExpressions(@NotNull JSFunction function, final Class<? extends T> ... classes) {
        if (function == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(49);
        }
        SmartList result2 = new SmartList();
        if (function.getStub() != null) {
            Collection<JSReturnStatement> returnStatements = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)function, RETURN_STATEMENT_TOKEN_SET, FUNCTIONS_TOKEN_SET);
            for (JSReturnStatement statement : returnStatements) {
                JSReturnStatementStub returnStub = (JSReturnStatementStub)statement.getStub();
                if (returnStub == null) continue;
                List childrenStubs = returnStub.getChildrenStubs();
                for (StubElement childrenStub : childrenStubs) {
                    PsiElement psi = childrenStub.getPsi();
                    if (!PsiTreeUtil.instanceOf((Object)psi, (Class[])classes)) continue;
                    result2.add((JSExpression)psi);
                }
            }
        } else {
            function.acceptChildren((PsiElementVisitor)new JSRecursiveWalkingElementVisitor((List)result2){
                final /* synthetic */ List val$result;
                {
                    this.val$result = list;
                }

                public void visitJSFunctionExpression(JSFunctionExpression node) {
                }

                public void visitJSFunctionDeclaration(JSFunction node) {
                }

                public void visitJSReturnStatement(JSReturnStatement node) {
                    JSExpression expression = node.getExpression();
                    if (PsiTreeUtil.instanceOf((Object)expression, (Class[])classes)) {
                        this.val$result.add(expression);
                    }
                }
            });
        }
        SmartList smartList = result2;
        if (smartList == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(50);
        }
        return smartList;
    }

    @Nullable
    public static PsiElement getStubOrPsiChild(@NotNull StubBasedPsiElementBase element, @NotNull TokenSet filter) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(51);
        }
        if (filter == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(52);
        }
        return JSStubBasedPsiTreeUtil.getStubOrPsiChild(element, filter, TokenSet.EMPTY);
    }

    @Nullable
    public static PsiElement getStubOrPsiChild(@NotNull StubBasedPsiElementBase<?> element, @NotNull TokenSet filter, @NotNull TokenSet stopAt) {
        StubElement stub;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(53);
        }
        if (filter == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(54);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(55);
        }
        if ((stub = element.getStub()) != null) {
            List childrenStubs = stub.getChildrenStubs();
            for (StubElement childStub : childrenStubs) {
                IStubElementType stubType = childStub.getStubType();
                if (filter.contains((IElementType)stubType)) {
                    return childStub.getPsi();
                }
                if (!stopAt.contains((IElementType)stubType)) continue;
                return null;
            }
        } else {
            for (ASTNode child = element.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
                IElementType elementType = child.getElementType();
                if (filter.contains(elementType)) {
                    return child.getPsi();
                }
                if (!stopAt.contains(elementType)) continue;
                return null;
            }
        }
        return null;
    }

    public static PsiElement[] getChildrenByType(JSElement element, TokenSet type) {
        if (element instanceof JSFileImpl || element instanceof JSStubElementImpl) {
            StubElement stub;
            StubElement stubElement = stub = element instanceof JSFileImpl ? ((JSFileImpl)element).getStub() : ((JSStubElementImpl)element).getStub();
            if (stub != null) {
                return stub.getChildrenByType(type, JSElement.ARRAY_FACTORY);
            }
        }
        ASTNode[] children = element.getNode().getChildren(type);
        PsiElement[] result2 = new PsiElement[children.length];
        for (int i = 0; i < children.length; ++i) {
            result2[i] = children[i].getPsi();
        }
        return result2;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(56);
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, null);
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(57);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult, @Nullable Set<PsiElement> visited) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(58);
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, visited, x -> false);
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(59);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult, @Nullable Set<PsiElement> visited, @NotNull Predicate<PsiElement> stopAt) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(60);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(61);
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, visited, stopAt, x -> false);
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(62);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult, @Nullable Set<PsiElement> visited, @NotNull Predicate<PsiElement> stopAt, @NotNull Predicate<PsiElement> stopBefore) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(63);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(64);
        }
        if (stopBefore == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(65);
        }
        if (stopAt.test(resolveResult)) {
            PsiElement psiElement = resolveResult;
            if (psiElement == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(66);
            }
            return psiElement;
        }
        String initializerReference = null;
        Object referencedElement = null;
        boolean referencedViaExportAssignment = false;
        if (resolveResult instanceof JSVariable) {
            PsiReference reference;
            PsiElement parent;
            JSExpression methodExpression;
            JSExpression initializer = ((JSVariable)resolveResult).getInitializerOrStub();
            if (initializer instanceof JSReferenceExpression) {
                PsiElement resolve = ((JSReferenceExpression)initializer).resolve();
                if (resolve != null) {
                    referencedElement = resolve;
                }
            } else if (initializer instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall()) {
                referencedElement = JSStubBasedPsiTreeUtil.getRequireCallReferencedElement((JSCallExpression)initializer);
            } else if (initializer instanceof JSCallExpression && (methodExpression = ((JSCallExpression)initializer).getStubSafeMethodExpression()) instanceof JSFunctionExpression) {
                Collection returnedExpressions = JSStubBasedPsiTreeUtil.findReturnedExpressions((JSFunction)((JSFunctionExpression)methodExpression), JSFunctionExpression.class);
                referencedElement = (PsiElement)ContainerUtil.getFirstItem(returnedExpressions);
            }
            String initializerText = ((JSVariable)resolveResult).getLiteralOrReferenceInitializerText();
            if (initializerText != null && JSSymbolUtil.isValidPropertyName(initializerText)) {
                initializerReference = initializerText;
            }
            if ((parent = resolveResult.getParent()) instanceof JSDestructuringProperty && referencedElement == null && (reference = parent.getReference()) instanceof JSDestructuringPropertyReference) {
                referencedElement = reference.resolve();
            }
        } else if (resolveResult instanceof JSProperty) {
            initializerReference = ((JSProperty)resolveResult).getInitializerReference();
        } else if (resolveResult instanceof JSDefinitionExpression) {
            initializerReference = ((JSDefinitionExpression)resolveResult).getInitializerReference();
        } else if (resolveResult instanceof TypeScriptImportStatement) {
            Collection referencedElements = ((TypeScriptImportStatement)resolveResult).findReferencedElements();
            if (referencedElements.size() == 1) {
                referencedElement = (PsiElement)ContainerUtil.getFirstItem((Collection)referencedElements);
            }
        } else if (resolveResult instanceof ES6ImportExportSpecifierAlias) {
            referencedElement = ((ES6ImportExportSpecifierAlias)resolveResult).findAliasedElement();
        } else if (resolveResult instanceof ES6ImportedExportedDefaultBinding) {
            PsiElement firstItem;
            Collection elements = ((ES6ImportedExportedDefaultBinding)resolveResult).findReferencedElements();
            referencedElement = elements.size() == 1 ? ((firstItem = (PsiElement)ContainerUtil.getFirstItem((Collection)elements)) == null ? null : JSStubBasedPsiTreeUtil.calculateMeaningfulElement(firstItem)) : null;
        } else if (resolveResult instanceof JSExportAssignment) {
            initializerReference = ((JSExportAssignment)resolveResult).getInitializerReference();
            if (initializerReference == null) {
                referencedElement = ((JSExportAssignment)resolveResult).getStubSafeElement();
            }
            referencedViaExportAssignment = true;
        }
        if (initializerReference != null && referencedElement == null) {
            referencedElement = JSStubBasedPsiTreeUtil.resolveLocally(initializerReference, resolveResult);
            if (referencedViaExportAssignment && referencedElement instanceof TypeScriptFunction && TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)referencedElement).size() > 1) {
                referencedElement = null;
            }
        }
        if (referencedElement != null && !stopBefore.test((PsiElement)referencedElement)) {
            if (visited == null) {
                visited = new THashSet();
            }
            if (visited.add((PsiElement)resolveResult)) {
                referencedElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(referencedElement, (Set<PsiElement>)visited);
            }
            PsiElement psiElement = referencedElement;
            if (psiElement == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(67);
            }
            return psiElement;
        }
        PsiElement psiElement = resolveResult;
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(68);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement calculateTargetElement(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(69);
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, null, IS_TARGET);
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(70);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement calculateTargetElementForHighlighting(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(71);
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, null, SEMANTIC_HIGHLIGHTING_STOP_AT, SEMANTIC_HIGHLIGHTING_STOP_BEFORE);
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(72);
        }
        return psiElement;
    }

    private static PsiElement getRequireCallReferencedElement(JSCallExpression initializer) {
        Collection<JSFile> files;
        String referencePath;
        JSPsiElementBase referencedElement = null;
        JSLiteralExpression argument = JSStubBasedPsiTreeUtil.findRequireCallArgument(initializer);
        String string = referencePath = argument != null ? argument.getSignificantValue() : null;
        if (referencePath != null && (files = CommonJSUtil.resolveReferencedElements((PsiElement)initializer, StringUtil.unquoteString((String)referencePath))).size() == 1) {
            JSFile file = files.iterator().next();
            JSPsiElementBase exportedElement = JSResolveUtil.getExportedElement(file);
            referencedElement = exportedElement != null ? exportedElement : file;
        }
        return referencedElement;
    }

    @Nullable
    public static JSLiteralExpression findRequireCallArgument(@NotNull JSCallExpression callExpression) {
        Collection<JSLiteralExpression> expressions;
        if (callExpression == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(73);
        }
        return (expressions = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)callExpression, JSStubElementTypes.LITERAL_EXPRESSION)).size() == 1 ? expressions.iterator().next() : null;
    }

    @Nullable
    public static PsiElement findAssociatedElement(@NotNull JSDocComment psiComment) {
        if (psiComment == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(74);
        }
        PsiElement parent = psiComment.getContext();
        PsiElement next = null;
        if (parent instanceof JSProperty || parent instanceof JSFunction || parent instanceof JSVariable) {
            next = parent;
        } else if (parent instanceof JSVarStatement) {
            JSVariable[] variables = ((JSVarStatement)parent).getStubSafeVariables();
            if (variables.length > 0) {
                next = variables[0];
            }
        } else {
            JSDocComment nextDoc;
            next = JSStubBasedPsiTreeUtil.getNextSibling((PsiElement)psiComment);
            while (next instanceof PsiWhiteSpace) {
                next = JSStubBasedPsiTreeUtil.getNextSibling(next);
            }
            if (next != null && (nextDoc = JSStubBasedPsiTreeUtil.findDocComment(next)) != null && nextDoc != psiComment) {
                next = null;
            }
        }
        return next;
    }

    @Nullable
    public static JSExpression findStubSafeChildExpression(StubBasedPsiElementBase<?> element) {
        StubElement stub = element.getStub();
        if (stub != null) {
            StubElement expressionStub = StubTreeUtil.findChildStubByType(stub, JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
            return expressionStub != null ? (JSExpression)expressionStub.getPsi() : null;
        }
        ASTNode exprNode = element.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
        return exprNode != null ? (JSExpression)exprNode.getPsi() : null;
    }

    public static Stream<? extends PsiElement> getFileOrModuleChildrenStream(@NotNull PsiElement fileOrModule) {
        if (fileOrModule == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(75);
        }
        return JSStubBasedPsiTreeUtil.getFilteredFileOrModuleChildrenStream(fileOrModule, null, null);
    }

    @NotNull
    public static Stream<? extends PsiElement> getFilteredFileOrModuleChildrenStream(@NotNull PsiElement fileOrModule, @Nullable JSStubElementType stubSearchFilter, @Nullable Class<? extends PsiElement> psiSearchFilter) {
        if (fileOrModule == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(76);
        }
        StubElement stub = null;
        if (fileOrModule instanceof PsiFileImpl) {
            stub = ((PsiFileImpl)fileOrModule).getGreenStub();
        } else if (fileOrModule instanceof JSStubElementImpl) {
            stub = ((JSStubElementImpl)fileOrModule).getGreenStub();
        }
        if (stub != null) {
            Stream<PsiElement> stream = stub.getChildrenStubs().stream().filter(el -> stubSearchFilter == null || el.getStubType() == stubSearchFilter).map(childStub -> childStub.getPsi());
            if (stream == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(77);
            }
            return stream;
        }
        JBIterable iterable = SyntaxTraverser.psiTraverser().children((Object)fileOrModule);
        if (psiSearchFilter != null) {
            iterable = iterable.filter(psiSearchFilter);
        }
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterable.iterator(), 16);
        Stream stream = StreamSupport.stream(spliterator, false);
        if (stream == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(78);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 22: 
            case 32: 
            case 35: 
            case 39: 
            case 50: 
            case 57: 
            case 59: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 77: 
            case 78: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 22: 
            case 32: 
            case 35: 
            case 39: 
            case 50: 
            case 57: 
            case 59: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 77: 
            case 78: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 22: 
            case 32: 
            case 35: 
            case 39: 
            case 50: 
            case 57: 
            case 59: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil";
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 28: 
            case 30: 
            case 33: 
            case 36: 
            case 46: 
            case 47: 
            case 48: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 38: 
            case 42: 
            case 45: 
            case 55: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElements";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 56: 
            case 58: 
            case 60: 
            case 63: 
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopBefore";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiComment";
                break;
            }
            case 75: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocallyWithMergedResults";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildStubBasedNamesMap";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsInStubScopeWithContext";
                break;
            }
            case 32: 
            case 35: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "findDescendants";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "findReturnedExpressions";
                break;
            }
            case 57: 
            case 59: 
            case 62: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMeaningfulElement";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateTargetElement";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateTargetElementForHighlighting";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredFileOrModuleChildrenStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocally";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocallyWithMergedResults";
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 22: 
            case 32: 
            case 35: 
            case 39: 
            case 50: 
            case 57: 
            case 59: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 77: 
            case 78: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasStub";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInScopeStubBased";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildStubBasedNamesMap";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findElementsInStubScopeWithContext";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableDeclaration";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "extractName";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInScopeAstBased";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getContextOfType";
                break;
            }
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findDescendants";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addDescendantsRecursively";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getNextSibling";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSibling";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findReturnedExpressions";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiChild";
                break;
            }
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "calculateMeaningfulElement";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "calculateTargetElement";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "calculateTargetElementForHighlighting";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "findRequireCallArgument";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "findAssociatedElement";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getFileOrModuleChildrenStream";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredFileOrModuleChildrenStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 22: 
            case 32: 
            case 35: 
            case 39: 
            case 50: 
            case 57: 
            case 59: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 77: 
            case 78: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

