/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.BasicJavascriptNamesValidator;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.util.ProcessingContext;
import com.sixrr.inspectjs.validity.ReservedWordUsedAsNameJSInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMemberInputValidator
implements RenameInputValidator {
    private static final ElementPattern<JSNamedElement> ourClassMemberPattern = PlatformPatterns.psiElement(JSNamedElement.class).with((PatternCondition)new PatternCondition<JSNamedElement>("class member"){

        public boolean accepts(@NotNull JSNamedElement element, ProcessingContext context) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            return JSUtils.getMemberContainingClass((PsiElement)element) != null || element instanceof TypeScriptTypeMember;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JSMemberInputValidator$1", "accepts"));
        }
    });
    private static ElementPattern<JSDefinitionExpression> ourDefinitionExpressionPattern = PlatformPatterns.psiElement(JSDefinitionExpression.class);
    private static final ElementPattern<JSProperty> ourPropertyPattern = PlatformPatterns.psiElement(JSProperty.class);

    @NotNull
    public ElementPattern<? extends PsiElement> getPattern() {
        ElementPattern elementPattern = StandardPatterns.or((ElementPattern[])new ElementPattern[]{ourPropertyPattern, ourClassMemberPattern, ourDefinitionExpressionPattern});
        if (elementPattern == null) {
            JSMemberInputValidator.$$$reportNull$$$0(0);
        }
        return elementPattern;
    }

    public boolean isInputValid(@NotNull String newName, @NotNull PsiElement psiElement, @NotNull ProcessingContext context) {
        if (newName == null) {
            JSMemberInputValidator.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            JSMemberInputValidator.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JSMemberInputValidator.$$$reportNull$$$0(3);
        }
        if (psiElement instanceof JSDefinitionExpression) {
            JSExpression expression = ((JSDefinitionExpression)psiElement).getExpression();
            if (expression instanceof JSIndexedPropertyAccessExpression) {
                return true;
            }
            return JSMemberInputValidator.isValidPropertyName(newName, psiElement);
        }
        if (psiElement instanceof JSProperty) {
            IElementType currentElementType = JSMemberInputValidator.getIdentifierElementType((JSNamedElement)((JSProperty)psiElement));
            if (JSTokenTypes.STRING_LITERALS.contains(currentElementType)) {
                return true;
            }
            return JSMemberInputValidator.isValidPropertyName(newName, psiElement);
        }
        if (psiElement instanceof JSNamedElement) {
            return JSMemberInputValidator.handleNamedElement(newName, (JSNamedElement)psiElement);
        }
        return false;
    }

    private static boolean isValidPropertyName(@NotNull String newName, @NotNull PsiElement psiElement) {
        if (newName == null) {
            JSMemberInputValidator.$$$reportNull$$$0(4);
        }
        if (psiElement == null) {
            JSMemberInputValidator.$$$reportNull$$$0(5);
        }
        return ReservedWordUsedAsNameJSInspection.dialectIsES5OrAbove(psiElement) ? BasicJavascriptNamesValidator.isIdentifierName(newName) : ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(psiElement.getLanguage())).isIdentifier(newName, psiElement.getProject());
    }

    private static boolean handleNamedElement(@NotNull String newName, @NotNull JSNamedElement namedElement) {
        IElementType currentElementType;
        if (newName == null) {
            JSMemberInputValidator.$$$reportNull$$$0(6);
        }
        if (namedElement == null) {
            JSMemberInputValidator.$$$reportNull$$$0(7);
        }
        if (JSTokenTypes.STRING_LITERALS.contains(currentElementType = JSMemberInputValidator.getIdentifierElementType(namedElement))) {
            return true;
        }
        return BasicJavascriptNamesValidator.isIdentifierName(newName);
    }

    @Nullable
    private static IElementType getIdentifierElementType(@NotNull JSNamedElement namedElement) {
        PsiElement identifierPsi;
        if (namedElement == null) {
            JSMemberInputValidator.$$$reportNull$$$0(8);
        }
        identifierPsi = (identifierPsi = namedElement.getNameIdentifier()) instanceof JSReferenceExpression ? ((JSReferenceExpression)identifierPsi).getReferenceNameElement() : identifierPsi;
        return identifierPsi != null ? identifierPsi.getNode().getElementType() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/JSMemberInputValidator";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSMemberInputValidator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInputValid";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidPropertyName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleNamedElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifierElementType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

