/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class JSSuggestionProvider
implements NameSuggestionProvider {
    public SuggestedNameInfo getSuggestedNames(PsiElement element, @Nullable PsiElement nameSuggestionContext, Set<String> result2) {
        ASTNode nameIdentifier;
        if (element instanceof JSVariable && (nameIdentifier = ((JSVariable)element).findNameIdentifier()) != null) {
            PsiElement nameElement = nameIdentifier.getPsi();
            if (nameElement instanceof JSExpression) {
                boolean transformToFieldName = JSResolveUtil.findParent(element) instanceof JSClass;
                Project project = element.getProject();
                for (String s : BasicIntroducedEntityInfoProvider.generateVariableNamesFromExpression((JSExpression)nameElement, nameSuggestionContext, Collections.emptyList())) {
                    if (transformToFieldName) {
                        s = JSRefactoringUtil.transformAccessorNameToPropertyName(s, project);
                    }
                    result2.add(s);
                }
            } else {
                JSType type = ((JSVariable)element).getType();
                if (type != null) {
                    PsiElement typeElement = ((JSVariable)element).getTypeElement();
                    if (typeElement instanceof JSReferenceExpression) {
                        result2.addAll(BasicIntroducedEntityInfoProvider.generateVariableNamesFromExpression((JSExpression)typeElement, nameSuggestionContext, result2));
                    } else if (nameSuggestionContext != null) {
                        result2.addAll(BasicIntroducedEntityInfoProvider.generateVariableNamesFromType(type, nameSuggestionContext, Collections.emptyList()));
                    }
                }
            }
        }
        return null;
    }
}

