/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractSuper;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.BaseJSRefactoringHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExtractSuperClassHandler
extends BaseJSRefactoringHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"extract.superclass.title");
    private static final String CANNOT_REFACTOR_REASON = RefactoringBundle.message((String)"error.wrong.caret.position.class");
    private final BiFunction<JSClass, JSElement, RefactoringDialog> myDialogFactory;

    public JSExtractSuperClassHandler(BiFunction<JSClass, JSElement, RefactoringDialog> dialogFactory) {
        super(REFACTORING_NAME, CANNOT_REFACTOR_REASON);
        this.myDialogFactory = dialogFactory;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            JSExtractSuperClassHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            JSExtractSuperClassHandler.$$$reportNull$$$0(1);
        }
        if (elements.length != 1) {
            return;
        }
        PsiElement element = elements[0];
        JSClass aClass = JSExtractSuperClassHandler.getClass(element);
        if (aClass != null) {
            if (aClass.isInterface()) {
                JSExtractSuperClassHandler.showErrorHint(project, dataContext, RefactoringBundle.message((String)"superclass.cannot.be.extracted.from.an.interface"));
            } else if (aClass instanceof TypeScriptTypeAlias) {
                JSExtractSuperClassHandler.showErrorHint(project, dataContext, JSBundle.message((String)"superclass.cannot.be.extracted.from.type.alias", (Object[])new Object[0]));
            } else if (aClass instanceof XmlBackedJSClassImpl) {
                JSExtractSuperClassHandler.showErrorHint(project, dataContext, JSBundle.message((String)"superclass.cannot.be.extracted.from.mxml.component", (Object[])new Object[0]));
            } else {
                JSElement selected = element instanceof JSElement ? (JSElement)element : null;
                RefactoringDialog dialog = this.myDialogFactory.apply(aClass, selected);
                dialog.show();
            }
        } else {
            JSExtractSuperClassHandler.showErrorHint(project, null, RefactoringBundle.message((String)"superclass.cannot.be.extracted.from.an.interface"));
        }
    }

    private static void showErrorHint(@NotNull Project project, @Nullable DataContext data, String message) {
        if (project == null) {
            JSExtractSuperClassHandler.$$$reportNull$$$0(2);
        }
        Editor editor = data != null ? (Editor)CommonDataKeys.EDITOR.getData(data) : null;
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractSuperClassHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

