/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.JSInsertThisFix;
import com.intellij.lang.javascript.inspections.JSDeclarationsAtScopeStartInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionHandler;
import com.intellij.lang.javascript.refactoring.extractMethod.JSScopeSelectionUI;
import com.intellij.lang.javascript.refactoring.extractMethod.JSSignatureContext;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionActionBase;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.lang.typescript.refactoring.extractMethod.TypeScriptExtractFunctionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateJSFunctionIntentionAction
extends CreateJSFunctionIntentionActionBase {
    private final boolean myIsMethod;
    private final String myFunctionName;
    private boolean myIsProperty;
    private static final String ourJSImplementedMethodBodyTemplate = "JavaScript Implemented Method Body.js";
    private static final String ATTRIBUTE_IS_ASSIGNMENT_TARGET = "IS_ASSIGNMENT_TARGET";
    private static final String ATTRIBUTE_IS_NEW_CALL = "IS_NEW_CALL";
    private static final String ATTRIBUTE_HAS_EXPECTED_TYPE = "HAS_EXPECTED_TYPE";

    public CreateJSFunctionIntentionAction(String name, boolean isMethod) {
        super(name, isMethod ? "javascript.create.method.intention.name" : "javascript.create.function.intention.name");
        this.myFunctionName = name;
        this.myIsMethod = isMethod;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        this.applyFixWithScopeSelection(project, psiElement, file, editor, ApplicationManager.getApplication().isUnitTestMode() ? (defaultSuggestedScope, scopeList, cb) -> cb.pass((Object)CreateJSFunctionIntentionAction.chooseIntroductionScopeForTest(psiElement, scopeList)) : new JSExtractFunctionHandler.ScopeSelectionPopup(editor));
    }

    public void applyFixWithScopeSelection(Project project, final PsiElement psiElement, PsiFile file, Editor editor, JSScopeSelectionUI scopeSelectionUi) {
        if (psiElement == null) {
            return;
        }
        JSExtractFunctionHandler extractFunctionHandler = DialectDetector.isTypeScript(psiElement) ? new TypeScriptExtractFunctionHandler() : new JSExtractFunctionHandler();
        JSReferenceExpression referenceExpression = (JSReferenceExpression)this.calculateAnchors((PsiElement)psiElement).first;
        if (CreateJSFunctionIntentionAction.getClassFromReferenceExpression(referenceExpression) != null) {
            this.doApplyFix(project, psiElement, file, editor);
            return;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)referenceExpression);
        List scopes = extractFunctionHandler.findBases(psiElement);
        if (dialect != null && JSClassUtils.isES6ClassImplementation(dialect) && referenceExpression.getQualifier() == null) {
            scopes = ContainerUtil.filter(scopes, scope -> scope.isClassContext() == this.myIsMethod);
        }
        final List finalScopes = scopes;
        final boolean isActionScript = dialect != null && dialect.isECMA4;
        JSSignatureContext context = new JSSignatureContext(){

            @Override
            public boolean isActionScript() {
                return isActionScript;
            }

            @Override
            public boolean isAsync() {
                return false;
            }

            @Override
            public PsiElement getAnchor() {
                return psiElement;
            }

            @Override
            @NotNull
            public List<JSExtractFunctionHandler.IntroductionScope> getIntroductionScopes() {
                List list = finalScopes;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionAction$1", "getIntroductionScopes"));
            }
        };
        Consumer callback = scope -> {
            if (scope.isClassContext()) {
                this.doApplyFix(project, psiElement, file, editor);
            } else {
                this.myIsProperty = scope.getParent() instanceof JSObjectLiteralExpression;
                boolean placeAtScopeStart = JSDeclarationsAtScopeStartInspection.isEnabledForElement(psiElement);
                PsiElement anchor = JSUtils.findFunctionAnchor(scope.getParent(), psiElement, placeAtScopeStart);
                anchor = JSPsiImplUtils.findLeadingCommentOrSelf(anchor);
                this.doApplyFix(project, psiElement, file, editor, anchor, scope.getParent());
            }
        };
        extractFunctionHandler.chooseIntroductionScope(context, (Consumer<JSExtractFunctionHandler.IntroductionScope>)callback, scopeSelectionUi, this.myFunctionName);
    }

    private static JSExtractFunctionHandler.IntroductionScope chooseIntroductionScopeForTest(@NotNull PsiElement usageElement, @NotNull List<JSScopeSelectionUI.ScopePresentation> presentations) {
        List scopes;
        if (usageElement == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(0);
        }
        if (presentations == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(1);
        }
        if ((scopes = ContainerUtil.map(presentations, presentation -> presentation.getScope())).isEmpty()) {
            throw new RuntimeException("No available scopes");
        }
        if (scopes.size() == 1) {
            return (JSExtractFunctionHandler.IntroductionScope)scopes.get(0);
        }
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)usageElement, JSStatement.class, (boolean)false);
        if (statement == null) {
            throw new RuntimeException("Could not find statement from usage");
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)statement);
        if (docComment instanceof JSDocComment) {
            String scopePresentation = docComment.getText().substring(3, docComment.getTextLength() - 2).trim();
            for (JSExtractFunctionHandler.IntroductionScope scope : scopes) {
                if (!scopePresentation.equals(scope.toString())) continue;
                return scope;
            }
            throw new RuntimeException("Scope with name " + scopePresentation + " not found");
        }
        return (JSExtractFunctionHandler.IntroductionScope)scopes.get(scopes.size() - 1);
    }

    @Nullable
    private static PsiElement getClassFromReferenceExpression(JSReferenceExpression referenceExpression) {
        if (referenceExpression == null || !JSClassUtils.canHaveClasses((PsiElement)referenceExpression)) {
            return null;
        }
        if (referenceExpression.getQualifier() != null) {
            return CreateJSFunctionIntentionAction.getType(referenceExpression.getQualifier(), referenceExpression.getContainingFile());
        }
        return null;
    }

    @Override
    protected void writeFunctionAndName(Template template, String createdMethodName, PsiFile file, PsiElement clazz, JSReferenceExpression referenceExpression) {
        if (this.myIsProperty) {
            createdMethodName = createdMethodName.substring(createdMethodName.lastIndexOf(".") + 1);
            template.addTextSegment(createdMethodName);
            template.addTextSegment(": function ");
            return;
        }
        if (clazz != null) {
            if (createdMethodName.indexOf(46) != -1) {
                createdMethodName = createdMethodName.substring(createdMethodName.lastIndexOf(".") + 1);
            }
            template.addTextSegment(JSClassUtils.createClassFunctionName(createdMethodName, (PsiElement)file));
            return;
        }
        if (DialectDetector.isActionScript((PsiElement)file) || DialectDetector.isTypeScript((PsiElement)file) && referenceExpression.getQualifier() == null || !this.myIsMethod) {
            template.addTextSegment("function ");
            template.addTextSegment(createdMethodName);
            return;
        }
        int indexOfDot = createdMethodName.lastIndexOf(46);
        if (indexOfDot > 0 && referenceExpression.getContainingFile() != file) {
            template.addTextSegment("export function ");
            template.addTextSegment(createdMethodName.substring(indexOfDot + 1));
            return;
        }
        if (indexOfDot == -1) {
            template.addTextSegment(JSChangeUtil.getVariablePrefix((PsiElement)file) + " ");
        }
        template.addTextSegment(createdMethodName);
        template.addTextSegment(" = function ");
    }

    @Override
    protected void addSemicolonSegment(Template template, PsiFile file) {
        if (this.myIsProperty) {
            template.addTextSegment(",");
        } else {
            super.addSemicolonSegment(template, file);
        }
    }

    @Override
    protected void addParameters(Template template, JSReferenceExpression referenceExpression, PsiFile file) {
        PsiElement element = referenceExpression.getParent();
        JSArgumentList list = element instanceof JSCallExpression ? ((JSCallExpression)element).getArgumentList() : null;
        CreateJSFunctionIntentionAction.addParameters(template, list, (PsiElement)referenceExpression, file);
    }

    public static void addParameters(Template template, @Nullable JSArgumentList list, PsiElement context, PsiFile file) {
        JSExpression[] expressions = list != null ? list.getArguments() : JSExpression.EMPTY_ARRAY;
        int paramCount = expressions.length;
        THashSet usedParameterNames = new THashSet();
        for (int i = 0; i < paramCount; ++i) {
            String typeName;
            JSExpression passedParameterValue;
            String var;
            if (i != 0) {
                template.addTextSegment(", ");
            }
            if ((var = (passedParameterValue = expressions[i]) instanceof JSReferenceExpression ? ((JSReferenceExpression)passedParameterValue).getReferenceName() : BasicIntroducedEntityInfoProvider.generateVariableNamesFromExpression(passedParameterValue, context)) == null || var.length() == 0) {
                var = "param" + (i != 0 ? Integer.toString(i + 1) : "");
            } else {
                String baseName = var;
                int j = 2;
                while (usedParameterNames.contains(var)) {
                    var = baseName + j;
                    ++j;
                }
                usedParameterNames.add(var);
            }
            BaseCreateFix.MyExpression expression = new BaseCreateFix.MyExpression(var);
            template.addVariable(var, (Expression)expression, (Expression)expression, true);
            DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)file);
            if (holder == null || !holder.isTypeScript && !holder.isECMA4) continue;
            JSType type = JSResolveUtil.getExpressionJSType(passedParameterValue);
            String string = typeName = type == null ? null : CreateJSFunctionIntentionAction.getTypeText(type);
            if ((typeName == null || "null".equals(typeName)) && holder.isTypeScript) continue;
            template.addTextSegment(":");
            CreateJSFunctionIntentionAction.addTypeVariable(template, var, context, typeName);
        }
    }

    @Override
    protected void addReturnType(Template template, JSReferenceExpression referenceExpression, PsiFile file) {
        this.guessTypeAndAddTemplateVariable(template, (JSExpression)referenceExpression, file, true);
    }

    @Override
    protected JSReferenceExpression beforeStartTemplateAction(JSReferenceExpression referenceExpression, Editor editor, @Nullable PsiElement anchor, boolean isStaticContext) {
        JSReferenceExpression superRefExpression = super.beforeStartTemplateAction(referenceExpression, editor, anchor, isStaticContext);
        if (superRefExpression == null) {
            return null;
        }
        if (CreateJSFunctionIntentionAction.shouldInsertQualifier(anchor, superRefExpression)) {
            String name;
            JSClass contextClass = JSUtils.getMemberContainingClass(anchor);
            String qualifier = "this";
            if (contextClass != null && isStaticContext && (name = contextClass.getName()) != null) {
                qualifier = name;
            }
            return (JSReferenceExpression)JSInsertThisFix.insertQualifier((JSExpression)superRefExpression, editor, qualifier);
        }
        return superRefExpression;
    }

    private static boolean shouldInsertQualifier(@Nullable PsiElement anchor, JSReferenceExpression superRefExpression) {
        return !DialectDetector.isActionScript((PsiElement)superRefExpression) && superRefExpression.getQualifier() == null && anchor != null && null != JSUtils.getMemberContainingClass(anchor);
    }

    @Override
    protected void addBody(Template template, JSReferenceExpression refExpr, PsiFile file) {
        template.addTextSegment("\n");
        template.addSelectionStartVariable();
        this.appendFunctionBody(template, refExpr, file);
        template.addSelectionEndVariable();
        template.addEndVariable();
        template.addTextSegment("\n");
    }

    protected void appendFunctionBody(Template template, JSReferenceExpression refExpr, PsiFile file) {
        PsiElement parent = refExpr.getParent();
        JSType expectedType = parent instanceof JSCallExpression ? JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parent) : null;
        String methodName = refExpr.getReferenceName();
        assert (methodName != null);
        if (DialectDetector.isTypeScript((PsiElement)file)) {
            StringBuilder builder = new StringBuilder();
            TypeScriptImplementMemberUtil.appendDefaultMethodBody((PsiElement)refExpr, expectedType, builder, methodName);
            template.addTextSegment(builder.toString());
        } else {
            CreateJSFunctionIntentionAction.buildImplementedFunctionBody(template, refExpr.getParent() instanceof JSNewExpression, file.getProject(), CreateJSFunctionIntentionAction.isAssignmentTarget(parent, expectedType), expectedType, methodName);
        }
    }

    private static void buildImplementedFunctionBody(@NotNull Template template, boolean isNewCall, @NotNull Project project, boolean isAssignmentTarget, @Nullable JSType expectedType, @NotNull String methodName) {
        if (template == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(3);
        }
        if (methodName == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(4);
        }
        template.addTextSegment(CreateJSFunctionIntentionAction.getImplementedFunctionBodyText(isNewCall, project, isAssignmentTarget, expectedType, methodName));
    }

    @NotNull
    public static String getImplementedFunctionBodyText(boolean isNewCall, @NotNull Project project, boolean isAssignmentTarget, @Nullable JSType expectedType, @NotNull String methodName) {
        String defaultValue;
        if (project == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(5);
        }
        if (methodName == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(6);
        }
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getCodeTemplate(ourJSImplementedMethodBodyTemplate);
        Properties properties = new Properties();
        properties.setProperty(ATTRIBUTE_HAS_EXPECTED_TYPE, String.valueOf(expectedType != null && !(expectedType instanceof JSVoidType)));
        properties.setProperty(ATTRIBUTE_IS_NEW_CALL, String.valueOf(isNewCall));
        properties.setProperty(ATTRIBUTE_IS_ASSIGNMENT_TARGET, String.valueOf(isAssignmentTarget));
        String string = defaultValue = expectedType != null ? JSTypeUtils.defaultValueOfType(expectedType) : null;
        if (defaultValue == null) {
            defaultValue = "undefined";
        }
        properties.setProperty("DEFAULT_RETURN_VALUE", defaultValue);
        properties.setProperty("METHOD_NAME", methodName);
        String string2 = TypeScriptImplementMemberUtil.getBodyTextFromTemplate(fileTemplate, properties);
        if (string2 == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(7);
        }
        return string2;
    }

    private static boolean isAssignmentTarget(PsiElement parent, JSType expectedType) {
        PsiElement parentParent = parent == null ? null : parent.getParent();
        return expectedType != null || parentParent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parentParent).getROperand() == parent || parentParent instanceof JSVariable && ((JSVariable)parentParent).getInitializer() == parent || parentParent instanceof JSReturnStatement || parentParent instanceof JSArgumentList;
    }

    @Override
    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, PsiFile file, PsiElement anchorParent) {
        super.buildTemplate(template, referenceExpression, staticContext, file, anchorParent);
        if (this.myIsMethod && !JSClassUtils.canHaveClasses((PsiElement)file)) {
            this.addSemicolonSegment(template, file);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentations";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementedFunctionBodyText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "chooseIntroductionScopeForTest";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildImplementedFunctionBody";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getImplementedFunctionBodyText";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

