/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSSmartCompletionContributor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.completion.TypeScriptSameSignatureCallParametersContributor;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptSmartCompletionContributor
extends JSSmartCompletionContributor {
    private static List<LookupElement> mergeVariants(@Nullable List<LookupElement> completionVariants, @Nullable List<LookupElement> extraVariants) {
        if (extraVariants == null) {
            return completionVariants;
        }
        if (completionVariants == null) {
            return extraVariants;
        }
        extraVariants.addAll(completionVariants);
        return extraVariants;
    }

    @Override
    @Nullable
    public List<?> getSmartCompletionVariants(@NotNull JSReferenceExpression location) {
        List<Object> variants;
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(0);
        }
        if (location.getQualifier() == null && !JSResolveUtil.isExprInStrictTypeContext(location) && !(variants = this.addVariantsForUnqualifiedReference(location)).isEmpty()) {
            return variants;
        }
        return TypeScriptSmartCompletionContributor.mergeVariants(TypeScriptSmartCompletionContributor.getVariantForDynamicallyNamedProperties(location), TypeScriptSmartCompletionContributor.mergeVariants(super.getSmartCompletionVariants(location), TypeScriptSameSignatureCallParametersContributor.getSameSignatureCallItems(location)));
    }

    @Nullable
    private static List<LookupElement> getVariantForDynamicallyNamedProperties(@NotNull JSReferenceExpression location) {
        JSExpression qualifier;
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((qualifier = location.getQualifier()) == null) {
            return null;
        }
        JSType type = JSResolveUtil.getExpressionJSType(qualifier);
        if (type == null) {
            return null;
        }
        ArrayList results = ContainerUtil.newArrayList();
        TypeScriptLiteralKeyUtil.evalForAllProperties(type, (o, element, nestingDepth) -> {
            TypeScriptSmartCompletionContributor.addVariantIfComputedProp(o, results, nestingDepth);
            return false;
        }, true);
        return results.size() == 0 ? null : results;
    }

    private static void addVariantIfComputedProp(@Nullable Object member, @NotNull List<LookupElement> results, int nestingDepth) {
        if (results == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(2);
        }
        if (!(member instanceof ES6Property) && !(member instanceof JSField)) {
            return;
        }
        ES6ComputedName computedPropertyName = ((JSComputedPropertyNameOwner)member).getComputedPropertyName();
        if (computedPropertyName == null) {
            return;
        }
        JSType expressionJSType = TypeScriptLiteralKeyUtil.getTypeForComputedPropExpression(computedPropertyName);
        if (expressionJSType instanceof JSStringLiteralTypeImpl) {
            String literal = ((JSStringLiteralTypeImpl)expressionJSType).getLiteral();
            results.add(JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)member, literal, JSLookupPriority.getNestingLevelPriority(nestingDepth), true, false));
        }
    }

    @Override
    protected void processSingleLiteralVariant(@NotNull JSExpression location, boolean insideStringLiteral, @NotNull List<LookupElement> literalVariants, JSType type) {
        String enumFieldName;
        TypeScriptEnumField field;
        TypeScriptEnum typeScriptEnum;
        JSResolvedTypeInfo resolvedType;
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(3);
        }
        if (literalVariants == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(4);
        }
        super.processSingleLiteralVariant(location, insideStringLiteral, literalVariants, type);
        if (insideStringLiteral) {
            return;
        }
        if (type instanceof JSResolvableType && type.isTypeScript() && (resolvedType = ((JSResolvableType)type).resolveType()) != null && resolvedType.isEnumLiteral() && (typeScriptEnum = (TypeScriptEnum)JSUtils.getMemberContainingClass((PsiElement)(field = resolvedType.getDeclarationOfType(TypeScriptEnumField.class)))) != null && (enumFieldName = TypeScriptSmartCompletionContributor.getEnumFieldName(typeScriptEnum, field.getName(), location)) != null) {
            LookupElement prioritizedLookupItem = JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)field, enumFieldName, JSLookupPriority.SMART_PRIORITY, false, false);
            literalVariants.add(prioritizedLookupItem);
        }
        if (location instanceof JSReferenceExpression && JSTypeUtils.isEnumType(type)) {
            Collection<? extends PsiElement> resolvedElements = TypeScriptTypeParser.resolveElementsByType(type);
            for (PsiElement psiElement : resolvedElements) {
                JSField[] fields;
                if (!(psiElement instanceof TypeScriptEnum)) continue;
                for (JSField field2 : fields = ((TypeScriptEnum)psiElement).getFields()) {
                    String fieldName = field2.getName();
                    String enumFieldName2 = TypeScriptSmartCompletionContributor.getEnumFieldName((TypeScriptEnum)psiElement, fieldName, location);
                    if (enumFieldName2 == null) continue;
                    literalVariants.add(JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)field2, enumFieldName2, JSLookupPriority.SMART_PRIORITY, true, false));
                }
            }
        }
    }

    @Nullable
    private static String getEnumFieldName(TypeScriptEnum element, String fieldName, JSExpression location) {
        String qualifiedName = element.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        JSType type = JSNamedType.createType(qualifiedName, JSTypeSourceFactory.createTypeSource((PsiElement)element), JSTypeContext.INSTANCE);
        String name = TypeScriptUtil.getShortestTypeNameInContext(type, (PsiElement)location);
        return name + "." + fieldName;
    }

    @Override
    protected void addVariantsForUnqualifiedExpectedType(@NotNull JSType expectedType, @NotNull JSReferenceExpression location, @NotNull List<Object> variants) {
        List<LookupElement> result2;
        JSType typedef;
        if (expectedType == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(5);
        }
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(6);
        }
        if (variants == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(7);
        }
        if (expectedType instanceof JSTypeImpl && (typedef = ((JSTypeImpl)expectedType).getTypedef()) != null) {
            expectedType = typedef;
        }
        if ((result2 = this.getLiteralVariantsForExpectedType((JSExpression)location, false, expectedType)) != null) {
            variants.addAll(result2);
        }
        super.addVariantsForUnqualifiedExpectedType(expectedType, location, variants);
    }

    @Override
    protected boolean needToQualify(int qualifiedStaticVariantsStart, int i) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalVariants";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/completion/TypeScriptSmartCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSmartCompletionVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getVariantForDynamicallyNamedProperties";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addVariantIfComputedProp";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processSingleLiteralVariant";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addVariantsForUnqualifiedExpectedType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

