/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection
extends JSInspection {
    public static final String SHORT_NAME = "TypeScriptAbstractClassConstructorCanBeMadeProtected";

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"typescript.abstract.class.constructor.can.be.made.protected", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSFunctionDeclaration(JSFunction node) {
                PsiElement nameIdentifier;
                if (!node.isConstructor()) {
                    return;
                }
                if (!DialectDetector.isTypeScript((PsiElement)node)) {
                    return;
                }
                JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)node);
                if (containingClass == null) {
                    return;
                }
                JSAttributeList list = node.getAttributeList();
                if (list != null && list.getAccessType() != JSAttributeList.AccessType.PUBLIC) {
                    return;
                }
                if (TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)containingClass) && (nameIdentifier = node.getNameIdentifier()) != null) {
                    holder.registerProblem(nameIdentifier, TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection.this.getDisplayName(), new LocalQuickFix[]{JSFixFactory.getInstance().changeConstructorAccessRightsFix(node, JSAttributeList.AccessType.PROTECTED)});
                }
            }
        };
        if (jSElementVisitor == null) {
            TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection.$$$reportNull$$$0(2);
        }
        return jSElementVisitor;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection.$$$reportNull$$$0(3);
        }
        return SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/typescript/inspections/TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

