/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TypeScriptChangeConstructorAccessRightsFix
extends FixAndIntentionAction {
    private final JSAttributeList.AccessType myAccessType;

    public TypeScriptChangeConstructorAccessRightsFix(JSFunction node, JSAttributeList.AccessType accessType) {
        this.myAccessType = accessType;
        this.registerElementRefForFix((PsiElement)node, null);
    }

    @Nls
    @NotNull
    public String getName() {
        String string = JSBundle.message((String)"typescript.make.constructor.protected", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptChangeConstructorAccessRightsFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        JSFunction function = (JSFunction)psiElement;
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(function.getAttributeList(), function.getProject());
        wrapper.overrideAccessType(this.myAccessType);
        wrapper.applyTo((JSAttributeListOwner)function);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptChangeConstructorAccessRightsFix", "getName"));
    }
}

