/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigBase;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptConfigIncludeBase;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptConfigPatternInclude;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeScriptConfigImpl
extends TypeScriptConfigBase {
    @NotNull
    private final VirtualFile myConfigFile;
    @NotNull
    private final Map<String, String> myOptions;
    @NotNull
    private final VirtualFile myConfigDirectory;
    @NotNull
    private final Collection<VirtualFile> myFilesList;
    @NotNull
    private final Collection<String> myExcludePatterns;
    @NotNull
    private final Collection<String> myIncludedPatterns;
    private final boolean myAllowJs;
    private final boolean myCheckJs;
    private final boolean mySuppressExcessPropertyChecks;
    @NotNull
    private final TypeScriptConfig.LanguageTarget myLanguageTarget;
    private final boolean myHasFilesList;
    private final boolean myHasIncludeList;
    private final boolean myHasExcludeList;
    @NotNull
    private final Collection<String> myRootDirs;
    @NotNull
    private final Collection<JSModulePathSubstitution> myPaths;
    @Nullable
    private final String myBaseUrl;
    private final boolean myCompileOnSave;
    private final boolean myInlineSourceMap;
    private final boolean mySourceMap;
    private final String myExtendsPath;
    @NotNull
    private final Project myProject;
    private final boolean myHasErrors;
    private final boolean myDirectoryBased;
    @Nullable
    private final String myModuleResolution;
    @Nullable
    private final String myModule;
    private final boolean myHasExplicitCompileOnSave;
    private final boolean myNoImplicitAny;
    private final boolean myStrictNullChecks;
    private final boolean myNoLib;
    @NotNull
    private final Collection<String> myTypeRoots;
    private final Collection<String> myLibs;
    @NotNull
    private final Collection<String> myTypes;
    private final NotNullLazyValue<Collection<VirtualFile>> myTypeRootFiles;
    private final NullableLazyValue<VirtualFile> myBaseUrlFile;
    private final NotNullLazyValue<Collection<PsiFileSystemItem>> myRootDirPsiElements;
    private final NotNullLazyValue<Collection<VirtualFile>> myRootDirFiles;

    @Nullable
    static TypeScriptConfigImpl getSimpleConfigImpl(@NotNull PsiFile rawFile) {
        if (rawFile == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!(rawFile instanceof JsonFile)) {
            return null;
        }
        Project project = rawFile.getProject();
        JsonFile file = (JsonFile)rawFile;
        VirtualFile configVirtualFile = rawFile.getVirtualFile();
        VirtualFile configFile = file.getVirtualFile();
        if (configFile == null) {
            return null;
        }
        VirtualFile configDirectory = configFile.getParent();
        if (configDirectory == null) {
            return null;
        }
        JsonObject jsonObject = (JsonObject)PsiTreeUtil.getChildOfType((PsiElement)file, JsonObject.class);
        boolean hasErrors = PsiTreeUtil.hasErrorElements((PsiElement)file);
        return jsonObject == null ? new TypeScriptConfigImpl(project, configVirtualFile, configDirectory, hasErrors) : new TypeScriptConfigImpl(project, configVirtualFile, configDirectory, jsonObject, hasErrors);
    }

    @Nullable
    VirtualFile getExtendsParent() {
        if (StringUtil.isEmpty((String)this.myExtendsPath)) {
            return null;
        }
        String text = StringUtil.endsWithIgnoreCase((String)this.myExtendsPath, (String)".json") ? this.myExtendsPath : this.myExtendsPath + ".json";
        return JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(this.getConfigDirectory(), text);
    }

    @NotNull
    private static Collection<VirtualFile> getFiles(@Nullable JsonProperty filesProperty) {
        if (filesProperty == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(1);
            }
            return list;
        }
        JsonValue value = filesProperty.getValue();
        if (!(value instanceof JsonArray)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        HashSet files = ContainerUtil.newHashSet();
        JsonArray arrayWithFiles = (JsonArray)value;
        for (JsonValue jsonValue : arrayWithFiles.getValueList()) {
            if (!(jsonValue instanceof JsonStringLiteral)) continue;
            for (PsiReference reference : jsonValue.getReferences()) {
                PsiElement resolve;
                if (reference instanceof FileReference && !((FileReference)reference).isLast() || !((resolve = reference.resolve()) instanceof PsiFileSystemItem)) continue;
                files.add(((PsiFileSystemItem)resolve).getVirtualFile());
            }
        }
        HashSet hashSet = files;
        if (hashSet == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    private static Map<String, String> getCompilerOptions(@Nullable JsonValue value) {
        HashMap result2 = ContainerUtil.newHashMap();
        if (!(value instanceof JsonObject)) {
            HashMap hashMap = result2;
            if (hashMap == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(4);
            }
            return hashMap;
        }
        JsonObject jsonObject = (JsonObject)value;
        for (JsonProperty property : jsonObject.getPropertyList()) {
            String optionName = property.getName();
            JsonValue optionValue = property.getValue();
            if (optionValue == null) continue;
            String optionText = optionValue instanceof JsonStringLiteral ? ((JsonStringLiteral)optionValue).getValue() : optionValue.getText();
            result2.put(StringUtil.unquoteString((String)optionName), optionText);
        }
        HashMap hashMap = result2;
        if (hashMap == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    private TypeScriptConfigImpl(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull VirtualFile configDirectory, boolean hasErrors) {
        if (project == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(6);
        }
        if (configFile == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(7);
        }
        if (configDirectory == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(8);
        }
        this.myTypeRootFiles = new NotNullLazyValue<Collection<VirtualFile>>(){

            @NotNull
            protected Collection<VirtualFile> compute() {
                if (TypeScriptConfigImpl.this.myTypeRoots.isEmpty()) {
                    VirtualFile defaultTypesDirectory = JSPathMappingsUtil.getRelativeOrAbsoluteFilePath("node_modules/@types", TypeScriptConfigImpl.this.getConfigDirectory());
                    if (defaultTypesDirectory == null) {
                        List list = ContainerUtil.emptyList();
                        if (list == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return list;
                    }
                    List list = ContainerUtil.createMaybeSingletonList((Object)defaultTypesDirectory);
                    if (list == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return list;
                }
                ArrayList results = ContainerUtil.newArrayList();
                for (String root : TypeScriptConfigImpl.this.myTypeRoots) {
                    VirtualFile path;
                    if (StringUtil.isEmpty((String)root) || (path = JSPathMappingsUtil.getRelativeOrAbsoluteFilePath(root, TypeScriptConfigImpl.this.getConfigDirectory())) == null) continue;
                    results.add(path);
                }
                ArrayList arrayList = results;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(2);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$1", "compute"));
            }
        };
        this.myBaseUrlFile = new NullableLazyValue<VirtualFile>(){

            protected VirtualFile compute() {
                if (TypeScriptConfigImpl.this.myBaseUrl == null) {
                    return null;
                }
                return JSPathMappingsUtil.getRelativeOrAbsoluteFilePath(TypeScriptConfigImpl.this.myBaseUrl, TypeScriptConfigImpl.this.getConfigDirectory());
            }
        };
        this.myRootDirPsiElements = new NotNullLazyValue<Collection<PsiFileSystemItem>>(){

            @NotNull
            protected Collection<PsiFileSystemItem> compute() {
                if (TypeScriptConfigImpl.this.myRootDirs.isEmpty()) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return list;
                }
                List list = ContainerUtil.mapNotNull((Collection)TypeScriptConfigImpl.this.myRootDirs, filePath -> {
                    VirtualFile path = JSPathMappingsUtil.getRelativeOrAbsoluteFilePath(filePath, TypeScriptConfigImpl.this.getConfigDirectory());
                    if (path != null) {
                        return PsiManager.getInstance((Project)TypeScriptConfigImpl.this.myProject).findDirectory(path);
                    }
                    return null;
                });
                if (list == null) {
                    3.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$3", "compute"));
            }
        };
        this.myRootDirFiles = new NotNullLazyValue<Collection<VirtualFile>>(){

            @NotNull
            protected Collection<VirtualFile> compute() {
                Collection dirs = (Collection)TypeScriptConfigImpl.this.myRootDirPsiElements.getValue();
                List list = ContainerUtil.map((Collection)dirs, PsiFileSystemItem::getVirtualFile);
                if (list == null) {
                    4.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$4", "compute"));
            }
        };
        this.myConfigFile = configFile;
        this.myConfigDirectory = configDirectory;
        this.myOptions = ContainerUtil.newHashMap();
        this.myFilesList = ContainerUtil.emptyList();
        this.myIncludedPatterns = ContainerUtil.emptyList();
        this.myExcludePatterns = DEFAULT_EXCLUDE_VALUES;
        this.myLanguageTarget = DEFAULT_LANGUAGE_TARGET;
        this.myRootDirs = ContainerUtil.emptyList();
        this.myPaths = ContainerUtil.emptyList();
        this.myBaseUrl = null;
        this.myProject = project;
        this.myHasErrors = hasErrors;
        this.myDirectoryBased = true;
        this.myCompileOnSave = true;
        this.myInlineSourceMap = false;
        this.mySourceMap = false;
        this.myLibs = ContainerUtil.emptyList();
        this.myModuleResolution = null;
        this.myModule = null;
        this.myTypeRoots = ContainerUtil.emptyList();
        this.myTypes = ContainerUtil.emptyList();
        this.myExtendsPath = null;
        this.myHasFilesList = false;
        this.myHasIncludeList = false;
        this.myHasExcludeList = false;
        this.myAllowJs = false;
        this.myCheckJs = false;
        this.mySuppressExcessPropertyChecks = false;
        this.myHasExplicitCompileOnSave = false;
        this.myNoImplicitAny = false;
        this.myStrictNullChecks = false;
        this.myNoLib = false;
    }

    public boolean hasExcludeList() {
        return this.myHasExcludeList;
    }

    private TypeScriptConfigImpl(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull VirtualFile configDirectory, @NotNull JsonObject jsonObject, boolean hasErrors) {
        if (project == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(9);
        }
        if (configFile == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(10);
        }
        if (configDirectory == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(11);
        }
        if (jsonObject == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(12);
        }
        this.myTypeRootFiles = new /* invalid duplicate definition of identical inner class */;
        this.myBaseUrlFile = new /* invalid duplicate definition of identical inner class */;
        this.myRootDirPsiElements = new /* invalid duplicate definition of identical inner class */;
        this.myRootDirFiles = new /* invalid duplicate definition of identical inner class */;
        JsonProperty compilerOptionsProperty = jsonObject.findProperty("compilerOptions");
        JsonValue compilerOptionsValue = compilerOptionsProperty == null ? null : compilerOptionsProperty.getValue();
        Map<String, String> options = TypeScriptConfigImpl.getCompilerOptions(compilerOptionsValue);
        JsonProperty filesProperty = jsonObject.findProperty("files");
        JsonProperty includeProperty = jsonObject.findProperty("include");
        JsonProperty excludeProperty = jsonObject.findProperty("exclude");
        this.myHasExcludeList = excludeProperty != null;
        this.myHasIncludeList = includeProperty != null;
        this.myHasFilesList = filesProperty != null;
        this.myConfigFile = configFile;
        this.myConfigDirectory = configDirectory;
        this.myProject = project;
        this.myOptions = options;
        this.myFilesList = TypeScriptConfigImpl.getFiles(filesProperty);
        this.myDirectoryBased = filesProperty == null && includeProperty == null;
        this.myExcludePatterns = excludeProperty != null ? TypeScriptConfigImpl.readValues(excludeProperty.getValue()) : DEFAULT_EXCLUDE_VALUES;
        this.myIncludedPatterns = includeProperty != null ? TypeScriptConfigImpl.readValues(includeProperty.getValue()) : ContainerUtil.emptyList();
        this.myRootDirs = TypeScriptConfigImpl.getRootDirs(compilerOptionsValue);
        this.myPaths = TypeScriptConfigImpl.getPaths(compilerOptionsValue);
        this.myBaseUrl = TypeScriptConfigImpl.getBaseUrl(compilerOptionsValue);
        this.myAllowJs = TypeScriptConfigImpl.getBooleanValue(compilerOptionsValue, "allowJs", false);
        this.myCheckJs = TypeScriptConfigImpl.getBooleanValue(compilerOptionsValue, "checkJs", false);
        this.myStrictNullChecks = TypeScriptConfigImpl.getBooleanValue(compilerOptionsValue, "strictNullChecks", false);
        this.mySuppressExcessPropertyChecks = TypeScriptConfigImpl.getBooleanValue(compilerOptionsValue, "suppressExcessPropertyErrors", false);
        this.myNoImplicitAny = TypeScriptConfigImpl.getBooleanValue(compilerOptionsValue, "noImplicitAny", false);
        this.myNoLib = TypeScriptConfigImpl.getBooleanValue(compilerOptionsValue, "noLib", false);
        this.myTypeRoots = TypeScriptConfigImpl.getTypeRoots(compilerOptionsValue);
        this.myTypes = TypeScriptConfigImpl.getTypes(compilerOptionsValue);
        this.myLibs = TypeScriptConfigImpl.getLibs(compilerOptionsValue);
        this.myModuleResolution = TypeScriptConfigImpl.getModuleResolution(compilerOptionsValue);
        this.myModule = TypeScriptConfigImpl.getModule(compilerOptionsValue);
        this.myHasErrors = hasErrors;
        this.myCompileOnSave = TypeScriptConfigImpl.getBooleanValue(jsonObject, "compileOnSave", true);
        this.myHasExplicitCompileOnSave = jsonObject.findProperty("compileOnSave") != null;
        this.myExtendsPath = TypeScriptConfigImpl.getStringOption((JsonElement)jsonObject, "extends");
        this.myInlineSourceMap = Boolean.parseBoolean(this.myOptions.get("inlineSourceMap"));
        this.mySourceMap = Boolean.parseBoolean(this.myOptions.get("sourceMap"));
        String optionValue = this.myOptions.get("target");
        this.myLanguageTarget = StringUtil.isEmpty((String)optionValue) ? DEFAULT_LANGUAGE_TARGET : TypeScriptConfigImpl.parseTarget(optionValue);
    }

    private static boolean getBooleanValue(@Nullable JsonValue jsonObject, String name, boolean defaultValue) {
        if (jsonObject == null || !(jsonObject instanceof JsonObject)) {
            return defaultValue;
        }
        return TypeScriptConfigImpl.getBooleanValue((JsonObject)jsonObject, name, defaultValue);
    }

    private static boolean getBooleanValue(@NotNull JsonObject jsonObject, String name, boolean defaultValue) {
        JsonProperty compileOnSave;
        if (jsonObject == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(13);
        }
        JsonValue compileOnSaveValue = (compileOnSave = jsonObject.findProperty(name)) == null ? null : compileOnSave.getValue();
        return compileOnSaveValue == null ? defaultValue : Boolean.valueOf(compileOnSaveValue.getText());
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getRootDirsFiles() {
        Collection collection = (Collection)this.myRootDirFiles.getValue();
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<String> getExcludePatterns() {
        Collection<String> collection = this.myExcludePatterns;
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<String> getIncludePatterns() {
        Collection<String> collection = this.myIncludedPatterns;
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getFileList() {
        Collection<VirtualFile> collection = this.myFilesList;
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(17);
        }
        return collection;
    }

    @Override
    public boolean hasFilesList() {
        return this.myHasFilesList;
    }

    @Override
    public boolean hasIncludesList() {
        return this.myHasIncludeList;
    }

    @Override
    public boolean isFromFileList(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(18);
        }
        TypeScriptConfigIncludeBase checker = this.getInclude();
        return checker.isFromFilesList(file);
    }

    @Override
    @Nullable
    public String getRawCompilerOption(@NotNull String name) {
        if (name == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(19);
        }
        return this.myOptions.get(name);
    }

    @Override
    public boolean hasExplicitCompileOnSave() {
        return this.myHasExplicitCompileOnSave;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getDependencies() {
        List list = ContainerUtil.createMaybeSingletonList((Object)this.myConfigFile);
        if (list == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(20);
        }
        return list;
    }

    @Override
    public boolean allowJs() {
        return this.myAllowJs;
    }

    @Override
    public boolean suppressExcessPropertyChecks() {
        return this.mySuppressExcessPropertyChecks;
    }

    @Override
    public boolean checkJs() {
        return this.myCheckJs;
    }

    @Override
    public boolean noImplicitAny() {
        return this.myNoImplicitAny;
    }

    @Override
    public boolean strictNullChecks() {
        return this.myStrictNullChecks;
    }

    @Override
    public boolean allowSyntheticDefaultImports() {
        return Boolean.valueOf(this.getRawCompilerOption("allowSyntheticDefaultImports"));
    }

    @Override
    public boolean noLib() {
        return this.myNoLib;
    }

    @Override
    @Nullable
    public String jsxFactory() {
        return this.hasCompilerOption("jsxFactory") ? this.getRawCompilerOption("jsxFactory") : null;
    }

    @Override
    public boolean isIncludedFile(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(21);
        }
        return this.isIncludedFile(file, true);
    }

    @Override
    public boolean isIncludedFile(@NotNull VirtualFile file, boolean checkExclude) {
        TypeScriptConfigIncludeBase checker;
        if (file == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(22);
        }
        if ((checker = this.getInclude()) instanceof TypeScriptConfigPatternInclude) {
            return ((TypeScriptConfigPatternInclude)checker).isIncludedFile(file, checkExclude);
        }
        return false;
    }

    @Nullable
    private static String getBaseUrl(@Nullable JsonValue compilerOptions) {
        return TypeScriptConfigImpl.getStringOption((JsonElement)compilerOptions, "baseUrl");
    }

    private static String getModuleResolution(@Nullable JsonValue compilerOptions) {
        return TypeScriptConfigImpl.getStringOption((JsonElement)compilerOptions, "moduleResolution");
    }

    private static String getModule(@Nullable JsonValue compilerOptions) {
        return TypeScriptConfigImpl.getStringOption((JsonElement)compilerOptions, "module");
    }

    @Nullable
    private static String getStringOption(@Nullable JsonElement options, String name) {
        if (!(options instanceof JsonObject)) {
            return null;
        }
        JsonObject jsonObject = (JsonObject)options;
        JsonProperty property = jsonObject.findProperty(name);
        if (property == null) {
            return null;
        }
        JsonValue value = property.getValue();
        return value instanceof JsonStringLiteral ? ((JsonStringLiteral)value).getValue() : null;
    }

    @NotNull
    private static Collection<String> getRootDirs(@Nullable JsonValue compilerOptions) {
        Collection<String> collection = TypeScriptConfigImpl.getPropertyList(compilerOptions, "rootDirs");
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(23);
        }
        return collection;
    }

    @NotNull
    private static Collection<String> getTypes(@Nullable JsonValue compilerOptions) {
        Collection<String> collection = TypeScriptConfigImpl.getPropertyList(compilerOptions, "types");
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(24);
        }
        return collection;
    }

    @NotNull
    private static Collection<String> getLibs(@Nullable JsonValue compilerOptions) {
        Collection<String> collection = TypeScriptConfigImpl.getPropertyList(compilerOptions, "lib");
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(25);
        }
        return collection;
    }

    @NotNull
    private static Collection<String> getTypeRoots(@Nullable JsonValue compilerOptions) {
        Collection<String> collection = TypeScriptConfigImpl.getPropertyList(compilerOptions, "typeRoots");
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(26);
        }
        return collection;
    }

    @NotNull
    private static Collection<String> getPropertyList(@Nullable JsonValue compilerOptions, String name) {
        if (!(compilerOptions instanceof JsonObject)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(27);
            }
            return list;
        }
        JsonObject jsonObject = (JsonObject)compilerOptions;
        JsonProperty property = jsonObject.findProperty(name);
        if (property == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(28);
            }
            return list;
        }
        JsonValue value = property.getValue();
        Collection<String> collection = TypeScriptConfigImpl.readValues(value);
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(29);
        }
        return collection;
    }

    @NotNull
    private static Collection<String> readValues(JsonValue value) {
        if (!(value instanceof JsonArray)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(30);
            }
            return list;
        }
        JsonArray jsonArray = (JsonArray)value;
        ArrayList resultList = ContainerUtil.newArrayList();
        for (JsonValue jsonValue : jsonArray.getValueList()) {
            if (!(jsonValue instanceof JsonStringLiteral)) continue;
            resultList.add(((JsonStringLiteral)jsonValue).getValue());
        }
        ArrayList arrayList = resultList;
        if (arrayList == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    private static Collection<JSModulePathSubstitution> getPaths(@Nullable JsonValue compilerOptions) {
        if (!(compilerOptions instanceof JsonObject)) {
            return ContainerUtil.emptyList();
        }
        JsonObject jsonObject = (JsonObject)compilerOptions;
        JsonProperty property = jsonObject.findProperty("paths");
        if (property == null) {
            return ContainerUtil.emptyList();
        }
        JsonValue propertyValue = property.getValue();
        if (!(propertyValue instanceof JsonObject)) {
            return ContainerUtil.emptyList();
        }
        JsonObject paths = (JsonObject)propertyValue;
        ArrayList result2 = ContainerUtil.newArrayList();
        for (JsonProperty jsonProperty : paths.getPropertyList()) {
            String name = jsonProperty.getName();
            JsonValue value = jsonProperty.getValue();
            ArrayList substitutions = ContainerUtil.newArrayList();
            if (value instanceof JsonStringLiteral) {
                substitutions.add(((JsonStringLiteral)value).getValue());
            } else if (value instanceof JsonArray) {
                for (JsonValue jsonValue : ((JsonArray)value).getValueList()) {
                    if (!(jsonValue instanceof JsonStringLiteral)) continue;
                    substitutions.add(((JsonStringLiteral)jsonValue).getValue());
                }
            }
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)compilerOptions.getProject());
            SmartPsiElementPointer pointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)jsonProperty);
            result2.add(new TypeScriptConfigPathSubstitution(substitutions, name, pointer));
        }
        return result2;
    }

    @Override
    public boolean isDirectoryBased() {
        return this.myDirectoryBased;
    }

    @Override
    @NotNull
    public VirtualFile getConfigFile() {
        VirtualFile virtualFile = this.myConfigFile;
        if (virtualFile == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(32);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile getConfigDirectory() {
        VirtualFile virtualFile = this.myConfigDirectory;
        if (virtualFile == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(33);
        }
        return virtualFile;
    }

    @Override
    public boolean hasErrors() {
        return this.myHasErrors;
    }

    @Override
    @NotNull
    public Collection<JSModulePathSubstitution> getPaths() {
        Collection<JSModulePathSubstitution> collection = this.myPaths;
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(34);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getRootDirs() {
        Collection collection = (Collection)this.myRootDirPsiElements.getValue();
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(35);
        }
        return collection;
    }

    @Override
    @NotNull
    public TypeScriptConfig.LanguageTarget getLanguageTarget() {
        TypeScriptConfig.LanguageTarget languageTarget = this.myLanguageTarget;
        if (languageTarget == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(36);
        }
        return languageTarget;
    }

    @Override
    @NotNull
    public Collection<String> getLibNames() {
        Collection<String> collection = this.myLibs;
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(37);
        }
        return collection;
    }

    @Override
    @Nullable
    public VirtualFile getBaseUrl() {
        return (VirtualFile)this.myBaseUrlFile.getValue();
    }

    @Override
    @Nullable
    public String getOutDirectory() {
        VirtualFile baseDirectory = this.getConfigDirectory();
        String directoryPath = this.getRawCompilerOption("outDir");
        return directoryPath != null ? TypeScriptConfigUtil.getOutDirectory(baseDirectory, directoryPath) : null;
    }

    public String toString() {
        return "TypeScriptConfigImpl{myConfigFile=" + this.myConfigFile + ", myOptions=" + this.myOptions + ", myConfigDirectory=" + this.myConfigDirectory + ", myFilesList=" + this.myFilesList + '}';
    }

    public static TypeScriptConfig.LanguageTarget parseTarget(String value) {
        String lowerCaseValue = StringUtil.toLowerCase((String)value.trim());
        if ("es3".equals(lowerCaseValue) || "es5".equals(lowerCaseValue)) {
            return TypeScriptConfig.LanguageTarget.ES3;
        }
        if ("es6".equals(lowerCaseValue) || "es2015".equals(lowerCaseValue)) {
            return TypeScriptConfig.LanguageTarget.ES6;
        }
        if (lowerCaseValue.startsWith("es")) {
            return new TypeScriptConfig.LanguageTarget(lowerCaseValue + ".full", 3);
        }
        return DEFAULT_LANGUAGE_TARGET;
    }

    @Override
    public boolean isCompileOnSave() {
        return this.myCompileOnSave;
    }

    @Override
    public boolean isInlineSourceMap() {
        return this.myInlineSourceMap;
    }

    @Override
    public boolean isSourceMap() {
        return this.mySourceMap;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getTypeRoots() {
        Collection collection = (Collection)this.myTypeRootFiles.getValue();
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(38);
        }
        return collection;
    }

    @Override
    @NotNull
    public TypeScriptConfig.ModuleResolution getResolution() {
        if (StringUtil.isEmpty((String)this.myModuleResolution)) {
            TypeScriptConfig.ModuleResolution moduleResolution = TypeScriptConfig.ModuleResolution.UNKNOWN;
            if (moduleResolution == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(39);
            }
            return moduleResolution;
        }
        if ("node".equals(this.myModuleResolution)) {
            TypeScriptConfig.ModuleResolution moduleResolution = TypeScriptConfig.ModuleResolution.NODE;
            if (moduleResolution == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(40);
            }
            return moduleResolution;
        }
        if ("classic".equals(this.myModuleResolution)) {
            TypeScriptConfig.ModuleResolution moduleResolution = TypeScriptConfig.ModuleResolution.CLASSIC;
            if (moduleResolution == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(41);
            }
            return moduleResolution;
        }
        TypeScriptConfig.ModuleResolution moduleResolution = TypeScriptConfig.ModuleResolution.UNKNOWN;
        if (moduleResolution == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(42);
        }
        return moduleResolution;
    }

    @Override
    @NotNull
    public TypeScriptConfig.ModuleTarget getModule() {
        if (this.myModule == null) {
            TypeScriptConfig.ModuleTarget moduleTarget = TypeScriptConfig.ModuleTarget.COMMON_JS;
            if (moduleTarget == null) {
                TypeScriptConfigImpl.$$$reportNull$$$0(43);
            }
            return moduleTarget;
        }
        TypeScriptConfig.ModuleTarget moduleTarget = StringUtil.equalsIgnoreCase((CharSequence)"commonjs", (CharSequence)this.myModule) ? TypeScriptConfig.ModuleTarget.COMMON_JS : TypeScriptConfig.ModuleTarget.OTHER;
        if (moduleTarget == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(44);
        }
        return moduleTarget;
    }

    @Override
    @NotNull
    public Collection<String> getTypes() {
        Collection<String> collection = this.myTypes;
        if (collection == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(45);
        }
        return collection;
    }

    public boolean hasCompilerOption(@NotNull String name) {
        if (name == null) {
            TypeScriptConfigImpl.$$$reportNull$$$0(46);
        }
        return this.myOptions.containsKey(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDirectory";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonObject";
                break;
            }
            case 18: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerOptions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDirsFiles";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludePatterns";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludePatterns";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileList";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 23: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDirs";
                break;
            }
            case 24: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibs";
                break;
            }
            case 26: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeRoots";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyList";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "readValues";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFile";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDirectory";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageTarget";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibNames";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolution";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleConfigImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanValue";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isFromFileList";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRawCompilerOption";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isIncludedFile";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "hasCompilerOption";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TypeScriptConfigPathSubstitution
    implements JSModulePathSubstitution {
        @NotNull
        private final Collection<String> mySubstitutions;
        private final String myName;
        private final SmartPsiElementPointer myPointer;

        public TypeScriptConfigPathSubstitution(@NotNull Collection<String> substitutions, @NotNull String name, @NotNull SmartPsiElementPointer pointer) {
            if (substitutions == null) {
                TypeScriptConfigPathSubstitution.$$$reportNull$$$0(0);
            }
            if (name == null) {
                TypeScriptConfigPathSubstitution.$$$reportNull$$$0(1);
            }
            if (pointer == null) {
                TypeScriptConfigPathSubstitution.$$$reportNull$$$0(2);
            }
            this.mySubstitutions = substitutions;
            this.myName = name;
            this.myPointer = pointer;
        }

        @Override
        @NotNull
        public Collection<String> getMappings() {
            Collection<String> collection = this.mySubstitutions;
            if (collection == null) {
                TypeScriptConfigPathSubstitution.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @Override
        @NotNull
        public String getPattern() {
            String string = this.myName;
            if (string == null) {
                TypeScriptConfigPathSubstitution.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public boolean canStartWith() {
            return false;
        }

        @Override
        public PsiElement getElement() {
            return this.myPointer.getElement();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeScriptConfigPathSubstitution that = (TypeScriptConfigPathSubstitution)o;
            if (!this.mySubstitutions.equals(that.mySubstitutions)) {
                return false;
            }
            return this.myName.equals(that.myName);
        }

        public int hashCode() {
            int result2 = this.mySubstitutions.hashCode();
            result2 = 31 * result2 + this.myName.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pointer";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$TypeScriptConfigPathSubstitution";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$TypeScriptConfigPathSubstitution";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMappings";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

