/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigsChangedListener;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypeScriptConfigService {
    public boolean isAccessible(@NotNull VirtualFile var1, @NotNull VirtualFile var2);

    @NotNull
    public Predicate<VirtualFile> getAccessScope(@NotNull VirtualFile var1);

    @NotNull
    public Collection<TypeScriptConfig> getConfigInclude(@NotNull VirtualFile var1);

    @Nullable
    public TypeScriptConfig parseConfigFile(@NotNull VirtualFile var1);

    @NotNull
    public Collection<TypeScriptConfig> getConfigFiles();

    public boolean isConfigInclude(@NotNull VirtualFile var1, @NotNull TypeScriptConfig var2);

    public void addChangeListener(@NotNull TypeScriptConfigsChangedListener var1);

    public boolean hasConfigs();

    @NotNull
    public ModificationTracker getTracker();

    @NotNull
    public Set<VirtualFile> getIncludedFiles(@NotNull VirtualFile var1);

    public static class Provider {
        @Nullable
        public static TypeScriptConfigService get(@NotNull Project project) {
            if (project == null) {
                Provider.$$$reportNull$$$0(0);
            }
            return (TypeScriptConfigService)ServiceManager.getService((Project)project, TypeScriptConfigService.class);
        }

        public static boolean isAccessible(@NotNull Project project, @NotNull VirtualFile scope, @NotNull VirtualFile referencedFile) {
            TypeScriptConfigService service;
            if (project == null) {
                Provider.$$$reportNull$$$0(1);
            }
            if (scope == null) {
                Provider.$$$reportNull$$$0(2);
            }
            if (referencedFile == null) {
                Provider.$$$reportNull$$$0(3);
            }
            if ((service = Provider.get(project)) == null) {
                return true;
            }
            return service.isAccessible(scope, referencedFile);
        }

        public static boolean isAccessible(@NotNull PsiElement source, @NotNull PsiElement reference) {
            if (source == null) {
                Provider.$$$reportNull$$$0(4);
            }
            if (reference == null) {
                Provider.$$$reportNull$$$0(5);
            }
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)source);
            VirtualFile ref = PsiUtilCore.getVirtualFile((PsiElement)reference);
            if (file == null || ref == null) {
                return true;
            }
            return Provider.isAccessible(source.getProject(), file, ref);
        }

        public static boolean hasConfigs(@Nullable Project project) {
            if (!Provider.checkProject(project)) {
                return false;
            }
            TypeScriptConfigService service = Provider.get(project);
            if (service == null) {
                return false;
            }
            return service.hasConfigs();
        }

        public static GlobalSearchScope getConfigResolveScope(@NotNull PsiElement context) {
            if (context == null) {
                Provider.$$$reportNull$$$0(6);
            }
            Project project = context.getProject();
            GlobalSearchScope defaultScope = JSResolveUtil.getResolveScope(context);
            if (!Provider.checkProject(project)) {
                return defaultScope;
            }
            TypeScriptConfigService service = Provider.get(project);
            if (service == null) {
                return defaultScope;
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)context);
            if (virtualFile == null) {
                return defaultScope;
            }
            final Predicate<VirtualFile> scopePredicate = service.getAccessScope(virtualFile);
            return new DelegatingGlobalSearchScope(defaultScope){

                public boolean contains(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!super.contains(file)) {
                        return false;
                    }
                    return scopePredicate.apply((Object)file);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider$1", "contains"));
                }
            };
        }

        @NotNull
        public static Collection<TypeScriptConfig> getConfigInclude(@Nullable Project project, @NotNull VirtualFile file) {
            if (file == null) {
                Provider.$$$reportNull$$$0(7);
            }
            if (!Provider.checkProject(project)) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    Provider.$$$reportNull$$$0(8);
                }
                return list;
            }
            TypeScriptConfigService service = Provider.get(project);
            if (service == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    Provider.$$$reportNull$$$0(9);
                }
                return list;
            }
            Collection<TypeScriptConfig> collection = service.getConfigInclude(file);
            if (collection == null) {
                Provider.$$$reportNull$$$0(10);
            }
            return collection;
        }

        private static boolean checkProject(@Nullable Project project) {
            return project != null && !project.isDefault() && !project.isDisposed();
        }

        @NotNull
        public static Collection<TypeScriptConfig> getConfigFiles(@Nullable Project project) {
            if (!Provider.checkProject(project)) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    Provider.$$$reportNull$$$0(11);
                }
                return list;
            }
            TypeScriptConfigService service = Provider.get(project);
            if (service == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    Provider.$$$reportNull$$$0(12);
                }
                return list;
            }
            Collection<TypeScriptConfig> collection = service.getConfigFiles();
            if (collection == null) {
                Provider.$$$reportNull$$$0(13);
            }
            return collection;
        }

        public static TypeScriptConfig parseConfigFile(Project project, @Nullable VirtualFile file) {
            if (file == null || !Provider.checkProject(project)) {
                return null;
            }
            TypeScriptConfigService service = Provider.get(project);
            if (service == null) {
                return null;
            }
            return service.parseConfigFile(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referencedFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigInclude";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isAccessible";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigResolveScope";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigInclude";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

