/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModuleReferenceBase;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportResolveContext;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001f\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u000fH\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000fH\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000fH\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000fH\u0002J\"\u0010&\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u001bH\u0002J\"\u0010)\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u001bH\u0002J\u001a\u0010+\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u001bH\u0002J\u001a\u0010-\u001a\u0004\u0018\u00010\u000f2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u001a\u0010.\u001a\u0004\u0018\u00010\u000f2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000fH\u0002J\u001a\u0010/\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000fH\u0002J\u001a\u00100\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000fH\u0002J\u0010\u00101\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u001a\u00102\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0014\u00103\u001a\u0004\u0018\u00010\u000f2\b\u00104\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u00105\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u00106\u001a\u00020\u000bH\u0002J\u0012\u00107\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u001a\u00108\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000fH\u0002J\u001a\u00109\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/lang/typescript/tsconfig/TypeScriptFileImportsResolverImpl;", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptFileImportsResolver;", "project", "Lcom/intellij/openapi/project/Project;", "resolveContext", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptImportResolveContext;", "nodeProcessor", "Lcom/intellij/javascript/nodejs/NodeModuleDirectorySearchProcessor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/typescript/tsconfig/TypeScriptImportResolveContext;Lcom/intellij/javascript/nodejs/NodeModuleDirectorySearchProcessor;)V", "extensions", "", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/typescript/tsconfig/TypeScriptImportResolveContext;Lcom/intellij/javascript/nodejs/NodeModuleDirectorySearchProcessor;[Ljava/lang/String;)V", "[Ljava/lang/String;", "classicNameResolver", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleName", "containingFile", "findRootDirWithLongestPrefix", "candidate", "directory", "getBaseUrl", "getPathMappings", "", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;", "getRootDirs", "hasPathMappings", "", "isClassic", "isExternalModuleNameRelative", "isUnknown", "loadModuleFromFile", "relativePath", "containingDirectory", "loadModuleFromNodeModules", "loadModuleFromNodeModulesAtTypes", "loadModuleFromNodeModulesFolder", "nodeModulesFolder", "loadModuleFromNodeModulesOneLevel", "nodeModulesDirectory", "typesOnly", "loadModuleFromNodeModulesWorker", "toSearchDir", "loadNodeModuleFromDirectory", "considerPackageJson", "loader", "nodeLoadModuleByRelativeName", "nodeModuleNameResolver", "nodeModuleNameResolverWorker", "pathEndsWithDirectorySeparator", "resolveFileModule", "toPreferredFileModule", "file", "tryAddingExtensions", "name", "tryLoadModuleUsingBaseUrl", "tryLoadModuleUsingOptionalResolutionSettings", "tryLoadModuleUsingRootDirs", "JavaScriptLanguage"})
public final class TypeScriptFileImportsResolverImpl
implements TypeScriptFileImportsResolver {
    private final Project project;
    private final TypeScriptImportResolveContext resolveContext;
    private final NodeModuleDirectorySearchProcessor nodeProcessor;
    private final String[] extensions;

    @Override
    @Nullable
    public VirtualFile resolveFileModule(@NotNull String moduleName, @NotNull VirtualFile containingFile) {
        VirtualFile result2;
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        Intrinsics.checkParameterIsNotNull((Object)containingFile, (String)"containingFile");
        ProgressManager.checkCanceled();
        VirtualFile virtualFile = containingFile.getParent();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile containingDirectory = virtualFile;
        if ((this.isClassic() || this.isUnknown()) && ((result2 = this.classicNameResolver(moduleName, containingFile)) != null || this.isClassic())) {
            return this.toPreferredFileModule(result2);
        }
        return this.toPreferredFileModule(this.nodeModuleNameResolver(moduleName, containingDirectory));
    }

    private final VirtualFile toPreferredFileModule(VirtualFile file) {
        if (file == null) {
            return null;
        }
        return JSModuleReferenceBase.getCanonicalPreferredFile(this.project, file);
    }

    private final VirtualFile nodeModuleNameResolverWorker(String moduleName, VirtualFile containingDirectory) {
        VirtualFile optionalResolved = this.tryLoadModuleUsingOptionalResolutionSettings(moduleName, containingDirectory);
        if (optionalResolved != null) {
            return optionalResolved;
        }
        if (!this.isExternalModuleNameRelative(moduleName)) {
            VirtualFile candidate = this.loadModuleFromNodeModules(moduleName, containingDirectory);
            if (candidate != null) {
                return candidate;
            }
        } else {
            VirtualFile candidate = this.nodeLoadModuleByRelativeName(moduleName, containingDirectory);
            if (candidate != null) {
                return candidate;
            }
        }
        return this.loadModuleFromFile(moduleName, containingDirectory);
    }

    private final VirtualFile findRootDirWithLongestPrefix(String candidate, VirtualFile directory) {
        VirtualFile matchedRootDir = null;
        String matchedNormalizedPrefix = null;
        for (VirtualFile rootDir : this.getRootDirs()) {
            String rootDirPath = rootDir.getPath() + '/';
            boolean isLongestMatchingPrefix = StringsKt.startsWith$default((String)candidate, (String)rootDirPath, (boolean)false, (int)2, null) && (matchedNormalizedPrefix == null || matchedNormalizedPrefix.length() < rootDirPath.length());
            if (!isLongestMatchingPrefix) continue;
            matchedRootDir = rootDir;
            matchedNormalizedPrefix = rootDirPath;
        }
        return matchedRootDir;
    }

    private final boolean isClassic() {
        return Intrinsics.areEqual((Object)((Object)this.resolveContext.moduleResolution()), (Object)((Object)TypeScriptConfig.ModuleResolution.CLASSIC));
    }

    private final boolean isUnknown() {
        return Intrinsics.areEqual((Object)((Object)this.resolveContext.moduleResolution()), (Object)((Object)TypeScriptConfig.ModuleResolution.UNKNOWN));
    }

    private final boolean hasPathMappings() {
        return !this.resolveContext.pathsMappings().isEmpty();
    }

    private final VirtualFile getBaseUrl() {
        return this.resolveContext.baseUrl();
    }

    private final Collection<VirtualFile> getRootDirs() {
        Collection<VirtualFile> collection = this.resolveContext.rootDirs();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"resolveContext.rootDirs()");
        return collection;
    }

    private final Collection<JSModulePathSubstitution> getPathMappings() {
        Collection<JSModulePathSubstitution> collection = this.resolveContext.pathsMappings();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"resolveContext.pathsMappings()");
        return collection;
    }

    private final boolean isExternalModuleNameRelative(String moduleName) {
        String path = FileUtil.toSystemIndependentName((String)moduleName);
        return StringsKt.startsWith$default((String)path, (String)"./", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path, (String)"../", (boolean)false, (int)2, null) || TypeScriptConfigUtil.isRootDiskPath(moduleName);
    }

    private final boolean pathEndsWithDirectorySeparator(String moduleName) {
        return StringsKt.endsWith$default((String)moduleName, (String)"/", (boolean)false, (int)2, null);
    }

    private final VirtualFile classicNameResolver(String moduleName, VirtualFile containingFile) {
        VirtualFile containingDirectory;
        VirtualFile virtualFile = containingDirectory = containingFile.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"containingDirectory");
        VirtualFile optionalResolved = this.tryLoadModuleUsingOptionalResolutionSettings(moduleName, virtualFile);
        if (optionalResolved != null) {
            return optionalResolved;
        }
        if (!this.isExternalModuleNameRelative(moduleName)) {
            VirtualFile iteratedOverParent = TypeScriptUtil.calcFileByReferencePath(this.project, containingFile, moduleName);
            if (iteratedOverParent != null) {
                return iteratedOverParent;
            }
            return this.loadModuleFromNodeModulesAtTypes(moduleName, containingDirectory);
        }
        return this.loadModuleFromFile(moduleName, containingDirectory);
    }

    private final VirtualFile nodeModuleNameResolver(String moduleName, VirtualFile containingDirectory) {
        return this.nodeModuleNameResolverWorker(moduleName, containingDirectory);
    }

    private final VirtualFile tryLoadModuleUsingOptionalResolutionSettings(String moduleName, VirtualFile containingDirectory) {
        if (this.isExternalModuleNameRelative(moduleName)) {
            return this.tryLoadModuleUsingRootDirs(moduleName, containingDirectory);
        }
        return this.tryLoadModuleUsingBaseUrl(moduleName);
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile tryLoadModuleUsingBaseUrl(String moduleName) {
        Collection<JSModulePathSubstitution> mappings;
        Pair<JSModulePathSubstitution, String> matchedElement;
        VirtualFile virtualFile = this.getBaseUrl();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile baseUrl = virtualFile;
        if (this.hasPathMappings() && (matchedElement = JSPathMappingsUtil.findMaxElementByPaths(moduleName, mappings = this.getPathMappings())) != null) {
            Object item$iv$iv2;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            JSModulePathSubstitution matchedPattern = (JSModulePathSubstitution)matchedElement.getFirst();
            String matchedStar = (String)matchedElement.getSecond();
            Collection<String> forFileReference = JSPathMappingsUtil.getMappings(matchedPattern, matchedStar, true);
            Collection<String> forExactReference = JSPathMappingsUtil.getMappings(matchedPattern, matchedStar, false);
            if (forExactReference.isEmpty() && forFileReference.isEmpty()) {
                return null;
            }
            Collection<String> collection = forFileReference;
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"forFileReference");
            Iterable iterable = CollectionsKt.plus(forExactReference, (Iterable)collection);
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv) {
                void it;
                String string = (String)item$iv$iv2;
                Collection collection2 = destination$iv$iv;
                String string2 = JSPathMappingsUtil.replaceStarForMapping((String)it, matchedStar);
                collection2.add(string2);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
            item$iv$iv2 = $receiver$iv$iv$iv.iterator();
            while (item$iv$iv2.hasNext()) {
                VirtualFile virtualFile2;
                String it;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = item$iv$iv2.next();
                String string = it = (String)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                if (this.loader(string, baseUrl) == null) continue;
                VirtualFile it$iv$iv = virtualFile2;
                destination$iv$iv.add(it$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            iterator = $receiver$iv.iterator();
            if (iterator.hasNext()) {
                Object element$iv = iterator.next();
                VirtualFile it = (VirtualFile)element$iv;
                return it;
            }
        }
        return this.loader(moduleName, baseUrl);
    }

    private final VirtualFile loadModuleFromNodeModules(String moduleName, VirtualFile containingFile) {
        return this.loadModuleFromNodeModulesWorker(moduleName, containingFile, false);
    }

    private final VirtualFile tryLoadModuleUsingRootDirs(String moduleName, VirtualFile directory) {
        String candidatePath;
        Collection<VirtualFile> rootDirs = this.getRootDirs();
        if (rootDirs.isEmpty()) {
            return null;
        }
        String string = candidatePath = JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(directory, moduleName);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"candidatePath");
        VirtualFile rootDir = this.findRootDirWithLongestPrefix(string, directory);
        if (rootDir != null) {
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            VirtualFile defaultFile = this.loader(moduleName, directory);
            if (defaultFile != null) {
                return defaultFile;
            }
            Object object = candidatePath;
            int n = rootDir.getPath().length() + 1;
            String string2 = ((String)object).substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            String suffix = string2;
            object = rootDirs;
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                if (!(rootDir != it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                VirtualFile virtualFile;
                Object element$iv$iv = element$iv$iv$iv;
                VirtualFile it = (VirtualFile)element$iv$iv;
                if (this.loader(suffix, it) == null) continue;
                VirtualFile it$iv$iv = virtualFile;
                destination$iv$iv.add(it$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            iterator = $receiver$iv.iterator();
            if (iterator.hasNext()) {
                Object element$iv = iterator.next();
                VirtualFile it = (VirtualFile)element$iv;
                return it;
            }
        }
        return null;
    }

    private final VirtualFile loader(String relativePath, VirtualFile directory) {
        if (this.isClassic()) {
            return this.loadModuleFromFile(relativePath, directory);
        }
        return this.nodeLoadModuleByRelativeName(relativePath, directory);
    }

    private final VirtualFile loadModuleFromFile(String relativePath, VirtualFile containingDirectory) {
        VirtualFile exactFile;
        String name;
        VirtualFile directory;
        if (StringsKt.endsWith$default((String)relativePath, (String)"/", (boolean)false, (int)2, null)) {
            return null;
        }
        String path = JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(containingDirectory, relativePath);
        int lastIndexOf = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (lastIndexOf >= 0) {
            String string = path;
            int n = 0;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, lastIndexOf);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String directoryPath = string3;
            VirtualFile virtualFile = containingDirectory.getFileSystem().findFileByPath(directoryPath);
            if (virtualFile == null) {
                return null;
            }
            directory = virtualFile;
            string = path;
            n = lastIndexOf + 1;
            String string4 = string;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            name = string5;
        } else {
            name = relativePath;
            directory = containingDirectory;
        }
        VirtualFile candidate = this.tryAddingExtensions(directory, name);
        if (candidate != null && !candidate.isDirectory()) {
            return candidate;
        }
        if (TypeScriptFileImportsResolver.hasJsExtension(name)) {
            String nameWithoutExtension;
            String string = nameWithoutExtension = FileUtil.getNameWithoutExtension((String)name);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nameWithoutExtension");
            VirtualFile tsCandidateForJSFile = this.tryAddingExtensions(directory, string);
            if (tsCandidateForJSFile != null && !tsCandidateForJSFile.isDirectory()) {
                return tsCandidateForJSFile;
            }
        }
        if ((exactFile = directory.findChild(name)) != null && !exactFile.isDirectory()) {
            return exactFile;
        }
        return null;
    }

    private final VirtualFile tryAddingExtensions(VirtualFile directory, String name) {
        for (Object element$iv : (Object[])this.extensions) {
            String it = (String)element$iv;
            VirtualFile candidate = directory.findChild(name + it);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    private final VirtualFile loadNodeModuleFromDirectory(VirtualFile directory, boolean considerPackageJson) {
        ResolvedModuleInfo resolvedModuleInfo = this.nodeProcessor.loadDirectory(null, directory, ModuleType.NODE_MODULES_DIR, considerPackageJson);
        return resolvedModuleInfo != null ? resolvedModuleInfo.getModuleMainFile() : null;
    }

    private final VirtualFile nodeLoadModuleByRelativeName(String relativePath, VirtualFile containingDirectory) {
        VirtualFile directoryCandidate;
        VirtualFile candidate;
        if (!this.pathEndsWithDirectorySeparator(relativePath) && (candidate = this.loadModuleFromFile(relativePath, containingDirectory)) != null) {
            return candidate;
        }
        VirtualFile virtualFile = JSPathMappingsUtil.getPathRelativeBaseUrl(containingDirectory, relativePath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = directoryCandidate = virtualFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"directoryCandidate");
        return this.loadNodeModuleFromDirectory(virtualFile2, true);
    }

    private final VirtualFile loadModuleFromNodeModulesAtTypes(String moduleName, VirtualFile containingDirectory) {
        return this.loadModuleFromNodeModulesWorker(moduleName, containingDirectory, true);
    }

    private final VirtualFile loadModuleFromNodeModulesWorker(String moduleName, VirtualFile toSearchDir, boolean typesOnly) {
        VirtualFile startDir = toSearchDir;
        while (startDir != null) {
            VirtualFile parent;
            VirtualFile nodeModulesDirectory = startDir.findChild("node_modules");
            if (nodeModulesDirectory == null) {
                nodeModulesDirectory = NodeModuleUtil.findUpClosestNodeModulesResolveRoot(startDir);
            }
            if (nodeModulesDirectory == null) break;
            VirtualFile candidate = this.loadModuleFromNodeModulesOneLevel(moduleName, nodeModulesDirectory, typesOnly);
            if (candidate != null) {
                return candidate;
            }
            if (nodeModulesDirectory.getParent() == null) {
                return null;
            }
            startDir = parent.getParent();
        }
        return null;
    }

    private final VirtualFile loadModuleFromNodeModulesOneLevel(String moduleName, VirtualFile nodeModulesDirectory, boolean typesOnly) {
        VirtualFile typesDirectory;
        VirtualFile moduleFile;
        VirtualFile virtualFile = moduleFile = typesOnly ? null : this.loadModuleFromNodeModulesFolder(moduleName, nodeModulesDirectory);
        if (moduleFile != null) {
            return moduleFile;
        }
        VirtualFile virtualFile2 = nodeModulesDirectory.findChild("@types");
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = typesDirectory = virtualFile2;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"typesDirectory");
        return this.loadModuleFromNodeModulesFolder(moduleName, virtualFile3);
    }

    private final VirtualFile loadModuleFromNodeModulesFolder(String moduleName, VirtualFile nodeModulesFolder) {
        VirtualFile directoryCandidate;
        VirtualFile exactFile = this.loadModuleFromFile(moduleName, nodeModulesFolder);
        if (exactFile != null) {
            return exactFile;
        }
        VirtualFile virtualFile = JSPathMappingsUtil.getPathRelativeBaseUrl(nodeModulesFolder, moduleName);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = directoryCandidate = virtualFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"directoryCandidate");
        return this.loadNodeModuleFromDirectory(virtualFile2, true);
    }

    public TypeScriptFileImportsResolverImpl(@NotNull Project project, @NotNull TypeScriptImportResolveContext resolveContext, @NotNull NodeModuleDirectorySearchProcessor nodeProcessor, @NotNull String[] extensions) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)resolveContext, (String)"resolveContext");
        Intrinsics.checkParameterIsNotNull((Object)nodeProcessor, (String)"nodeProcessor");
        Intrinsics.checkParameterIsNotNull((Object)extensions, (String)"extensions");
        this.project = project;
        this.resolveContext = resolveContext;
        this.nodeProcessor = nodeProcessor;
        this.extensions = extensions;
    }

    public TypeScriptFileImportsResolverImpl(@NotNull Project project, @NotNull TypeScriptImportResolveContext resolveContext, @NotNull NodeModuleDirectorySearchProcessor nodeProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)resolveContext, (String)"resolveContext");
        Intrinsics.checkParameterIsNotNull((Object)nodeProcessor, (String)"nodeProcessor");
        Intrinsics.checkExpressionValueIsNotNull((Object)TypeScriptFileImportsResolver.TS_EXTENSIONS, (String)"TypeScriptFileImportsResolver.TS_EXTENSIONS");
        this(project, resolveContext, nodeProcessor, TypeScriptFileImportsResolver.TS_EXTENSIONS);
    }
}

