/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.util.ParenthesesUtils;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.BoolUtils;
import com.sixrr.inspectjs.utils.ComparisonUtils;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointlessBooleanExpressionJSInspection
extends JavaScriptInspection {
    private final BooleanLiteralComparisonFix fix = new BooleanLiteralComparisonFix();

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("pointless.boolean.expression.display.name", new Object[0]);
        if (string == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessBooleanExpressionVisitor();
    }

    @Override
    public String buildErrorString(Object ... args) {
        if (args[0] instanceof JSBinaryExpression) {
            return InspectionJSBundle.message("pointless.boolean.error.string", PointlessBooleanExpressionJSInspection.calculateSimplifiedBinaryExpression((JSBinaryExpression)args[0]));
        }
        return InspectionJSBundle.message("pointless.boolean.error.string", PointlessBooleanExpressionJSInspection.calculateSimplifiedPrefixExpression((JSPrefixExpression)args[0]));
    }

    @Nullable
    private static String calculateSimplifiedBinaryExpression(JSBinaryExpression expression) {
        IElementType sign = expression.getOperationSign();
        JSExpression lhs = expression.getLOperand();
        if (lhs == null) {
            return null;
        }
        JSExpression rhs = expression.getROperand();
        if (rhs == null) {
            return null;
        }
        String rhsText = rhs.getText();
        String lhsText = lhs.getText();
        if (JSTokenTypes.ANDAND.equals(sign) || JSTokenTypes.AND.equals(sign)) {
            if (PointlessBooleanExpressionJSInspection.isTrue(lhs)) {
                return rhsText;
            }
            return lhsText;
        }
        if (JSTokenTypes.OROR.equals(sign) || JSTokenTypes.OR.equals(sign)) {
            if (PointlessBooleanExpressionJSInspection.isFalse(lhs)) {
                return rhsText;
            }
            return lhsText;
        }
        if (JSTokenTypes.XOR.equals(sign) || JSTokenTypes.NE.equals(sign) || JSTokenTypes.NEQEQ.equals(sign)) {
            if (PointlessBooleanExpressionJSInspection.isFalse(lhs)) {
                return rhsText;
            }
            if (PointlessBooleanExpressionJSInspection.isFalse(rhs)) {
                return lhsText;
            }
            if (PointlessBooleanExpressionJSInspection.isTrue(lhs)) {
                return PointlessBooleanExpressionJSInspection.createStringForNegatedExpression(rhs);
            }
            return PointlessBooleanExpressionJSInspection.createStringForNegatedExpression(lhs);
        }
        if (JSTokenTypes.EQEQ.equals(sign) || JSTokenTypes.EQEQEQ.equals(sign)) {
            if (PointlessBooleanExpressionJSInspection.isTrue(lhs)) {
                return rhsText;
            }
            if (PointlessBooleanExpressionJSInspection.isTrue(rhs)) {
                return lhsText;
            }
            if (PointlessBooleanExpressionJSInspection.isFalse(lhs)) {
                return PointlessBooleanExpressionJSInspection.createStringForNegatedExpression(rhs);
            }
            return PointlessBooleanExpressionJSInspection.createStringForNegatedExpression(lhs);
        }
        return "";
    }

    private static String createStringForNegatedExpression(JSExpression exp) {
        if (ComparisonUtils.isComparison(exp)) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)exp;
            IElementType sign = binaryExpression.getOperationSign();
            String negatedComparison = ComparisonUtils.getNegatedComparison(sign);
            JSExpression lhs = binaryExpression.getLOperand();
            JSExpression rhs = binaryExpression.getROperand();
            assert (rhs != null);
            return lhs.getText() + negatedComparison + rhs.getText();
        }
        if (ParenthesesUtils.getPrecedence(exp) > 3) {
            return "!(" + exp.getText() + ')';
        }
        return '!' + exp.getText();
    }

    @NonNls
    private static String calculateSimplifiedPrefixExpression(JSPrefixExpression expression) {
        JSPrefixExpression prefixExpression;
        JSExpression operand = expression.getExpression();
        if (PointlessBooleanExpressionJSInspection.isTrue(operand)) {
            return "false";
        }
        if (PointlessBooleanExpressionJSInspection.isFalse(operand)) {
            return "true";
        }
        if (operand instanceof JSPrefixExpression && (prefixExpression = (JSPrefixExpression)operand).getOperationSign() == JSTokenTypes.EXCL) {
            return prefixExpression.getExpression().getText();
        }
        assert (false) : "JS prefix expression cannot be simplified";
        return expression.getText();
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        if (JSInheritedLanguagesHelper.isSimplifyBooleanFixEnabled(location)) {
            return this.fix;
        }
        return null;
    }

    private static boolean andExpressionIsPointless(JSExpression lhs, JSExpression rhs) {
        return PointlessBooleanExpressionJSInspection.isTrue(lhs);
    }

    private static boolean orExpressionIsPointless(JSExpression lhs, JSExpression rhs) {
        return PointlessBooleanExpressionJSInspection.isFalse(lhs);
    }

    private static boolean xorExpressionIsPointless(JSExpression lhs, JSExpression rhs) {
        return PointlessBooleanExpressionJSInspection.isTrue(lhs) || PointlessBooleanExpressionJSInspection.isTrue(rhs) || PointlessBooleanExpressionJSInspection.isFalse(lhs) || PointlessBooleanExpressionJSInspection.isFalse(rhs);
    }

    private static boolean notExpressionIsPointless(@Nullable JSExpression arg) {
        JSPrefixExpression expression;
        if (PointlessBooleanExpressionJSInspection.isFalse(arg) || PointlessBooleanExpressionJSInspection.isTrue(arg)) {
            return true;
        }
        if (arg instanceof JSPrefixExpression && (expression = (JSPrefixExpression)arg).getOperationSign() == JSTokenTypes.EXCL) {
            JSExpression innerExpr = expression.getExpression();
            return innerExpr != null && BoolUtils.isBoolean(innerExpr);
        }
        return false;
    }

    private static boolean isTrue(JSExpression expression) {
        if (expression == null) {
            return false;
        }
        if (!(expression instanceof JSLiteralExpression)) {
            return false;
        }
        String text = expression.getText();
        return "true".equals(text);
    }

    private static boolean isFalse(JSExpression expression) {
        if (expression == null) {
            return false;
        }
        if (!(expression instanceof JSLiteralExpression)) {
            return false;
        }
        String text = expression.getText();
        return "false".equals(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/confusing/PointlessBooleanExpressionJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PointlessBooleanExpressionVisitor
    extends BaseInspectionVisitor {
        private final Set<IElementType> booleanTokens = new THashSet(5);
        private final Set<IElementType> trickyBooleanTokens;

        private PointlessBooleanExpressionVisitor() {
            this.booleanTokens.add(JSTokenTypes.ANDAND);
            this.booleanTokens.add(JSTokenTypes.AND);
            this.booleanTokens.add(JSTokenTypes.OROR);
            this.booleanTokens.add(JSTokenTypes.OR);
            this.booleanTokens.add(JSTokenTypes.XOR);
            this.trickyBooleanTokens = new THashSet(4);
            this.trickyBooleanTokens.add(JSTokenTypes.EQEQ);
            this.trickyBooleanTokens.add(JSTokenTypes.EQEQEQ);
            this.trickyBooleanTokens.add(JSTokenTypes.NE);
            this.trickyBooleanTokens.add(JSTokenTypes.NEQEQ);
        }

        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSBinaryExpression(expression);
            if (expression.getROperand() == null) {
                return;
            }
            IElementType sign = expression.getOperationSign();
            if (!this.booleanTokens.contains(sign)) {
                boolean rightIsBoolConst;
                if (!DialectDetector.isTypeScript((PsiElement)expression) || !this.trickyBooleanTokens.contains(sign)) {
                    return;
                }
                JSExpression rhs = expression.getROperand();
                JSExpression lhs = expression.getLOperand();
                boolean leftIsBoolConst = PointlessBooleanExpressionJSInspection.isTrue(lhs) || PointlessBooleanExpressionJSInspection.isFalse(lhs);
                boolean bl = rightIsBoolConst = PointlessBooleanExpressionJSInspection.isTrue(rhs) || PointlessBooleanExpressionJSInspection.isFalse(rhs);
                if (!leftIsBoolConst && !rightIsBoolConst) {
                    return;
                }
                TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(expression.getContainingFile());
                if (config2 == null || !config2.strictNullChecks()) {
                    return;
                }
                JSType type = JSResolveUtil.getExpressionJSType(leftIsBoolConst ? rhs : lhs);
                if (type instanceof JSBooleanType) {
                    this.registerError((PsiElement)expression);
                }
                return;
            }
            JSExpression rhs = expression.getROperand();
            JSExpression lhs = expression.getLOperand();
            boolean isPointless = JSTokenTypes.ANDAND.equals(sign) || JSTokenTypes.AND.equals(sign) ? PointlessBooleanExpressionJSInspection.andExpressionIsPointless(lhs, rhs) : (JSTokenTypes.OROR.equals(sign) || JSTokenTypes.OR.equals(sign) ? PointlessBooleanExpressionJSInspection.orExpressionIsPointless(lhs, rhs) : (JSTokenTypes.XOR.equals(sign) ? PointlessBooleanExpressionJSInspection.xorExpressionIsPointless(lhs, rhs) : false));
            if (!isPointless) {
                return;
            }
            this.registerError((PsiElement)expression);
        }

        public void visitJSPrefixExpression(@NotNull JSPrefixExpression expression) {
            if (expression == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(1);
            }
            super.visitJSPrefixExpression(expression);
            IElementType sign = expression.getOperationSign();
            if (sign == null) {
                return;
            }
            JSExpression operand = expression.getExpression();
            if (JSTokenTypes.EXCL.equals(sign) && PointlessBooleanExpressionJSInspection.notExpressionIsPointless(operand)) {
                this.registerError((PsiElement)expression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/sixrr/inspectjs/confusing/PointlessBooleanExpressionJSInspection$PointlessBooleanExpressionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSBinaryExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSPrefixExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BooleanLiteralComparisonFix
    extends InspectionJSFix {
        private BooleanLiteralComparisonFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("simplify.fix", new Object[0]);
            if (string == null) {
                BooleanLiteralComparisonFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element = descriptor2.getPsiElement();
            if (element instanceof JSBinaryExpression) {
                JSBinaryExpression expression = (JSBinaryExpression)element;
                String replacementString = PointlessBooleanExpressionJSInspection.calculateSimplifiedBinaryExpression(expression);
                BooleanLiteralComparisonFix.replaceExpression((JSExpression)expression, replacementString);
            } else {
                JSPrefixExpression expression = (JSPrefixExpression)element;
                String replacementString = PointlessBooleanExpressionJSInspection.calculateSimplifiedPrefixExpression(expression);
                BooleanLiteralComparisonFix.replaceExpression((JSExpression)expression, replacementString);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/PointlessBooleanExpressionJSInspection$BooleanLiteralComparisonFix", "getFamilyName"));
        }
    }
}

