/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.externalSystem.model.DataNodeSerializer;
import com.intellij.openapi.externalSystem.model.FSTProxySerializer;
import com.intellij.openapi.externalSystem.model.MultiLoaderWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Proxy;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.FSTObjectSerializer;

public class FSTSerializer<T>
implements DataNodeSerializer<T> {
    private static DataNodeSerializer ourInstance = new FSTSerializer();
    private final FSTConfiguration myConf = FSTConfiguration.createDefaultConfiguration();

    public FSTSerializer() {
        this.myConf.registerSerializer(Proxy.class, (FSTObjectSerializer)new FSTProxySerializer(), true);
        FSTConfiguration.LastResortClassResolver prevResolver = this.myConf.getLastResortResolver();
        this.myConf.setLastResortResolver(p -> p.startsWith("com.sun.proxy.$Proxy") ? Proxy.class : (prevResolver != null ? prevResolver.getClass(p) : null));
    }

    @Override
    public byte[] getBytes(T data) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try (FSTObjectOutput oOut = new FSTObjectOutput((OutputStream)bOut, this.myConf);){
            oOut.writeObject(data);
            oOut.flush();
            byte[] byArray = bOut.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T readData(byte[] data, ClassLoader ... classLoaders) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        ClassLoader original = null;
        FSTObjectInput oIn = new FSTObjectInput((InputStream)inputStream, this.myConf);
        try {
            original = this.myConf.getClassLoader();
            this.myConf.setClassLoader((ClassLoader)new MultiLoaderWrapper(this.getClass().getClassLoader(), classLoaders));
            Object object = oIn.readObject();
            assert (object != null);
            Object object2 = object;
            return (T)object2;
        }
        finally {
            this.myConf.setClassLoader(original);
            oIn.close();
        }
    }

    public static <T> DataNodeSerializer<T> getInstance() {
        return ourInstance;
    }
}

