/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashMap;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryData
extends AbstractNamedData
implements Named,
ProjectCoordinate {
    private static final long serialVersionUID = 1L;
    private final Map<LibraryPathType, Set<String>> myPaths;
    private final boolean myUnresolved;
    private String myGroup;
    private String myArtifactId;
    private String myVersion;

    public LibraryData(@NotNull ProjectSystemId owner, @NotNull String name) {
        if (owner == null) {
            LibraryData.$$$reportNull$$$0(0);
        }
        if (name == null) {
            LibraryData.$$$reportNull$$$0(1);
        }
        this(owner, name, false);
    }

    public LibraryData(@NotNull ProjectSystemId owner, @NotNull String name, boolean unresolved) {
        if (owner == null) {
            LibraryData.$$$reportNull$$$0(2);
        }
        if (name == null) {
            LibraryData.$$$reportNull$$$0(3);
        }
        super(owner, name, name.isEmpty() ? "" : owner.getReadableName() + ": " + name);
        this.myPaths = new HashMap();
        this.myUnresolved = unresolved;
    }

    @Override
    @Nullable
    public String getGroupId() {
        return this.myGroup;
    }

    public void setGroup(String group) {
        this.myGroup = group;
    }

    @Override
    @Nullable
    public String getArtifactId() {
        return this.myArtifactId;
    }

    public void setArtifactId(String artifactId) {
        this.myArtifactId = artifactId;
    }

    @Override
    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(String version) {
        this.myVersion = version;
    }

    public boolean isUnresolved() {
        return this.myUnresolved;
    }

    @NotNull
    public Set<String> getPaths(@NotNull LibraryPathType type) {
        Set<String> result2;
        if (type == null) {
            LibraryData.$$$reportNull$$$0(4);
        }
        Set<Object> set = (result2 = this.myPaths.get((Object)type)) == null ? Collections.emptySet() : result2;
        if (set == null) {
            LibraryData.$$$reportNull$$$0(5);
        }
        return set;
    }

    public void addPath(@NotNull LibraryPathType type, @NotNull String path2) {
        Set<String> paths;
        if (type == null) {
            LibraryData.$$$reportNull$$$0(6);
        }
        if (path2 == null) {
            LibraryData.$$$reportNull$$$0(7);
        }
        if ((paths = this.myPaths.get((Object)type)) == null) {
            paths = new LinkedHashSet<String>();
            this.myPaths.put(type, paths);
        }
        paths.add(ExternalSystemApiUtil.toCanonicalPath(path2));
    }

    public void forgetAllPaths() {
        this.myPaths.clear();
    }

    @Override
    public int hashCode() {
        int result2 = this.myPaths.hashCode();
        result2 = 31 * result2 + super.hashCode();
        result2 = 31 * result2 + (this.myUnresolved ? 0 : 1);
        result2 = 31 * result2 + (this.myGroup != null ? this.myGroup.hashCode() : 0);
        result2 = 31 * result2 + (this.myArtifactId != null ? this.myArtifactId.hashCode() : 0);
        result2 = 31 * result2 + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        return result2;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        LibraryData that = (LibraryData)o;
        if (this.myGroup != null ? !this.myGroup.equals(that.myGroup) : that.myGroup != null) {
            return false;
        }
        if (this.myArtifactId != null ? !this.myArtifactId.equals(that.myArtifactId) : that.myArtifactId != null) {
            return false;
        }
        if (this.myVersion != null ? !this.myVersion.equals(that.myVersion) : that.myVersion != null) {
            return false;
        }
        return super.equals(that) && this.myUnresolved == that.myUnresolved && this.myPaths.equals(that.myPaths);
    }

    public String toString() {
        String externalName = this.getExternalName();
        String displayName = StringUtil.isEmpty((String)externalName) ? this.myPaths.toString() : externalName;
        return String.format("library %s%s", displayName, this.myUnresolved ? "(unresolved)" : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/model/project/LibraryData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/model/project/LibraryData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPaths";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

