/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsState;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="masterDetails", storages={@Storage(value="$WORKSPACE_FILE$")})
public class MasterDetailsStateService
implements PersistentStateComponent<States> {
    private final SkipDefaultValuesSerializationFilters mySerializationFilter = new SkipDefaultValuesSerializationFilters();
    private final Map<String, ComponentState> myStates = new HashMap<String, ComponentState>();

    public static MasterDetailsStateService getInstance(@NotNull Project project) {
        if (project == null) {
            MasterDetailsStateService.$$$reportNull$$$0(0);
        }
        return ServiceManager.getService(project, MasterDetailsStateService.class);
    }

    public void register(String key, MasterDetailsComponent component) {
    }

    @Nullable
    public MasterDetailsState getComponentState(@NotNull @NonNls String key, Class<? extends MasterDetailsState> stateClass) {
        ComponentState state;
        if (key == null) {
            MasterDetailsStateService.$$$reportNull$$$0(1);
        }
        if ((state = this.myStates.get(key)) == null) {
            return null;
        }
        Element settings = state.mySettings;
        return settings != null ? (MasterDetailsState)XmlSerializer.deserialize((Element)settings, stateClass) : null;
    }

    public void setComponentState(@NotNull @NonNls String key, @NotNull MasterDetailsState state) {
        if (key == null) {
            MasterDetailsStateService.$$$reportNull$$$0(2);
        }
        if (state == null) {
            MasterDetailsStateService.$$$reportNull$$$0(3);
        }
        Element element = XmlSerializer.serialize((Object)state, (SerializationFilter)this.mySerializationFilter);
        ComponentState componentState = new ComponentState();
        componentState.myKey = key;
        componentState.mySettings = element;
        this.myStates.put(key, componentState);
    }

    @Override
    public States getState() {
        States states = new States();
        states.myStates.addAll(this.myStates.values());
        Collections.sort(states.getStates(), Comparator.comparing(o -> o.myKey));
        return states;
    }

    @Override
    public void loadState(States states) {
        this.myStates.clear();
        for (ComponentState state : states.getStates()) {
            this.myStates.put(state.myKey, state);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/ui/MasterDetailsStateService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getComponentState";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setComponentState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class States {
        private List<ComponentState> myStates = new ArrayList<ComponentState>();

        @XCollection(style=XCollection.Style.v2)
        public List<ComponentState> getStates() {
            return this.myStates;
        }

        public void setStates(List<ComponentState> states) {
            this.myStates = states;
        }
    }

    @Tag(value="state")
    public static class ComponentState {
        @Attribute(value="key")
        public String myKey;
        @Tag(value="settings")
        public Element mySettings;
    }
}

