/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopupChooserBuilder {
    private JComponent myChooserComponent;
    private String myTitle;
    private final ArrayList<KeyStroke> myAdditionalKeystrokes;
    private Runnable myItemChosenRunnable;
    private JComponent mySouthComponent;
    private JComponent myEastComponent;
    private JBPopup myPopup;
    private boolean myRequestFocus;
    private boolean myForceResizable;
    private boolean myForceMovable;
    private String myDimensionServiceKey;
    private Computable<Boolean> myCancelCallback;
    private boolean myAutoselect;
    private float myAlpha;
    private Component[] myFocusOwners;
    private boolean myCancelKeyEnabled;
    private final List<JBPopupListener> myListeners;
    private String myAd;
    private Dimension myMinSize;
    private ActiveComponent myCommandButton;
    private final List<Pair<ActionListener, KeyStroke>> myKeyboardActions;
    private Component mySettingsButtons;
    private boolean myAutoselectOnMouseMove;
    private Function<Object, String> myItemsNamer;
    private boolean myMayBeParent;
    private int myAdAlignment;
    private boolean myModalContext;
    private boolean myCloseOnEnter;
    private boolean myCancelOnWindowDeactivation;
    private boolean myUseForXYLocation;
    @Nullable
    private Processor<JBPopup> myCouldPin;
    private boolean myCancelOnClickOutside;
    private JScrollPane myScrollPane;

    public PopupChooserBuilder setCancelOnClickOutside(boolean cancelOnClickOutside) {
        this.myCancelOnClickOutside = cancelOnClickOutside;
        return this;
    }

    public JScrollPane getScrollPane() {
        return this.myScrollPane;
    }

    public PopupChooserBuilder(@NotNull JList list) {
        if (list == null) {
            PopupChooserBuilder.$$$reportNull$$$0(0);
        }
        this.myAdditionalKeystrokes = new ArrayList();
        this.myRequestFocus = true;
        this.myForceResizable = false;
        this.myForceMovable = false;
        this.myDimensionServiceKey = null;
        this.myAutoselect = true;
        this.myFocusOwners = new Component[0];
        this.myCancelKeyEnabled = true;
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myKeyboardActions = new ArrayList<Pair<ActionListener, KeyStroke>>();
        this.myAutoselectOnMouseMove = true;
        this.myItemsNamer = null;
        this.myAdAlignment = 2;
        this.myCloseOnEnter = true;
        this.myCancelOnWindowDeactivation = true;
        this.myCancelOnClickOutside = true;
        this.myChooserComponent = list;
    }

    public PopupChooserBuilder(@NotNull JTable table) {
        if (table == null) {
            PopupChooserBuilder.$$$reportNull$$$0(1);
        }
        this.myAdditionalKeystrokes = new ArrayList();
        this.myRequestFocus = true;
        this.myForceResizable = false;
        this.myForceMovable = false;
        this.myDimensionServiceKey = null;
        this.myAutoselect = true;
        this.myFocusOwners = new Component[0];
        this.myCancelKeyEnabled = true;
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myKeyboardActions = new ArrayList<Pair<ActionListener, KeyStroke>>();
        this.myAutoselectOnMouseMove = true;
        this.myItemsNamer = null;
        this.myAdAlignment = 2;
        this.myCloseOnEnter = true;
        this.myCancelOnWindowDeactivation = true;
        this.myCancelOnClickOutside = true;
        this.myChooserComponent = table;
    }

    public PopupChooserBuilder(@NotNull JTree tree) {
        if (tree == null) {
            PopupChooserBuilder.$$$reportNull$$$0(2);
        }
        this.myAdditionalKeystrokes = new ArrayList();
        this.myRequestFocus = true;
        this.myForceResizable = false;
        this.myForceMovable = false;
        this.myDimensionServiceKey = null;
        this.myAutoselect = true;
        this.myFocusOwners = new Component[0];
        this.myCancelKeyEnabled = true;
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myKeyboardActions = new ArrayList<Pair<ActionListener, KeyStroke>>();
        this.myAutoselectOnMouseMove = true;
        this.myItemsNamer = null;
        this.myAdAlignment = 2;
        this.myCloseOnEnter = true;
        this.myCancelOnWindowDeactivation = true;
        this.myCancelOnClickOutside = true;
        this.myChooserComponent = tree;
    }

    @NotNull
    public PopupChooserBuilder setTitle(@NotNull @Nls String title) {
        if (title == null) {
            PopupChooserBuilder.$$$reportNull$$$0(3);
        }
        this.myTitle = title;
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            PopupChooserBuilder.$$$reportNull$$$0(4);
        }
        return popupChooserBuilder;
    }

    @NotNull
    public PopupChooserBuilder addAdditionalChooseKeystroke(@Nullable KeyStroke keyStroke) {
        if (keyStroke != null) {
            this.myAdditionalKeystrokes.add(keyStroke);
        }
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            PopupChooserBuilder.$$$reportNull$$$0(5);
        }
        return popupChooserBuilder;
    }

    @NotNull
    public PopupChooserBuilder setItemChoosenCallback(@NotNull Runnable runnable) {
        if (runnable == null) {
            PopupChooserBuilder.$$$reportNull$$$0(6);
        }
        this.myItemChosenRunnable = runnable;
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            PopupChooserBuilder.$$$reportNull$$$0(7);
        }
        return popupChooserBuilder;
    }

    @NotNull
    public PopupChooserBuilder setSouthComponent(@NotNull JComponent cmp) {
        if (cmp == null) {
            PopupChooserBuilder.$$$reportNull$$$0(8);
        }
        this.mySouthComponent = cmp;
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            PopupChooserBuilder.$$$reportNull$$$0(9);
        }
        return popupChooserBuilder;
    }

    @NotNull
    public PopupChooserBuilder setCouldPin(@Nullable Processor<JBPopup> callback) {
        this.myCouldPin = callback;
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            PopupChooserBuilder.$$$reportNull$$$0(10);
        }
        return popupChooserBuilder;
    }

    @NotNull
    public PopupChooserBuilder setEastComponent(@NotNull JComponent cmp) {
        if (cmp == null) {
            PopupChooserBuilder.$$$reportNull$$$0(11);
        }
        this.myEastComponent = cmp;
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            PopupChooserBuilder.$$$reportNull$$$0(12);
        }
        return popupChooserBuilder;
    }

    public PopupChooserBuilder setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
        return this;
    }

    public PopupChooserBuilder setResizable(boolean forceResizable) {
        this.myForceResizable = forceResizable;
        return this;
    }

    public PopupChooserBuilder setMovable(boolean forceMovable) {
        this.myForceMovable = forceMovable;
        return this;
    }

    public PopupChooserBuilder setDimensionServiceKey(@NonNls String key) {
        this.myDimensionServiceKey = key;
        return this;
    }

    public PopupChooserBuilder setUseDimensionServiceForXYLocation(boolean use) {
        this.myUseForXYLocation = use;
        return this;
    }

    public PopupChooserBuilder setCancelCallback(Computable<Boolean> callback) {
        this.myCancelCallback = callback;
        return this;
    }

    public PopupChooserBuilder setCommandButton(@NotNull ActiveComponent commandButton) {
        if (commandButton == null) {
            PopupChooserBuilder.$$$reportNull$$$0(13);
        }
        this.myCommandButton = commandButton;
        return this;
    }

    public PopupChooserBuilder setAlpha(float alpha) {
        this.myAlpha = alpha;
        return this;
    }

    public PopupChooserBuilder setAutoselectOnMouseMove(boolean doAutoSelect) {
        this.myAutoselectOnMouseMove = doAutoSelect;
        return this;
    }

    public PopupChooserBuilder setFilteringEnabled(Function<Object, String> namer) {
        this.myItemsNamer = namer;
        return this;
    }

    public PopupChooserBuilder setModalContext(boolean modalContext) {
        this.myModalContext = modalContext;
        return this;
    }

    @NotNull
    public JBPopup createPopup() {
        JList list;
        BooleanFunction keyEventHandler = null;
        if (this.myChooserComponent instanceof JList) {
            list = (JList)this.myChooserComponent;
            this.myChooserComponent = ListWithFilter.wrap(list, new MyListWrapper(list), this.myItemsNamer);
            keyEventHandler = keyEvent -> keyEvent.isConsumed();
        } else {
            list = null;
        }
        JPanel contentPane = new JPanel(new BorderLayout());
        if (!this.myForceMovable && this.myTitle != null) {
            JLabel label = new JLabel(this.myTitle);
            label.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            label.setHorizontalAlignment(0);
            contentPane.add((Component)label, "North");
        }
        if (list != null && list.getSelectedIndex() == -1 && this.myAutoselect) {
            list.setSelectedIndex(0);
        }
        (list != null ? list : this.myChooserComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (UIUtil.isActionClick((MouseEvent)e, (int)502) && !UIUtil.isSelectionButtonDown((MouseEvent)e) && !e.isConsumed()) {
                    if (PopupChooserBuilder.this.myCloseOnEnter) {
                        PopupChooserBuilder.this.closePopup(true, e, true);
                    } else {
                        PopupChooserBuilder.this.myItemChosenRunnable.run();
                    }
                }
            }
        });
        this.registerClosePopupKeyboardAction(KeyStroke.getKeyStroke(27, 0, true), false);
        if (this.myCloseOnEnter) {
            this.registerClosePopupKeyboardAction(KeyStroke.getKeyStroke(10, 0, true), true);
        } else {
            this.registerKeyboardAction(KeyStroke.getKeyStroke(10, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    PopupChooserBuilder.this.myItemChosenRunnable.run();
                }
            });
        }
        for (KeyStroke keystroke : this.myAdditionalKeystrokes) {
            this.registerClosePopupKeyboardAction(keystroke, true);
        }
        if (this.myChooserComponent instanceof ListWithFilter) {
            this.myScrollPane = ((ListWithFilter)this.myChooserComponent).getScrollPane();
        } else if (this.myChooserComponent instanceof JTable) {
            this.myScrollPane = this.createScrollPane((JTable)this.myChooserComponent);
        } else if (this.myChooserComponent instanceof JTree) {
            this.myScrollPane = this.createScrollPane((JTree)this.myChooserComponent);
        } else {
            throw new IllegalStateException("PopupChooserBuilder is intended to be constructed with one of JTable, JTree, JList components");
        }
        this.myScrollPane.getViewport().setCursor(Cursor.getPredefinedCursor(12));
        Insets viewportPadding = UIUtil.getListViewportPadding();
        ((JComponent)this.myScrollPane.getViewport().getView()).setBorder(BorderFactory.createEmptyBorder(viewportPadding.top, viewportPadding.left, viewportPadding.bottom, viewportPadding.right));
        if (this.myChooserComponent instanceof ListWithFilter) {
            this.addCenterComponentToContentPane(contentPane, this.myChooserComponent);
        } else {
            this.addCenterComponentToContentPane(contentPane, this.myScrollPane);
        }
        if (this.mySouthComponent != null) {
            this.addSouthComponentToContentPane(contentPane, this.mySouthComponent);
        }
        if (this.myEastComponent != null) {
            this.addEastComponentToContentPane(contentPane, this.myEastComponent);
        }
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder(contentPane, this.myChooserComponent);
        for (JBPopupListener each : this.myListeners) {
            builder.addListener(each);
        }
        builder.setDimensionServiceKey(null, this.myDimensionServiceKey, this.myUseForXYLocation).setRequestFocus(this.myRequestFocus).setResizable(this.myForceResizable).setMovable(this.myForceMovable).setTitle(this.myForceMovable ? this.myTitle : null).setCancelCallback(this.myCancelCallback).setAlpha(this.myAlpha).setFocusOwners(this.myFocusOwners).setCancelKeyEnabled(this.myCancelKeyEnabled).setAdText(this.myAd, this.myAdAlignment).setKeyboardActions(this.myKeyboardActions).setMayBeParent(this.myMayBeParent).setLocateWithinScreenBounds(true).setCancelOnOtherWindowOpen(true).setModalContext(this.myModalContext).setCancelOnWindowDeactivation(this.myCancelOnWindowDeactivation).setCancelOnClickOutside(this.myCancelOnClickOutside).setCouldPin(this.myCouldPin);
        if (keyEventHandler != null) {
            builder.setKeyEventHandler((BooleanFunction<KeyEvent>)keyEventHandler);
        }
        if (this.myCommandButton != null) {
            builder.setCommandButton(this.myCommandButton);
        }
        if (this.myMinSize != null) {
            builder.setMinSize(this.myMinSize);
        }
        if (this.mySettingsButtons != null) {
            builder.setSettingButtons(this.mySettingsButtons);
        }
        JBPopup jBPopup = this.myPopup = builder.createPopup();
        if (jBPopup == null) {
            PopupChooserBuilder.$$$reportNull$$$0(14);
        }
        return jBPopup;
    }

    protected void addEastComponentToContentPane(JPanel contentPane, JComponent component) {
        contentPane.add((Component)component, "East");
    }

    protected void addSouthComponentToContentPane(JPanel contentPane, JComponent component) {
        contentPane.add((Component)component, "South");
    }

    protected void addCenterComponentToContentPane(JPanel contentPane, JComponent component) {
        contentPane.add((Component)component, "Center");
    }

    public PopupChooserBuilder setMinSize(Dimension dimension) {
        this.myMinSize = dimension;
        return this;
    }

    public PopupChooserBuilder registerKeyboardAction(KeyStroke keyStroke, ActionListener actionListener) {
        this.myKeyboardActions.add((Pair<ActionListener, KeyStroke>)Pair.create((Object)actionListener, (Object)keyStroke));
        return this;
    }

    private void registerClosePopupKeyboardAction(KeyStroke keyStroke, final boolean shouldPerformAction) {
        this.registerPopupKeyboardAction(keyStroke, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!shouldPerformAction && PopupChooserBuilder.this.myChooserComponent instanceof ListWithFilter && ((ListWithFilter)PopupChooserBuilder.this.myChooserComponent).resetFilter()) {
                    return;
                }
                PopupChooserBuilder.this.closePopup(shouldPerformAction, null, shouldPerformAction);
            }
        });
    }

    private void registerPopupKeyboardAction(KeyStroke keyStroke, AbstractAction action) {
        this.myChooserComponent.registerKeyboardAction(action, keyStroke, 1);
    }

    private void closePopup(boolean shouldPerformAction, MouseEvent e, boolean isOk) {
        if (shouldPerformAction) {
            this.myPopup.setFinalRunnable(this.myItemChosenRunnable);
        }
        if (isOk) {
            this.myPopup.closeOk(e);
        } else {
            this.myPopup.cancel(e);
        }
    }

    @NotNull
    private JScrollPane createScrollPane(final JTable table) {
        if (table instanceof TreeTable) {
            TreeUtil.expandAll(((TreeTable)table).getTree());
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (table.getSelectedRow() == -1) {
            table.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (table.getRowCount() >= 20) {
            scrollPane.getViewport().setPreferredSize(new Dimension(table.getPreferredScrollableViewportSize().width, 300));
        } else {
            scrollPane.getViewport().setPreferredSize(table.getPreferredSize());
        }
        if (this.myAutoselectOnMouseMove) {
            table.addMouseMotionListener(new MouseMotionAdapter(){
                boolean myIsEngaged = false;

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (this.myIsEngaged) {
                        int index = table.rowAtPoint(e.getPoint());
                        table.getSelectionModel().setSelectionInterval(index, index);
                    } else {
                        this.myIsEngaged = true;
                    }
                }
            });
        }
        JScrollPane jScrollPane = scrollPane;
        if (jScrollPane == null) {
            PopupChooserBuilder.$$$reportNull$$$0(15);
        }
        return jScrollPane;
    }

    @NotNull
    private JScrollPane createScrollPane(final JTree tree) {
        TreeUtil.expandAll(tree);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(tree);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (tree.getSelectionCount() == 0) {
            tree.setSelectionRow(0);
        }
        if (tree.getRowCount() >= 20) {
            scrollPane.getViewport().setPreferredSize(new Dimension(tree.getPreferredScrollableViewportSize().width, 300));
        } else {
            scrollPane.getViewport().setPreferredSize(tree.getPreferredSize());
        }
        if (this.myAutoselectOnMouseMove) {
            tree.addMouseMotionListener(new MouseMotionAdapter(){
                boolean myIsEngaged = false;

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (this.myIsEngaged) {
                        Point p = e.getPoint();
                        int index = tree.getRowForLocation(p.x, p.y);
                        tree.setSelectionRow(index);
                    } else {
                        this.myIsEngaged = true;
                    }
                }
            });
        }
        JScrollPane jScrollPane = scrollPane;
        if (jScrollPane == null) {
            PopupChooserBuilder.$$$reportNull$$$0(16);
        }
        return jScrollPane;
    }

    public PopupChooserBuilder setAutoSelectIfEmpty(boolean autoselect) {
        this.myAutoselect = autoselect;
        return this;
    }

    public PopupChooserBuilder setCancelKeyEnabled(boolean enabled) {
        this.myCancelKeyEnabled = enabled;
        return this;
    }

    public PopupChooserBuilder addListener(JBPopupListener listener) {
        this.myListeners.add(listener);
        return this;
    }

    public PopupChooserBuilder setSettingButton(Component abutton) {
        this.mySettingsButtons = abutton;
        return this;
    }

    public PopupChooserBuilder setMayBeParent(boolean mayBeParent) {
        this.myMayBeParent = mayBeParent;
        return this;
    }

    public PopupChooserBuilder setCloseOnEnter(boolean closeOnEnter) {
        this.myCloseOnEnter = closeOnEnter;
        return this;
    }

    @NotNull
    public PopupChooserBuilder setFocusOwners(@NotNull Component[] focusOwners) {
        if (focusOwners == null) {
            PopupChooserBuilder.$$$reportNull$$$0(17);
        }
        this.myFocusOwners = focusOwners;
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            PopupChooserBuilder.$$$reportNull$$$0(18);
        }
        return popupChooserBuilder;
    }

    @NotNull
    public PopupChooserBuilder setAdText(String ad) {
        this.setAdText(ad, 2);
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            PopupChooserBuilder.$$$reportNull$$$0(19);
        }
        return popupChooserBuilder;
    }

    public PopupChooserBuilder setAdText(String ad, int alignment) {
        this.myAd = ad;
        this.myAdAlignment = alignment;
        return this;
    }

    public PopupChooserBuilder setCancelOnWindowDeactivation(boolean cancelOnWindowDeactivation) {
        this.myCancelOnWindowDeactivation = cancelOnWindowDeactivation;
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/popup/PopupChooserBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmp";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandButton";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusOwners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/popup/PopupChooserBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setTitle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addAdditionalChooseKeystroke";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setItemChoosenCallback";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setSouthComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setCouldPin";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "setEastComponent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createScrollPane";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "setFocusOwners";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "setAdText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTitle";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setItemChoosenCallback";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setSouthComponent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setEastComponent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setCommandButton";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setFocusOwners";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyListWrapper
    extends JBScrollPane
    implements DataProvider {
        private final JList myList;

        private MyListWrapper(JList list) {
            super(UIUtil.isUnderAquaLookAndFeel() ? 0 : -1);
            list.setVisibleRowCount(15);
            this.setViewportView(list);
            if (PopupChooserBuilder.this.myAutoselectOnMouseMove) {
                ListUtil.installAutoSelectOnMouseMove(list);
            }
            ScrollingUtil.installActions(list);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.myList = list;
        }

        @Override
        @Nullable
        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
                return this.myList.getSelectedValue();
            }
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                return this.myList.getSelectedValues();
            }
            return null;
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.isPreferredSizeSet()) {
                return super.getPreferredSize();
            }
            Dimension size = this.myList.getPreferredSize();
            size.height = Math.min(size.height, this.myList.getPreferredScrollableViewportSize().height);
            JScrollBar bar = this.getVerticalScrollBar();
            if (bar != null) {
                size.width += bar.getPreferredSize().width;
            }
            return size;
        }

        @Override
        public void setBorder(Border border) {
            if (this.myList != null) {
                this.myList.setBorder(border);
            }
        }

        @Override
        public void requestFocus() {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myList, true));
        }

        @Override
        public synchronized void addMouseListener(MouseListener l) {
            this.myList.addMouseListener(l);
        }
    }
}

