/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.vcs.FileStatus;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStatusFactory {
    private static final FileStatusFactory ourInstance = new FileStatusFactory();
    public static final String FILESTATUS_COLOR_KEY_PREFIX = "FILESTATUS_";
    private final List<FileStatus> myStatuses = new ArrayList<FileStatus>();

    private FileStatusFactory() {
    }

    public synchronized FileStatus createFileStatus(@NonNls @NotNull String id, @NotNull String description) {
        if (id == null) {
            FileStatusFactory.$$$reportNull$$$0(0);
        }
        if (description == null) {
            FileStatusFactory.$$$reportNull$$$0(1);
        }
        return this.createFileStatus(id, description, null);
    }

    public synchronized FileStatus createFileStatus(@NonNls @NotNull String id, @NotNull String description, @Nullable Color color) {
        if (id == null) {
            FileStatusFactory.$$$reportNull$$$0(2);
        }
        if (description == null) {
            FileStatusFactory.$$$reportNull$$$0(3);
        }
        FileStatusImpl result2 = new FileStatusImpl(id, ColorKey.createColorKey(FILESTATUS_COLOR_KEY_PREFIX + id, color), description);
        this.myStatuses.add(result2);
        return result2;
    }

    public synchronized FileStatus[] getAllFileStatuses() {
        return this.myStatuses.toArray(new FileStatus[this.myStatuses.size()]);
    }

    public static FileStatusFactory getInstance() {
        return ourInstance;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "id";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "description";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/FileStatusFactory";
        objectArray[2] = "createFileStatus";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FileStatusImpl
    implements FileStatus {
        private final String myStatus;
        private final ColorKey myColorKey;
        private final String myText;

        public FileStatusImpl(@NotNull String status, @NotNull ColorKey key, String text) {
            if (status == null) {
                FileStatusImpl.$$$reportNull$$$0(0);
            }
            if (key == null) {
                FileStatusImpl.$$$reportNull$$$0(1);
            }
            this.myStatus = status;
            this.myColorKey = key;
            this.myText = text;
        }

        public String toString() {
            return this.myStatus;
        }

        @Override
        public String getText() {
            return this.myText;
        }

        @Override
        public Color getColor() {
            return EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getColor(this.getColorKey());
        }

        @Override
        @NotNull
        public ColorKey getColorKey() {
            ColorKey colorKey = this.myColorKey;
            if (colorKey == null) {
                FileStatusImpl.$$$reportNull$$$0(2);
            }
            return colorKey;
        }

        @Override
        @NotNull
        public String getId() {
            String string = this.myStatus;
            if (string == null) {
                FileStatusImpl.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/FileStatusFactory$FileStatusImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/FileStatusFactory$FileStatusImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColorKey";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

