/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageContextPanel;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageContextPanelBase;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.StatusText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsagePreviewPanel
extends UsageContextPanelBase
implements DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.usages.impl.UsagePreviewPanel");
    private Editor myEditor;
    private final boolean myIsEditor;
    private int myLineHeight;
    private List<UsageInfo> myCachedSelectedUsageInfos;
    private Pattern myCachedSearchPattern;
    private Pattern myCachedReplacePattern;
    private static final Key<Boolean> IN_PREVIEW_USAGE_FLAG = Key.create((String)"IN_PREVIEW_USAGE_FLAG");
    private static Key<Balloon> REPLACEMENT_BALLOON_KEY = Key.create((String)"REPLACEMENT_BALLOON_KEY");
    private static final Key<UsagePreviewPanel> PREVIEW_EDITOR_FLAG = Key.create((String)"PREVIEW_EDITOR_FLAG");

    public UsagePreviewPanel(@NotNull Project project, @NotNull UsageViewPresentation presentation) {
        if (project == null) {
            UsagePreviewPanel.$$$reportNull$$$0(0);
        }
        if (presentation == null) {
            UsagePreviewPanel.$$$reportNull$$$0(1);
        }
        this(project, presentation, false);
    }

    public UsagePreviewPanel(@NotNull Project project, @NotNull UsageViewPresentation presentation, boolean isEditor) {
        if (project == null) {
            UsagePreviewPanel.$$$reportNull$$$0(2);
        }
        if (presentation == null) {
            UsagePreviewPanel.$$$reportNull$$$0(3);
        }
        super(project, presentation);
        this.myCachedSearchPattern = null;
        this.myCachedReplacePattern = null;
        this.myIsEditor = isEditor;
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.EDITOR.getName().equals(dataId) && this.myEditor != null) {
            return this.myEditor;
        }
        return null;
    }

    private void resetEditor(@NotNull List<UsageInfo> infos) {
        if (infos == null) {
            UsagePreviewPanel.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiElement psiElement = infos.get(0).getElement();
        if (psiElement == null) {
            return;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance(this.myProject).getInjectionHost(psiFile);
        if (host != null && (psiFile = host.getContainingFile()) == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance(psiFile.getProject()).getDocument(psiFile);
        if (document == null) {
            return;
        }
        if (this.myEditor == null || document != this.myEditor.getDocument()) {
            this.releaseEditor();
            this.removeAll();
            this.myEditor = this.createEditor(psiFile, document);
            if (this.myEditor == null) {
                return;
            }
            this.myLineHeight = this.myEditor.getLineHeight();
            this.myEditor.setBorder(null);
            this.add(this.myEditor.getComponent(), "Center");
            this.invalidate();
            this.validate();
        }
        if (!(Comparing.equal(infos, this.myCachedSelectedUsageInfos) && UsageViewPresentation.arePatternsEqual(this.myCachedSearchPattern, this.myPresentation.getSearchPattern()) && UsageViewPresentation.arePatternsEqual(this.myCachedReplacePattern, this.myPresentation.getReplacePattern()))) {
            UsagePreviewPanel.highlight(infos, this.myEditor, this.myProject, true, 3000);
            this.myCachedSelectedUsageInfos = infos;
            this.myCachedSearchPattern = this.myPresentation.getSearchPattern();
            this.myCachedReplacePattern = this.myPresentation.getReplacePattern();
        }
    }

    public int getLineHeight() {
        return this.myLineHeight;
    }

    public static void highlight(@NotNull List<UsageInfo> infos, @NotNull Editor editor, @NotNull Project project, boolean highlightOnlyNameElements, int highlightLayer) {
        if (infos == null) {
            UsagePreviewPanel.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            UsagePreviewPanel.$$$reportNull$$$0(6);
        }
        if (project == null) {
            UsagePreviewPanel.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(!PsiDocumentManager.getInstance(project).hasUncommitedDocuments());
        MarkupModel markupModel = editor.getMarkupModel();
        for (RangeHighlighter highlighter : markupModel.getAllHighlighters()) {
            if (highlighter.getUserData(IN_PREVIEW_USAGE_FLAG) == null) continue;
            highlighter.dispose();
        }
        Balloon balloon = (Balloon)editor.getUserData(REPLACEMENT_BALLOON_KEY);
        if (balloon != null && !Disposer.isDisposed((Disposable)balloon)) {
            Disposer.dispose((Disposable)balloon);
            editor.putUserData(REPLACEMENT_BALLOON_KEY, null);
        }
        FindModel findModel = UsagePreviewPanel.getFindModel(editor);
        for (int i = infos.size() - 1; i >= 0; --i) {
            PsiFile psiFile;
            PsiElement nameElement;
            TextRange textRange;
            UsageInfo info = infos.get(i);
            PsiElement psiElement = info.getElement();
            if (psiElement == null || !psiElement.isValid()) continue;
            int offsetInFile = psiElement.getTextOffset();
            EditorColorsManager colorManager = EditorColorsManager.getInstance();
            TextAttributes attributes = colorManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            TextRange elementRange = psiElement.getTextRange();
            ProperTextRange infoRange = info.getRangeInElement();
            TextRange textRange2 = textRange = infoRange == null || infoRange.getStartOffset() > elementRange.getLength() || infoRange.getEndOffset() > elementRange.getLength() ? null : elementRange.cutOut((TextRange)infoRange);
            if (textRange == null) {
                textRange = elementRange;
            }
            if (highlightOnlyNameElements && psiElement instanceof PsiNamedElement && !(psiElement instanceof PsiFile) && (nameElement = (psiFile = psiElement.getContainingFile()).findElementAt(offsetInFile)) != null) {
                textRange = nameElement.getTextRange();
            }
            textRange = InjectedLanguageManager.getInstance(project).injectedToHost(psiElement, textRange);
            RangeHighlighter highlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), highlightLayer, attributes, HighlighterTargetArea.EXACT_RANGE);
            highlighter.putUserData(IN_PREVIEW_USAGE_FLAG, Boolean.TRUE);
            if (infoRange != null && findModel != null && findModel.isReplaceState()) {
                RangeHighlighter boxHighlighter = markupModel.addRangeHighlighter(infoRange.getStartOffset(), infoRange.getEndOffset(), highlightLayer, new TextAttributes(null, null, editor.getColorsScheme().getColor(EditorColors.CARET_COLOR), EffectType.BOXED, 0), HighlighterTargetArea.EXACT_RANGE);
                boxHighlighter.putUserData(IN_PREVIEW_USAGE_FLAG, Boolean.TRUE);
                editor.getCaretModel().moveToOffset(infoRange.getEndOffset());
            } else {
                editor.getCaretModel().moveToOffset(textRange.getEndOffset());
            }
            if (findModel == null || infos.size() != 1 || infoRange == null || !infoRange.equals((Object)textRange)) continue;
            UsagePreviewPanel.showBalloon(project, editor, (TextRange)infoRange, findModel);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
    }

    private static void showBalloon(Project project, Editor editor, TextRange range, @NotNull FindModel findModel) {
        if (findModel == null) {
            UsagePreviewPanel.$$$reportNull$$$0(8);
        }
        try {
            String replacementPreviewText = FindManager.getInstance(project).getStringToReplace(editor.getDocument().getText(range), findModel, range.getStartOffset(), editor.getDocument().getText());
            ReplacementView replacementView = new ReplacementView(replacementPreviewText);
            BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createBalloonBuilder(replacementView);
            balloonBuilder.setFadeoutTime(0L);
            balloonBuilder.setFillColor(IdeTooltipManager.GRAPHITE_COLOR);
            balloonBuilder.setAnimationCycle(0);
            balloonBuilder.setHideOnClickOutside(false);
            balloonBuilder.setHideOnKeyOutside(false);
            balloonBuilder.setHideOnAction(false);
            balloonBuilder.setCloseButtonEnabled(true);
            Balloon balloon = balloonBuilder.createBalloon();
            EditorUtil.disposeWithEditor((Editor)editor, (Disposable)balloon);
            balloon.show(new ReplacementBalloonPositionTracker(project, editor, range, findModel), Balloon.Position.below);
            editor.putUserData(REPLACEMENT_BALLOON_KEY, balloon);
        }
        catch (FindManager.MalformedReplacementStringException malformedReplacementStringException) {
            // empty catch block
        }
    }

    @Nullable
    private static FindModel getFindModel(@NotNull Editor editor) {
        if (editor == null) {
            UsagePreviewPanel.$$$reportNull$$$0(9);
        }
        UsagePreviewPanel panel = (UsagePreviewPanel)editor.getUserData(PREVIEW_EDITOR_FLAG);
        Pattern searchPattern = null;
        Pattern replacePattern = null;
        if (panel != null) {
            searchPattern = panel.myPresentation.getSearchPattern();
            replacePattern = panel.myPresentation.getReplacePattern();
        }
        if (searchPattern == null || replacePattern == null) {
            return null;
        }
        FindModel stub = new FindModel();
        stub.setMultiline(true);
        stub.setRegularExpressions(true);
        stub.setReplaceAll(true);
        stub.setStringToFind(searchPattern.pattern());
        stub.setStringToReplace(replacePattern.pattern());
        return stub;
    }

    private Editor createEditor(PsiFile psiFile, Document document) {
        if (this.isDisposed) {
            return null;
        }
        Project project = psiFile.getProject();
        Editor editor = EditorFactory.getInstance().createEditor(document, project, psiFile.getVirtualFile(), !this.myIsEditor, EditorKind.PREVIEW);
        EditorSettings settings = editor.getSettings();
        this.customizeEditorSettings(settings);
        editor.putUserData(PREVIEW_EDITOR_FLAG, this);
        return editor;
    }

    protected void customizeEditorSettings(EditorSettings settings) {
        settings.setLineMarkerAreaShown(this.myIsEditor);
        settings.setFoldingOutlineShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setAnimatedScrolling(false);
    }

    @Override
    public void dispose() {
        this.isDisposed = true;
        this.releaseEditor();
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            if (editor.getProject() != this.myProject || editor.getUserData(PREVIEW_EDITOR_FLAG) != this) continue;
            LOG.error("Editor was not released:" + editor);
        }
    }

    private void releaseEditor() {
        if (this.myEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.myEditor);
            this.myEditor = null;
            this.myCachedSelectedUsageInfos = null;
            this.myCachedSearchPattern = null;
            this.myCachedReplacePattern = null;
        }
    }

    @Nullable
    public final String getCannotPreviewMessage(@Nullable List<UsageInfo> infos) {
        if (infos == null || infos.isEmpty()) {
            return UsageViewBundle.message("select.the.usage.to.preview", this.myPresentation.getUsagesWord());
        }
        PsiFile psiFile = null;
        for (UsageInfo info : infos) {
            PsiElement element = info.getElement();
            if (element == null) continue;
            PsiFile file = element.getContainingFile();
            if (psiFile == null) {
                psiFile = file;
                continue;
            }
            if (psiFile == file) continue;
            return UsageViewBundle.message("several.occurrences.selected", new Object[0]);
        }
        return null;
    }

    @Override
    public void updateLayoutLater(@Nullable List<UsageInfo> infos) {
        String cannotPreviewMessage = this.getCannotPreviewMessage(infos);
        if (cannotPreviewMessage != null) {
            this.releaseEditor();
            this.removeAll();
            int newLineIndex = cannotPreviewMessage.indexOf("\n");
            if (newLineIndex == -1) {
                this.getEmptyText().setText(cannotPreviewMessage);
            } else {
                this.getEmptyText().setText(cannotPreviewMessage.substring(0, newLineIndex)).appendSecondaryText(cannotPreviewMessage.substring(newLineIndex + 1), StatusText.DEFAULT_ATTRIBUTES, null);
            }
            this.revalidate();
        } else {
            this.resetEditor(infos);
        }
    }

    static boolean insideVisibleArea(Editor e, TextRange r) {
        int textLength = e.getDocument().getTextLength();
        if (r.getStartOffset() > textLength) {
            return false;
        }
        if (r.getEndOffset() > textLength) {
            return false;
        }
        Rectangle visibleArea = e.getScrollingModel().getVisibleArea();
        Point point = e.logicalPositionToXY(e.offsetToLogicalPosition(r.getStartOffset()));
        return visibleArea.contains(point);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/usages/impl/UsagePreviewPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "highlight";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "showBalloon";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getFindModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ReplacementBalloonPositionTracker
    extends PositionTracker<Balloon> {
        private final Project myProject;
        private final Editor myEditor;
        private final TextRange myRange;
        private final FindModel myFindModel;

        ReplacementBalloonPositionTracker(Project project, Editor editor, TextRange range, FindModel findModel) {
            super(editor.getContentComponent());
            this.myProject = project;
            this.myEditor = editor;
            this.myRange = range;
            this.myFindModel = findModel;
        }

        @Override
        public RelativePoint recalculateLocation(Balloon balloon) {
            int startOffset = this.myRange.getStartOffset();
            int endOffset = this.myRange.getEndOffset();
            if (!UsagePreviewPanel.insideVisibleArea(this.myEditor, this.myRange)) {
                if (!balloon.isDisposed()) {
                    Disposer.dispose((Disposable)balloon);
                }
                VisibleAreaListener visibleAreaListener = new VisibleAreaListener(){

                    @Override
                    public void visibleAreaChanged(VisibleAreaEvent e) {
                        if (UsagePreviewPanel.insideVisibleArea(myEditor, myRange)) {
                            UsagePreviewPanel.showBalloon(myProject, myEditor, myRange, myFindModel);
                            1 visibleAreaListener = this;
                            myEditor.getScrollingModel().removeVisibleAreaListener(visibleAreaListener);
                        }
                    }
                };
                this.myEditor.getScrollingModel().addVisibleAreaListener(visibleAreaListener);
            }
            Point startPoint = this.myEditor.visualPositionToXY(this.myEditor.offsetToVisualPosition(startOffset));
            Point endPoint = this.myEditor.visualPositionToXY(this.myEditor.offsetToVisualPosition(endOffset));
            Point point = new Point((startPoint.x + endPoint.x) / 2, startPoint.y + this.myEditor.getLineHeight());
            return new RelativePoint((Component)this.myEditor.getContentComponent(), point);
        }
    }

    private static class ReplacementView
    extends JPanel {
        private static final String MALFORMED_REPLACEMENT_STRING = "Malformed replacement string";

        @Override
        protected void paintComponent(@NotNull Graphics graphics) {
            if (graphics == null) {
                ReplacementView.$$$reportNull$$$0(0);
            }
        }

        public ReplacementView(@Nullable String replacement) {
            String textToShow = replacement;
            if (replacement == null) {
                textToShow = MALFORMED_REPLACEMENT_STRING;
            }
            JLabel jLabel = new JLabel(textToShow);
            jLabel.setForeground((Color)(replacement != null ? new JBColor((Color)Gray._240, (Color)Gray._200) : JBColor.RED));
            this.add(jLabel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/intellij/usages/impl/UsagePreviewPanel$ReplacementView", "paintComponent"));
        }
    }

    public static class Provider
    implements UsageContextPanel.Provider {
        @Override
        @NotNull
        public UsageContextPanel create(@NotNull UsageView usageView) {
            if (usageView == null) {
                Provider.$$$reportNull$$$0(0);
            }
            UsagePreviewPanel usagePreviewPanel = new UsagePreviewPanel(((UsageViewImpl)usageView).getProject(), usageView.getPresentation(), true);
            if (usagePreviewPanel == null) {
                Provider.$$$reportNull$$$0(1);
            }
            return usagePreviewPanel;
        }

        @Override
        public boolean isAvailableFor(@NotNull UsageView usageView) {
            if (usageView == null) {
                Provider.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        @NotNull
        public String getTabTitle() {
            if ("Preview" == null) {
                Provider.$$$reportNull$$$0(3);
            }
            return "Preview";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageView";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/UsagePreviewPanel$Provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/UsagePreviewPanel$Provider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTabTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailableFor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

