/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.hash.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CdiObservesInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(PsiClass psiClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            CdiObservesInspection.$$$reportNull$$$0(0);
        }
        Map<PsiMethod, Set<PsiParameter>> observesMethods = CdiObservesInspection.collectObserverMethods(psiClass);
        for (PsiMethod method : observesMethods.keySet()) {
            Set<PsiParameter> observesParameters = observesMethods.get(method);
            CdiObservesInspection.checkObservesMethod(holder, method, observesParameters);
        }
    }

    private static void checkObservesMethod(ProblemsHolder holder, PsiMethod method, Set<PsiParameter> observesParameters) {
        CdiObservesInspection.checkMultipleObservesParameters(holder, method, observesParameters);
        CdiObservesInspection.checkWrongAnnotatedParameter(method, holder, "javax.enterprise.inject.Disposes");
        CdiObservesInspection.checkWrongAnnotations(holder, method, "javax.enterprise.inject.Produces");
        CdiObservesInspection.checkWrongAnnotations(holder, method, "javax.inject.Inject");
    }

    private static void checkWrongAnnotations(ProblemsHolder holder, PsiMethod method, String anno) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)anno, (int)0)) {
            holder.registerProblem((PsiElement)method.getNameIdentifier(), CdiInspectionBundle.message("CdiObservesInspection.wrong.observe.method.annotation", anno), new LocalQuickFix[0]);
        }
    }

    private static void checkMultipleObservesParameters(ProblemsHolder holder, PsiMethod method, Set<PsiParameter> observesParameters) {
        if (observesParameters.size() > 1) {
            holder.registerProblem((PsiElement)method.getNameIdentifier(), CdiInspectionBundle.message("CdiObservesInspection.multiple.observes.parameters.not.allowed", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkWrongAnnotatedParameter(PsiMethod method, ProblemsHolder holder, String anno) {
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)anno, (int)0)) continue;
            holder.registerProblem((PsiElement)method.getNameIdentifier(), CdiInspectionBundle.message("CdiObservesInspection.observer.method.with.wrong.parameters", anno), new LocalQuickFix[0]);
            break;
        }
    }

    @NotNull
    private static Map<PsiMethod, Set<PsiParameter>> collectObserverMethods(PsiClass psiClass) {
        HashMap observesMethods = new HashMap();
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)"javax.enterprise.event.Observes", (int)0)) continue;
                Set parameters = (Set)observesMethods.get(psiMethod);
                if (parameters == null) {
                    parameters = new HashSet();
                    observesMethods.put(psiMethod, parameters);
                }
                parameters.add(psiParameter);
            }
        }
        HashMap hashMap = observesMethods;
        if (hashMap == null) {
            CdiObservesInspection.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.observer.method.errors", new Object[0]);
        if (string == null) {
            CdiObservesInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CdiObservesInspection" == null) {
            CdiObservesInspection.$$$reportNull$$$0(3);
        }
        return "CdiObservesInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            CdiObservesInspection.$$$reportNull$$$0(4);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/highlighting/CdiObservesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/highlighting/CdiObservesInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectObserverMethods";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

