/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.files;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.ConfigurableTemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.psi.VtlLanguage;
import com.intellij.velocity.psi.files.VtlFileElementTypes;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements ConfigurableTemplateLanguageFileViewProvider {
    private final Language myTemplateDataLanguage;
    private final Set<Language> myAllLanguages;

    public VtlFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        this(manager, virtualFile, physical, VtlFileViewProvider.getSubstitutedLanguage(manager, virtualFile));
    }

    private VtlFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical, Language templateDataLanguage) {
        super(manager, virtualFile, physical);
        this.myTemplateDataLanguage = templateDataLanguage;
        this.myAllLanguages = Collections.unmodifiableSet(ContainerUtil.newTroveSet((Object[])new Language[]{VtlLanguage.INSTANCE, this.myTemplateDataLanguage}));
    }

    @NotNull
    private static Language getSubstitutedLanguage(PsiManager manager, VirtualFile virtualFile) {
        Language language = VtlFileViewProvider.getTemplateDataLanguage(virtualFile, manager.getProject());
        Object object = language instanceof TemplateLanguage ? PlainTextLanguage.INSTANCE : LanguageSubstitutors.INSTANCE.substituteLanguage(language, virtualFile, manager.getProject());
        if (object == null) {
            VtlFileViewProvider.$$$reportNull$$$0(0);
        }
        return object;
    }

    @NotNull
    public Language getBaseLanguage() {
        VtlLanguage vtlLanguage = VtlLanguage.INSTANCE;
        if (vtlLanguage == null) {
            VtlFileViewProvider.$$$reportNull$$$0(1);
        }
        return vtlLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = this.myAllLanguages;
        if (set == null) {
            VtlFileViewProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            VtlFileViewProvider.$$$reportNull$$$0(3);
        }
        if (lang == this.getBaseLanguage()) {
            return this.createFileInner(lang);
        }
        if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl file = (PsiFileImpl)this.createFileInner(lang);
            file.setContentElementType((IElementType)VtlFileElementTypes.TEMPLATE_DATA);
            return file;
        }
        return null;
    }

    private PsiFile createFileInner(Language lang) {
        return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
    }

    @NotNull
    protected VtlFileViewProvider cloneInner(@NotNull VirtualFile copy) {
        if (copy == null) {
            VtlFileViewProvider.$$$reportNull$$$0(4);
        }
        VtlFileViewProvider vtlFileViewProvider = new VtlFileViewProvider((PsiManager)this.getManager(), copy, false, this.myTemplateDataLanguage);
        if (vtlFileViewProvider == null) {
            VtlFileViewProvider.$$$reportNull$$$0(5);
        }
        return vtlFileViewProvider;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateDataLanguage;
        if (language == null) {
            VtlFileViewProvider.$$$reportNull$$$0(6);
        }
        return language;
    }

    @NotNull
    static Language getTemplateDataLanguage(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        Language language;
        if (virtualFile == null) {
            VtlFileViewProvider.$$$reportNull$$$0(7);
        }
        if (project == null) {
            VtlFileViewProvider.$$$reportNull$$$0(8);
        }
        Language language2 = (language = TemplateDataLanguageMappings.getInstance((Project)project).getMapping(virtualFile)) == null ? VtlFileViewProvider.getTemplateDataLanguageByExtension(virtualFile) : language;
        if (language2 == null) {
            VtlFileViewProvider.$$$reportNull$$$0(9);
        }
        return language2;
    }

    @NotNull
    private static Language getTemplateDataLanguageByExtension(VirtualFile virtualFile) {
        String name = virtualFile.getName();
        int index2 = name.lastIndexOf(46);
        if (index2 < 3) {
            Language language = StdLanguages.HTML;
            if (language == null) {
                VtlFileViewProvider.$$$reportNull$$$0(10);
            }
            return language;
        }
        int index1 = 1 + name.lastIndexOf(46, index2 - 1);
        if (index1 < 1) {
            Language language = StdLanguages.HTML;
            if (language == null) {
                VtlFileViewProvider.$$$reportNull$$$0(11);
            }
            return language;
        }
        String dataLanguageFileExtension = name.substring(index1, index2);
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(dataLanguageFileExtension);
        if (fileType instanceof LanguageFileType) {
            Language language = ((LanguageFileType)fileType).getLanguage();
            if (language == null) {
                VtlFileViewProvider.$$$reportNull$$$0(12);
            }
            return language;
        }
        Language language = StdLanguages.HTML;
        if (language == null) {
            VtlFileViewProvider.$$$reportNull$$$0(13);
        }
        return language;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/psi/files/VtlFileViewProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutedLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/psi/files/VtlFileViewProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneInner";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguageByExtension";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateDataLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

